/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.ltl.Formula;
import gov.nasa.arc.ase.ltl.Node;
import gov.nasa.arc.ase.util.graph.Edge;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

class Transition {
    private TreeSet propositions;
    private int pointsTo;
    private BitSet accepting;
    private boolean safe_accepting;

    public Transition(TreeSet treeSet, int n, BitSet bitSet, boolean bl) {
        this.propositions = treeSet;
        this.pointsTo = n;
        this.accepting = new BitSet(Node.getAcceptingConds());
        this.accepting.or(bitSet);
        this.safe_accepting = bl;
    }

    public int goesTo() {
        return this.pointsTo;
    }

    public boolean enabled(Hashtable hashtable) {
        Iterator iterator = this.propositions.iterator();
        Formula formula = null;
        while (iterator.hasNext()) {
            formula = (Formula)iterator.next();
            char c = formula.getContent();
            switch (c) {
                case 'N': {
                    Boolean bl = (Boolean)hashtable.get(formula.getSub1().getName());
                    if (bl == null) {
                        return false;
                    }
                    if (!bl.booleanValue()) break;
                    return false;
                }
                case 't': {
                    break;
                }
                case 'p': {
                    Boolean bl = (Boolean)hashtable.get(formula.getName());
                    if (bl == null) {
                        return false;
                    }
                    if (bl.booleanValue()) break;
                    return false;
                }
            }
        }
        return true;
    }

    public void FSPoutput() {
        if (this.propositions.isEmpty()) {
            System.out.print("TRUE{");
        } else {
            Iterator iterator = this.propositions.iterator();
            Formula formula = null;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while (iterator.hasNext()) {
                formula = (Formula)iterator.next();
                char c = formula.getContent();
                if (bl) {
                    stringBuffer.append("_AND_");
                }
                bl = true;
                switch (c) {
                    case 'N': {
                        stringBuffer.append('N');
                        stringBuffer.append(formula.getSub1().getName());
                        break;
                    }
                    case 't': {
                        stringBuffer.append("TRUE");
                        break;
                    }
                    default: {
                        stringBuffer.append(formula.getName());
                    }
                }
            }
            System.out.print(stringBuffer + "{");
        }
        if (Node.accepting_conds == 0) {
            if (this.safe_accepting) {
                System.out.print("0");
            }
        } else {
            int n = 0;
            while (n < Node.accepting_conds) {
                if (!this.accepting.get(n)) {
                    System.out.print(n);
                }
                ++n;
            }
        }
        System.out.print("} -> S" + this.pointsTo + " ");
    }

    public void SMoutput(gov.nasa.arc.ase.util.graph.Node[] nodeArray, gov.nasa.arc.ase.util.graph.Node node) {
        Object object;
        String string = "-";
        String string2 = "-";
        if (!this.propositions.isEmpty()) {
            object = this.propositions.iterator();
            Formula formula = null;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while (object.hasNext()) {
                formula = (Formula)object.next();
                char c = formula.getContent();
                if (bl) {
                    stringBuffer.append("&");
                }
                bl = true;
                switch (c) {
                    case 'N': {
                        stringBuffer.append('!');
                        stringBuffer.append(formula.getSub1().getName());
                        break;
                    }
                    case 't': {
                        stringBuffer.append("true");
                        break;
                    }
                    default: {
                        stringBuffer.append(formula.getName());
                    }
                }
            }
            string = stringBuffer.toString();
        }
        object = new Edge(node, nodeArray[this.pointsTo], string, string2);
        if (Node.accepting_conds == 0) {
            if (this.safe_accepting) {
                ((Edge)object).setBooleanAttribute("acc0", true);
            }
        } else {
            int n = 0;
            while (n < Node.accepting_conds) {
                if (!this.accepting.get(n)) {
                    ((Edge)object).setBooleanAttribute("acc" + n, true);
                }
                ++n;
            }
        }
    }
}

