/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

public class HashPool {
    private Hashtable pool = new Hashtable();
    private int size;
    private int length = 10;
    private Object[] objects = new Object[10];
    private static final int DELTA = 10;

    public HashPool() {
        this.objects[0] = null;
        this.size = 1;
    }

    public synchronized PoolEntry put(Object object) {
        PoolEntry poolEntry = (PoolEntry)this.pool.get(object);
        if (poolEntry != null) {
            return poolEntry;
        }
        if (this.length < this.size + 1) {
            Object[] objectArray = new Object[this.length + 10];
            System.arraycopy(this.objects, 0, objectArray, 0, this.length);
            this.objects = objectArray;
            this.length += 10;
        }
        this.objects[this.size] = object;
        poolEntry = new PoolEntry(object, this.size++);
        this.pool.put(object, poolEntry);
        return poolEntry;
    }

    public Object get(Object object) {
        if (object == null) {
            return null;
        }
        PoolEntry poolEntry = (PoolEntry)this.pool.get(object);
        if (poolEntry != null) {
            return poolEntry.obj;
        }
        return this.put(object).obj;
    }

    public Object getObject(int n) {
        return this.objects[n];
    }

    public PoolEntry getEntry(Object object) {
        if (object == null) {
            return null;
        }
        PoolEntry poolEntry = (PoolEntry)this.pool.get(object);
        if (poolEntry != null) {
            return poolEntry;
        }
        return this.put(object);
    }

    public int getIndex(Object object) {
        if (object == null) {
            return -1;
        }
        PoolEntry poolEntry = (PoolEntry)this.pool.get(object);
        if (poolEntry != null) {
            return poolEntry.idx;
        }
        return this.put(object).idx;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void print() {
        System.out.println("{");
        TreeSet treeSet = new TreeSet(this.pool.values());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            System.out.println("\t" + e);
        }
        System.out.println("}");
    }

    public class PoolEntry
    implements Comparable {
        private Object obj;
        private int idx;

        public PoolEntry(Object object, int n) {
            this.obj = object;
            this.idx = n;
        }

        public Object getObject() {
            return this.obj;
        }

        public int getIndex() {
            return this.idx;
        }

        public int hashCode() {
            return this.idx;
        }

        public boolean equals(Object object) {
            PoolEntry poolEntry = (PoolEntry)object;
            return poolEntry.idx == this.idx;
        }

        public String toString() {
            return this.idx + " => " + this.obj;
        }

        public int compareTo(Object object) {
            PoolEntry poolEntry = (PoolEntry)object;
            return this.idx - poolEntry.idx;
        }
    }
}

