/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Attributes {
    private Hashtable ht = new Hashtable();

    public Attributes() {
    }

    public Attributes(Attributes attributes) {
        Enumeration enumeration = attributes.ht.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.ht.put(k, attributes.ht.get(k));
        }
    }

    public Attributes(String string) {
        if (string.equals("-")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf("=");
            if (n == -1) {
                string3 = string4;
                string2 = "";
            } else {
                string3 = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
            this.ht.put(string3, string2);
        }
    }

    public int getInt(String string) {
        Object v = this.ht.get(string);
        if (v == null) {
            return 0;
        }
        try {
            return Integer.parseInt((String)v);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getString(String string) {
        return (String)this.ht.get(string);
    }

    public boolean getBoolean(String string) {
        return this.ht.get(string) != null;
    }

    public void setInt(String string, int n) {
        this.ht.put(string, Integer.toString(n));
    }

    public void setString(String string, String string2) {
        this.ht.put(string, string2);
    }

    public void setBoolean(String string, boolean bl) {
        if (bl) {
            this.ht.put(string, "");
        } else {
            this.ht.remove(string);
        }
    }

    public void unset(String string) {
        this.ht.remove(string);
    }

    public String toString() {
        if (this.ht.size() == 0) {
            return "-";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.ht.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string = (String)this.ht.get(k);
            stringBuffer.append(k);
            if (!string.equals("")) {
                stringBuffer.append('=');
                stringBuffer.append((Object)string);
            }
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }
}

