/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.extension;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Relation
extends Hashtable {
    boolean is_relation = false;

    public Object put(Object key, Object value) {
        Object o;
        if (!this.containsKey(key)) {
            return super.put(key, value);
        }
        if (!this.is_relation) {
            this.is_relation = true;
        }
        if ((o = this.get(key)) instanceof Vector) {
            Vector v = (Vector)o;
            if (!v.contains(value)) {
                v.addElement(value);
            }
        } else {
            Vector<Object> v = new Vector<Object>(4);
            v.addElement(o);
            if (!v.equals(o)) {
                v.addElement(value);
            }
            super.put(key, v);
        }
        return o;
    }

    public boolean isRelation() {
        return this.is_relation;
    }

    public Relation inverse() {
        Relation inv = new Relation();
        Enumeration k = this.keys();
        while (k.hasMoreElements()) {
            Object key = k.nextElement();
            Object val = this.get(key);
            if (!(val instanceof Vector)) {
                inv.put(val, key);
                continue;
            }
            Enumeration v = ((Vector)val).elements();
            while (v.hasMoreElements()) {
                inv.put(v.nextElement(), key);
            }
        }
        return inv;
    }

    public void union(Relation r) {
        if (r == null) {
            return;
        }
        Enumeration k = r.keys();
        while (k.hasMoreElements()) {
            Object key = k.nextElement();
            Object val = r.get(key);
            this.putValues(key, val);
        }
    }

    public void relabel(Relation r) {
        Enumeration k = this.keys();
        while (k.hasMoreElements()) {
            Enumeration v;
            Object newkey;
            String oldkey = (String)k.nextElement();
            Object values = this.get(oldkey);
            if (r.containsKey(oldkey)) {
                newkey = r.get(oldkey);
                this.remove(oldkey);
                if (!(newkey instanceof Vector)) {
                    this.putValues(newkey, values);
                    continue;
                }
                v = ((Vector)newkey).elements();
                while (v.hasMoreElements()) {
                    this.putValues(v.nextElement(), values);
                }
                continue;
            }
            if (!Relation.hasPrefix(oldkey, r)) continue;
            newkey = r.get(Relation.prefix(oldkey, r));
            if (!(newkey instanceof Vector)) {
                String nk = Relation.prefixReplace(oldkey, (String)newkey, r);
                this.putValues(nk, values);
                continue;
            }
            v = ((Vector)newkey).elements();
            while (v.hasMoreElements()) {
                String nk = Relation.prefixReplace(oldkey, (String)v.nextElement(), r);
                this.putValues(nk, values);
            }
        }
    }

    protected void putValues(Object key, Object values) {
        if (!(values instanceof Vector)) {
            this.put(key, values);
        } else {
            Enumeration v = ((Vector)values).elements();
            while (v.hasMoreElements()) {
                this.put(key, v.nextElement());
            }
        }
    }

    private static String prefixReplace(String s, String np, Hashtable oldtonew) {
        int prefix_end = Relation.maximalPrefix(s, oldtonew);
        if (prefix_end < 0) {
            return s;
        }
        return String.valueOf(np) + s.substring(prefix_end);
    }

    private static int maximalPrefix(String s, Hashtable oldtonew) {
        int prefix_end = s.lastIndexOf(46);
        if (prefix_end < 0) {
            return prefix_end;
        }
        if (oldtonew.containsKey(s.substring(0, prefix_end))) {
            return prefix_end;
        }
        return Relation.maximalPrefix(s.substring(0, prefix_end), oldtonew);
    }

    private static boolean hasPrefix(String s, Hashtable oldtonew) {
        return Relation.maximalPrefix(s, oldtonew) >= 0;
    }

    private static String prefix(String s, Hashtable oldtonew) {
        return s.substring(0, Relation.maximalPrefix(s, oldtonew));
    }
}

