/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.bpel;

import ic.doc.ltsa.bpel.bpelaction;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class bpel2fsp {
    private Document bpelDoc = null;
    private NodeList processlist = null;
    private Node currentprocessnode = null;
    private LinkedList CompositionList = new LinkedList();
    private LinkedList WarningList = null;
    private LinkedList CaseList = new LinkedList();
    private LinkedList AlphabetList = new LinkedList();
    private HashMap AssignValueList = new HashMap();
    private LinkedList ActionList = new LinkedList();
    private LinkedList LinksList = new LinkedList();
    private LinkedList constructList = null;
    private LinkedList ScopeList = new LinkedList();
    private LinkedList SwitchList = new LinkedList();
    private LinkedList FaultHanderList = new LinkedList();
    private LinkedList PickList = null;
    private HashMap ProcessPartnersList = null;
    private HashMap ProcessActionList = null;
    private int serviceLinkTypeCounter = 0;
    private HashMap FSPProcessList = null;
    private HashMap processList = null;
    private OutputStream outFSPStream = null;
    private OutputStream outStream = null;
    private int flowIDCounter = 1;
    private int whileIDCounter = 1;
    private int sequenceIDCounter = 1;
    private int assignIDCounter = 1;
    private int actionID = 1;
    private int caseCounter = 0;
    private int throwCounter = 0;
    private String tempPortPartner;
    private boolean withinScope = false;
    private boolean hasFaultHandler = false;
    public String strBPELProcessName = "";
    private transient Vector cellEditorListeners;

    public bpel2fsp() {
        this.constructList = new LinkedList();
        this.PickList = new LinkedList();
        this.ProcessPartnersList = new HashMap();
        this.ProcessActionList = new HashMap();
    }

    public LinkedList getActionList() {
        return this.ActionList;
    }

    public LinkedList getActionListByProcessName(String processname) {
        LinkedList aprocessActionList = null;
        if (this.ProcessActionList.containsKey(processname)) {
            aprocessActionList = (LinkedList)this.ProcessActionList.get(processname);
        }
        return aprocessActionList;
    }

    private int getLinkValue(String linkvalue) {
        int value = this.LinksList.indexOf(linkvalue);
        if (value < 1) {
            value = 1;
        }
        return value;
    }

    private int getAssignValue(String variable, String assignvalue) {
        LinkedList variableLinkedList;
        if (!this.AssignValueList.containsKey(variable)) {
            this.AssignValueList.put(variable, new LinkedList());
        }
        if (!(variableLinkedList = (LinkedList)this.AssignValueList.get(variable)).contains(assignvalue)) {
            variableLinkedList.add(assignvalue);
        }
        return variableLinkedList.indexOf(assignvalue);
    }

    private boolean isTextNode(Node currentNode) {
        return currentNode.getNodeName().equals("#text");
    }

    private void reportNodeWarning(Node currentNode, String Warning) {
        this.writeOutput("WARNING: Construct " + currentNode + " " + Warning);
    }

    private String translateBPELNode(Node currentNode, boolean addAlphabet) {
        String currentNodeString = "";
        Document bpelDoc = null;
        NodeList currentnodelist = null;
        if (currentNode.getNodeName().compareTo("onMessage") == 0) {
            currentNodeString = this.buildOnMessage(currentNode);
        }
        if (currentNode.getNodeName().compareTo("catchAll") == 0) {
            currentNodeString = this.buildCatchFSP(currentNode, true);
        }
        if (currentNode.getNodeName().compareTo("catch") == 0) {
            currentNodeString = this.buildCatchFSP(currentNode, true);
        }
        if (currentNode.getNodeName().compareTo("faultHandlers") == 0) {
            currentNodeString = this.buildFaultHandlersFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("scope") == 0) {
            currentNodeString = this.buildScopeFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("link") == 0) {
            currentNodeString = this.buildLinkFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("sequence") == 0) {
            currentNodeString = this.buildSequenceFSP(currentNode, true, addAlphabet);
        }
        if (currentNode.getNodeName().compareTo("assign") == 0) {
            currentNodeString = this.buildAssignFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("assignment") == 0) {
            currentNodeString = this.buildAssignFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("wait") == 0) {
            currentNodeString = this.buildWaitFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("receive") == 0) {
            currentNodeString = this.buildReceiveReplyFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("reply") == 0) {
            currentNodeString = this.buildReceiveReplyFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("flow") == 0) {
            currentNodeString = this.buildFlowFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("while") == 0) {
            currentNodeString = this.buildWhileFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("case") == 0) {
            currentNodeString = this.buildCaseFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("otherwise") == 0) {
            currentNodeString = this.buildCaseFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("switch") == 0) {
            currentNodeString = this.buildSwitchFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("pick") == 0) {
            currentNodeString = this.buildPickFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("throw") == 0) {
            currentNodeString = this.buildThrow(currentNode);
        }
        if (currentNode.getNodeName().compareTo("terminate") == 0) {
            currentNodeString = this.buildTerminate(currentNode);
        }
        if (currentNode.getNodeName().compareTo("invoke") == 0) {
            currentNodeString = this.buildReceiveReplyFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("links") == 0) {
            currentNodeString = "";
            bpelDoc = currentNode.getOwnerDocument();
            currentnodelist = bpelDoc.getElementsByTagName("link");
            this.writeFSPOutput("// Links start");
            int loop = 0;
            while (loop < currentnodelist.getLength()) {
                if (currentnodelist.item(loop).getNodeName().compareTo("link") == 0) {
                    this.translateBPELNode(currentnodelist.item(loop), false);
                }
                ++loop;
            }
            this.writeFSPOutput("// Links end");
        }
        return currentNodeString;
    }

    private void initCounters() {
        this.flowIDCounter = 1;
        this.whileIDCounter = 1;
        this.sequenceIDCounter = 1;
        this.assignIDCounter = 1;
        this.actionID = 1;
        this.throwCounter = 1;
    }

    public boolean translateFSPProcess(String processname, String process) {
        boolean isendprocess = false;
        return isendprocess;
    }

    public boolean translateFromFSP() {
        boolean result = false;
        String archmodel = "";
        int LastArchModelProcess_pos = 0;
        int StartArchModelProcess_pos = 0;
        if (!this.FSPProcessList.isEmpty()) {
            archmodel = this.GetFSPProcess("||ArchitectureModel");
            StartArchModelProcess_pos = archmodel.indexOf("(") + 1;
            LastArchModelProcess_pos = archmodel.indexOf("||");
            String cfr_ignored_0 = "_deterministic ||" + archmodel.substring(StartArchModelProcess_pos, LastArchModelProcess_pos).trim();
            this.GetFSPProcess("_deterministic ||" + archmodel.substring(StartArchModelProcess_pos, LastArchModelProcess_pos).trim());
        }
        return result;
    }

    private Node getRootNodeFromBPELDOM(NodeList currentnodelist, String NodeName) {
        Node nodefound = null;
        int elem = 0;
        while (elem < currentnodelist.getLength()) {
            if (currentnodelist.item(elem).getNodeName().equals(NodeName)) {
                nodefound = currentnodelist.item(elem);
            }
            ++elem;
        }
        return nodefound;
    }

    public void prepareforCompositeProcess() {
        this.ProcessPartnersList.clear();
        this.ProcessActionList.clear();
        this.serviceLinkTypeCounter = 1;
    }

    private String filterStrforFSP(String source) {
        if (source != null) {
            source = source.replace(':', '_');
            source = source.replace(';', '_');
        }
        return source;
    }

    public boolean translateToFSP(boolean isComposite) {
        boolean result = false;
        NodeList currentnodelist = null;
        Node currentnode = null;
        String SetModelComposition = null;
        boolean sequenceRoot = false;
        boolean flowRoot = false;
        String mainprocess = "";
        this.hasFaultHandler = false;
        this.CompositionList.clear();
        this.CompositionList.clear();
        this.CaseList.clear();
        this.AlphabetList.clear();
        this.AssignValueList.clear();
        this.LinksList.clear();
        this.ScopeList.clear();
        this.ActionList.clear();
        if (this.ActionList.size() > 0) {
            this.writeFSPOutput("// ActionList: Size=" + this.ActionList.size() + " , First=" + this.ActionList.getFirst());
        }
        this.initCounters();
        this.writeFSPOutput("\n// /////////////////////////////////////////////////////////////////");
        this.writeFSPOutput("// START BPEL4WS Process: " + this.strBPELProcessName);
        this.writeFSPOutput("// /////////////////////////////////////////////////////////////////");
        currentnode = this.getRootNodeFromBPELDOM(this.bpelDoc.getChildNodes(), "process");
        currentnodelist = currentnode.getChildNodes();
        currentnode = this.getRootNodeFromBPELDOM(currentnodelist, "variables");
        if (currentnode != null) {
            this.writeOutput("// found variables - translating");
            this.buildvariablesFSP(currentnode);
        }
        if ((currentnode = this.getRootNodeFromBPELDOM(currentnodelist, "faultHandlers")) != null) {
            this.writeOutput("// found faultHandlers - translating");
            this.buildFaultHandlersFSP(currentnode);
        }
        if ((currentnode = this.getRootNodeFromBPELDOM(currentnodelist, "partners")) != null) {
            this.writeOutput("// found partners - building partner list...");
            this.ProcessPartnersList.put(this.strBPELProcessName, this.buildPartnerList(currentnode));
            this.writeFSPOutput("\n//" + this.strBPELProcessName + " : Partners = " + this.ProcessPartnersList.size() + "/////////////////////////////////////////////////////////////////");
        }
        if ((currentnode = this.getRootNodeFromBPELDOM(currentnodelist, "sequence")) != null) {
            this.writeOutput("// found sequence - translating");
            sequenceRoot = true;
            this.writeOutput("// found sequence - translating");
        }
        if ((currentnode = this.getRootNodeFromBPELDOM(currentnodelist, "flow")) != null) {
            this.writeOutput("// found sequence - translating");
            flowRoot = true;
        }
        if (sequenceRoot | flowRoot) {
            if (sequenceRoot) {
                currentnode = this.getRootNodeFromBPELDOM(currentnodelist, "sequence");
                this.writeFSPOutput("// Entry: SEQUENCE start ---------------------------");
                mainprocess = this.buildSequenceFSP(currentnode, true, true);
                this.writeFSPOutput("// Entry: SEQUENCE end ---------------------------");
            }
            if (flowRoot) {
                currentnode = this.getRootNodeFromBPELDOM(currentnodelist, "flow");
                this.writeFSPOutput("// Entry: FLOW start -------------------------------");
                mainprocess = this.buildFlowFSP(currentnode);
                this.writeFSPOutput("// Entry: FLOW end -------------------------------");
            }
            SetModelComposition = "||" + this.strBPELProcessName + "_Instance = (";
            Iterator I = this.CompositionList.iterator();
            while (I.hasNext()) {
                SetModelComposition = String.valueOf(SetModelComposition) + I.next();
                if (!I.hasNext()) continue;
                SetModelComposition = String.valueOf(SetModelComposition) + " || ";
            }
            SetModelComposition = String.valueOf(SetModelComposition) + ").";
            this.writeFSPOutput(SetModelComposition);
            SetModelComposition = "||" + this.strBPELProcessName + "_BPELModel = (";
            SetModelComposition = String.valueOf(SetModelComposition) + mainprocess;
            SetModelComposition = String.valueOf(SetModelComposition) + ").";
            this.writeFSPOutput(SetModelComposition);
        } else {
            this.writeOutput("WARNING: NO SEQUENCE SPECIFIED!");
        }
        this.writeFSPOutput("// /////////////////////////////////////////////////////////////////");
        this.writeFSPOutput("// END BPEL4WS Process: " + this.strBPELProcessName);
        this.writeFSPOutput("// /////////////////////////////////////////////////////////////////");
        this.writeOutput("******************************************************");
        this.writeOutput("************ FSP SPECIFICATION END    ****************");
        this.writeOutput("******************************************************");
        if (isComposite) {
            this.ProcessActionList.put(this.strBPELProcessName, this.ActionList.clone());
        }
        try {
            this.outFSPStream.close();
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return result;
    }

    private HashMap buildPartnerList(Node PartnersNode) {
        HashMap<String, String> PartnersList = new HashMap<String, String>();
        NodeList currentnodelist = null;
        NodeList tempNodeList = null;
        Node Partner = null;
        String PartnerName = "";
        String serviceLink = "";
        currentnodelist = this.bpelDoc.getElementsByTagName("partners");
        if (currentnodelist.getLength() > 0) {
            tempNodeList = currentnodelist.item(0).getChildNodes();
            int loop = 0;
            while (loop < tempNodeList.getLength()) {
                Partner = tempNodeList.item(loop);
                if (Partner.getNodeName().compareTo("partner") == 0) {
                    PartnerName = Partner.getAttributes().getNamedItem("name").getNodeValue().toLowerCase();
                    serviceLink = Partner.getAttributes().getNamedItem("serviceLinkType").getNodeValue().toLowerCase();
                    PartnersList.put(PartnerName, serviceLink);
                    this.writeFSPOutput("// Added Partner : " + PartnerName + "," + serviceLink);
                    PartnerName = "";
                    serviceLink = "";
                }
                ++loop;
            }
        }
        return PartnersList;
    }

    public String getProcessPartnerPortType(String processname, String partner, String Role) {
        HashMap LocalPartnerList = null;
        String result = "";
        if (this.ProcessPartnersList != null && (LocalPartnerList = (HashMap)this.ProcessPartnersList.get(processname)) != null && LocalPartnerList.containsKey(partner) && (result = (String)LocalPartnerList.get(partner)).indexOf(":") > 0) {
            result = result.substring(result.indexOf(":") + 1);
        }
        return result;
    }

    public String getProcessPartnerByserviceLinkType(String processname, String serviceLinkType) {
        HashMap LocalPartnerList = null;
        String result = "";
        if (this.ProcessPartnersList != null && (LocalPartnerList = (HashMap)this.ProcessPartnersList.get(processname)) != null) {
            Iterator I = LocalPartnerList.keySet().iterator();
            while (I.hasNext()) {
                String sltpartner = (String)I.next();
                String slt = (String)LocalPartnerList.get(sltpartner);
                if (!(slt = slt.substring(slt.indexOf(":") + 1)).equals(serviceLinkType.toLowerCase())) continue;
                result = sltpartner;
            }
        }
        return result;
    }

    private String addPortActionMap(ByteArrayOutputStream baos, String process, String partner, String serviceLink, String operation, HashMap wsdllist) {
        String processopname = String.valueOf(process) + "_" + partner + "_" + operation;
        String portname = (String.valueOf(processopname) + "_PORT").toUpperCase();
        String partername = "";
        String portpartner = "";
        String porttype = "";
        String serviceLinkType = "";
        String strWSDLXML = "";
        boolean haspartner = false;
        this.tempPortPartner = "";
        try {
            if (wsdllist != null) {
                strWSDLXML = (String)wsdllist.get(process);
                int slbegin = strWSDLXML.indexOf("serviceLinkType name=\"");
                if (slbegin > 0) {
                    int slend = strWSDLXML.indexOf("\"", slbegin + 22);
                    serviceLinkType = strWSDLXML.substring(slbegin + 22, slend);
                    int portbegin = strWSDLXML.indexOf("portType name=\"");
                    if (portbegin > 0) {
                        int portend = strWSDLXML.indexOf("\"", portbegin + 15);
                        porttype = strWSDLXML.substring(portbegin + 15, portend);
                    }
                }
                if (porttype.length() > 0) {
                    Iterator I = wsdllist.keySet().iterator();
                    while (I.hasNext()) {
                        int partnerptend;
                        int opbegin;
                        String Iprocess;
                        String Iwsdl;
                        int partnerptbegin;
                        if (!I.hasNext() || (partnerptbegin = (Iwsdl = (String)wsdllist.get(Iprocess = (String)I.next())).indexOf("portType name=\"")) <= 0 || (opbegin = Iwsdl.indexOf("operation name=\"", partnerptend = Iwsdl.indexOf("\"", partnerptbegin + 15))) <= 0) continue;
                        int opend = Iwsdl.indexOf("\"", opbegin + 16);
                        String Iopename = Iwsdl.substring(opbegin + 16, opend);
                        if (!operation.toLowerCase().equals(Iopename.toLowerCase())) continue;
                        haspartner = true;
                        this.tempPortPartner = partername = Iprocess;
                        System.out.println("\nFOUND PARTNER: " + partername);
                        portpartner = this.getProcessPartnerByserviceLinkType(Iprocess, serviceLinkType);
                        System.out.println("\nPARTNER PORT: " + portpartner);
                    }
                }
            }
            baos.write("\n// /////////////////////////////////////////////////////////////////".toString().getBytes());
            baos.write("\n// PORT PROCESS CONNECTOR: Compose synchronised message ports.".toString().getBytes());
            baos.write("\n// /////////////////////////////////////////////////////////////////".toString().getBytes());
            baos.write(("\nrange " + portname.toUpperCase() + "_RANGE = 0..0").toString().getBytes());
            baos.write(("\n" + portname.toUpperCase() + "_REPLY = (").toString().getBytes());
            if (haspartner) {
                baos.write(("reply_" + portpartner + "_" + partername.toLowerCase() + "_" + operation.toLowerCase() + "->").toString().getBytes());
            }
            baos.write(("reply_" + partner + "_" + process.toLowerCase() + "_" + operation.toLowerCase() + "->").toString().getBytes());
            baos.write((String.valueOf(portname) + "_REPLY).").toString().getBytes());
            baos.write(("\n" + portname + "_INVOKE = (invoke_" + process.toLowerCase() + "_" + partner + "_" + operation.toLowerCase() + "->").toString().getBytes());
            if (haspartner) {
                baos.write(("receive_" + portpartner + "_" + partername.toLowerCase() + "_" + operation.toLowerCase() + "->").toString().getBytes());
            }
            baos.write((String.valueOf(portname) + "_INVOKE).").toString().getBytes());
            baos.write(("\n||" + portname + " = (" + portname + "_INVOKE || " + portname + "_REPLY).\n").toString().getBytes());
            baos.write("\n// /////////////////////////////////////////////////////////////////".toString().getBytes());
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return portname;
    }

    public String buildChoreographyModel(HashMap newProcessList, HashMap newwsdllist) {
        LinkedList<String> PortList = new LinkedList<String>();
        int loop = 0;
        String processarchs = "";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        String portopname = "";
        try {
            this.prepareforCompositeProcess();
            loop = 0;
            Iterator I = newProcessList.keySet().iterator();
            while (I.hasNext()) {
                if (!I.hasNext()) continue;
                String processname = (String)I.next();
                this.loadBPEL((String)newProcessList.get(processname), false);
                this.setFSPOutput(baos);
                this.setOutput(temp);
                this.translateToFSP(true);
                processname = String.valueOf(processname) + "_BPELModel";
                if (loop > 0) {
                    processarchs = String.valueOf(processarchs) + " || ";
                }
                processarchs = String.valueOf(processarchs) + processname;
                ++loop;
            }
            loop = 0;
            I = newProcessList.keySet().iterator();
            while (I.hasNext()) {
                if (!I.hasNext()) continue;
                String process = (String)I.next();
                this.getActionListByProcessName(process);
                Iterator Actions = this.getActionListByProcessName(process).iterator();
                while (Actions.hasNext()) {
                    bpelaction abpelaction;
                    String nextaction = (String)Actions.next();
                    if (!nextaction.startsWith("invoke") && !nextaction.startsWith("receive") && !nextaction.startsWith("reply") || !(abpelaction = new bpelaction(nextaction)).getAction().equals("invoke")) continue;
                    String serviceLinkType = this.getProcessPartnerPortType(process.toUpperCase(), abpelaction.getPartner2(), abpelaction.getOperation()).toString();
                    PortList.add(this.addPortActionMap(baos, process.toUpperCase(), abpelaction.getPartner2(), serviceLinkType.toUpperCase(), abpelaction.getOperation().toUpperCase(), newwsdllist));
                    if (serviceLinkType.length() == 0) {
                        serviceLinkType = "unknown" + this.serviceLinkTypeCounter++;
                    }
                    portopname = String.valueOf(process.toLowerCase()) + "_" + serviceLinkType + "_" + abpelaction.getOperation();
                    baos.write("\n// /////////////////////////////////////////////////////////////////////////".toString().getBytes());
                    baos.write(("\n// " + nextaction.toString() + " CONNECTOR PORT ARCHITECTURE").toString().getBytes());
                    baos.write("\n// ////////////////////////////////////////////////////////////////////////".toString().getBytes());
                    baos.write(("\n||PortArchitecture_" + portopname + " = (").toString().getBytes());
                    baos.write((String.valueOf(process) + "_BPELModel").toString().getBytes());
                    if (this.tempPortPartner.length() > 0) {
                        baos.write((" || " + this.tempPortPartner + "_BPELModel").toString().getBytes());
                    }
                    baos.write((" || " + PortList.getLast()).toString().getBytes());
                    baos.write(").\n".toString().getBytes());
                }
            }
            baos.write("\n// /////////////////////////////////////////////////////////////////".toString().getBytes());
            baos.write("\n// COMPOSITION ARCHITECTURE: Compose parallel architecture model.".toString().getBytes());
            baos.write("\n// /////////////////////////////////////////////////////////////////".toString().getBytes());
            baos.write("\n||CompositionArchitecture = (".toString().getBytes());
            baos.write(processarchs.toString().getBytes());
            baos.write(").".toString().getBytes());
            return baos.toString();
        }
        catch (Exception exception) {
            return baos.toString();
        }
    }

    private String buildWaitFSP(Node SequenceNode) {
        String compositionString = "";
        String compositionName = "";
        String variableName = "";
        SequenceNode.getChildNodes();
        try {
            compositionName = SequenceNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
            compositionName = compositionName.replace('-', '_');
        }
        catch (Exception exception) {
            compositionName = "WAIT" + this.throwCounter++;
        }
        try {
            variableName = SequenceNode.getAttributes().getNamedItem("for").getNodeValue().toUpperCase();
            compositionName = String.valueOf(compositionName) + "_" + variableName;
        }
        catch (Exception exception) {
            compositionName = String.valueOf(compositionName) + "_" + variableName;
        }
        try {
            compositionString = String.valueOf(compositionName) + " = (" + compositionName.toLowerCase() + "->END).";
            this.writeFSPOutput(compositionString);
        }
        catch (Exception E) {
            System.err.println("\nERRROR...");
            E.printStackTrace(System.err);
        }
        return compositionName;
    }

    private String buildThrow(Node SequenceNode) {
        String compositionString = "";
        String compositionName = "";
        String variableName = "";
        SequenceNode.getChildNodes();
        try {
            compositionName = SequenceNode.getAttributes().getNamedItem("faultName").getNodeValue().toUpperCase();
            if (compositionName.indexOf(":") > 0) {
                compositionName = compositionName.substring(compositionName.indexOf(":") + 1);
            }
        }
        catch (Exception exception) {
            compositionName = "THROW" + this.throwCounter++;
        }
        try {
            variableName = SequenceNode.getAttributes().getNamedItem("faultVariable").getNodeValue().toUpperCase();
            compositionName = String.valueOf(compositionName) + "_" + variableName;
        }
        catch (Exception exception) {
            compositionName = String.valueOf(compositionName) + "_" + variableName;
        }
        try {
            compositionString = String.valueOf(compositionName) + " = (" + compositionName.toLowerCase() + "->END).";
            this.writeFSPOutput(compositionString);
        }
        catch (Exception E) {
            System.err.println("\nERRROR...");
            E.printStackTrace(System.err);
        }
        return compositionName;
    }

    public String buildCatchFSP(Node SequenceNode, boolean hasname) {
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructString = "";
        String compositionName = "";
        try {
            constructNodeList = SequenceNode.getChildNodes();
            compositionName = !hasname ? SequenceNode.getAttributes().getNamedItem("faultName").getNodeValue().toUpperCase() : "CATCH" + this.sequenceIDCounter++;
            compositionString = String.valueOf(compositionString) + " = (faultcaught->END).";
            this.writeFSPOutput(compositionString);
            if (SequenceNode.getNodeName().equals("otherwise")) {
                compositionName = String.valueOf(compositionName) + "EVAL";
            }
            compositionString = String.valueOf(compositionName) + " = ";
            constructcounter = 0;
            int loop = 0;
            while (loop < constructNodeList.getLength()) {
                constructNode = constructNodeList.item(loop);
                if (!this.isTextNode(constructNode) && !constructNode.getNodeName().equals("#comment")) {
                    if (constructcounter > 0) {
                        compositionString = String.valueOf(compositionString) + " ; ";
                    }
                    constructString = this.translateBPELNode(constructNode, false);
                    compositionString = constructNode.hasAttributes() && constructString.length() == 0 ? String.valueOf(compositionString) + constructString : String.valueOf(compositionString) + constructString;
                    if (constructString.length() > 0) {
                        ++constructcounter;
                    }
                }
                ++loop;
            }
            compositionString = String.valueOf(compositionString) + "; END";
            compositionString = String.valueOf(compositionString) + ".";
            this.writeFSPOutput(compositionString);
        }
        catch (Exception E) {
            System.err.println("\nERRROR...");
            E.printStackTrace(System.err);
        }
        return compositionName;
    }

    public String buildSequenceFSP(Node SequenceNode, boolean hasname, boolean addAlphabet) {
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructString = "";
        String compositionName = "";
        try {
            constructNodeList = SequenceNode.getChildNodes();
            compositionName = !hasname ? SequenceNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : "SEQUENCE" + this.sequenceIDCounter++;
            compositionName = String.valueOf(this.strBPELProcessName) + "_" + compositionName;
            if (SequenceNode.getNodeName().equals("otherwise")) {
                compositionName = String.valueOf(compositionName) + "EVAL";
            }
            compositionString = String.valueOf(compositionName) + " = ";
            constructcounter = 0;
            int loop = 0;
            while (loop < constructNodeList.getLength()) {
                constructNode = constructNodeList.item(loop);
                if (!this.isTextNode(constructNode) && !constructNode.getNodeName().equals("#comment")) {
                    if (constructcounter > 0) {
                        compositionString = String.valueOf(compositionString) + " ; ";
                    }
                    constructString = this.translateBPELNode(constructNode, false);
                    this.writeOutput("// add SEQ: " + constructNode.getNodeName() + " - " + constructString + "\n");
                    compositionString = constructNode.hasAttributes() && constructString.length() == 0 ? String.valueOf(compositionString) + constructString : String.valueOf(compositionString) + constructString;
                    if (constructString.length() > 0) {
                        ++constructcounter;
                    }
                }
                ++loop;
            }
            compositionString = String.valueOf(compositionString) + "; END";
            if (addAlphabet && this.AlphabetList.size() > 0) {
                compositionString = String.valueOf(compositionString) + " + {";
                Iterator I = this.AlphabetList.iterator();
                while (I.hasNext()) {
                    compositionString = String.valueOf(compositionString) + I.next();
                    if (!I.hasNext()) continue;
                    compositionString = String.valueOf(compositionString) + ",";
                }
                compositionString = String.valueOf(compositionString) + "}";
            }
            compositionString = String.valueOf(compositionString) + ".";
            this.writeFSPOutput(compositionString);
            if (addAlphabet) {
                this.CompositionList.add(compositionName);
            }
        }
        catch (Exception E) {
            System.err.println("\nERRROR...");
            E.printStackTrace(System.err);
        }
        return compositionName;
    }

    public String buildRendevousPortModel(String processa, String processb) {
        String compositionString = "";
        this.writeFSPOutput("\n// /////////////////////////////////////////////////////////////////");
        this.writeFSPOutput("\n// PORT MODEL - INVOKE/RECEIVE/REPLY");
        this.writeFSPOutput("\n// /////////////////////////////////////////////////////////////////");
        compositionString = String.valueOf(compositionString) + "\n// Invoke-Receive-Reply Connector Model\n";
        compositionString = String.valueOf(compositionString) + "range PORTM = 0..0\n";
        compositionString = String.valueOf(compositionString) + "PORT_REPLY = (reply[v:PORTM]->invoke_output[v]->PORT_REPLY).\n";
        compositionString = String.valueOf(compositionString) + "PORT_INVOKE = (invoke_input[v:PORTM]->receive[v]->PORT_INVOKE).\n";
        compositionString = String.valueOf(compositionString) + "||APORT = (PORT_INVOKE || PORT_REPLY).\n";
        this.writeFSPOutput("\n// /////////////////////////////////////////////////////////////////");
        this.writeFSPOutput("\n// PORT MODEL - INVOKE/RECEIVE");
        this.writeFSPOutput("\n// /////////////////////////////////////////////////////////////////");
        compositionString = String.valueOf(compositionString) + "BPORT_INVOKE = (invoke_input[v:PORTM]->receive[v]->BPORT_INVOKE).\n";
        compositionString = String.valueOf(compositionString) + "||BPORT = (BPORT_INVOKE).\n";
        this.writeFSPOutput("\n// /////////////////////////////////////////////////////////////////\n");
        this.writeFSPOutput(compositionString);
        return compositionString;
    }

    public String buildRequestOnlyPortModel(String processa, String processb) {
        String compositionString = "";
        this.writeFSPOutput("\n// /////////////////////////////////////////////////////////////////");
        this.writeFSPOutput("\n// PORT MODEL - INVOKE/RECEIVE");
        this.writeFSPOutput("\n// /////////////////////////////////////////////////////////////////");
        compositionString = String.valueOf(compositionString) + "BPORT_INVOKE = (invoke_input[v:PORTM]->receive[v]->BPORT_INVOKE).\n";
        compositionString = String.valueOf(compositionString) + "||BPORT = (BPORT_INVOKE).\n";
        this.writeFSPOutput("\n// /////////////////////////////////////////////////////////////////\n");
        this.writeFSPOutput(compositionString);
        return compositionString;
    }

    private String buildCaseFSP(Node FlowNode) {
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String compositionName = "";
        String conditionString = "";
        String conditionvariableName = "";
        String conditionvariablePart = "";
        String conditionvariableValue = "";
        String whileLoopActionName = "";
        String whilecompositionName = "";
        constructNodeList = FlowNode.getChildNodes();
        compositionName = FlowNode.getAttributes().getNamedItem("name") != null ? FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : String.valueOf(FlowNode.getNodeName().toUpperCase()) + this.caseCounter++;
        compositionString = "||" + FlowNode.getNodeName().toUpperCase();
        if (FlowNode.getAttributes().getNamedItem("condition") != null) {
            conditionString = FlowNode.getAttributes().getNamedItem("condition").getNodeValue();
            int beginname = conditionString.indexOf("'") + 1;
            int endname = conditionString.indexOf("'", beginname);
            conditionvariableName = conditionString.substring(beginname, endname);
            beginname = conditionString.indexOf("'", endname + 1) + 1;
            endname = conditionString.indexOf("'", beginname);
            conditionvariablePart = conditionString.substring(beginname, endname);
            beginname = conditionString.indexOf("=");
            endname = conditionString.indexOf("'", beginname);
            conditionvariableValue = conditionString.substring(beginname + 1).trim();
            compositionString = String.valueOf(compositionString) + conditionvariableName + conditionvariablePart;
            this.writeOutput("//adding case = " + compositionName + conditionvariableName + conditionvariablePart);
            compositionString = String.valueOf(compositionString) + " = " + conditionvariableName + "." + conditionvariablePart;
            compositionString = String.valueOf(compositionString) + ":" + this.strBPELProcessName + "_variable(0).";
            compositionString = String.valueOf(conditionvariableName.toUpperCase()) + conditionvariablePart.toUpperCase() + "OUTCOME";
            this.CompositionList.add(String.valueOf(compositionName) + compositionString);
            compositionString = "||" + compositionName + compositionString + " = " + conditionvariableName + "." + conditionvariablePart + ":" + this.strBPELProcessName + "_variable.";
            this.writeFSPOutput(compositionString);
            this.ActionList.add(String.valueOf(conditionvariableName) + "." + conditionvariablePart);
            compositionString = String.valueOf(compositionName) + conditionvariableName.toUpperCase() + conditionvariablePart.toUpperCase() + "OUTCOME_ALPHABET";
            this.AlphabetList.add(compositionString);
            compositionString = "set " + compositionString + " = {" + conditionvariableName + "." + conditionvariablePart + ".{read,write}.[" + this.strBPELProcessName + "_IntRange]}";
            this.writeFSPOutput(compositionString);
            this.writeFSPOutput(String.valueOf(compositionName) + conditionvariableName.toUpperCase() + conditionvariablePart.toUpperCase() + "EVAL = (" + conditionvariableName + "." + conditionvariablePart + ".read[i:" + this.strBPELProcessName + "_IntRange]->" + compositionName + conditionvariableName.toUpperCase() + conditionvariablePart.toUpperCase() + "EVAL[i]),");
            this.writeFSPOutput(String.valueOf(compositionName) + conditionvariableName.toUpperCase() + conditionvariablePart.toUpperCase() + "EVAL[i:" + this.strBPELProcessName + "_IntRange] = if (i==" + this.getAssignValue(conditionvariableName, conditionvariableValue) + ")");
            this.writeFSPOutput("then " + compositionName + "; END else ");
            int caseIndex = this.CaseList.indexOf(compositionName);
            this.writeOutput("//else = " + compositionName + " index = " + caseIndex + 1);
            if (caseIndex > -1 && caseIndex + 1 < this.CaseList.size()) {
                String caseevalname = (String)this.CaseList.get(caseIndex + 1);
                if (!caseevalname.startsWith("OTHERWISE")) {
                    caseevalname = String.valueOf(caseevalname) + "EVAL";
                }
                this.writeFSPOutput(String.valueOf(caseevalname) + ";");
            }
            this.writeFSPOutput(" END.");
            this.writeFSPOutput("||" + compositionName + "EVAL = (" + compositionName + conditionvariableName.toUpperCase() + conditionvariablePart.toUpperCase() + "EVAL).");
        }
        whilecompositionName = compositionName;
        compositionString = "||" + compositionName + " = (";
        constructcounter = 0;
        String constructString = "";
        compositionName = String.valueOf(conditionvariableName.toUpperCase()) + conditionvariablePart.toUpperCase();
        if (!FlowNode.getNodeName().equals("otherwise")) {
            compositionName = String.valueOf(compositionName) + "EVAL";
        }
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode)) {
                constructString = this.translateBPELNode(constructNode, false);
                if (constructcounter > 0) {
                    compositionString = String.valueOf(compositionString) + " || ";
                } else {
                    whileLoopActionName = constructString;
                }
                if (!constructNode.hasAttributes()) {
                    constructName = "*unknown*";
                    this.reportNodeWarning(constructNode, "has no name.");
                } else {
                    constructName = constructNode.getAttributes().getNamedItem("name") != null ? constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : String.valueOf(constructNode.getNodeName().toUpperCase()) + this.whileIDCounter++;
                }
                compositionString = String.valueOf(compositionString) + constructName;
                ++constructcounter;
            }
            ++loop;
        }
        this.writeFSPOutput("||" + whilecompositionName + " = (" + whileLoopActionName + ").");
        compositionString = String.valueOf(compositionString) + ").";
        return compositionName;
    }

    private String buildSwitchFSP(Node FlowNode) {
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String compositionName = "";
        String constructString = "";
        int noofcases = 0;
        constructNodeList = FlowNode.getChildNodes();
        compositionName = FlowNode.getAttributes().getNamedItem("name") != null ? FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : String.valueOf(FlowNode.getNodeName().toUpperCase()) + this.whileIDCounter++;
        compositionString = String.valueOf(compositionName) + " = ";
        constructcounter = 0;
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode)) {
                ++noofcases;
                constructName = constructNode.getAttributes().getNamedItem("name") != null ? constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : String.valueOf(constructNode.getNodeName().toUpperCase()) + this.CaseList.size();
                this.writeOutput("//adding case = " + constructName);
                if (this.CaseList.contains("OTHERWISE1")) {
                    this.CaseList.set(this.CaseList.indexOf("OTHERWISE1"), constructName);
                    this.CaseList.add("OTHERWISE1");
                } else {
                    this.CaseList.add(constructName);
                }
            }
            ++loop;
        }
        this.caseCounter = 0;
        loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode)) {
                constructString = this.translateBPELNode(constructNode, false);
                if (constructNode.hasAttributes() && constructString.length() == 0 && constructcounter == 0) {
                    compositionString = String.valueOf(compositionString) + this.CaseList.getFirst().toString() + constructString;
                }
                if (constructcounter == 0) {
                    compositionString = String.valueOf(compositionString) + this.CaseList.getFirst().toString() + constructString;
                }
                ++constructcounter;
            }
            ++loop;
        }
        compositionString = String.valueOf(compositionString) + "; END.";
        this.writeFSPOutput(compositionString);
        return compositionName;
    }

    private String buildPickFSP(Node FlowNode) {
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String compositionName = "";
        String constructString = "";
        int noofcases = 0;
        LinkedList<String> OnMessageList = null;
        OnMessageList = new LinkedList<String>();
        constructNodeList = FlowNode.getChildNodes();
        compositionName = FlowNode.getAttributes().getNamedItem("name") != null ? FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : String.valueOf(FlowNode.getNodeName().toUpperCase()) + this.PickList.size();
        this.PickList.add(compositionName);
        compositionString = "||" + compositionName + "C = (";
        constructcounter = 0;
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode)) {
                ++noofcases;
                if (constructNode.getAttributes().getNamedItem("name") != null) {
                    constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
                } else {
                    String cfr_ignored_0 = String.valueOf(constructNode.getNodeName().toUpperCase()) + noofcases;
                }
            }
            ++loop;
        }
        constructcounter = 0;
        loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode)) {
                if (constructcounter > 0) {
                    compositionString = String.valueOf(compositionString) + " || ";
                }
                constructString = this.translateBPELNode(constructNode, false);
                OnMessageList.add(constructString.substring(constructString.indexOf("|") + 1));
                compositionString = String.valueOf(compositionString) + constructString.substring(0, constructString.indexOf("|")) + "_SEQ";
                ++constructcounter;
            }
            ++loop;
        }
        compositionString = String.valueOf(compositionString) + ").";
        this.writeFSPOutput(compositionString);
        compositionString = compositionName + " = (";
        constructcounter = 0;
        loop = 0;
        while (loop < OnMessageList.size()) {
            if (constructcounter > 0) {
                compositionString = String.valueOf(compositionString) + " | ";
            }
            compositionString = String.valueOf(compositionString) + OnMessageList.get(loop) + compositionName;
            ++constructcounter;
            ++loop;
        }
        compositionString = String.valueOf(compositionString) + ").";
        this.writeFSPOutput(compositionString);
        return String.valueOf(compositionName) + "||" + compositionName + "C";
    }

    private String actionChildren(Node constructNode) {
        NodeList constructNodeList = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String whileLoopActionName = "";
        String whilecompositionName = "";
        constructNodeList = constructNode.getChildNodes();
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode)) {
                this.translateBPELNode(constructNode, false);
                if (constructcounter > 0) {
                    compositionString = String.valueOf(compositionString) + " || ";
                }
                if (!constructNode.hasAttributes()) {
                    constructName = "*unknown*";
                    this.reportNodeWarning(constructNode, "has no name.");
                }
                compositionString = String.valueOf(compositionString) + constructName;
                ++constructcounter;
            }
            ++loop;
        }
        this.writeFSPOutput("||" + whilecompositionName + " = (" + whileLoopActionName + ").");
        return "";
    }

    private String getBPELNodeAttribute(Node anode, String attributename, String defaultvalue) {
        String attributevalue = "";
        try {
            attributevalue = anode.getAttributes().getNamedItem(attributename) != null ? anode.getAttributes().getNamedItem(attributename).getNodeValue().toUpperCase() : defaultvalue;
        }
        catch (Exception exception) {
            attributevalue = "exception";
        }
        return attributevalue;
    }

    private String buildOnMessage(Node aconstructNode) {
        String compositionName = "";
        String messageComposition = "";
        String compositionString = "";
        String constructString = "";
        String process = "";
        int constructcounter = 0;
        Node constructNode = null;
        NodeList constructNodeList = null;
        String messageName = this.getBPELNodeAttribute(aconstructNode, "operation", "MESSAGE");
        compositionName = String.valueOf(this.strBPELProcessName) + "_ONMESSAGE_" + messageName;
        process = String.valueOf(messageName.toLowerCase()) + "->";
        this.ActionList.add(process);
        messageComposition = String.valueOf(compositionName) + " = (" + messageName.toLowerCase() + "->END).";
        this.writeFSPOutput(messageComposition);
        this.writeOutput("//onMessage: " + messageName);
        constructNodeList = aconstructNode.getChildNodes();
        compositionString = String.valueOf(this.strBPELProcessName) + "_ONMESSAGE_" + messageName + "_SEQ =  " + this.strBPELProcessName + "_ONMESSAGE_" + messageName + " ; ";
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode) && !constructNode.getNodeName().equals("#comment")) {
                if (constructcounter > 0) {
                    compositionString = String.valueOf(compositionString) + " ; ";
                }
                constructString = this.translateBPELNode(constructNode, false);
                this.writeOutput("// add SEQ: " + constructNode.getNodeName() + " - " + constructString + "\n");
                compositionString = constructNode.hasAttributes() && constructString.length() == 0 ? String.valueOf(compositionString) + constructString : String.valueOf(compositionString) + constructString;
                if (constructString.length() > 0) {
                    ++constructcounter;
                }
            }
            ++loop;
        }
        compositionString = String.valueOf(compositionString) + "; END.";
        this.writeFSPOutput(compositionString);
        return String.valueOf(compositionName) + "|" + process;
    }

    private String buildTerminate(Node constructNode) {
        String compositionName = "";
        String compositionString = "";
        compositionName = String.valueOf(this.strBPELProcessName) + "_TERMINATE";
        compositionString = String.valueOf(compositionName) + " = (terminate->END).";
        this.writeFSPOutput(compositionString);
        return compositionName;
    }

    private String addFaultHandling(String compositionString, String action) {
        compositionString = String.valueOf(compositionString) + action + " -> END |";
        compositionString = String.valueOf(compositionString) + action + " -> RAISEFAULT),\n";
        compositionString = String.valueOf(compositionString) + "RAISEFAULT = " + this.strBPELProcessName + "_SEQUENCE1; END.";
        return compositionString;
    }

    private String buildReceiveReplyFSP(Node constructNode) {
        String compositionString = "";
        String compositionName = "";
        String action = "";
        String linkName = "";
        String partner = "";
        String operationame = "";
        String processName = "";
        if (constructNode.hasAttributes()) {
            try {
                compositionName = constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
            }
            catch (Exception exception) {
                compositionName = String.valueOf(constructNode.getNodeName().toUpperCase()) + this.actionID++;
            }
            Node partnernode = null;
            partnernode = constructNode.getAttributes().getNamedItem("partner");
            if (partnernode == null) {
                partnernode = constructNode.getAttributes().getNamedItem("serviceLink");
            }
            if (partner == null) {
                partnernode = constructNode.getAttributes().getNamedItem("partnerLink");
            }
            if (partnernode != null) {
                partner = partnernode.getNodeValue().toLowerCase();
            }
            try {
                operationame = constructNode.getAttributes().getNamedItem("operation").getNodeValue().toLowerCase();
            }
            catch (Exception exception) {
                operationame = compositionName;
            }
        } else {
            compositionName = String.valueOf(constructNode.getNodeName().toUpperCase()) + this.actionID++;
        }
        processName = compositionName = String.valueOf(this.strBPELProcessName) + "_" + compositionName;
        compositionString = String.valueOf(compositionName) + " = (";
        String newaction = "reply_" + partner + "_" + this.strBPELProcessName.toLowerCase() + "_" + operationame.toLowerCase();
        partner = constructNode.getNodeName().toLowerCase().equals("receive") || constructNode.getNodeName().toLowerCase().equals("reply") ? String.valueOf(partner) + "_" + this.strBPELProcessName.toLowerCase() : String.valueOf(this.strBPELProcessName.toLowerCase()) + "_" + partner;
        action = String.valueOf(constructNode.getNodeName().toLowerCase()) + "_" + partner + "_" + operationame.toLowerCase();
        this.ActionList.add(action);
        compositionString = this.hasFaultHandler ? this.addFaultHandling(compositionString, action) : String.valueOf(compositionString) + action + " -> END).";
        if (constructNode.getNodeName().toLowerCase().equals("invoke") && constructNode.hasAttributes()) {
            try {
                if (constructNode.getAttributes().getNamedItem("outputVariable").getNodeValue().length() > 0) {
                    this.ActionList.add(newaction);
                    compositionString = String.valueOf(compositionString) + "\n";
                    compositionString = String.valueOf(compositionString) + compositionName + "_REPLY = (" + newaction + " ->END).";
                    compositionString = String.valueOf(compositionString) + compositionName + "_SEQ = " + compositionName + "; " + compositionName + "_REPLY; END." + "\n";
                    processName = compositionName;
                    compositionName = String.valueOf(compositionName) + "_SEQ";
                }
            }
            catch (Exception exception) {}
        }
        if ((linkName = this.actionSourceandTargets(constructNode, processName, compositionName)).length() > 0) {
            compositionName = linkName;
        }
        this.writeFSPOutput(compositionString);
        return compositionName;
    }

    private String buildFaultHandlersFSP(Node FaultHandlerNode) {
        this.hasFaultHandler = false;
        return "";
    }

    public LinkedList getDeadlockComponentsfromBPELTrace(String traceoutput) {
        LinkedList<String> list = null;
        list = new LinkedList<String>();
        int tracestartpos = 0;
        int endcurraction = 0;
        int partnerfromstart = 0;
        int partnertostart = 0;
        int actionend = 0;
        String curraction = "";
        String partnerfrom = "";
        String partnerto = "";
        String deadlockstr = "Trace to DEADLOCK:";
        String propertyviolationstr = "Trace to property violation";
        boolean endanalysis = false;
        try {
            if (traceoutput.length() > 0) {
                tracestartpos = traceoutput.indexOf(deadlockstr);
                if (tracestartpos < 0 && !endanalysis) {
                    tracestartpos = traceoutput.indexOf(propertyviolationstr);
                }
                if (tracestartpos >= 0 && !endanalysis) {
                    tracestartpos = tracestartpos + deadlockstr.length() + 1;
                    endcurraction = traceoutput.indexOf("\n", tracestartpos + 1);
                    while (endcurraction > 0 && !endanalysis) {
                        curraction = traceoutput.substring(tracestartpos + 1, endcurraction);
                        if (curraction.indexOf("Analysed") >= 0) {
                            endanalysis = true;
                        }
                        if (curraction.length() > 0 && !endanalysis && (partnerfromstart = curraction.indexOf("_")) >= 0) {
                            curraction.substring(0, partnerfromstart).trim();
                            partnertostart = curraction.indexOf("_", partnerfromstart + 1);
                            partnerfrom = curraction.substring(partnerfromstart + 1, partnertostart);
                            actionend = curraction.indexOf("_", partnertostart + 1);
                            partnerto = curraction.substring(partnertostart + 1, actionend);
                            if (partnerfrom.length() > 0 && partnerto.length() > 0) {
                                if (!list.contains(partnerfrom)) {
                                    list.add(partnerfrom);
                                }
                                if (!list.contains(partnerto)) {
                                    list.add(partnerto);
                                }
                            }
                        }
                        tracestartpos = endcurraction;
                        endcurraction = traceoutput.indexOf("\n", tracestartpos + 1);
                    }
                }
            }
        }
        catch (Exception exception) {}
        return list;
    }

    public LinkedList getDeadlockActionsfromBPELTrace(String traceoutput) {
        LinkedList list = null;
        list = new LinkedList();
        int tracestartpos = 0;
        int endcurraction = 0;
        int partnerfromstart = 0;
        int partnertostart = 0;
        int actionend = 0;
        String curraction = "";
        String deadlockstr = "Trace to DEADLOCK:";
        String propertyviolationstr = "Trace to property violation";
        String partnerfrom = "";
        String partnerto = "";
        boolean endanalysis = false;
        try {
            if (traceoutput.length() > 0) {
                tracestartpos = traceoutput.indexOf(deadlockstr);
                if (tracestartpos < 0 && !endanalysis) {
                    tracestartpos = traceoutput.indexOf(propertyviolationstr);
                }
                if (tracestartpos >= 0 && !endanalysis) {
                    tracestartpos = tracestartpos + deadlockstr.length() + 1;
                    endcurraction = traceoutput.indexOf("\n", tracestartpos + 1);
                    while (endcurraction > 0 && !endanalysis) {
                        curraction = traceoutput.substring(tracestartpos + 1, endcurraction);
                        if (curraction.indexOf("Analysed") >= 0) {
                            endanalysis = true;
                        }
                        if (curraction.length() > 0 && !endanalysis && (partnerfromstart = curraction.indexOf("_")) >= 0) {
                            curraction.substring(0, partnerfromstart).trim();
                            partnertostart = curraction.indexOf("_", partnerfromstart + 1);
                            partnerfrom = curraction.substring(partnerfromstart + 1, partnertostart);
                            actionend = curraction.indexOf("_", partnertostart + 1);
                            partnerto = curraction.substring(partnertostart + 1, actionend);
                            if (partnerfrom.length() > 0 && partnerto.length() > 0) {
                                LinkedList<String> actionlabel = new LinkedList<String>();
                                actionlabel.add(partnerfrom);
                                actionlabel.add(partnerto);
                                actionlabel.add(curraction);
                                list.add(actionlabel);
                            }
                        }
                        tracestartpos = endcurraction;
                        endcurraction = traceoutput.indexOf("\n", tracestartpos + 1);
                    }
                }
            }
        }
        catch (Exception exception) {}
        return list;
    }

    private String buildAssignFSP(Node FlowNode) {
        String linkName;
        NodeList constructNodeList = null;
        NamedNodeMap assignNodeAttributes = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String compositionName = "";
        String conditionvariableName = "";
        Node toNode = null;
        Node fromNode = null;
        String assignValue = "";
        String action = "";
        String originalName = "";
        String seqString = "";
        boolean isCopyNode = false;
        constructNodeList = FlowNode.getChildNodes();
        compositionName = FlowNode.hasAttributes() ? FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : "ASSIGN" + this.assignIDCounter++;
        originalName = compositionName;
        seqString = String.valueOf(originalName) + "SEQ = " + originalName;
        constructcounter = 0;
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (constructNode.getNodeName().compareTo("copy") == 0 || constructNode.getNodeName().compareTo("xpath") == 0) {
                isCopyNode = true;
                if (constructcounter > 0) {
                    compositionName = String.valueOf(originalName) + "_" + constructcounter;
                    seqString = String.valueOf(seqString) + "; " + compositionName;
                }
                ++constructcounter;
                compositionString = String.valueOf(compositionName) + " = (";
                NodeList CopyNodeList = constructNode.getChildNodes();
                int loopcopy = 0;
                while (loopcopy < CopyNodeList.getLength()) {
                    Node copyNode = CopyNodeList.item(loopcopy);
                    if (copyNode.getNodeName().compareTo("from") == 0) {
                        fromNode = CopyNodeList.item(loopcopy);
                    }
                    if (copyNode.getNodeName().compareTo("to") == 0) {
                        toNode = CopyNodeList.item(loopcopy);
                    }
                    ++loopcopy;
                }
                assignNodeAttributes = toNode.getAttributes();
                Node toattributenode = null;
                Node partnode = null;
                toattributenode = assignNodeAttributes.getNamedItem("expression");
                if (toattributenode == null) {
                    toattributenode = assignNodeAttributes.getNamedItem("variable");
                    if (toattributenode == null && (toattributenode = assignNodeAttributes.getNamedItem("container")) == null && (toattributenode = assignNodeAttributes.getNamedItem("partner")) == null) {
                        toattributenode = assignNodeAttributes.getNamedItem("sref:serviceReference");
                    }
                    if (toattributenode != null) {
                        partnode = toNode.getAttributes().getNamedItem("part");
                    }
                } else {
                    partnode = toattributenode.getAttributes().getNamedItem("part");
                }
                conditionvariableName = constructName = this.filterStrforFSP(toattributenode.getNodeValue());
                if (partnode != null) {
                    constructName = String.valueOf(constructName) + "." + this.filterStrforFSP(partnode.getNodeValue().toLowerCase());
                }
                if (fromNode.getAttributes().getNamedItem("expression") != null) {
                    assignValue = fromNode.getAttributes().getNamedItem("expression").getNodeValue();
                }
                if (fromNode.getAttributes().getNamedItem("variable") != null) {
                    assignValue = fromNode.getAttributes().getNamedItem("variable").getNodeValue();
                }
                if (fromNode.getAttributes().getNamedItem("serviceReference") != null) {
                    assignValue = fromNode.getAttributes().getNamedItem("serviceReference").getNodeValue();
                }
                action = constructName = String.valueOf(constructName) + ".write[" + this.getAssignValue(conditionvariableName, assignValue) + "]";
                this.ActionList.add(action);
                compositionString = String.valueOf(compositionString) + constructName + " -> END";
            }
            if (!this.isTextNode(constructNode) && isCopyNode) {
                compositionString = String.valueOf(compositionString) + ").";
                this.writeFSPOutput(compositionString);
            }
            ++loop;
        }
        if (constructcounter > 1) {
            seqString = String.valueOf(seqString) + "; END.";
            this.writeFSPOutput(seqString);
            compositionName = String.valueOf(originalName) + "SEQ";
        }
        if ((linkName = this.actionSourceandTargets(FlowNode, compositionName, compositionName)).length() > 0) {
            compositionName = linkName;
        }
        return compositionName;
    }

    private String buildWhileFSP(Node FlowNode) {
        int endname;
        int beginname;
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String compositionName = "";
        String conditionString = "";
        String conditionvariableName = "";
        String conditionvariablePart = "";
        String conditionvariableValue = "";
        String whileLoopActionName = "";
        String whilecompositionName = "";
        constructNodeList = FlowNode.getChildNodes();
        if (FlowNode.hasAttributes()) {
            try {
                compositionName = FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
            }
            catch (Exception exception) {
                compositionName = String.valueOf(FlowNode.getNodeName().toUpperCase()) + this.whileIDCounter++;
            }
        }
        compositionString = "||WHILE";
        conditionString = FlowNode.getAttributes().getNamedItem("condition").getNodeValue();
        if (conditionString.indexOf("bpws:") > -1) {
            beginname = conditionString.indexOf("bpws:") + 5;
            endname = conditionString.indexOf("('", beginname);
            conditionvariableName = conditionString.substring(beginname, endname);
            conditionvariableValue = "value";
            conditionvariablePart = conditionString.substring(endname + 2, conditionString.indexOf("'", endname + 2));
        } else {
            beginname = conditionString.indexOf("'") + 1;
            endname = conditionString.indexOf("'", beginname);
            conditionvariableName = conditionString.substring(beginname, endname);
            beginname = conditionString.indexOf("'", endname + 1) + 1;
            endname = conditionString.indexOf("'", beginname);
            conditionvariablePart = conditionString.substring(beginname, endname);
            beginname = conditionString.indexOf("=");
            endname = conditionString.indexOf("'", beginname);
            conditionvariableValue = conditionString.substring(beginname + 1).trim();
        }
        compositionString = String.valueOf(compositionString) + conditionvariableName + conditionvariablePart;
        compositionString = String.valueOf(compositionString) + " = " + conditionvariableName + "." + conditionvariablePart;
        compositionString = String.valueOf(compositionString) + ":" + this.strBPELProcessName + "_variable(0).";
        compositionString = String.valueOf(conditionvariableName.toUpperCase()) + conditionvariablePart.toUpperCase() + "OUTCOME";
        this.CompositionList.add(compositionString);
        compositionString = "||" + compositionString + " = " + conditionvariableName + "." + conditionvariablePart + ":" + this.strBPELProcessName + "_variable.";
        this.writeFSPOutput(compositionString);
        compositionString = String.valueOf(conditionvariableName.toUpperCase()) + conditionvariablePart.toUpperCase() + "OUTCOME_ALPHABET";
        this.AlphabetList.add(compositionString);
        compositionString = "set " + compositionString + " = {" + conditionvariableName + "." + conditionvariablePart + ".{read,write}.[" + this.strBPELProcessName + "_IntRange]}";
        this.writeFSPOutput(compositionString);
        this.writeFSPOutput("");
        this.writeFSPOutput("");
        this.writeFSPOutput(String.valueOf(conditionvariableName.toUpperCase()) + conditionvariablePart.toUpperCase() + "EVAL = (" + conditionvariableName + "." + conditionvariablePart + ".read[i:" + this.strBPELProcessName + "_IntRange]->" + conditionvariableName.toUpperCase() + conditionvariablePart.toUpperCase() + "EVAL[i]),");
        this.writeFSPOutput(String.valueOf(conditionvariableName.toUpperCase()) + conditionvariablePart.toUpperCase() + "EVAL[i:" + this.strBPELProcessName + "_IntRange] = if (i==" + this.getAssignValue(conditionvariableName, conditionvariableValue) + ")");
        this.writeFSPOutput("then " + compositionName + ";" + conditionvariableName.toUpperCase() + conditionvariablePart.toUpperCase() + "EVAL" + " else END.");
        whilecompositionName = compositionName;
        compositionString = "||" + compositionName + " = (";
        constructcounter = 0;
        String constructString = "";
        compositionName = String.valueOf(conditionvariableName.toUpperCase()) + conditionvariablePart.toUpperCase() + "EVAL";
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode)) {
                constructString = this.translateBPELNode(constructNode, false);
                if (constructcounter > 0) {
                    compositionString = String.valueOf(compositionString) + " || ";
                } else {
                    whileLoopActionName = constructString;
                }
                if (!constructNode.hasAttributes()) {
                    constructName = "*unknown*";
                    this.reportNodeWarning(constructNode, "has no name.");
                } else {
                    constructName = compositionName;
                }
                compositionString = String.valueOf(compositionString) + constructName;
                ++constructcounter;
            }
            ++loop;
        }
        this.writeFSPOutput("||" + whilecompositionName + " = (" + whileLoopActionName + ").");
        compositionString = String.valueOf(compositionString) + ").";
        return compositionName;
    }

    public String buildScopeFSP(Node SequenceNode) {
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructString = "";
        String compositionName = "";
        try {
            constructNodeList = SequenceNode.getChildNodes();
            if (SequenceNode.hasAttributes()) {
                try {
                    compositionName = SequenceNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
                }
                catch (Exception exception) {
                    compositionName = String.valueOf(SequenceNode.getNodeName().toUpperCase()) + this.actionID++;
                }
            } else {
                compositionName = String.valueOf(SequenceNode.getNodeName().toUpperCase()) + this.actionID++;
            }
            this.withinScope = true;
            this.writeFSPOutput("//-------------------------------------------------------");
            this.writeFSPOutput("// start Scope: " + compositionName);
            if (SequenceNode.getNodeName().equals("otherwise")) {
                compositionName = String.valueOf(compositionName) + "EVAL";
            }
            compositionString = "||" + compositionName + " = (";
            constructcounter = 0;
            int loop = 0;
            while (loop < constructNodeList.getLength()) {
                constructNode = constructNodeList.item(loop);
                if (!this.isTextNode(constructNode) && !constructNode.getNodeName().equals("#comment")) {
                    if (constructcounter > 0) {
                        compositionString = String.valueOf(compositionString) + " || ";
                    }
                    constructString = this.translateBPELNode(constructNode, false);
                    compositionString = constructNode.hasAttributes() && constructString.length() == 0 ? String.valueOf(compositionString) + constructString : String.valueOf(compositionString) + constructString;
                    if (constructString.length() > 0) {
                        ++constructcounter;
                    }
                }
                ++loop;
            }
            compositionString = String.valueOf(compositionString) + ").";
            this.writeFSPOutput(compositionString);
        }
        catch (Exception E) {
            System.err.println("\nERRROR...");
            E.printStackTrace(System.err);
        }
        this.hasFaultHandler = false;
        this.withinScope = false;
        this.writeFSPOutput("// end Scope: " + compositionName);
        this.writeFSPOutput("//-------------------------------------------------------");
        return compositionName;
    }

    public String buildLinkFSP(Node FlowNode) {
        String compositionString = "";
        String compositionName = "";
        if (FlowNode.hasAttributes()) {
            compositionName = FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
        }
        compositionName = compositionName.replace('-', '_');
        this.writeFSPOutput("LINK" + (this.LinksList.size() + 1) + " = (" + compositionName.toLowerCase() + " -> END).");
        this.LinksList.add(compositionName.toLowerCase());
        return compositionString;
    }

    private String actionSourceandTargets(Node aNode, String parentName, String processName) {
        NodeList constructNodeList = null;
        Node constructNode = null;
        String constructString = "";
        int constructcounter = 0;
        String actionName = "";
        String conditionString = "";
        String conditionvariableName = "";
        String linkno = "";
        LinkedList<String> linksAlphabetList = null;
        String constructname = "";
        boolean hassrctargetlinks = false;
        LinkedList<String> srclist = new LinkedList<String>();
        LinkedList<String> targetlist = new LinkedList<String>();
        linksAlphabetList = new LinkedList<String>();
        String linkLabel = "";
        linksAlphabetList.clear();
        constructNodeList = aNode.getChildNodes();
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode) && (constructNode.getNodeName().equals("source") || constructNode.getNodeName().equals("target"))) {
                constructname = String.valueOf(parentName) + "LINKSEQ";
                ++constructcounter;
                actionName = constructNode.getAttributes().getNamedItem("linkName").getNodeValue().toLowerCase();
                actionName = actionName.replace('-', '_');
                linkno = "" + (this.getLinkValue(actionName) + 1);
                if (constructNode.getAttributes().getLength() > 1) {
                    constructNode.getAttributes().getNamedItem("transitionCondition").getNodeValue().toLowerCase();
                    conditionString = constructNode.getAttributes().getNamedItem("transitionCondition").getNodeValue();
                    int beginname = conditionString.indexOf("'") + 1;
                    int endname = conditionString.indexOf("'", beginname);
                    conditionvariableName = conditionString.substring(beginname, endname);
                    beginname = conditionString.indexOf("'", endname + 1) + 1;
                    endname = conditionString.indexOf("'", beginname);
                    conditionString.substring(beginname, endname);
                    beginname = conditionString.indexOf("=");
                    endname = conditionString.indexOf("'", beginname);
                    conditionString.substring(beginname + 1).trim();
                    this.writeFSPOutput(this.buildGuardFSP(constructNode, conditionvariableName, "LINK" + linkno + "; END", "LINK" + linkno));
                    this.writeFSPOutput("||" + parentName + "LINK" + linkno + "CONT = request.guardlink" + linkno + ":" + this.strBPELProcessName + "_variable.");
                    this.writeFSPOutput("set " + parentName + "LINK" + linkno + "CONT_ALPHABET = {request.guardlink" + linkno + ".{read,write}.[" + this.strBPELProcessName + "_IntRange" + "]}");
                    linksAlphabetList.add(String.valueOf(parentName) + "LINK" + linkno + "CONT_ALPHABET");
                    linkLabel = String.valueOf(parentName) + "GUARD" + "LINK" + linkno;
                } else {
                    if (constructNode.getNodeName().equals("source")) {
                        constructString = "||" + parentName + "SRCLINK" + linkno + " = (LINK" + (this.getLinkValue(actionName) + 1) + ").";
                        linkLabel = String.valueOf(parentName) + "SRCLINK" + linkno;
                    } else {
                        constructString = "||" + parentName + "TARGETLINK" + linkno + " = (LINK" + (this.getLinkValue(actionName) + 1) + ").";
                        linkLabel = String.valueOf(parentName) + "TARGETLINK" + linkno;
                    }
                    this.writeFSPOutput(constructString);
                }
                if (constructNode.getNodeName().equals("source")) {
                    srclist.add(linkLabel);
                } else {
                    targetlist.add(linkLabel);
                }
            }
            ++loop;
        }
        constructString = String.valueOf(parentName) + "LINKSEQ = ";
        if (targetlist.size() > 0) {
            String linkComp = "";
            linkComp = "||" + parentName + "TARGETLINKS = (";
            hassrctargetlinks = true;
            Iterator I = targetlist.iterator();
            while (I.hasNext()) {
                linkComp = String.valueOf(linkComp) + I.next();
                if (!I.hasNext()) continue;
                linkComp = String.valueOf(linkComp) + " || ";
            }
            linkComp = String.valueOf(linkComp) + ").";
            this.writeFSPOutput(linkComp);
            constructString = String.valueOf(constructString) + parentName + "TARGETLINKS; ";
        }
        constructString = String.valueOf(constructString) + processName + ";";
        if (srclist.size() > 0) {
            String srclinkComp = "";
            srclinkComp = "||" + parentName + "SRCLINKS = (";
            hassrctargetlinks = true;
            Iterator I = srclist.iterator();
            while (I.hasNext()) {
                srclinkComp = String.valueOf(srclinkComp) + I.next();
                if (!I.hasNext()) continue;
                srclinkComp = String.valueOf(srclinkComp) + " || ";
            }
            srclinkComp = String.valueOf(srclinkComp) + ").";
            this.writeFSPOutput(srclinkComp);
            constructString = String.valueOf(constructString) + parentName + "SRCLINKS; ";
        }
        constructString = String.valueOf(constructString) + "END";
        if (linksAlphabetList.size() > 0) {
            constructString = String.valueOf(constructString) + " + {";
            Iterator I = linksAlphabetList.iterator();
            while (I.hasNext()) {
                constructString = String.valueOf(constructString) + I.next();
                if (!I.hasNext()) continue;
                constructString = String.valueOf(constructString) + ",";
            }
            constructString = String.valueOf(constructString) + "}";
        }
        constructString = String.valueOf(constructString) + ".";
        if (!hassrctargetlinks) {
            constructname = processName;
        } else {
            this.writeFSPOutput(constructString);
        }
        return constructname;
    }

    public String buildGuardFSP(Node FlowNode, String conditionvariableName, String guardactionlist, String guardlabel) {
        String compositionString = "";
        String compositionName = "";
        String conditionvariablePart = "";
        String conditionvariableValue = "";
        String intRange = String.valueOf(this.strBPELProcessName) + "_IntRange";
        if (FlowNode.hasAttributes()) {
            FlowNode.getAttributes().getNamedItem("linkName").getNodeValue().toUpperCase();
        }
        compositionName = String.valueOf(this.strBPELProcessName) + "_" + FlowNode.getParentNode().getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
        conditionvariablePart = "guard" + guardlabel;
        this.writeFSPOutput("");
        this.writeFSPOutput(String.valueOf(compositionName) + conditionvariablePart.toUpperCase() + " = (" + conditionvariableName + "." + conditionvariablePart.toLowerCase() + ".read[i:" + intRange + "]->" + compositionName + conditionvariablePart.toUpperCase() + "[i]),");
        this.writeFSPOutput(String.valueOf(compositionName) + conditionvariablePart.toUpperCase() + "[i:" + intRange + "] = if (i==" + this.getAssignValue(conditionvariableName, conditionvariableValue) + ") then " + guardactionlist + ".");
        return compositionString;
    }

    public String buildvariablesFSP(Node FlowNode) {
        String compositionString = "";
        String compositionName = "";
        String intRange = "";
        String strEnum = "";
        this.writeFSPOutput("// variable start");
        compositionName = String.valueOf(this.strBPELProcessName) + "_" + "variable";
        intRange = String.valueOf(this.strBPELProcessName) + "_" + "IntRange";
        strEnum = String.valueOf(compositionName) + "_ENUM";
        this.writeFSPOutput("range " + intRange + " = 0..1");
        this.writeFSPOutput(String.valueOf(compositionName) + "(A=0) = " + compositionName + "[A],");
        this.writeFSPOutput(String.valueOf(compositionName) + "[i:" + intRange + "] = ( write[j:" + intRange + "]->" + compositionName + "[j] | read[i]->" + compositionName + "[i]),");
        this.writeFSPOutput(String.valueOf(compositionName) + "['null] = ( write[j:" + intRange + "]->" + compositionName + "[j] | read['null]->" + compositionName + "['null]).");
        this.writeFSPOutput("");
        this.writeFSPOutput("set " + strEnum + " = {a, b, c}");
        this.writeFSPOutput("ENUM_" + compositionName + "(A='null) = " + compositionName + "[A],");
        this.writeFSPOutput(String.valueOf(compositionName) + "[i:" + strEnum + "] = ( write[j:" + strEnum + "]->" + compositionName + "[j] | read[i]->" + compositionName + "[i]),");
        this.writeFSPOutput(String.valueOf(compositionName) + "['null] = ( write[j:" + strEnum + "]->" + compositionName + "[j] | read['null]->" + compositionName + "['null]).");
        this.writeFSPOutput("");
        this.writeFSPOutput("// variable end");
        this.writeFSPOutput("");
        return compositionString;
    }

    private String buildFlowFSP(Node FlowNode) {
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String compositionName = "";
        String constructString = "";
        constructNodeList = FlowNode.getChildNodes();
        if (FlowNode.hasAttributes()) {
            compositionName = FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
            compositionName = compositionName.replace('-', '_');
        } else {
            compositionName = "FLOW" + this.flowIDCounter++;
        }
        compositionString = "||" + compositionName + " = (";
        constructcounter = 0;
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode) && (constructString = this.translateBPELNode(constructNode, false)).length() > 0) {
                if (constructcounter > 0) {
                    compositionString = String.valueOf(compositionString) + " || ";
                }
                if (constructNode.hasAttributes() && constructString.length() > 0) {
                }
                compositionString = String.valueOf(compositionString) + constructString;
                ++constructcounter;
            }
            ++loop;
        }
        compositionString = String.valueOf(compositionString) + ").";
        compositionString = compositionString.replaceAll(";", "||");
        this.writeFSPOutput(compositionString);
        this.CompositionList.add(compositionName);
        return compositionName;
    }

    public boolean runAnalysis() {
        int loop;
        boolean result = false;
        NodeList tempNodeList = null;
        NodeList currentnodelist = null;
        int noofPartners = 0;
        int noofvariables = 0;
        int noofSequences = 0;
        int noofWhile = 0;
        int noofFlow = 0;
        currentnodelist = this.bpelDoc.getElementsByTagName("partners");
        if (currentnodelist.getLength() > 0) {
            tempNodeList = currentnodelist.item(0).getChildNodes();
            loop = 0;
            while (loop < tempNodeList.getLength()) {
                if (tempNodeList.item(loop).getNodeName().compareTo("partner") == 0) {
                    ++noofPartners;
                }
                ++loop;
            }
        }
        if ((currentnodelist = this.bpelDoc.getElementsByTagName("variables")).getLength() > 0) {
            tempNodeList = currentnodelist.item(0).getChildNodes();
            loop = 0;
            while (loop < tempNodeList.getLength()) {
                if (tempNodeList.item(loop).getNodeName().compareTo("variable") == 0) {
                    ++noofvariables;
                }
                ++loop;
            }
        }
        currentnodelist = this.bpelDoc.getElementsByTagName("sequence");
        noofSequences = currentnodelist.getLength();
        currentnodelist = this.bpelDoc.getElementsByTagName("while");
        noofWhile = currentnodelist.getLength();
        currentnodelist = this.bpelDoc.getElementsByTagName("flow");
        noofFlow = currentnodelist.getLength();
        this.writeOutput("//******************************************************");
        this.writeOutput("//************     BPEL ANALYSIS        ****************");
        this.writeOutput("//******************************************************");
        this.writeOutput("//PARTNERS   : " + noofPartners);
        this.writeOutput("//variableS : " + noofvariables);
        this.writeOutput("//SEQUENCES  : " + noofSequences);
        this.writeOutput("//WHILE      : " + noofWhile);
        this.writeOutput("//FLOW       : " + noofFlow);
        this.writeOutput("//******************************************************");
        this.writeOutput("//******************************************************");
        return result;
    }

    public boolean convertProcess(String processName) {
        boolean result = false;
        return result;
    }

    public String GetFSPProcess(String processname) {
        if (!this.FSPProcessList.isEmpty()) {
            return (String)this.FSPProcessList.get(processname);
        }
        return "";
    }

    public LinkedList extractFSPSpecLabels(String fspspecpath, boolean isfile) {
        int actionend = 0;
        int actionstart = 0;
        String action2 = "";
        LinkedList<String> specLinkedList = new LinkedList<String>();
        specLinkedList.clear();
        try {
            if (fspspecpath.length() > 0) {
                BufferedReader read;
                if (isfile) {
                    File file = new File(fspspecpath);
                    read = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                } else {
                    read = new BufferedReader(new InputStreamReader(new StringBufferInputStream(fspspecpath)));
                }
                String s = read.readLine();
                while (s != null) {
                    actionend = 0;
                    s = read.readLine();
                    if (!read.ready()) continue;
                    actionstart = s.indexOf("->", actionend);
                    while (actionstart > 0) {
                        if (actionstart > 0 && (actionend = s.indexOf("->", actionstart + 2)) > 0) {
                            char actionchar;
                            String actionstr = s.substring(actionstart + 2, actionend).trim();
                            int action2end = s.indexOf("->", actionend + 2);
                            if (action2end > 0) {
                                action2 = s.substring(actionend + 2, action2end).trim();
                            }
                            if (Character.isLowerCase(actionchar = actionstr.charAt(0))) {
                                if (specLinkedList.indexOf(actionstr) < 1 && actionstr.length() > 0 && actionstr.indexOf("|") < 0 && !specLinkedList.contains(actionstr)) {
                                    specLinkedList.add(actionstr);
                                }
                                if (specLinkedList.indexOf(action2) < 1 && action2.length() > 0 && action2.indexOf("|") < 0 && !specLinkedList.contains(action2)) {
                                    specLinkedList.add(action2);
                                }
                            }
                        }
                        actionstart = actionend > 0 ? s.indexOf("->", actionend) : 0;
                    }
                }
            }
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return specLinkedList;
    }

    public void printFSPProcessList() {
        Iterator i = this.FSPProcessList.keySet().iterator();
        while (i.hasNext()) {
            String cfr_ignored_0 = (String)i.next();
        }
    }

    public boolean loadFSP(String FSPInput, boolean isFilename) {
        boolean result = false;
        String text = "";
        String processname = "";
        String lastprocessname = "";
        int processname_end = 0;
        if (FSPInput.length() > 0) {
            try {
                if (isFilename) {
                    this.writeOutput("Loading FSP Input: " + FSPInput);
                    this.FSPProcessList = new HashMap();
                    BufferedReader in = new BufferedReader(new FileReader(FSPInput));
                    text = in.readLine();
                    while (in.ready()) {
                        if (text.length() > 0 && text.indexOf("//") < 0) {
                            processname_end = text.indexOf("=");
                            processname = text.substring(0, processname_end).trim();
                            if (text.indexOf(",") > 0) {
                                this.FSPProcessList.put(String.valueOf(lastprocessname) + "_" + processname, text.substring(processname_end));
                                lastprocessname = processname;
                            } else {
                                this.FSPProcessList.put(processname, text.substring(processname_end));
                                lastprocessname = "";
                            }
                        }
                        text = in.readLine();
                    }
                    in.close();
                    this.printFSPProcessList();
                } else {
                    new StringBufferInputStream(FSPInput);
                }
                result = true;
            }
            catch (Exception E) {
                E.printStackTrace(System.err);
            }
            if (result) {
                this.writeOutput("Successfully Loaded : " + FSPInput);
            } else {
                this.writeOutput("Failed input : " + FSPInput);
            }
        } else {
            this.writeOutput("ERROR: No BPEL input specified to load." + FSPInput);
        }
        return result;
    }

    public boolean loadBPEL(String BPELInput, boolean isFilename) {
        boolean result = false;
        if (BPELInput.length() > 0) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setIgnoringElementContentWhitespace(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                if (isFilename) {
                    this.writeOutput("Loading BPEL Input: " + BPELInput);
                    this.bpelDoc = db.parse(BPELInput);
                } else {
                    StringBufferInputStream is = new StringBufferInputStream(BPELInput);
                    this.bpelDoc = db.parse(is);
                }
                this.processlist = this.bpelDoc.getElementsByTagName("process");
                if (this.processlist.getLength() > 0) {
                    this.currentprocessnode = this.processlist.item(0);
                    this.strBPELProcessName = this.currentprocessnode.getAttributes().getNamedItem("name").getNodeValue().toString().toUpperCase();
                } else {
                    this.writeOutput("ERROR: No process found.");
                }
                result = true;
            }
            catch (Exception E) {
                E.printStackTrace(System.err);
            }
        } else {
            this.writeOutput("ERROR: No BPEL input specified to load." + BPELInput);
        }
        return result;
    }

    public void setFSPOutput(OutputStream os) {
        this.outFSPStream = os;
    }

    public void setOutput(OutputStream os) {
        this.outStream = os;
    }

    private boolean writeFSPOutput(String strOut) {
        boolean result = false;
        try {
            if (this.outFSPStream != null) {
                strOut = String.valueOf(strOut) + "\n";
                this.outFSPStream.write(strOut.getBytes());
                this.outFSPStream.flush();
            } else {
                System.out.println(strOut);
            }
        }
        catch (Exception E) {
            E.printStackTrace(System.err);
        }
        return result;
    }

    private boolean writeOutput(String strOut) {
        boolean result = false;
        try {
            if (this.outStream != null) {
                strOut = String.valueOf(strOut) + "\n";
                this.outStream.write(strOut.getBytes());
                this.outStream.flush();
            } else {
                System.out.println(strOut);
            }
        }
        catch (Exception E) {
            E.printStackTrace(System.err);
        }
        return result;
    }

    public static void main(String[] args) {
        String Filename = "collaxa\\switch.bpel";
        File BPELFileObj = new File(Filename);
        String BPELFile = BPELFileObj.getAbsolutePath();
        int ext = BPELFileObj.getAbsolutePath().lastIndexOf(".");
        BPELFileObj.getAbsolutePath().substring(0, ext);
        bpel2fsp convert1 = new bpel2fsp();
        try {
            convert1.setFSPOutput(System.out);
            convert1.loadBPEL(BPELFile, true);
            convert1.runAnalysis();
            convert1.translateToFSP(false);
        }
        catch (Exception E) {
            E.printStackTrace();
        }
    }

    public synchronized void removeCellEditorListener(CellEditorListener l) {
        if (this.cellEditorListeners != null && this.cellEditorListeners.contains(l)) {
            Vector v = (Vector)this.cellEditorListeners.clone();
            v.removeElement(l);
            this.cellEditorListeners = v;
        }
    }

    public synchronized void addCellEditorListener(CellEditorListener l) {
        Vector v;
        Vector vector = v = this.cellEditorListeners == null ? new Vector(2) : (Vector)this.cellEditorListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.cellEditorListeners = v;
        }
    }

    protected void fireEditingStopped(ChangeEvent e) {
        if (this.cellEditorListeners != null) {
            Vector listeners = this.cellEditorListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((CellEditorListener)listeners.elementAt(i)).editingStopped(e);
                ++i;
            }
        }
    }

    protected void fireEditingCanceled(ChangeEvent e) {
        if (this.cellEditorListeners != null) {
            Vector listeners = this.cellEditorListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((CellEditorListener)listeners.elementAt(i)).editingCanceled(e);
                ++i;
            }
        }
    }
}

