/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.PrefixTree;
import java.util.Enumeration;
import java.util.Vector;

public class Alphabet {
    PrefixTree root = null;
    String[] myAlpha;
    CompactState sm;
    public int maxLevel = 0;

    public Alphabet(CompactState sm) {
        this.sm = sm;
        this.myAlpha = new String[sm.alphabet.length];
        int i = 0;
        while (i < sm.alphabet.length) {
            this.myAlpha[i] = sm.alphabet[i];
            ++i;
        }
        this.sort(this.myAlpha, 1);
        i = 1;
        while (i < this.myAlpha.length) {
            this.root = PrefixTree.addName(this.root, this.myAlpha[i]);
            ++i;
        }
        if (this.root != null) {
            this.maxLevel = this.root.maxDepth();
        }
    }

    public Alphabet(String[] inames) {
        String[] names = new String[inames.length];
        int i = 0;
        while (i < names.length) {
            names[i] = inames[i];
            ++i;
        }
        if (names.length > 1) {
            this.sort(names, 0);
        }
        i = 0;
        while (i < names.length) {
            this.root = PrefixTree.addName(this.root, names[i]);
            ++i;
        }
    }

    public Alphabet(Vector names) {
        this(names.toArray(new String[names.size()]));
    }

    public String toString() {
        if (this.root == null) {
            return "{}";
        }
        return this.root.toString();
    }

    public void print(LTSOutput output, int level) {
        output.outln("Process:\n\t" + this.sm.name);
        output.outln("Alphabet:");
        if (this.root == null) {
            output.outln("\t{}");
            return;
        }
        if (level == 0) {
            output.outln("\t" + this.root.toString());
        } else {
            output.out("\t{ ");
            Vector v = new Vector();
            this.root.getStrings(v, level - 1, null);
            Enumeration e = v.elements();
            boolean first = true;
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (!first) {
                    output.out("\t  ");
                }
                if (e.hasMoreElements()) {
                    output.outln(String.valueOf(s) + ",");
                } else {
                    output.outln(s);
                }
                first = false;
            }
            output.outln("\t}");
        }
    }

    private void sort(String[] a, int from) {
        int i = from;
        while (i < a.length - 1) {
            int min = i;
            int j = i + 1;
            while (j < a.length) {
                if (a[j].compareTo(a[min]) < 0) {
                    min = j;
                }
                ++j;
            }
            String temp = a[i];
            a[i] = a[min];
            a[min] = temp;
            ++i;
        }
    }
}

