/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Counter;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.Symbol;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class AutCompactState
extends CompactState {
    public AutCompactState(Symbol name, File autfile) {
        this.name = name.toString();
        BufferedReader bf = null;
        try {
            bf = new BufferedReader(new FileReader(autfile));
        }
        catch (Exception e) {
            Diagnostics.fatal("Error opening file" + e, name);
        }
        try {
            String header = bf.readLine();
            if (header == null) {
                Diagnostics.fatal("file is empty", name);
            }
            this.maxStates = this.statesAUTheader(header);
            this.states = new EventState[this.maxStates];
            Hashtable<String, Integer> newAlpha = new Hashtable<String, Integer>();
            Counter c = new Counter(0);
            newAlpha.put("tau", c.label());
            String line = null;
            int trans = this.transitionsAUTheader(header);
            int tc = 0;
            while ((line = bf.readLine()) != null) {
                this.parseAUTtransition(line, newAlpha, c);
                ++tc;
            }
            if (tc != trans) {
                Diagnostics.fatal("transitions read different from .aut header", name);
            }
            this.alphabet = new String[newAlpha.size()];
            Enumeration e = newAlpha.keys();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                int i = (Integer)newAlpha.get(s);
                this.alphabet[i] = s;
            }
        }
        catch (Exception e) {
            Diagnostics.fatal("Error reading/translating file" + e, name);
        }
    }

    protected int statesAUTheader(String header) {
        int i = header.lastIndexOf(44);
        String s = header.substring(i + 1, header.indexOf(41)).trim();
        return Integer.parseInt(s);
    }

    protected int transitionsAUTheader(String header) {
        int i = header.indexOf(44);
        int j = header.lastIndexOf(44);
        String s = header.substring(i + 1, j).trim();
        return Integer.parseInt(s);
    }

    protected void parseAUTtransition(String line, Hashtable alpha, Counter c) {
        int i = line.indexOf(40);
        int j = line.indexOf(44);
        String s = line.substring(i + 1, j).trim();
        int from = Integer.parseInt(s);
        int k = line.indexOf(44, j + 1);
        String label = line.substring(j + 1, k).trim();
        if (label.charAt(0) == '\"') {
            label = label.substring(1, label.length() - 1).trim();
        }
        int l = line.indexOf(41);
        s = line.substring(k + 1, l).trim();
        int to = Integer.parseInt(s);
        Integer labelid = (Integer)alpha.get(label);
        if (labelid == null) {
            labelid = c.label();
            alpha.put(label, labelid);
        }
        this.states[from] = EventState.add(this.states[from], new EventState(labelid, to));
    }
}

