/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.StackChecker;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class PartialOrder {
    private CompactState[] machines;
    private int[][] actionSharedBy;
    private StackChecker checker;
    private int[][] candidates;
    private int[][] partners;
    private int Nactions;
    private String[] names;
    private BitSet visible;
    private boolean preserveOE;
    private BitSet high;

    public PartialOrder(Hashtable alphabet, String[] actionName, CompactState[] sm, StackChecker ck, Vector hidden, boolean exposeNotHide, boolean OE, BitSet high) {
        this.machines = sm;
        this.names = actionName;
        this.Nactions = actionName.length;
        this.checker = ck;
        this.preserveOE = OE;
        this.high = high;
        this.actionSharedBy = new int[this.Nactions][];
        int i = 1;
        while (i < actionName.length) {
            BitSet b = (BitSet)alphabet.get(actionName[i]);
            this.actionSharedBy[i] = this.bitsToArray(b);
            ++i;
        }
        this.visible = new BitSet(this.Nactions);
        i = 1;
        while (i < actionName.length) {
            if (hidden == null) {
                this.visible.set(i);
            } else if (exposeNotHide) {
                if (CompactState.contains(actionName[i], hidden)) {
                    this.visible.set(i);
                }
            } else if (!CompactState.contains(actionName[i], hidden)) {
                this.visible.set(i);
            }
            ++i;
        }
        this.initPartners();
        this.candidates = this.computeCandidates();
    }

    public List transitions(int[] state) {
        int mach = 0;
        while (mach < this.machines.length) {
            ArrayList trs;
            boolean res;
            if (this.candidates[mach][state[mach]] == 1 && (res = this.getMachTransitions(trs = new ArrayList(8), mach, state, null))) {
                return trs;
            }
            ++mach;
        }
        mach = 0;
        while (mach < this.machines.length) {
            List trs;
            int partner;
            if (this.candidates[mach][state[mach]] == 2 && mach == this.partners[partner = this.partners[mach][state[mach]]][state[partner]] && (trs = this.getPairTransitions(mach, partner, state)) != null) {
                return trs;
            }
            ++mach;
        }
        return null;
    }

    private boolean addTransitions(List trs, int[] state, int event, int first) {
        int[] saved = null;
        int mach = this.actionSharedBy[event][first];
        EventState p = this.machines[mach].states[state[mach]];
        if (p != null) {
            saved = this.myclone(state, event);
        }
        p = EventState.firstCompState(p, event, state);
        if (first < this.actionSharedBy[event].length - 1) {
            if (!this.addTransitions(trs, state, event, first + 1)) {
                return false;
            }
        } else {
            if (this.checker.onStack(state)) {
                return false;
            }
            trs.add(state);
        }
        while (p != null) {
            int[] next = this.myclone(saved, event);
            p = EventState.moreCompState(p, next);
            if (first < this.actionSharedBy[event].length - 1) {
                if (this.addTransitions(trs, next, event, first + 1)) continue;
                return false;
            }
            if (this.checker.onStack(next)) {
                return false;
            }
            trs.add(next);
        }
        return true;
    }

    private List getPairTransitions(int mach, int partner, int[] state) {
        ArrayList trs = new ArrayList(8);
        boolean res = true;
        if (!this.preserveOE) {
            BitSet tmp = this.getUnshared(mach, state);
            if (tmp != null) {
                res = this.getMachTransitions(trs, mach, state, tmp);
            }
            if (!res) {
                return null;
            }
            tmp = this.getUnshared(partner, state);
            if (tmp != null) {
                res = this.getMachTransitions(trs, partner, state, tmp);
            }
            if (!res) {
                return null;
            }
        }
        BitSet machB = new BitSet(this.Nactions);
        EventState.hasEvents(this.machines[mach].states[state[mach]], machB);
        BitSet partnerB = new BitSet(this.Nactions);
        EventState.hasEvents(this.machines[partner].states[state[partner]], partnerB);
        machB.and(partnerB);
        if (this.preserveOE && this.countSet(machB) != 1) {
            return null;
        }
        machB.clear(0);
        int[] actions = this.bitsToArray(machB);
        int i = 0;
        while (i < actions.length) {
            res = this.addTransitions(trs, this.myclone(state, actions[i]), actions[i], 0);
            if (!res) {
                return null;
            }
            ++i;
        }
        return trs;
    }

    private BitSet getUnshared(int mach, int[] state) {
        BitSet b = new BitSet(this.Nactions);
        Enumeration e = this.machines[mach].states[state[mach]].elements();
        while (e.hasMoreElements()) {
            EventState es = (EventState)e.nextElement();
            if (es.event == 0) {
                b.set(es.event);
                continue;
            }
            if (this.actionSharedBy[es.event].length != 1) continue;
            b.set(es.event);
        }
        if (b.length() == 0) {
            return null;
        }
        return b;
    }

    private boolean getMachTransitions(List trs, int mach, int[] state, BitSet single) {
        Enumeration e = this.machines[mach].states[state[mach]].elements();
        while (e.hasMoreElements()) {
            EventState es = (EventState)e.nextElement();
            if (single != null && !single.get(es.event)) continue;
            int[] next = this.myclone(state, es.event);
            next[mach] = es.next;
            if (this.checker.onStack(next)) {
                return false;
            }
            trs.add(next);
        }
        return true;
    }

    private int[] bitsToArray(BitSet b) {
        int len = this.countSet(b);
        if (len == 0) {
            return null;
        }
        int[] a = new int[len];
        int j = 0;
        int max = b.length();
        int i = 0;
        while (i < max) {
            if (b.get(i)) {
                a[j] = i;
                ++j;
            }
            ++i;
        }
        return a;
    }

    private int countSet(BitSet b) {
        int count = 0;
        int len = b.length();
        int i = 0;
        while (i < len) {
            if (b.get(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private int[] myclone(int[] x, int event) {
        int[] tmp = new int[x.length];
        int i = 0;
        while (i < x.length - 1) {
            tmp[i] = x[i];
            ++i;
        }
        tmp[x.length - 1] = event;
        return tmp;
    }

    private void printArray(String s, int[][] a) {
        System.out.println(s);
        int i = 0;
        while (i < a.length) {
            System.out.print("Mach " + i + " --");
            int j = 0;
            while (j < a[i].length) {
                System.out.print(" " + a[i][j]);
                ++j;
            }
            System.out.println(".");
            ++i;
        }
    }

    private void initPartners() {
        this.partners = new int[this.machines.length][];
        int i = 0;
        while (i < this.machines.length) {
            this.partners[i] = new int[this.machines[i].states.length];
            int j = 0;
            while (j < this.machines[i].states.length) {
                this.partners[i][j] = -1;
                ++j;
            }
            ++i;
        }
    }

    private int[][] computeCandidates() {
        int[][] cd = new int[this.machines.length][];
        int i = 0;
        while (i < this.machines.length) {
            cd[i] = new int[this.machines[i].states.length];
            int j = 0;
            while (j < this.machines[i].states.length) {
                int[] actions = EventState.localEnabled(this.machines[i].states[j]);
                cd[i][j] = this.candidateNumber(i, j, actions);
                ++j;
            }
            ++i;
        }
        return cd;
    }

    private int candidateNumber(int mach, int state, int[] actions) {
        if (actions == null) {
            return 0;
        }
        if (this.preserveOE && EventState.hasNonDet(this.machines[mach].states[state])) {
            return 0;
        }
        int cn = 0;
        int singles = 0;
        int partner = -1;
        int i = 0;
        while (i < actions.length) {
            int shared = 0;
            int a = actions[i];
            if (this.visible.get(a)) {
                return 0;
            }
            if (this.high != null && !this.high.get(a)) {
                return 0;
            }
            shared = a == 0 ? 1 : this.actionSharedBy[a].length;
            if (shared == 1) {
                ++singles;
            }
            if (shared > cn) {
                cn = shared;
            }
            if (cn > 2) {
                return 0;
            }
            if (shared == 2) {
                if (partner < 0) {
                    partner = this.getPartner(mach, a);
                } else if (partner != this.getPartner(mach, a)) {
                    return 0;
                }
            }
            ++i;
        }
        if (this.preserveOE && (singles > 1 || cn == 2 && singles > 0)) {
            return 0;
        }
        if (cn == 2) {
            this.partners[mach][state] = partner;
        }
        return cn;
    }

    private int getPartner(int mach, int event) {
        if (this.actionSharedBy[event][0] == mach) {
            return this.actionSharedBy[event][1];
        }
        return this.actionSharedBy[event][0];
    }
}

