/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.Node;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.ltl.LabelFactory;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;

class Converter
extends CompactState {
    BitSet accepting;
    Graph g;
    int iacc = 0;

    Converter(String n, Graph g, LabelFactory lf) {
        this.name = n;
        this.g = g;
        this.accepting = this.getAcceptance();
        this.alphabet = lf.makeAlphabet();
        this.makeStates(lf);
    }

    private void makeStates(LabelFactory lf) {
        this.maxStates = this.g.getNodeCount() + this.iacc + 1;
        this.states = new EventState[this.maxStates];
        HashMap trl = lf.getTransLabels();
        this.addTrueNode(this.maxStates - 1, trl);
        Iterator ii = this.g.getNodes().iterator();
        while (ii.hasNext()) {
            this.addNode((Node)ii.next(), trl);
        }
        if (this.iacc == 1) {
            this.states[0] = EventState.union(this.states[0], this.states[1]);
        }
        this.addAccepting();
        this.reachable();
    }

    private void addAccepting() {
        int id = 0;
        while (id < this.maxStates - 1) {
            if (this.accepting.get(id)) {
                this.states[id + this.iacc] = EventState.add(this.states[id + this.iacc], new EventState(this.alphabet.length - 1, id + this.iacc));
            }
            ++id;
        }
    }

    void addNode(Node n, HashMap trl) {
        int id = n.getId();
        BitSet all = new BitSet(this.alphabet.length - 2);
        Iterator ii = n.getOutgoingEdges().iterator();
        while (ii.hasNext()) {
            this.addEdge((Edge)ii.next(), id, trl, all);
        }
        this.complete(id, all);
    }

    void addTrueNode(int id, HashMap trl) {
        BitSet tr = (BitSet)trl.get("true");
        int i = 0;
        while (i < tr.size()) {
            if (tr.get(i)) {
                this.states[id] = EventState.add(this.states[id], new EventState(i + 1, id));
            }
            ++i;
        }
    }

    void complete(int id, BitSet all) {
        int i = 0;
        while (i < this.alphabet.length - 2) {
            if (!all.get(i)) {
                this.states[id + this.iacc] = EventState.add(this.states[id + this.iacc], new EventState(i + 1, this.maxStates - 1));
            }
            ++i;
        }
    }

    void addEdge(Edge e, int id, HashMap trl, BitSet all) {
        String s = e.getGuard().equals("-") ? "true" : e.getGuard();
        BitSet tr = (BitSet)trl.get(s);
        all.or(tr);
        int i = 0;
        while (i < tr.size()) {
            if (tr.get(i)) {
                this.states[id + this.iacc] = EventState.add(this.states[id + this.iacc], new EventState(i + 1, e.getNext().getId() + this.iacc));
            }
            ++i;
        }
    }

    public void printFSP(PrintStream printstream) {
        if (this.g.getInit() != null) {
            printstream.print(String.valueOf(this.name) + " = S" + this.g.getInit().getId());
        } else {
            printstream.print("Empty");
        }
        Iterator iterator = this.g.getNodes().iterator();
        while (iterator.hasNext()) {
            printstream.println(",");
            Node node = (Node)iterator.next();
            this.printNode(node, printstream);
        }
        printstream.println(".");
        if (printstream != System.out) {
            printstream.close();
        }
    }

    protected BitSet getAcceptance() {
        BitSet acc = new BitSet();
        int i = this.g.getIntAttribute("nsets");
        if (i > 0) {
            Diagnostics.fatal("More than one acceptance set");
        }
        Iterator iterator1 = this.g.getNodes().iterator();
        while (iterator1.hasNext()) {
            Node node1 = (Node)iterator1.next();
            if (!node1.getBooleanAttribute("accepting")) continue;
            acc.set(node1.getId());
        }
        return acc;
    }

    void printNode(Node n, PrintStream printstream) {
        String s = this.accepting.get(n.getId()) ? "@" : "";
        printstream.print("S" + n.getId() + s + " =(");
        Iterator iterator = n.getOutgoingEdges().iterator();
        while (iterator.hasNext()) {
            this.printEdge((Edge)iterator.next(), printstream);
            if (!iterator.hasNext()) continue;
            printstream.print(" |");
        }
        printstream.print(")");
    }

    void printEdge(Edge e, PrintStream printstream) {
        String s = e.getGuard().equals("-") ? "true" : e.getGuard();
        printstream.print(String.valueOf(s) + " -> S" + e.getNext().getId());
    }
}

