/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.ltl.And;
import ic.doc.ltsa.lts.ltl.False;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.Next;
import ic.doc.ltsa.lts.ltl.Not;
import ic.doc.ltsa.lts.ltl.Or;
import ic.doc.ltsa.lts.ltl.Proposition;
import ic.doc.ltsa.lts.ltl.Release;
import ic.doc.ltsa.lts.ltl.True;
import ic.doc.ltsa.lts.ltl.Until;
import ic.doc.ltsa.lts.ltl.Visitor;

class NotVisitor
implements Visitor {
    private FormulaFactory fac;

    NotVisitor(FormulaFactory f) {
        this.fac = f;
    }

    public Formula visit(True t) {
        return False.make();
    }

    public Formula visit(False f) {
        return True.make();
    }

    public Formula visit(Proposition p) {
        return this.fac.makeNot(p);
    }

    public Formula visit(Not n) {
        return n.getNext();
    }

    public Formula visit(Next n) {
        return this.fac.makeNext(this.fac.makeNot(n.getNext()));
    }

    public Formula visit(And a) {
        return this.fac.makeOr(this.fac.makeNot(a.getLeft()), this.fac.makeNot(a.getRight()));
    }

    public Formula visit(Or o) {
        return this.fac.makeAnd(this.fac.makeNot(o.getLeft()), this.fac.makeNot(o.getRight()));
    }

    public Formula visit(Until u) {
        return this.fac.makeRelease(this.fac.makeNot(u.getLeft()), this.fac.makeNot(u.getRight()));
    }

    public Formula visit(Release r) {
        return this.fac.makeUntil(this.fac.makeNot(r.getLeft()), this.fac.makeNot(r.getRight()));
    }
}

