/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.editors;

import ic.doc.ltsa.bpel.bpel2fsp;
import ic.doc.ltsa.bpel.bpws4jlog2fsp;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.LTSInput;
import ic.doc.ltsa.lts.LTSOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import ltsaeclipse.FSPIStorage;
import ltsaeclipse.FSPIStorageEditorInput;
import ltsaeclipse.LTSAFunctions;
import ltsaeclipse.editor.ui.actions.CompileAction;
import ltsaeclipse.editors.LTSAContentOutlinePage;
import ltsaeclipse.editors.LTSATextEditor;
import ltsaeclipse.views.ExampleTask;
import ltsaeclipse.views.LTSAActionTable;
import ltsaeclipse.views.LTSACompilerView;
import ltsaeclipse.views.LTSADrawTable;
import ltsaeclipse.views.LTSADrawView;
import ltsaeclipse.views.MappingLTSView;
import mscedit.MSCEditorControl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPageEditor
extends MultiPageEditorPart {
    protected LTSAContentOutlinePage page;
    private CompositeState currentstate;
    public bpel2fsp bpeltranslator;
    public bpws4jlog2fsp log2fsp;
    private LTSAFunctions LTSAfunctions = new LTSAFunctions();
    private int activepage = 0;
    private boolean isFirstView = true;
    private SashForm transitionsSashForm;
    LTSAActionTable MappingtableViewer;
    private MappingLTSView AMappingLTSView;
    private IFileEditorInput fileinput;
    private IFileEditorInput processinput;
    private String specificationfile = "";
    public String specificationlts = "";
    private String processfile = "";
    private String mscxmlfile = "";
    private IPath mappingfilepath;
    private IEditorInput ltsinput;
    int Nmach = 0;
    int hasC = 0;
    CompactState[] sm;
    boolean[] machineHasAction;
    boolean[] machineToDrawSet;
    private MultiPageEditor mpe = this;
    private LTSAEclipseIO MyInput;
    private LTSAEclipseIO MyOutput;
    private LTSATextEditor editor;
    private LTSATextEditor verificationeditor;
    private TextEditor bpeleditor;
    private TextEditor wscdleditor;
    private TextEditor logeditor;
    private MSCEditorControl MSCEditorControl;
    private Font font;
    private StyledText alphabetText;
    private StyledText transitionsText;
    private LTSADrawTable transitionstableViewer;
    static /* synthetic */ Class class$0;

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            IEditorInput input = this.editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                this.fileinput = (IFileEditorInput)input;
                this.page = new LTSAContentOutlinePage(((IFileEditorInput)input).getFile());
                this.page.SetEditor(this);
                return this.page;
            }
            this.page = new LTSAContentOutlinePage(this.getLTS());
            this.page.SetEditor(this);
            return this.page;
        }
        return super.getAdapter(key);
    }

    public MultiPageEditor() {
        this.bpeltranslator = new bpel2fsp();
    }

    public LTSATextEditor getLTSEditor() {
        return this.editor;
    }

    public String getLTS() {
        String lts = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        lts = String.valueOf(lts) + "\n";
        return lts;
    }

    public void dispose() {
        LTSADrawView drawv = this.getDrawView();
        if (drawv != null) {
            drawv.setMPE(null);
            drawv.updateView("");
        }
        try {
            this.fileinput.getFile().refreshLocal(1, null);
        }
        catch (Exception exception) {
            this.showMessage("Close File", "Unable to refresh file.");
        }
        super.dispose();
    }

    public void moveToInEditor(int from, int to) {
        this.editor.setHighlightRange(from, to, true);
    }

    public void createMarkerProblem(int from, int pos, String message) {
        if (this.fileinput != null) {
            try {
                IMarker marker = this.fileinput.getFile().createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", 2);
                marker.setAttribute("lineNumber", (Object)new Integer(from));
            }
            catch (Exception exception) {}
        }
    }

    private File getFileFromIFile(IFile iFile) {
        File p_file = null;
        if (iFile != null) {
            p_file = (File)iFile;
        }
        return p_file;
    }

    private IEditorInput createBPELEditorInput(IPath path, String filename, String ext) {
        IFile workspaceFile = null;
        try {
            File test = new File(String.valueOf(this.fileinput.getFile().getLocation().toString()) + ".lts");
            test.createNewFile();
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            workspaceFile = myWorkspaceRoot.getFile(path.removeFileExtension().addFileExtension(String.valueOf(ext) + ".lts"));
            if (workspaceFile != null) {
                return new FileEditorInput(workspaceFile);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private IEditorInput createEditorInputFromString(String contents) {
        FSPIStorage storage = new FSPIStorage(contents);
        FSPIStorageEditorInput input = new FSPIStorageEditorInput(storage);
        return input;
    }

    private IEditorInput createEditorInput(IPath path, String filename) {
        IFile workspaceFile = null;
        try {
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            workspaceFile = myWorkspaceRoot.getFileForLocation(path);
            if (workspaceFile != null) {
                return new FileEditorInput(workspaceFile);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    void createPage0() {
        this.isFirstView = true;
        try {
            this.editor = new LTSATextEditor(this);
            IEditorInput input = this.getEditorInput();
            if (input instanceof IFileEditorInput) {
                this.fileinput = (IFileEditorInput)input;
                if (this.fileinput.getFile().getFileExtension().equals("bpel")) {
                    this.processinput = this.fileinput;
                    this.processfile = this.processinput.getFile().getFullPath().makeAbsolute().toString();
                    this.bpeleditor = new TextEditor();
                    int index = this.addPage((IEditorPart)this.bpeleditor, this.getEditorInput());
                    this.setPageText(index, "BPEL4WS Source");
                    this.setTitle(this.bpeleditor.getTitle());
                    IEditorInput ltsinput = this.createBPELEditorInput(this.fileinput.getFile().getFullPath(), String.valueOf(this.fileinput.getFile().getLocation().toString()) + ".lts", "bpel");
                    if (ltsinput != null) {
                        index = this.addPage((IEditorPart)this.editor, ltsinput);
                        this.setPageText(index, "FSP Editor");
                        this.createPage1();
                    }
                } else if (this.fileinput.getFile().getFileExtension().equals("cdl")) {
                    this.processinput = this.fileinput;
                    this.processfile = this.processinput.getFile().getFullPath().makeAbsolute().toString();
                    this.wscdleditor = new TextEditor();
                    int index = this.addPage((IEditorPart)this.wscdleditor, this.getEditorInput());
                    this.setPageText(index, "WS-CDL Source");
                    this.setTitle(this.wscdleditor.getTitle());
                    IEditorInput ltsinput = this.createBPELEditorInput(this.fileinput.getFile().getFullPath(), String.valueOf(this.fileinput.getFile().getLocation().toString()) + ".lts", "cdl");
                    if (ltsinput != null) {
                        index = this.addPage((IEditorPart)this.editor, ltsinput);
                        this.setPageText(index, "FSP Editor");
                        this.createPage1();
                    }
                } else if (this.fileinput.getFile().getFileExtension().equals("log")) {
                    this.processfile = this.fileinput.getFile().getFullPath().makeAbsolute().toString();
                    this.logeditor = new TextEditor();
                    int index = this.addPage((IEditorPart)this.logeditor, this.getEditorInput());
                    this.setPageText(index, "BPWS4J Log");
                    this.setTitle(this.logeditor.getTitle());
                    IEditorInput ltsinput = this.LTSAfunctions.createEditorInputFromString("");
                    if (ltsinput != null) {
                        index = this.addPage((IEditorPart)this.editor, ltsinput);
                        this.setPageText(index, "FSP Editor");
                        this.createPage1();
                    }
                } else if (this.fileinput.getFile().getFileExtension().equals("msc") || this.fileinput.getFile().getFileExtension().equals("xml")) {
                    this.mscxmlfile = this.fileinput.getFile().getFullPath().makeAbsolute().toString();
                    Composite composite = new Composite(this.getContainer(), 0);
                    this.MSCEditorControl = new MSCEditorControl(composite);
                    this.MSCEditorControl.mpe = this;
                    int index = this.addPage((Control)composite);
                    this.setPageText(index, "MSC Editor");
                    this.setTitle(this.fileinput.getFile().getName());
                    IEditorInput ltsinput = this.LTSAfunctions.createEditorInputFromString("");
                    if (ltsinput != null) {
                        index = this.addPage((IEditorPart)this.editor, ltsinput);
                        this.setPageText(index, "FSP Editor");
                        this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(" ");
                        this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set("");
                    }
                    try {
                        this.MSCEditorControl.SetSpecFile(new File(this.fileinput.getFile().getRawLocation().toString()));
                        if (this.fileinput.getFile().getContents().read() > 0) {
                            this.MSCEditorControl.OpenSpecFile(new File(this.fileinput.getFile().getRawLocation().toString()));
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
                    this.setPageText(index, "FSP Editor");
                    this.setTitle(this.editor.getTitle());
                    int operations = 19;
                    DropTarget target = new DropTarget(this.getControl(0), operations);
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    final FileTransfer fileTransfer = FileTransfer.getInstance();
                    Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
                    types = new Transfer[]{fileTransfer, textTransfer};
                    target.setTransfer(types);
                    target.addDropListener(new DropTargetListener(){

                        public void dragEnter(DropTargetEvent event) {
                        }

                        public void dragOver(DropTargetEvent event) {
                        }

                        public void dragOperationChanged(DropTargetEvent event) {
                        }

                        public void dragLeave(DropTargetEvent event) {
                        }

                        public void dropAccept(DropTargetEvent event) {
                        }

                        public void drop(DropTargetEvent event) {
                            if (fileTransfer.isSupportedType(event.currentDataType)) {
                                String[] files = (String[])event.data;
                                int i = 0;
                                while (i < files.length) {
                                    if (files[i].endsWith(".bpel")) {
                                        MultiPageEditor.this.doTranslateFromFile(files[i], false);
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                }
            } else if (input instanceof FSPIStorageEditorInput) {
                FSPIStorageEditorInput fspinput = (FSPIStorageEditorInput)input;
                String contents = "";
                try {
                    contents = fspinput.getFSPStorage().getStorageAsString();
                }
                catch (Exception exception) {}
                if (contents.indexOf("MSC/XML") == 0) {
                    this.createMSCEditor(false);
                } else {
                    int index = this.addPage((IEditorPart)this.editor, (IEditorInput)fspinput);
                    this.setPageText(index, "FSP Editor");
                    this.setTitle("new");
                }
            } else {
                int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
                this.setPageText(index, "FSP Editor");
                this.setTitle("new");
                this.setTitle(this.editor.getTitle());
            }
            this.createContextMenu();
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    void createMSCEditor(boolean isfile) {
        Composite composite = new Composite(this.getContainer(), 0);
        this.MSCEditorControl = new MSCEditorControl(composite);
        this.MSCEditorControl.mpe = this;
        int index = this.addPage((Control)composite);
        this.setPageText(index, "MSC Editor");
        IEditorInput ltsinput = this.LTSAfunctions.createEditorInputFromString("");
        if (ltsinput != null) {
            try {
                index = this.addPage((IEditorPart)this.editor, ltsinput);
            }
            catch (Exception exception) {}
            this.setPageText(index, "FSP Editor");
            this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(" ");
            this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set("");
        }
        if (isfile) {
            this.mscxmlfile = this.fileinput.getFile().getFullPath().makeAbsolute().toString();
            this.setTitle(this.fileinput.getFile().getName());
            try {
                this.MSCEditorControl.SetSpecFile(new File(this.fileinput.getFile().getRawLocation().toString()));
                if (this.fileinput.getFile().getContents().read() > 0) {
                    this.MSCEditorControl.OpenSpecFile(new File(this.fileinput.getFile().getRawLocation().toString()));
                }
            }
            catch (Exception exception) {}
        }
    }

    void createPage1() {
        int[] nArray = new int[]{10, 150};
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        SashForm MappingSashForm = new SashForm(composite, 512);
        this.AMappingLTSView = new MappingLTSView((Composite)MappingSashForm, this);
        this.MappingtableViewer = new LTSAActionTable((Composite)MappingSashForm, null, "");
        this.MappingtableViewer.setProcessFile(this.processfile);
        this.MappingtableViewer.SetMPE(this);
        int operations = 19;
        DropTarget target = new DropTarget(this.MappingtableViewer.getControl(), operations);
        TextTransfer textTransfer = TextTransfer.getInstance();
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        types = new Transfer[]{fileTransfer, textTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                new LinkedList();
                if (fileTransfer.isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].endsWith(".map")) {
                            MultiPageEditor.this.MappingtableViewer.doRestoreMapping(files[i]);
                            MultiPageEditor.this.specificationlts = "";
                        } else if (files[i].endsWith(".xml")) {
                            MultiPageEditor.this.MappingtableViewer.GetMPE().getMappingLTSView().addMappingLTSFile(files[i]);
                            String maplts = MultiPageEditor.this.getFSPfromMSCXML(files[i]);
                            MultiPageEditor.this.MappingtableViewer.doRestoreRelabels(MultiPageEditor.this.getFSPfromMSCXML(files[i]), false, true, files[i]);
                            MultiPageEditor.this.specificationfile = files[i];
                            MultiPageEditor.this.specificationlts = maplts;
                        } else {
                            MultiPageEditor.this.MappingtableViewer.doRestoreRelabels(files[i], true, true, files[i]);
                            MultiPageEditor.this.specificationfile = files[i];
                            MultiPageEditor.this.specificationlts = "";
                        }
                        ++i;
                    }
                }
            }
        });
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Mappings");
        this.createContextMenu();
    }

    public String getFSPfromMSCXML(String filename) {
        MSCEditorControl mec = new MSCEditorControl(null);
        String lts = mec.doSynthesiseFromFile(new File(filename));
        return lts;
    }

    void createPage2(boolean addpage, IEditorInput ltsinput) {
        int[] nArray = new int[]{100, 300};
        String source = "";
        boolean hasmappings = false;
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.transitionsSashForm = new SashForm(composite, 256);
        this.transitionstableViewer = new LTSADrawTable((Composite)this.transitionsSashForm, null);
        this.verificationeditor = new LTSATextEditor(this);
        if (ltsinput != null) {
            if (!addpage) {
                this.removePage(3);
            }
            int index = 0;
            try {
                ExampleTask task;
                int relabelcounter;
                ExampleTask task2;
                index = this.addPage((IEditorPart)this.verificationeditor, ltsinput);
                this.setPageText(index, "Verification");
                source = String.valueOf(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get()) + "\n";
                source = String.valueOf(source) + "||" + this.bpeltranslator.strBPELProcessName + "_BPELArchitectureModel = " + this.bpeltranslator.strBPELProcessName + "_BPELModel";
                Vector vec = this.MappingtableViewer.getTaskList().getTasks();
                int element = 0;
                while (element < vec.size()) {
                    task2 = (ExampleTask)vec.get(element);
                    if (task2.getOwner().length() > 0) {
                        hasmappings = true;
                    }
                    ++element;
                }
                if (hasmappings) {
                    relabelcounter = 0;
                    source = String.valueOf(source) + " / {";
                    int element2 = 0;
                    while (element2 < vec.size()) {
                        task = (ExampleTask)vec.get(element2);
                        if (task.getOwner().length() > 0) {
                            if (relabelcounter > 0) {
                                source = String.valueOf(source) + ",";
                            }
                            source = String.valueOf(source) + task.getOwner() + "/" + task.getDescription();
                            ++relabelcounter;
                        }
                        ++element2;
                    }
                    source = String.valueOf(source) + "}";
                }
                hasmappings = false;
                element = 0;
                while (element < vec.size()) {
                    task2 = (ExampleTask)vec.get(element);
                    if (!task2.isCompleted()) {
                        hasmappings = true;
                    }
                    ++element;
                }
                if (hasmappings) {
                    relabelcounter = 0;
                    source = String.valueOf(source) + " \\ {";
                    int element3 = 0;
                    while (element3 < vec.size()) {
                        task = (ExampleTask)vec.get(element3);
                        if (!task.isCompleted()) {
                            if (relabelcounter > 0) {
                                source = String.valueOf(source) + ",";
                            }
                            source = String.valueOf(source) + task.getDescription();
                            ++relabelcounter;
                        }
                        ++element3;
                    }
                    source = String.valueOf(source) + "}";
                }
                hasmappings = true;
                source = String.valueOf(source) + ".\n";
                source = String.valueOf(source) + "||Abs_Process_BPEL = " + this.bpeltranslator.strBPELProcessName + "_BPELArchitectureModel.\n";
                IDocument doc = this.verificationeditor.getDocumentProvider().getDocument((Object)this.verificationeditor.getEditorInput());
                source = String.valueOf(source) + "\n" + doc.get();
                source = String.valueOf(source) + "||Abs_Process_SPEC = ArchitectureModel.\n";
                source = String.valueOf(source) + "deterministic ||DetA = Abs_Process_SPEC \\ {endAction}.\n";
                source = String.valueOf(source) + "property ||PropBPELSpec = DetA.\n";
                source = String.valueOf(source) + "||AA_Check_BPEL_MSC = (PropBPELSpec || Abs_Process_BPEL )";
                if (hasmappings) {
                    relabelcounter = 0;
                    source = String.valueOf(source) + " / {";
                    int element4 = 0;
                    while (element4 < vec.size()) {
                        task = (ExampleTask)vec.get(element4);
                        if (task.getOwner().length() > 0) {
                            if (relabelcounter > 0) {
                                source = String.valueOf(source) + ",";
                            }
                            source = String.valueOf(source) + task.getDescription() + "/" + task.getOwner();
                            ++relabelcounter;
                        }
                        ++element4;
                    }
                    source = String.valueOf(source) + "}";
                }
                source = String.valueOf(source) + ".\n";
                source = String.valueOf(source) + "deterministic ||DetB = Abs_Process_BPEL.\n";
                source = String.valueOf(source) + "property ||PropSpecBPEL = DetB.\n";
                source = String.valueOf(source) + "||AA_Check_MSC_BPEL = (PropSpecBPEL || Abs_Process_SPEC )";
                if (hasmappings) {
                    relabelcounter = 0;
                    source = String.valueOf(source) + " / {";
                    int element5 = 0;
                    while (element5 < vec.size()) {
                        task = (ExampleTask)vec.get(element5);
                        if (task.getOwner().length() > 0) {
                            if (relabelcounter > 0) {
                                source = String.valueOf(source) + ",";
                            }
                            source = String.valueOf(source) + task.getDescription() + "/" + task.getOwner();
                            ++relabelcounter;
                        }
                        ++element5;
                    }
                    source = String.valueOf(source) + "}";
                }
                source = String.valueOf(source) + ".\n";
                doc.set(source);
                this.setActivePage(index);
                this.page.setPageInput(source);
                this.page.update();
            }
            catch (Exception exception) {}
        }
        this.createContextMenu();
    }

    protected void createPages() {
        this.createPage0();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getActivePage() == 0) {
            if (this.MSCEditorControl != null) {
                this.MSCEditorControl.SaveSpecFile();
            }
            if (this.bpeleditor != null) {
                this.doSaveBPEL(this.processinput.getFile().getFullPath());
            }
            if (this.editor != null) {
                this.doSaveLTS(this.fileinput.getFile().getFullPath(), String.valueOf(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get()) + "\n");
            }
        } else if (this.getActivePage() == 1) {
            if (this.editor != null) {
                this.doSaveLTS(this.fileinput.getFile().getFullPath(), String.valueOf(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get()) + "\n");
            }
        } else if (this.getActivePage() == 2) {
            if (this.mappingfilepath != null) {
                this.MappingtableViewer.doSaveMapping(this.mappingfilepath);
            }
        } else {
            this.getEditor(this.getActivePage()).doSave(monitor);
            this.doParse();
            this.isFirstView = true;
            if (this.page != null) {
                this.page.update();
            }
        }
    }

    public void doSaveAs() {
        if (this.getActivePage() == 0) {
            if (this.MSCEditorControl != null) {
                SaveAsDialog sad = new SaveAsDialog(this.getSite().getShell());
                sad.setOriginalName(this.getTitle());
                sad.setTitle("Save MSC As");
                sad.open();
                if (sad.getReturnCode() == 0) {
                    IPath mscfilepath = sad.getResult();
                    IFile savefile = ResourcesPlugin.getWorkspace().getRoot().getFile(mscfilepath);
                    this.MSCEditorControl.doSave(savefile.getRawLocation().toFile());
                }
            } else {
                this.isFirstView = true;
                IEditorPart editor = this.getEditor(0);
                editor.doSaveAs();
                this.setPageText(0, editor.getTitle());
                this.setInput(editor.getEditorInput());
                if (this.page != null) {
                    this.page.update();
                }
            }
        } else if (this.getActivePage() == 1) {
            SaveAsDialog sad = new SaveAsDialog(this.getSite().getShell());
            sad.setTitle("Save FSP As");
            sad.open();
            if (sad.getReturnCode() == 0) {
                IPath fspfilepath = sad.getResult();
                this.doSaveLTS(fspfilepath, String.valueOf(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get()) + "\n");
            }
        } else if (this.getActivePage() == 2) {
            String bpelprocessmapfilename = "process_spec";
            if (this.bpeltranslator.strBPELProcessName.length() > 0) {
                bpelprocessmapfilename = String.valueOf(this.bpeltranslator.strBPELProcessName) + ".map";
            }
            SaveAsDialog sad = new SaveAsDialog(this.getSite().getShell());
            sad.setOriginalName(bpelprocessmapfilename);
            sad.setTitle("Save Mapping As");
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile workspaceFile = myWorkspaceRoot.getFile((IPath)new Path(String.valueOf(this.processinput.getFile().getFullPath().toString()) + ".map"));
            sad.setOriginalFile(workspaceFile);
            sad.open();
            if (sad.getReturnCode() == 0) {
                this.mappingfilepath = sad.getResult();
                this.MappingtableViewer.doSaveMapping(this.mappingfilepath);
            }
        }
    }

    public void doSaveLTS(IPath path, String contents) {
        if (contents.length() > 0) {
            try {
                IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFile workspaceFile = myWorkspaceRoot.getFile(path);
                workspaceFile.delete(false, null);
                workspaceFile.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
            }
            catch (Exception exception) {}
        } else {
            this.showMessage("Save FSP", "Please select a specification file before saving mapping.");
        }
    }

    public void doSaveBPEL(IPath path) {
        try {
            String contents = String.valueOf(this.bpeleditor.getDocumentProvider().getDocument((Object)this.bpeleditor.getEditorInput()).get()) + "\n";
            if (contents.length() > 0) {
                IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFile workspaceFile = myWorkspaceRoot.getFile(path);
                workspaceFile.delete(false, null);
                workspaceFile.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
            } else {
                this.showMessage("Save Process Mapping", "Please select a specification file before saving mapping.");
            }
        }
        catch (Exception exception) {
            this.showMessage("Save BPEL File", "Failed to save file.");
        }
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void updatePages(boolean outputresults) {
        if (this.bpeleditor != null) {
            if (this.bpeleditor.isDirty() || this.isFirstView) {
                if (this.bpeleditor.getDocumentProvider().getDocument((Object)this.bpeleditor.getEditorInput()).get().length() > 0) {
                    this.doTranslate(outputresults);
                }
                this.isFirstView = false;
                if (this.page != null) {
                    this.page.setPageInput("");
                    this.page.update();
                }
            }
        } else if (this.logeditor != null) {
            if (this.logeditor.isDirty() || this.isFirstView) {
                if (this.logeditor.getDocumentProvider().getDocument((Object)this.logeditor.getEditorInput()).get().length() > 0) {
                    this.doLogTranslate(outputresults);
                }
                this.isFirstView = false;
                if (this.page != null) {
                    this.page.setPageInput("");
                    this.page.update();
                }
            }
        } else if (this.MSCEditorControl != null) {
            this.doUpdateLTSEditor(this.MSCEditorControl.doSynthesise());
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        Control control = this.getControl(newPageIndex);
        if (control != null) {
            control.setVisible(true);
        }
        this.setFocus();
        if (this.getActivePage() > 0) {
            this.updatePages(true);
        }
    }

    void setFont() {
        FontDialog fontDialog = new FontDialog(this.getSite().getShell());
        FontData fontData = fontDialog.open();
        if (fontData != null && this.font != null) {
            this.font.dispose();
        }
    }

    public MappingLTSView getMappingLTSView() {
        return this.AMappingLTSView;
    }

    public CompositeState getCurrentState() {
        return this.currentstate;
    }

    public void setCurrentState(CompositeState newstate) {
        this.currentstate = newstate;
    }

    public void doCompose() {
        if (this.currentstate != null) {
            this.getOutputView().doCompose(this.currentstate);
        }
        this.updateDraw();
    }

    public void doAnalyse() {
        if (this.currentstate != null) {
            this.getOutputView().doAnalyse(this.currentstate);
        }
    }

    public void doMinimise() {
        if (this.currentstate != null) {
            this.getOutputView().doMinimise(this.currentstate);
        }
        this.updateDraw();
    }

    public void doProgress() {
        if (this.currentstate != null) {
            this.getOutputView().doProgress(this.currentstate);
        }
    }

    public LTSADrawView getDrawView() {
        LTSADrawView drawv = (LTSADrawView)this.getSite().getPage().findView("ltsaeclipse.views.LTSADrawView");
        if (drawv != null) {
            try {
                drawv.setMPE(this);
                drawv.updateView("");
            }
            catch (Exception exception) {}
        }
        return drawv;
    }

    public LTSACompilerView getOutputView() {
        LTSACompilerView outview = (LTSACompilerView)this.getSite().getPage().findView("ltsaeclipse.views.LTSACompilerView");
        if (outview == null) {
            try {
                this.getSite().getPage().showView("ltsaeclipse.views.LTSACompilerView");
                outview = (LTSACompilerView)this.getSite().getPage().findView("ltsaeclipse.views.LTSACompilerView");
            }
            catch (Exception exception) {}
        }
        return outview;
    }

    public void updateDraw() {
        LTSADrawView drawv = this.getDrawView();
        if (drawv != null) {
            drawv.updateView("");
        }
    }

    public void clearMarkers() {
        if (this.fileinput != null) {
            try {
                this.fileinput.getFile().deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
            catch (Exception exception) {}
        }
    }

    public void doCompile() {
        String composition = "";
        String source = "";
        if (this.page != null) {
            try {
                composition = this.page.currentselection;
            }
            catch (Exception exception) {}
        }
        if (composition.equals("")) {
            composition = "Default";
        }
        this.clearMarkers();
        this.getOutputView().setMPE(this);
        if (this.getActivePage() > 2) {
            source = String.valueOf(this.verificationeditor.getDocumentProvider().getDocument((Object)this.verificationeditor.getEditorInput()).get()) + "\n";
        } else {
            if (this.bpeleditor != null && this.isFirstView) {
                this.doTranslate(false);
            }
            source = String.valueOf(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get()) + "\n";
        }
        this.getOutputView().setSource(source);
        this.getOutputView().doCompile(this, composition);
    }

    public String getActiveSource() {
        String source = "";
        this.getActivePage();
        source = this.getActivePage() > 2 ? String.valueOf(this.verificationeditor.getDocumentProvider().getDocument((Object)this.verificationeditor.getEditorInput()).get()) + "\n" : String.valueOf(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get()) + "\n";
        return source;
    }

    public Hashtable doParse() {
        this.clearMarkers();
        this.getOutputView().setSource(this.getActiveSource());
        this.getOutputView().doParse(this);
        return this.getOutputView().getParsetable();
    }

    public void doTranslateFromFile(String filename, boolean outputresults) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            out.write("Translating to BPEL4WS...".getBytes());
            this.bpeltranslator.loadBPEL(filename, true);
            this.bpeltranslator.setFSPOutput(baos);
            this.bpeltranslator.setOutput(out);
            this.bpeltranslator.translateToFSP(false);
            this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(baos.toString());
            this.page.update();
        }
        catch (Exception exception) {}
        this.MappingtableViewer.setActionList(this.bpeltranslator.getActionList());
    }

    public void doTranslate(boolean outputresults) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            out.write("Translating BPEL4WS to FSP...".getBytes());
            this.bpeltranslator.loadBPEL(this.bpeleditor.getDocumentProvider().getDocument((Object)this.bpeleditor.getEditorInput()).get(), false);
            this.bpeltranslator.setFSPOutput(baos);
            this.bpeltranslator.setOutput(out);
            this.bpeltranslator.translateToFSP(false);
            this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(baos.toString());
            this.page.update();
        }
        catch (Exception exception) {}
        this.MappingtableViewer.setActionList(this.bpeltranslator.getActionList());
        try {
            ResourcesPlugin.getWorkspace().getRoot();
            String mapfile = String.valueOf(this.processinput.getFile().getRawLocation().toString()) + ".map";
            this.MappingtableViewer.doRestoreMapping(mapfile);
            this.specificationfile = this.MappingtableViewer.getSourceFile();
        }
        catch (Exception exception) {
            this.showMessage("test", "failed to find: " + this.bpeleditor.getTitle() + ".map");
        }
    }

    public void doLogTranslate(boolean outputresults) {
        new ByteArrayOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.log2fsp == null) {
            this.log2fsp = new bpws4jlog2fsp();
        }
        String test = this.logeditor.getDocumentProvider().getDocument((Object)this.logeditor.getEditorInput()).get();
        this.log2fsp.setLog(test);
        this.log2fsp.setFSPOutput(baos);
        this.log2fsp.translate();
        this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(baos.toString());
        this.page.update();
    }

    public void doUpdateLTSEditor(String lts) {
        this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(lts);
        this.page.update();
    }

    public void doTranslateMap() {
        boolean addpage = false;
        if (this.specificationfile.length() > 0) {
            this.ltsinput = this.specificationlts.length() > 0 ? this.createEditorInputFromString(this.specificationlts) : this.createEditorInput((IPath)new Path(this.specificationfile), "");
            if (this.verificationeditor == null) {
                addpage = true;
            }
            this.createPage2(addpage, this.ltsinput);
        }
    }

    void displayAlphabet() {
        String alphabetstr = "";
        if (this.sm != null) {
            alphabetstr = String.valueOf(alphabetstr) + "Process: \n";
            alphabetstr = String.valueOf(alphabetstr) + "\t" + this.sm[0].name + "\n";
            alphabetstr = String.valueOf(alphabetstr) + "Alphabet: \n";
            alphabetstr = String.valueOf(alphabetstr) + "\t{";
            int word = 0;
            while (word < this.sm[0].alphabet.length) {
                alphabetstr = String.valueOf(alphabetstr) + " " + this.sm[0].alphabet[word];
                if (word < this.sm[0].alphabet.length) {
                    alphabetstr = String.valueOf(alphabetstr) + ",";
                }
                ++word;
            }
            alphabetstr = String.valueOf(alphabetstr) + " } ";
            this.alphabetText.setText(alphabetstr);
        }
    }

    void displayTransitions() {
        String alphabetstr = "";
        LTSAEclipseIO MyOutput2 = new LTSAEclipseIO();
        if (this.sm != null) {
            alphabetstr = String.valueOf(alphabetstr) + "Process: \n";
            alphabetstr = String.valueOf(alphabetstr) + "\t" + this.sm[0].name + "\n";
            alphabetstr = String.valueOf(alphabetstr) + "Transitions: \n";
            alphabetstr = String.valueOf(alphabetstr) + MyOutput2.result;
            this.transitionsText.setText(alphabetstr);
        }
    }

    void sortWords() {
        String editorText = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        StringTokenizer tokenizer = new StringTokenizer(editorText, " \t\n\r\f!@#$%^&*()-_=+`~[]{};:'\",.<>/?|\\");
        ArrayList<String> editorWords = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            editorWords.add(tokenizer.nextToken());
        }
        Collections.sort(editorWords, Collator.getInstance());
        StringWriter displayText = new StringWriter();
        int i = 0;
        while (i < editorWords.size()) {
            displayText.write((String)editorWords.get(i));
            displayText.write(System.getProperty("line.separator"));
            ++i;
        }
    }

    private void createContextMenu() {
        Action compileAction = new Action(){

            public void run() {
                MultiPageEditor.this.doCompile();
            }
        };
        compileAction.setText("&Compile");
        compileAction.setToolTipText("Compose FSP");
        compileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT"));
        MenuManager menuMgr = new MenuManager(this.getEditorSite().getId(), this.getSite().getId());
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MultiPageEditor.this.fillContextMenu(manager);
            }
        });
        menuMgr.add((IAction)compileAction);
        Menu contextMenu = menuMgr.createContextMenu(this.getControl(0));
        this.getControl(0).setMenu(contextMenu);
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        CompileAction compileFSPAction = new CompileAction();
        compileFSPAction.setActiveEditor(this);
        menuMgr.add((IAction)compileFSPAction);
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation(null, (String)title, (String)message);
    }

    private void list_new_machines(CompositeState cs, int newPageIndex) {
        int i;
        int hasC;
        int n = hasC = cs != null && cs.composition != null ? 1 : 0;
        if (cs != null && cs.machines != null && cs.machines.size() > 0) {
            this.sm = new CompactState[cs.machines.size() + hasC];
            Enumeration e = cs.machines.elements();
            i = 0;
            while (e.hasMoreElements()) {
                this.sm[i] = (CompactState)e.nextElement();
                ++i;
            }
            this.Nmach = this.sm.length;
            if (hasC == 1) {
                this.sm[this.Nmach - 1] = cs.composition;
            }
            this.machineHasAction = new boolean[this.Nmach];
            this.machineToDrawSet = new boolean[this.Nmach];
        } else {
            this.Nmach = 0;
            this.machineHasAction = null;
            this.machineToDrawSet = null;
        }
        DefaultListModel<String> lm = new DefaultListModel<String>();
        i = 0;
        while (i < this.Nmach) {
            String stringStates;
            if (hasC == 1 && i == this.Nmach - 1) {
                lm.addElement("||" + this.sm[i].name);
                stringStates = "" + this.sm[i].maxStates;
                this.addMachine(newPageIndex, "||" + this.sm[i].name, stringStates);
            } else {
                lm.addElement(this.sm[i].name);
                stringStates = "" + this.sm[i].maxStates;
                this.addMachine(newPageIndex, this.sm[i].name, stringStates);
            }
            ++i;
        }
    }

    public void addMachine(int newPageIndex, String machinename, String states) {
    }

    public void removeMachines(int newPageIndex) {
    }

    public void refreshList(int newPageIndex) {
        this.removeMachines(newPageIndex);
        if (this.getCurrentState() != null) {
            this.list_new_machines(this.getCurrentState(), newPageIndex);
        }
    }

    public void updateAlphabet(String machine) {
        this.alphabetText.setText(machine);
    }

    public void traceToMSC(String traceoutput) {
        LinkedList components = null;
        LinkedList actions = null;
        if (traceoutput.length() > 0) {
            if (this.bpeltranslator == null) {
                this.bpeltranslator = new bpel2fsp();
            }
            components = this.bpeltranslator.getDeadlockComponentsfromBPELTrace(traceoutput);
            actions = this.bpeltranslator.getDeadlockActionsfromBPELTrace(traceoutput);
            try {
                FSPIStorage storage = new FSPIStorage("MSC/XML");
                FSPIStorageEditorInput input = new FSPIStorageEditorInput(storage);
                MultiPageEditor msceditor = (MultiPageEditor)this.getSite().getPage().openEditor((IEditorInput)input, "ltsaeclipse.editors.MultiPageEditor");
                msceditor.MSCEditorControl.addbMSC("process", components, actions);
            }
            catch (Exception exception) {}
        }
    }

    class LTSAEclipseIO
    implements LTSInput,
    LTSOutput {
        String fSrc = "A = (test -> END). B = (test2 -> END). ||C = (A || B).";
        public int fPos;
        public String result = "";

        LTSAEclipseIO() {
        }

        public void setFPos(int value) {
            this.fPos = value;
        }

        public char backChar() {
            --this.fPos;
            if (this.fPos < 0) {
                this.fPos = 0;
                return '\u0000';
            }
            return this.fSrc.charAt(this.fPos);
        }

        public char nextChar() {
            ++this.fPos;
            if (this.fPos < this.fSrc.length()) {
                return this.fSrc.charAt(this.fPos);
            }
            --this.fPos;
            return '\u0000';
        }

        public void out(String str) {
            this.result = String.valueOf(this.result) + str;
        }

        public void clearOutput() {
            this.result = "";
        }

        public void outln(String str) {
            this.result = String.valueOf(this.result) + str;
        }

        public void showOutput() {
        }

        public int getMarker() {
            return this.fPos;
        }
    }
}

