/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import ic.doc.ltsa.lts.Alphabet;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.EventState;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.util.BitSet;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import ltsaeclipse.editors.MultiPageEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class DrawCanvas
extends Canvas {
    final float ZOOMIN_RATE = 1.1f;
    final float ZOOMOUT_RATE = 0.9f;
    private AffineTransform transform = new AffineTransform();
    final Point origin = new Point(0, 0);
    int scroll_x = 0;
    int scroll_y = 0;
    GC thisgc;
    int MaxX = 0;
    int MaxY = 0;
    int MinY = 0;
    private String currentDir = "";
    public MultiPageEditor mpe;
    public static int MAXDRAWSTATES = 70;
    static final int STATESIZE = 30;
    Font labelFont;
    Font nameFont;
    Font stateFont = new Font(null, "Sans Serif", 13, 1);
    BitSet accepting;
    private int[] arrowX = new int[3];
    private int[] arrowY = new int[3];
    private static int arrowForward = 1;
    private static int arrowBackward = 2;
    private static int arrowDown = 3;
    protected boolean displayName = false;
    protected boolean newLabelFormat = true;
    protected boolean selectedMachine = false;
    int SEPARATION = 80;
    int ARCINC = 30;
    boolean needcompute = true;
    int topX = 0;
    int topY = 0;
    int zeroX = 0;
    int zeroY = 0;
    int heightAboveCenter;
    int nameWidth = 0;
    Dimension size;
    private int errorState = 0;
    private int lastselected = -3;
    private int selected = 0;
    private String lastaction;
    CompactState mach = null;
    CompositeState cs;
    int[] lastEvent;
    int[] prevEvent;
    String lastName;
    int Nmach = 0;
    int hasC = 0;
    CompactState[] sm;
    boolean[] machineHasAction;
    boolean[] machineToDrawSet;
    String[][] labels;

    public DrawCanvas(Composite parent) {
        this(parent, 0);
    }

    public DrawCanvas(Composite parent, int style) {
        super(parent, style | 0x800 | 0x200 | 0x100 | 0x40000);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                DrawCanvas.this.DrawMachine(event);
            }
        });
        this.initScrollBars();
    }

    public void dispose() {
    }

    private void paint(GC gc) {
        this.getClientArea();
        CompactState m = this.mach;
        if (m == null) {
            this.drawBlank(gc);
        } else {
            this.draw(gc);
        }
    }

    private void initScrollBars() {
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setEnabled(true);
        final ScrollBar hBar = this.getHorizontalBar();
        hBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int hSelection = hBar.getSelection();
                int destX = -hSelection - DrawCanvas.this.origin.x;
                Rectangle rect = DrawCanvas.this.getClientArea();
                DrawCanvas.this.scroll(destX, 0, 0, 0, rect.width, rect.height, false);
                DrawCanvas.this.topX = DrawCanvas.this.origin.x = -hSelection;
            }
        });
        final ScrollBar vBar = this.getVerticalBar();
        vBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int vSelection = vBar.getSelection();
                int destY = -vSelection - DrawCanvas.this.origin.y;
                Rectangle rect = DrawCanvas.this.getClientArea();
                DrawCanvas.this.scroll(0, destY, 0, 0, rect.width, rect.height, false);
                DrawCanvas.this.topY = DrawCanvas.this.origin.y = -vSelection;
            }
        });
    }

    void setScrollBarSize() {
        ScrollBar horizontal = this.getHorizontalBar();
        ScrollBar vertical = this.getVerticalBar();
        horizontal.setMinimum(0);
        horizontal.setMaximum(this.size.width);
        horizontal.setThumb(this.size.width % this.getClientArea().width);
        vertical.setMinimum(0);
        vertical.setMaximum(this.size.height);
        vertical.setThumb(this.size.height % this.getClientArea().height);
    }

    void setScrollBars() {
        ScrollBar horizontal = this.getHorizontalBar();
        ScrollBar vertical = this.getVerticalBar();
        Rectangle canvasBounds = this.getClientArea();
        int width = 1000;
        int height = 1000;
        if (width > canvasBounds.width) {
            horizontal.setVisible(true);
            horizontal.setValues(this.scroll_x, 0, width, canvasBounds.width, canvasBounds.width, canvasBounds.width);
        } else {
            horizontal.setVisible(false);
            this.scroll_x = 0;
        }
        if (height > canvasBounds.height) {
            vertical.setVisible(true);
            vertical.setValues(this.scroll_y, 0, height, canvasBounds.height, canvasBounds.height, canvasBounds.height);
        } else {
            vertical.setVisible(false);
            this.scroll_y = 0;
        }
    }

    private void scrollHorizontally(ScrollBar scrollBar) {
        Rectangle canvasBounds = this.getClientArea();
        int width = 1000;
        int height = 1000;
        if (width > canvasBounds.width) {
            int x = -scrollBar.getSelection();
            if (x + width < canvasBounds.width) {
                x = canvasBounds.width - width;
            }
            this.scroll(x, this.scroll_y, this.scroll_x, this.scroll_y, width, height, false);
            this.scroll_x = x;
        } else {
            this.topX = 0;
        }
    }

    private void scrollVertically(ScrollBar scrollBar) {
        Rectangle canvasBounds = this.getClientArea();
        int width = 1000;
        int height = 1000;
        if (height > canvasBounds.height) {
            int y = -scrollBar.getSelection();
            if (y + height < canvasBounds.height) {
                y = canvasBounds.height - height;
            }
            this.scroll(this.scroll_x, y, this.scroll_x, this.scroll_y, width, height, false);
            this.scroll_y = y;
        } else {
            this.topY = 0;
        }
    }

    public void syncsScrollBars() {
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setIncrement(this.getClientArea().width / 100);
        horizontal.setPageIncrement(this.getClientArea().width);
        Rectangle imageBound = new Rectangle(10, 10, 10000, 10);
        imageBound.width = 5000;
        imageBound.height = 5000;
        int cw = this.getClientArea().width;
        int cfr_ignored_0 = this.getClientArea().height;
        if (imageBound.width > cw) {
            horizontal.setMaximum(imageBound.width);
            horizontal.setEnabled(true);
            this.topX -= horizontal.getIncrement();
        }
        horizontal.setSelection(this.topX);
        horizontal.setThumb(this.getClientArea().width);
        this.redraw();
    }

    public void old_syncScrollBars() {
        AffineTransform af = this.transform;
        double sx = af.getScaleX();
        double sy = af.getScaleY();
        double tx = af.getTranslateX();
        double ty = af.getTranslateY();
        if (tx > 0.0) {
            tx = 0.0;
        }
        if (ty > 0.0) {
            ty = 0.0;
        }
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setIncrement(this.getClientArea().width / 100);
        horizontal.setPageIncrement(this.getClientArea().width);
        Rectangle imageBound = new Rectangle(10, 10, 10000, 10);
        imageBound.width = 5000;
        imageBound.height = 5000;
        int cw = this.getClientArea().width;
        int ch = this.getClientArea().height;
        if ((double)imageBound.width * sx > (double)cw) {
            horizontal.setMaximum((int)((double)imageBound.width * sx));
            horizontal.setEnabled(true);
            if ((int)(-tx) > horizontal.getMaximum() - cw) {
                tx = -horizontal.getMaximum() + cw;
            }
            this.topX = (int)tx;
        } else {
            horizontal.setEnabled(false);
            tx = ((double)cw - (double)imageBound.width * sx) / 2.0;
        }
        horizontal.setSelection((int)(-tx));
        horizontal.setThumb(this.getClientArea().width);
        ScrollBar vertical = this.getVerticalBar();
        vertical.setIncrement(this.getClientArea().height / 100);
        vertical.setPageIncrement(this.getClientArea().height);
        if ((double)imageBound.height * sy > (double)ch) {
            vertical.setMaximum((int)((double)imageBound.height * sy));
            vertical.setEnabled(true);
            if ((int)(-ty) > vertical.getMaximum() - ch) {
                ty = -vertical.getMaximum() + ch;
            }
        } else {
            vertical.setEnabled(false);
            ty = ((double)ch - (double)imageBound.height * sy) / 2.0;
        }
        vertical.setSelection((int)(-ty));
        vertical.setThumb(this.getClientArea().height);
        this.topY = (int)ty;
        this.topX = (int)tx;
        af = AffineTransform.getScaleInstance(sx, sy);
        af.preConcatenate(AffineTransform.getTranslateInstance(tx, ty));
        this.transform = af;
        this.redraw();
    }

    public void onFileOpen() {
    }

    public void setImageData(ImageData data) {
    }

    public void fitCanvas() {
    }

    public void showOriginal() {
    }

    public void centerZoom(double dx, double dy, double scale, AffineTransform af) {
        af.preConcatenate(AffineTransform.getTranslateInstance(-dx, -dy));
        af.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
        af.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
        this.transform = af;
    }

    public void setStretch(boolean absolute, int separation, int arcIncrement) {
        if (absolute) {
            this.SEPARATION = separation;
            this.ARCINC = arcIncrement;
        } else {
            if (this.SEPARATION + separation > 10) {
                this.SEPARATION += separation;
            }
            if (this.ARCINC + arcIncrement > 5) {
                this.ARCINC += arcIncrement;
            }
        }
        this.needcompute = true;
        this.redraw();
    }

    public void stretchHorizontal(int stretch) {
        this.setStretch(false, stretch, 0);
    }

    public void stretchVertical(int stretch) {
        this.setStretch(false, 0, stretch);
    }

    public void zoomIn() {
        Rectangle rect = this.getClientArea();
        int w = rect.width;
        int h = rect.height;
        double dx = (double)w / 2.0;
        double dy = (double)h / 2.0;
        this.centerZoom(dx, dy, 1.1f, this.transform);
    }

    public void zoomOut() {
        Rectangle rect = this.getClientArea();
        int w = rect.width;
        int h = rect.height;
        double dx = (double)w / 2.0;
        double dy = (double)h / 2.0;
        this.centerZoom(dx, dy, 0.9f, this.transform);
    }

    private void DrawMachine(PaintEvent e) {
        this.thisgc = e.gc;
        if (this.mach != null) {
            this.new_machines(this.mpe.getCurrentState());
            this.labelFont = new Font(null, "Times New Roman", 9, 0);
            this.accepting = this.mach.accepting();
            if (this.newLabelFormat) {
                this.initCompactLabels();
            }
            e.gc.setBackground(new Color(null, 255, 255, 255));
            Rectangle clientArea = this.getClientArea();
            e.gc.fillRectangle(clientArea);
            this.size = this.computeDimension(e.gc, this.mach);
            this.draw(e.gc);
        } else {
            this.drawBlank(e.gc);
        }
        this.setScrollBarSize();
    }

    public void drawBlank(GC g) {
        g.setBackground(new Color(null, 255, 255, 255));
        Rectangle clientArea = this.getClientArea();
        g.fillRectangle(clientArea);
        ScrollBar hBar = this.getHorizontalBar();
        hBar.setValues(0, 0, 0, 0, 0, 0);
        ScrollBar vBar = this.getVerticalBar();
        vBar.setValues(0, 0, 0, 0, 0, 0);
    }

    public void draw(GC g) {
        this.getClientArea();
        if (this.needcompute) {
            this.computeDimension(g, this.mach);
            this.needcompute = false;
        }
        this.nameFont = this.labelFont;
        CompactState m = this.mach;
        if (m == null) {
            return;
        }
        int aw = 0;
        if (this.displayName && this.errorState == 0) {
            aw = this.nameWidth;
        }
        this.zeroX = this.topX + 10 + this.errorState * this.SEPARATION + aw;
        this.zeroY = this.topY + this.heightAboveCenter - 15;
        if (m.maxStates > MAXDRAWSTATES) {
            g.setFont(this.nameFont);
            g.drawString(String.valueOf(m.name) + " Max states is " + MAXDRAWSTATES + " -- too many states for this machine: " + m.maxStates, this.topX, this.topY + 20);
        } else {
            String event;
            EventState tr;
            EventState p;
            int[] ntrans;
            g.setFont(this.nameFont);
            FontMetrics fm = g.getFontMetrics();
            int nw = fm.getAverageCharWidth() * m.name.length();
            g.setBackground(new Color(null, 0, 0, 0));
            if (this.displayName) {
                g.drawString(m.name, this.zeroX - nw, this.zeroY - 5);
            }
            int i = 0;
            while (i < m.maxStates) {
                ntrans = new int[m.maxStates + 1];
                p = m.states[i];
                while (p != null) {
                    tr = p;
                    event = m.alphabet[tr.event];
                    if (event.charAt(0) != '@') {
                        while (tr != null) {
                            int n = tr.next + 1;
                            ntrans[n] = ntrans[n] + 1;
                            this.drawTransition(g, i, tr.next, event, ntrans[tr.next + 1], i == this.lastselected && tr.next == this.selected, false);
                            tr = tr.nondet;
                        }
                    }
                    p = p.list;
                }
                ++i;
            }
            i = 0;
            while (i < m.maxStates) {
                ntrans = new int[m.maxStates + 1];
                p = m.states[i];
                while (p != null) {
                    tr = p;
                    event = m.alphabet[tr.event];
                    if (event.charAt(0) != '@') {
                        while (tr != null) {
                            int n = tr.next + 1;
                            ntrans[n] = ntrans[n] + 1;
                            if (!this.newLabelFormat) {
                                this.drawTransition(g, i, tr.next, event, ntrans[tr.next + 1], i == this.lastselected && tr.next == this.selected, false);
                            } else if (ntrans[tr.next + 1] == 1) {
                                this.drawTransition(g, i, tr.next, this.labels[i + 1][tr.next + 1], ntrans[tr.next + 1], i == this.lastselected && tr.next == this.selected, true);
                            }
                            tr = tr.nondet;
                        }
                    }
                    p = p.list;
                }
                ++i;
            }
            i = -this.errorState;
            while (i < m.maxStates) {
                this.drawState(g, i, i == this.selected);
                ++i;
            }
        }
        ScrollBar hBar = this.getHorizontalBar();
        hBar.setMaximum(this.MaxX);
        hBar.setIncrement(this.MaxX / 50);
        hBar.setMinimum(0);
        ScrollBar vBar = this.getHorizontalBar();
        vBar.setMaximum(this.MaxY);
        vBar.setIncrement(this.MaxY / 50);
        vBar.setMinimum(0);
    }

    private void initCompactLabels() {
        if (this.mach == null) {
            return;
        }
        if (this.mach.maxStates > MAXDRAWSTATES) {
            return;
        }
        this.labels = new String[this.mach.maxStates + 1][this.mach.maxStates + 1];
        int i = 0;
        while (i < this.mach.maxStates) {
            EventState current = EventState.transpose(this.mach.states[i]);
            while (current != null) {
                String[] events = EventState.eventsToNextNoAccept(current, this.mach.alphabet);
                Alphabet a = new Alphabet(events);
                this.labels[i + 1][current.next + 1] = a.toString();
                current = current.list;
            }
            ++i;
        }
    }

    private void new_machines(CompositeState cs) {
        int i;
        int hasC;
        int n = hasC = cs != null && cs.composition != null ? 1 : 0;
        if (cs != null && cs.machines != null && cs.machines.size() > 0) {
            this.sm = new CompactState[cs.machines.size() + hasC];
            Enumeration e = cs.machines.elements();
            i = 0;
            while (e.hasMoreElements()) {
                this.sm[i] = (CompactState)e.nextElement();
                ++i;
            }
            this.Nmach = this.sm.length;
            if (hasC == 1) {
                this.sm[this.Nmach - 1] = cs.composition;
            }
            this.machineHasAction = new boolean[this.Nmach];
            this.machineToDrawSet = new boolean[this.Nmach];
        } else {
            this.Nmach = 0;
            this.machineHasAction = null;
            this.machineToDrawSet = null;
        }
        DefaultListModel<String> lm = new DefaultListModel<String>();
        i = 0;
        while (i < this.Nmach) {
            if (hasC == 1 && i == this.Nmach - 1) {
                lm.addElement("||" + this.sm[i].name);
            } else {
                lm.addElement(this.sm[i].name);
            }
            ++i;
        }
    }

    private void drawArrow(GC g, int x, int y, int direction) {
        if (direction == arrowForward) {
            this.arrowX[0] = x - 5;
            this.arrowY[0] = y - 5;
            this.arrowX[1] = x + 5;
            this.arrowY[1] = y;
            this.arrowX[2] = x - 5;
            this.arrowY[2] = y + 5;
        } else if (direction == arrowBackward) {
            this.arrowX[0] = x + 5;
            this.arrowY[0] = y - 5;
            this.arrowX[1] = x - 5;
            this.arrowY[1] = y;
            this.arrowX[2] = x + 5;
            this.arrowY[2] = y + 5;
        } else if (direction == arrowDown) {
            this.arrowX[0] = x - 5;
            this.arrowY[0] = y - 5;
            this.arrowX[1] = x + 5;
            this.arrowY[1] = y - 5;
            this.arrowX[2] = x;
            this.arrowY[2] = y + 5;
        }
        int[] pa = new int[]{this.arrowX[0], this.arrowY[0], this.arrowX[1], this.arrowY[1], this.arrowX[2], this.arrowY[2]};
        g.setForeground(new Color(null, 0, 0, 0));
        g.setBackground(new Color(null, 0, 0, 0));
        g.fillPolygon(pa);
    }

    protected Dimension computeDimension(GC g, CompactState m) {
        int nameHeight = 0;
        if (this.displayName) {
            if (g != null) {
                g.setFont(this.nameFont);
                FontMetrics fm = g.getFontMetrics();
                this.nameWidth = fm.getAverageCharWidth() * this.mach.name.length();
                nameHeight = fm.getHeight();
            } else {
                this.nameWidth = this.SEPARATION;
            }
        } else {
            this.nameWidth = 0;
        }
        if (m.maxStates > MAXDRAWSTATES) {
            return new Dimension(220 + this.nameWidth, 50);
        }
        String largestEndLabel = null;
        if (!this.newLabelFormat) {
            EventState p = m.states[m.maxStates - 1];
            while (p != null) {
                EventState tr = p;
                while (tr != null) {
                    if (tr.next == m.maxStates - 1) {
                        // empty if block
                    }
                    tr = tr.nondet;
                }
                p = p.list;
            }
        } else {
            largestEndLabel = this.labels[m.maxStates][m.maxStates];
        }
        int endWidth = 10;
        if (largestEndLabel != null) {
            if (g != null) {
                g.setFont(this.labelFont);
                FontMetrics fm = g.getFontMetrics();
                endWidth = fm.getAverageCharWidth() * largestEndLabel.length();
                endWidth += this.SEPARATION / 3;
            } else {
                endWidth = this.SEPARATION;
            }
        }
        this.errorState = 0;
        int i = 0;
        while (i < m.maxStates) {
            if (EventState.hasState(m.states[i], -1)) {
                this.errorState = 1;
            }
            ++i;
        }
        int maxFwd = 0;
        int maxFwdLabels = 0;
        int maxBwd = 0;
        int maxBwdLabels = 0;
        int i2 = 0;
        while (i2 < m.maxStates) {
            int[] ntrans = new int[m.maxStates + 1];
            int fwdToState = 0;
            int bwdToState = 0;
            boolean fwd = false;
            boolean bwd = false;
            EventState p = m.states[i2];
            while (p != null) {
                EventState tr = p;
                while (tr != null) {
                    int n = tr.next + 1;
                    ntrans[n] = ntrans[n] + 1;
                    int diff = tr.next - i2;
                    if (diff > maxFwd || diff == maxFwd && ntrans[tr.next + 1] > maxFwdLabels) {
                        maxFwd = diff;
                        fwdToState = tr.next + 1;
                        fwd = true;
                    }
                    if (diff < maxBwd || diff == maxBwd && ntrans[tr.next + 1] > maxBwdLabels) {
                        maxBwd = diff;
                        bwdToState = tr.next + 1;
                        bwd = true;
                    }
                    tr = tr.nondet;
                }
                p = p.list;
            }
            if (fwd) {
                int n = maxFwdLabels = this.newLabelFormat ? 1 : ntrans[fwdToState];
            }
            if (bwd) {
                maxBwdLabels = this.newLabelFormat ? 1 : ntrans[bwdToState];
            }
            ++i2;
        }
        if (m.maxStates == 1) {
            maxFwdLabels = 0;
        }
        int fheight = 10;
        if (g != null) {
            g.setFont(this.labelFont);
            FontMetrics fm = g.getFontMetrics();
            fheight = fm.getHeight();
        }
        this.heightAboveCenter = maxFwd != 0 ? this.ARCINC * maxFwd / 2 : 15 + nameHeight;
        this.heightAboveCenter = this.heightAboveCenter + maxFwdLabels * fheight + 10;
        int heightBelowCenter = maxBwd != 0 ? this.ARCINC * Math.abs(maxBwd) / 2 : 15;
        heightBelowCenter = heightBelowCenter + maxBwdLabels * fheight + 10;
        int pwidth = this.errorState == 0 ? 10 + this.nameWidth + 30 + endWidth + (m.maxStates - 1) * this.SEPARATION : 40 + endWidth + m.maxStates * this.SEPARATION;
        int pheight = this.heightAboveCenter + heightBelowCenter;
        return new Dimension(pwidth, pheight);
    }

    protected Dimension computeDimension2(GC g, CompactState m) {
        int nameHeight = 0;
        if (this.displayName) {
            if (g != null) {
                g.setFont(this.nameFont);
                FontMetrics fm = g.getFontMetrics();
                this.nameWidth = fm.getAverageCharWidth() * this.mach.name.length();
                nameHeight = fm.getHeight();
            } else {
                this.nameWidth = this.SEPARATION;
            }
        } else {
            this.nameWidth = 0;
        }
        if (m.maxStates > MAXDRAWSTATES) {
            return new Dimension(220 + this.nameWidth, 50);
        }
        String largestEndLabel = null;
        if (!this.newLabelFormat) {
            EventState p = m.states[m.maxStates - 1];
            while (p != null) {
                EventState tr = p;
                while (tr != null) {
                    if (tr.next == m.maxStates - 1) {
                        if (largestEndLabel == null) {
                            largestEndLabel = m.alphabet[tr.event];
                        } else {
                            String s = m.alphabet[tr.event];
                            if (s.length() > largestEndLabel.length()) {
                                largestEndLabel = s;
                            }
                        }
                    }
                    tr = tr.nondet;
                }
                p = p.list;
            }
        } else {
            largestEndLabel = this.labels[m.maxStates][m.maxStates];
        }
        int endWidth = 10;
        if (largestEndLabel != null) {
            if (g != null) {
                g.setFont(this.labelFont);
                g.setFont(this.labelFont);
                FontMetrics fm = g.getFontMetrics();
                endWidth = fm.getAverageCharWidth() * largestEndLabel.length();
                endWidth += this.SEPARATION / 3;
            } else {
                endWidth = this.SEPARATION;
            }
        }
        this.errorState = 0;
        int i = 0;
        while (i < m.maxStates) {
            if (EventState.hasState(m.states[i], -1)) {
                this.errorState = 1;
            }
            ++i;
        }
        int maxFwd = 0;
        int maxFwdLabels = 0;
        int maxBwd = 0;
        int maxBwdLabels = 0;
        int i2 = 0;
        while (i2 < m.maxStates) {
            int[] ntrans = new int[m.maxStates + 1];
            int fwdToState = 0;
            int bwdToState = 0;
            boolean fwd = false;
            boolean bwd = false;
            EventState p = m.states[i2];
            while (p != null) {
                EventState tr = p;
                while (tr != null) {
                    int n = tr.next + 1;
                    ntrans[n] = ntrans[n] + 1;
                    int diff = tr.next - i2;
                    if (diff > maxFwd || diff == maxFwd && ntrans[tr.next + 1] > maxFwdLabels) {
                        maxFwd = diff;
                        fwdToState = tr.next + 1;
                        fwd = true;
                    }
                    if (diff < maxBwd || diff == maxBwd && ntrans[tr.next + 1] > maxBwdLabels) {
                        maxBwd = diff;
                        bwdToState = tr.next + 1;
                        bwd = true;
                    }
                    tr = tr.nondet;
                }
                p = p.list;
            }
            if (fwd) {
                int n = maxFwdLabels = this.newLabelFormat ? 1 : ntrans[fwdToState];
            }
            if (bwd) {
                maxBwdLabels = this.newLabelFormat ? 1 : ntrans[bwdToState];
            }
            ++i2;
        }
        if (m.maxStates == 1) {
            maxFwdLabels = 0;
        }
        int fheight = 10;
        if (g != null) {
            g.setFont(this.labelFont);
            FontMetrics fm = g.getFontMetrics();
            fheight = fm.getHeight();
        }
        this.heightAboveCenter = maxFwd != 0 ? this.ARCINC * maxFwd / 2 : 15 + nameHeight;
        this.heightAboveCenter = this.heightAboveCenter + maxFwdLabels * fheight + 10;
        int heightBelowCenter = maxBwd != 0 ? this.ARCINC * Math.abs(maxBwd) / 2 : 15;
        heightBelowCenter = heightBelowCenter + maxBwdLabels * fheight + 10;
        int pwidth = this.errorState == 0 ? 10 + this.nameWidth + 30 + endWidth + (m.maxStates - 1) * this.SEPARATION : 40 + endWidth + m.maxStates * this.SEPARATION;
        int pheight = this.heightAboveCenter + heightBelowCenter;
        return new Dimension(pwidth, pheight);
    }

    private void drawTransition(GC g, int from, int to, String s, int n, boolean highlight, boolean dotext) {
        int py;
        if (highlight) {
            g.setBackground(new Color(null, 255, 0, 0));
        } else {
            g.setBackground(new Color(null, 0, 0, 0));
        }
        int sign = to <= from ? -1 : 1;
        int start = to < from ? to : from;
        int x = this.zeroX + start * this.SEPARATION + 15;
        int w = to != from ? this.SEPARATION * Math.abs(from - to) : this.SEPARATION / 3;
        int h = to != from ? this.ARCINC * Math.abs(from - to) : 25;
        int y = this.zeroY - (h - 30) / 2;
        y += 30;
        if (n == 1 && !dotext) {
            if (from != to) {
                g.drawArc(x, y, w, h, 0, 180 * sign);
                if (sign > 0) {
                    this.drawArrow(g, x + w / 2, y, arrowForward);
                } else {
                    this.drawArrow(g, x + w / 2, y + h - 1, arrowBackward);
                }
            } else {
                g.drawArc(x, y, w, h, 0, 360);
                this.drawArrow(g, x + w, y + h / 2, arrowDown);
            }
        }
        if (x + w > this.MaxX) {
            this.MaxX = x + w;
        }
        if (y + h > this.MaxY) {
            this.MaxY = y + h;
        }
        if (!dotext) {
            return;
        }
        ++n;
        g.setFont(this.labelFont);
        FontMetrics fm = g.getFontMetrics();
        int drop = fm.getHeight() / 3;
        int px = x + w / 2 - fm.getAverageCharWidth() * s.length() / 2;
        int n2 = py = sign > 0 ? y + drop : y + h + drop;
        if (to == from) {
            py = y + h / 2 + drop;
        }
        if (n > 1) {
            py -= (n - 1) * (fm.getHeight() * 2) * sign;
        }
        if (sign < 0 && to != from) {
            py -= fm.getHeight() * 2;
        } else if (to == from) {
            py -= fm.getHeight();
        }
        g.setBackground(new Color(null, 255, 255, 255));
        if (highlight && (this.lastaction != null && this.lastaction.equals(s) || this.newLabelFormat)) {
            g.setForeground(new Color(null, 0, 100, 0));
        } else {
            g.setForeground(new Color(null, 0, 0, 0));
        }
        g.drawString(s, px, py);
    }

    private void drawState(GC g, int id, boolean highlight) {
        int x = this.zeroX + id * this.SEPARATION;
        int y = this.zeroY;
        y += 30;
        if (highlight) {
            g.setBackground(new Color(null, 255, 0, 0));
        } else {
            g.setBackground(new Color(null, 0, 255, 255));
        }
        if (id >= 0 && this.accepting.get(id)) {
            g.fillArc(x - 3, y - 3, 36, 36, 0, 360);
        } else {
            g.fillArc(x, y, 30, 30, 0, 360);
        }
        g.setForeground(new Color(null, 0, 0, 0));
        g.setFont(this.stateFont);
        if (id >= 0 && this.accepting.get(id)) {
            g.drawArc(x - 3, y - 3, 36, 36, 0, 360);
        }
        g.drawArc(x, y, 30, 30, 0, 360);
        FontMetrics fm = g.getFontMetrics();
        String sid = id == this.mach.endseq ? "E" : "" + id;
        int px = x + 15 - fm.getAverageCharWidth() * sid.length() / 2;
        int py = y + 6;
        g.drawString(sid, px, py);
    }
}

