/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import synthesis.ConditionEvent;
import synthesis.Event;
import synthesis.InputEvent;
import synthesis.MessageEvent;
import synthesis.MyOutput;
import synthesis.OutputEvent;
import synthesis.StringSet;

public class Instance {
    private LinkedList list = new LinkedList();

    public void appendEvent(Event E) {
        this.list.add(E);
    }

    public void addEvent(Event E) {
        this.insertEvent(E, 0);
    }

    public ListIterator iterator() {
        return this.list.listIterator(0);
    }

    public int size() {
        return this.list.size();
    }

    public Event get(int i) {
        return (Event)this.list.get(i);
    }

    public void append(Instance I) {
        ListIterator J = I.iterator();
        while (J.hasNext()) {
            this.appendEvent((Event)J.next());
        }
    }

    public void appendAndMap(Instance I, Map Sigma) {
        ListIterator J = I.iterator();
        while (J.hasNext()) {
            MessageEvent f;
            Event e = (Event)J.next();
            Event NewEvent = null;
            if (e instanceof ConditionEvent) {
                NewEvent = new ConditionEvent(e.getLabel());
            } else if (e instanceof OutputEvent) {
                f = new OutputEvent(e.getLabel());
                ((OutputEvent)f).setTo(new String(((OutputEvent)e).getTo()));
                NewEvent = f;
            } else {
                f = new InputEvent(e.getLabel());
                ((InputEvent)f).setFrom(new String(((InputEvent)e).getFrom()));
                NewEvent = f;
            }
            this.appendEvent(NewEvent);
            Sigma.put(NewEvent, e);
        }
    }

    public int getFirstMessageEvent() {
        boolean found = false;
        int i = 0;
        while (i < this.size() && !found) {
            Event e = this.get(i);
            found = !(e instanceof ConditionEvent);
            ++i;
        }
        if (found) {
            return i - 1;
        }
        return -1;
    }

    public void removeConditions() {
        int i = 0;
        while (i < this.list.size()) {
            Event e = (Event)this.list.get(i);
            if (e instanceof ConditionEvent) {
                this.list.remove(i);
                --i;
            }
            ++i;
        }
    }

    public boolean containsConditions() {
        boolean Contains = false;
        int i = 0;
        while (i < this.list.size() && !Contains) {
            Event e = (Event)this.list.get(i);
            Contains = e instanceof ConditionEvent;
            ++i;
        }
        return Contains;
    }

    public void deleteCondition(String name) {
        int i = 0;
        while (i < this.list.size()) {
            Event e = (Event)this.list.get(i);
            if (e instanceof ConditionEvent && e.getLabel().equals(name)) {
                this.list.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void addToAlphabet(StringSet L) {
        int i = 0;
        while (i < this.list.size()) {
            Event e = (Event)this.list.get(i);
            if (!(e instanceof ConditionEvent)) {
                L.add(e.getLabel());
            }
            ++i;
        }
    }

    public void insertEvent(Event E, int pos) {
        this.list.add(pos, E);
    }

    public void removeEvent(int pos) {
        this.list.remove(pos);
    }

    public void print(MyOutput Out) {
        ListIterator I = this.iterator();
        while (I.hasNext()) {
            Event e = (Event)I.next();
            if (e == null) {
                Out.println("////IS NULL");
                continue;
            }
            if (e instanceof ConditionEvent) {
                Out.println("   local " + e.getLabel() + ";");
                continue;
            }
            if (e instanceof OutputEvent) {
                Out.println("   out " + e.getLabel() + " to " + ((OutputEvent)e).getTo() + ";");
                continue;
            }
            Out.println("   in " + e.getLabel() + " from " + ((InputEvent)e).getFrom() + ";");
        }
    }

    public void print(LTSOutput Out) {
        ListIterator I = this.iterator();
        while (I.hasNext()) {
            Event e = (Event)I.next();
            if (e == null) {
                Out.outln("////IS NULL");
                continue;
            }
            if (e instanceof ConditionEvent) {
                Out.outln("   local " + e.getLabel() + ";");
                continue;
            }
            if (e instanceof OutputEvent) {
                Out.outln("   out " + e.getLabel() + " to " + ((OutputEvent)e).getTo() + ";");
                continue;
            }
            Out.outln("   in " + e.getLabel() + " from " + ((InputEvent)e).getFrom() + ";");
        }
    }

    public Object clone() {
        Instance Inst = new Instance();
        ListIterator I = this.iterator();
        while (I.hasNext()) {
            MessageEvent f;
            Event e = (Event)I.next();
            if (e instanceof ConditionEvent) {
                ConditionEvent ne = new ConditionEvent(e.getLabel());
                ne.Id = e.Id;
                Inst.appendEvent(ne);
                continue;
            }
            if (e instanceof OutputEvent) {
                f = new OutputEvent(e.getLabel());
                ((OutputEvent)f).setTo(new String(((OutputEvent)e).getTo()));
                ((OutputEvent)f).Id = e.Id;
                Inst.appendEvent(f);
                continue;
            }
            f = new InputEvent(e.getLabel());
            ((InputEvent)f).setFrom(new String(((InputEvent)e).getFrom()));
            ((InputEvent)f).Id = e.Id;
            Inst.appendEvent(f);
        }
        return Inst;
    }

    public boolean isPrefixOf(Instance Inst) {
        Event e1 = null;
        Event e2 = null;
        ListIterator I = this.iterator();
        ListIterator J = Inst.iterator();
        boolean isPrefix = true;
        while (isPrefix && I.hasNext()) {
            e1 = (Event)I.next();
            if (e1 instanceof ConditionEvent) continue;
            boolean found = false;
            while (!found && J.hasNext()) {
                e2 = (Event)J.next();
                if (e2 instanceof ConditionEvent) continue;
                found = true;
            }
            isPrefix = found ? e2.getLabel().equals(e1.getLabel()) : false;
        }
        return isPrefix;
    }

    public boolean isEmpty() {
        ListIterator I = this.iterator();
        boolean found = false;
        while (!found && I.hasNext()) {
            Event e1 = (Event)I.next();
            boolean bl = found = !(e1 instanceof ConditionEvent);
        }
        return !found;
    }

    public void deleteLast(int n) {
        while (this.size() > 0 && n > 0) {
            this.list.remove(this.size() - 1);
            --n;
        }
    }

    public int getIdOfLast() {
        return ((Event)this.list.get((int)(this.size() - 1))).Id;
    }

    public boolean isTheSameAs(Instance I, LTSOutput o) {
        boolean equals = true;
        boolean dbg = false;
        if (dbg) {
            o.outln("Comparing instance: " + I.size() + ", " + this.size());
        }
        if (I.size() != this.size()) {
            return false;
        }
        if (dbg) {
            o.outln("SameSize");
        }
        ListIterator A = this.iterator();
        ListIterator B = I.iterator();
        while (A.hasNext() && B.hasNext() && equals) {
            Event a = (Event)A.next();
            Event b = (Event)B.next();
            if (dbg) {
                o.outln("Checking evets " + a.getLabel() + " and " + b.getLabel());
            }
            boolean bl = equals = a instanceof ConditionEvent && b instanceof ConditionEvent || a instanceof InputEvent && b instanceof InputEvent || a instanceof OutputEvent && b instanceof OutputEvent;
            if (!equals) continue;
            equals = a.getLabel().equals(b.getLabel());
        }
        return equals;
    }

    public boolean outputs(String lbl) {
        boolean found = false;
        int i = 0;
        while (i < this.size() && !found) {
            Event e = this.get(i);
            if (e instanceof OutputEvent) {
                found = e.getLabel().equals(lbl);
            }
            ++i;
        }
        return found;
    }

    public boolean inputs(String lbl) {
        boolean found = false;
        int i = 0;
        while (i < this.size() && !found) {
            Event e = this.get(i);
            if (e instanceof InputEvent) {
                found = e.getLabel().equals(lbl);
            }
            ++i;
        }
        return found;
    }

    public StringSet getAlphabet() {
        StringSet S = new StringSet();
        int i = 0;
        while (i < this.size()) {
            Event e = this.get(i);
            S.add(e.getLabel());
            ++i;
        }
        return S;
    }
}

