/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.Vector;
import synthesis.StringSet;

public class Trace {
    private Vector Events = new Vector();
    private int size = 0;

    public void add(String lbl) {
        this.Events.add(this.size, lbl);
        ++this.size;
    }

    public boolean equals(Object o) {
        if (o instanceof Trace) {
            Trace t = (Trace)o;
            boolean equals = t.size() == this.size();
            int i = 0;
            while (i < this.size && equals) {
                equals = t.get(i).equals(this.get(i));
                ++i;
            }
            return equals;
        }
        return false;
    }

    public String getString() {
        String S = "";
        int i = 0;
        while (i < this.size) {
            S = String.valueOf(S) + this.get(i);
            ++i;
        }
        return S;
    }

    public void print(LTSOutput o) {
        int i = 0;
        while (i < this.size) {
            o.out(this.get(i));
            if (i < this.size - 1) {
                o.out(",");
            }
            ++i;
        }
        o.outln(".");
    }

    public String get(int c) {
        return (String)this.Events.get(c);
    }

    public int size() {
        return this.size;
    }

    public Trace subtrace(int from, int to) {
        Trace t = new Trace();
        int i = from;
        while (i <= to) {
            t.add(this.get(i));
            ++i;
        }
        return t;
    }

    public Trace subtrace(int from) {
        return this.subtrace(from, this.size() - 1);
    }

    public Trace myClone() {
        Trace t = new Trace();
        t.Events = (Vector)this.Events.clone();
        t.size = this.size();
        return t;
    }

    public boolean isPrefixOf(Trace t) {
        if (this.size() > t.size()) {
            return false;
        }
        return t.subtrace(0, this.size() - 1).equals(this);
    }

    public Trace project(StringSet S) {
        Trace projection = new Trace();
        int i = 0;
        while (i < this.size) {
            if (S.contains(this.get(i))) {
                projection.add(this.get(i));
            }
            ++i;
        }
        return projection;
    }
}

