/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import gov.nasa.arc.ase.util.graph.EmptyVisitor;
import gov.nasa.arc.ase.util.graph.Generate;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.Label;
import gov.nasa.arc.ase.util.graph.Node;
import gov.nasa.arc.ase.util.graph.SynchronousProduct;
import java.io.IOException;

public class Degeneralize {
    public static void help() {
        System.err.println("usage:");
        System.err.println("\tDegenalize [outfile]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            System.out.println("usage:");
            System.out.println("\tjava gov.nasa.arc.ase.util.graph.Degeneralize [<filename>]");
            return;
        }
        Graph graph = null;
        try {
            graph = stringArray.length == 0 ? Graph.load() : Graph.load(stringArray[0]);
        }
        catch (IOException iOException) {
            System.out.println("Can't load the graph.");
            return;
        }
        graph = Degeneralize.degeneralize(graph);
        graph.save();
    }

    private static void accept(Graph graph) {
        graph.setBooleanAttribute("nsets", false);
        graph.forAllNodes(new EmptyVisitor(){

            public void visitNode(Node node) {
                if (node.getBooleanAttribute("acc0")) {
                    node.setBooleanAttribute("accepting", true);
                    node.setBooleanAttribute("acc0", false);
                }
            }
        });
    }

    public static Graph degeneralize(Graph graph) {
        int n = graph.getIntAttribute("nsets");
        String string = graph.getStringAttribute("type");
        if (string.equals("gba")) {
            String string2 = graph.getStringAttribute("ac");
            if (string2.equals("nodes")) {
                if (n == 1) {
                    Degeneralize.accept(graph);
                } else {
                    Label.label(graph);
                    Graph graph2 = Generate.generate(n);
                    graph = SynchronousProduct.product(graph, graph2);
                }
            } else if (string2.equals("edges")) {
                Graph graph3 = Generate.generate(n);
                graph = SynchronousProduct.product(graph, graph3);
            }
        } else if (!string.equals("ba")) {
            throw new RuntimeException("invalid graph type: " + string);
        }
        return graph;
    }
}

