/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import gov.nasa.arc.ase.util.graph.Attributes;
import gov.nasa.arc.ase.util.graph.Node;
import java.io.PrintStream;

public class Edge {
    private Node source;
    private Node next;
    private String guard;
    private String action;
    private Attributes attributes;

    public Edge(Node node, Node node2, String string, String string2, Attributes attributes) {
        this.init(node, node2, string, string2, attributes);
    }

    public Edge(Node node, Node node2, String string, String string2) {
        this.init(node, node2, string, string2, null);
    }

    public Edge(Node node, Node node2, String string) {
        this.init(node, node2, string, "-", null);
    }

    public Edge(Node node, Node node2) {
        this.init(node, node2, "-", "-", null);
    }

    public Edge(Node node, Edge edge) {
        this.init(node, edge.next, new String(edge.guard), new String(edge.action), new Attributes(edge.attributes));
    }

    public Edge(Edge edge, Node node) {
        this.init(edge.source, node, new String(edge.guard), new String(edge.action), new Attributes(edge.attributes));
    }

    public Edge(Edge edge) {
        this.init(edge.source, edge.next, new String(edge.guard), new String(edge.action), new Attributes(edge.attributes));
    }

    public Node getSource() {
        return this.source;
    }

    public Node getNext() {
        return this.next;
    }

    public String getGuard() {
        return this.guard;
    }

    public String getAction() {
        return this.action;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public int getIntAttribute(String string) {
        return this.attributes.getInt(string);
    }

    public String getStringAttribute(String string) {
        return this.attributes.getString(string);
    }

    public boolean getBooleanAttribute(String string) {
        return this.attributes.getBoolean(string);
    }

    public void setIntAttribute(String string, int n) {
        this.attributes.setInt(string, n);
    }

    public void setStringAttribute(String string, String string2) {
        this.attributes.setString(string, string2);
    }

    public void setBooleanAttribute(String string, boolean bl) {
        this.attributes.setBoolean(string, bl);
    }

    public synchronized void remove() {
        this.source.removeOutgoingEdge(this);
        this.next.removeIncomingEdge(this);
    }

    public synchronized void setAttributes(Attributes attributes) {
        this.attributes = new Attributes(attributes);
    }

    private void init(Node node, Node node2, String string, String string2, Attributes attributes) {
        this.source = node;
        this.next = node2;
        this.guard = string;
        this.action = string2;
        this.attributes = attributes == null ? new Attributes() : attributes;
        node.addOutgoingEdge(this);
        node2.addIncomingEdge(this);
    }

    void save(PrintStream printStream, int n) {
        switch (n) {
            case 0: {
                this.save_sm(printStream);
                break;
            }
            case 1: {
                this.save_fsp(printStream);
            }
        }
    }

    private void save_fsp(PrintStream printStream) {
        String string = "";
        String string2 = this.guard.equals("-") ? "TRUE" : this.guard;
        int n = this.source.getGraph().getIntAttribute("nsets");
        if (n == 0) {
            if (this.getBooleanAttribute("accepting")) {
                string = "@";
            }
        } else {
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                if (this.getBooleanAttribute("acc" + n2)) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(n2);
                }
                ++n2;
            }
            if (!bl) {
                string = "{" + stringBuffer.toString() + "}";
            }
        }
        printStream.print(string2 + string + "-> S" + this.next.getId());
    }

    private void save_sm(PrintStream printStream) {
        printStream.print("    ");
        printStream.println(this.next.getId());
        printStream.print("    ");
        printStream.println(this.guard);
        printStream.print("    ");
        printStream.println(this.action);
        printStream.print("    ");
        printStream.println(this.attributes);
    }
}

