/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import gov.nasa.arc.ase.util.graph.Attributes;
import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.Visitor;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Node {
    private Graph graph;
    private List outgoingEdges;
    private List incomingEdges;
    private Attributes attributes;

    public Node(Graph graph, Attributes attributes) {
        this.init(graph, attributes);
    }

    public Node(Graph graph) {
        this.init(graph, null);
    }

    public Node(Node node) {
        this.init(node.graph, new Attributes(node.attributes));
        Iterator iterator = node.outgoingEdges.iterator();
        while (iterator.hasNext()) {
            new Edge(this, (Edge)iterator.next());
        }
        Iterator iterator2 = node.incomingEdges.iterator();
        while (iterator2.hasNext()) {
            new Edge((Edge)iterator2.next(), this);
        }
    }

    public int getOutgoingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public int getIncomingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public List getOutgoingEdges() {
        return new LinkedList(this.outgoingEdges);
    }

    public List getIncomingEdges() {
        return new LinkedList(this.incomingEdges);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public int getIntAttribute(String string) {
        return this.attributes.getInt(string);
    }

    public String getStringAttribute(String string) {
        return this.attributes.getString(string);
    }

    public boolean getBooleanAttribute(String string) {
        return this.attributes.getBoolean(string);
    }

    public synchronized void setIntAttribute(String string, int n) {
        if (string.equals("_id")) {
            return;
        }
        this.attributes.setInt(string, n);
    }

    public synchronized void setStringAttribute(String string, String string2) {
        if (string.equals("_id")) {
            return;
        }
        this.attributes.setString(string, string2);
    }

    public synchronized void setBooleanAttribute(String string, boolean bl) {
        if (string.equals("_id")) {
            return;
        }
        this.attributes.setBoolean(string, bl);
    }

    synchronized void setId(int n) {
        this.attributes.setInt("_id", n);
    }

    public synchronized int getId() {
        return this.attributes.getInt("_id");
    }

    public synchronized void remove() {
        Iterator iterator = new LinkedList(this.outgoingEdges).iterator();
        while (iterator.hasNext()) {
            ((Edge)iterator.next()).remove();
        }
        Iterator iterator2 = new LinkedList(this.incomingEdges).iterator();
        while (iterator2.hasNext()) {
            ((Edge)iterator2.next()).remove();
        }
        this.graph.removeNode(this);
    }

    synchronized void removeOutgoingEdge(Edge edge) {
        this.outgoingEdges.remove(edge);
    }

    synchronized void removeIncomingEdge(Edge edge) {
        this.incomingEdges.remove(edge);
    }

    synchronized void addOutgoingEdge(Edge edge) {
        this.outgoingEdges.add(edge);
    }

    synchronized void addIncomingEdge(Edge edge) {
        this.incomingEdges.add(edge);
    }

    public synchronized void setAttributes(Attributes attributes) {
        int n = this.getId();
        this.attributes = new Attributes(attributes);
        this.setId(n);
    }

    private void init(Graph graph, Attributes attributes) {
        this.graph = graph;
        this.attributes = attributes == null ? new Attributes() : attributes;
        this.incomingEdges = new LinkedList();
        this.outgoingEdges = new LinkedList();
        this.graph.addNode(this);
    }

    void save(PrintStream printStream, int n) {
        switch (n) {
            case 0: {
                this.save_sm(printStream);
                break;
            }
            case 1: {
                this.save_fsp(printStream);
            }
        }
    }

    private void save_fsp(PrintStream printStream) {
        printStream.print("S" + this.getId() + "=(");
        Iterator iterator = this.outgoingEdges.iterator();
        while (iterator.hasNext()) {
            ((Edge)iterator.next()).save(printStream, 1);
            if (!iterator.hasNext()) continue;
            printStream.print(" |");
        }
        printStream.print(")");
    }

    private void save_sm(PrintStream printStream) {
        int n = this.getId();
        printStream.print("  ");
        printStream.println(this.outgoingEdges.size());
        this.attributes.unset("_id");
        printStream.print("  ");
        printStream.println(this.attributes);
        this.setId(n);
        Iterator iterator = this.outgoingEdges.iterator();
        while (iterator.hasNext()) {
            ((Edge)iterator.next()).save(printStream, 0);
        }
    }

    public synchronized void forAllEdges(Visitor visitor) {
        Iterator iterator = new LinkedList(this.outgoingEdges).iterator();
        while (iterator.hasNext()) {
            visitor.visitEdge((Edge)iterator.next());
        }
    }
}

