/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.EmptyVisitor;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.Node;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SCC {
    public static void help() {
        System.err.println("usage:");
        System.err.println("\tDegenalize [-join|-degeneralize] [outfile]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        String string = null;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (string == null) {
                string = stringArray[n];
            } else {
                SCC.help();
            }
            ++n;
        }
        try {
            Graph graph = Graph.load("out.sm");
            List list = SCC.scc(graph);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                List list2 = (List)iterator.next();
                System.out.println("component:");
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Node node = (Node)iterator2.next();
                    System.out.println("  " + node.getStringAttribute("label"));
                }
                System.out.println();
            }
            if (string == null) {
                graph.save();
            } else {
                graph.save(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public static List scc(Graph graph) {
        Node node = graph.getInit();
        if (node == null) {
            return new LinkedList();
        }
        node.setBooleanAttribute("_reached", true);
        SCCState sCCState = new SCCState();
        SCC.visit(node, sCCState);
        final List[] listArray = new List[sCCState.SCC];
        int n = 0;
        while (n < sCCState.SCC) {
            listArray[n] = new LinkedList();
            ++n;
        }
        graph.forAllNodes(new EmptyVisitor(){

            public void visitNode(Node node) {
                listArray[node.getIntAttribute("_scc")].add(node);
                node.setBooleanAttribute("_reached", false);
                node.setBooleanAttribute("_dfsnum", false);
                node.setBooleanAttribute("_low", false);
                node.setBooleanAttribute("_scc", false);
            }
        });
        LinkedList<List> linkedList = new LinkedList<List>();
        int n2 = 0;
        while (n2 < sCCState.SCC) {
            linkedList.add(listArray[n2]);
            ++n2;
        }
        return linkedList;
    }

    private static void visit(Node node, SCCState sCCState) {
        Object object;
        sCCState.L.add(0, node);
        node.setIntAttribute("_dfsnum", sCCState.N);
        node.setIntAttribute("_low", sCCState.N);
        ++sCCState.N;
        Iterator iterator = node.getOutgoingEdges().iterator();
        while (iterator.hasNext()) {
            object = (Edge)iterator.next();
            Node node2 = ((Edge)object).getNext();
            if (!node2.getBooleanAttribute("_reached")) {
                node2.setBooleanAttribute("_reached", true);
                SCC.visit(node2, sCCState);
                node.setIntAttribute("_low", Math.min(node.getIntAttribute("_low"), node2.getIntAttribute("_low")));
                continue;
            }
            if (node2.getIntAttribute("_dfsnum") >= node.getIntAttribute("_dfsnum") || !sCCState.L.contains(node2)) continue;
            node.setIntAttribute("_low", Math.min(node.getIntAttribute("_low"), node2.getIntAttribute("_dfsnum")));
        }
        if (node.getIntAttribute("_low") == node.getIntAttribute("_dfsnum")) {
            do {
                object = (Node)sCCState.L.remove(0);
                ((Node)object).setIntAttribute("_scc", sCCState.SCC);
            } while (object != node);
            ++sCCState.SCC;
        }
    }

    public static void print(List list) {
        System.out.println("Strongly connected components:");
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            System.out.println("\tSCC #" + n++);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Node node = (Node)iterator2.next();
                System.out.println("\t\t" + node.getId() + " - " + node.getStringAttribute("label"));
            }
        }
    }

    private static class SCCState {
        public int N = 0;
        public int SCC = 0;
        public List L = new LinkedList();

        private SCCState() {
        }
    }
}

