/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.EmptyVisitor;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.Node;
import java.io.IOException;

public class SM2Dot {
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("usage:");
            System.err.println("\tSM2Dot <filename>");
            System.err.println();
            System.exit(1);
        }
        try {
            Graph graph = Graph.load(stringArray[0]);
            SM2Dot.startDigraph(stringArray[0]);
            SM2Dot.printInit(graph.getInit());
            graph.forAllNodes(new EmptyVisitor(){

                public void visitNode(Node node) {
                    SM2Dot.printNode(node);
                    node.forAllEdges(new EmptyVisitor(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void visitEdge(Edge edge) {
                            SM2Dot.printEdge(edge);
                        }
                    });
                }
            });
            SM2Dot.endDigraph();
        }
        catch (IOException iOException) {
            System.err.println("Can't load file: " + stringArray[0]);
            System.exit(1);
        }
    }

    public static void startDigraph(String string) {
        if (string.lastIndexOf(47) != -1) {
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        string = string.replace('.', '_');
        string = string.replace('-', '_');
        System.out.println("digraph " + string + " {");
    }

    public static void endDigraph() {
        System.out.println("}");
    }

    public static void printInit(Node node) {
        System.out.println("\tinit [color=white, label=\"\"];");
        System.out.println("\tinit -> " + node.getId() + ";");
    }

    public static void printNode(Node node) {
        int n = node.getId();
        if (node.getBooleanAttribute("accepting")) {
            System.out.println("\t" + n + " [shape=doublecircle];");
        } else {
            System.out.println("\t" + n + " [shape=circle];");
        }
        String string = node.getStringAttribute("label");
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("\\n");
        }
        stringBuffer.append(n + "\\n");
        int n2 = node.getGraph().getIntAttribute("nsets");
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            if (node.getBooleanAttribute("acc" + n3)) {
                if (bl) {
                    stringBuffer.append("{");
                    bl = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(n3);
            }
            ++n3;
        }
        if (!bl) {
            stringBuffer.append("}");
        }
        System.out.println("\t" + n + " [label=\"" + stringBuffer.toString() + "\"];");
    }

    public static void printEdge(Edge edge) {
        int n = edge.getSource().getId();
        int n2 = edge.getNext().getId();
        String string = edge.getGuard();
        String string2 = edge.getAction();
        String string3 = edge.getStringAttribute("label");
        StringBuffer stringBuffer = new StringBuffer();
        if (string3 != null) {
            stringBuffer.append(string3);
            stringBuffer.append("\\n");
        }
        if (!string.equals("-")) {
            if (!string2.equals("-")) {
                stringBuffer.append(string + "/" + string2 + "\\n");
            } else {
                stringBuffer.append(string + "\\n");
            }
        } else if (!string2.equals("-")) {
            stringBuffer.append(string + "/" + string2 + "\\n");
        } else {
            stringBuffer.append("true\\n");
        }
        int n3 = edge.getSource().getGraph().getIntAttribute("nsets");
        boolean bl = true;
        int n4 = 0;
        while (n4 < n3) {
            if (edge.getBooleanAttribute("acc" + n4)) {
                if (bl) {
                    stringBuffer.append("{");
                    bl = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(n4);
            }
            ++n4;
        }
        if (!bl) {
            stringBuffer.append("}");
        }
        System.out.println("\t" + n + " -> " + n2 + " [label=\"" + stringBuffer.toString() + "\"]");
    }
}

