/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.Node;
import gov.nasa.arc.ase.util.graph.SCC;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;

public class SCCReduction {
    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            System.out.println("usage:");
            System.out.println("\tjava gov.nasa.arc.ase.util.graph.SCCReduction [<filename>]");
            return;
        }
        Graph graph = null;
        try {
            graph = stringArray.length == 0 ? Graph.load() : Graph.load(stringArray[0]);
        }
        catch (IOException iOException) {
            System.out.println("Can't load the graph.");
            return;
        }
        graph = SCCReduction.reduce(graph);
        graph.save();
    }

    private static boolean isAccepting(List list, Graph graph) {
        String string = graph.getStringAttribute("type");
        String string2 = graph.getStringAttribute("ac");
        if (string.equals("ba")) {
            if (string2.equals("nodes")) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!((Node)iterator.next()).getBooleanAttribute("accepting")) continue;
                    return true;
                }
                return false;
            }
            if (string2.equals("edges")) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    Iterator iterator2 = node.getOutgoingEdges().iterator();
                    while (iterator2.hasNext()) {
                        Edge edge = (Edge)iterator2.next();
                        if (!edge.getBooleanAttribute("accepting")) continue;
                        return true;
                    }
                }
                return false;
            }
            throw new RuntimeException("invalid accepting type: " + string2);
        }
        if (string.equals("gba")) {
            int n = graph.getIntAttribute("nsets");
            BitSet bitSet = new BitSet(n);
            int n2 = 0;
            if (string2.equals("nodes")) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    int n3 = 0;
                    while (n3 < n) {
                        if (node.getBooleanAttribute("acc" + n3) && !bitSet.get(n3)) {
                            bitSet.set(n3);
                            ++n2;
                        }
                        ++n3;
                    }
                }
            } else if (string2.equals("edges")) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    Iterator iterator3 = node.getOutgoingEdges().iterator();
                    while (iterator3.hasNext()) {
                        Edge edge = (Edge)iterator3.next();
                        int n4 = 0;
                        while (n4 < n) {
                            if (edge.getBooleanAttribute("acc" + n4) && !bitSet.get(n4)) {
                                bitSet.set(n4);
                                ++n2;
                            }
                            ++n4;
                        }
                    }
                }
            } else {
                throw new RuntimeException("invalid accepting type: " + string2);
            }
            return n2 == n;
        }
        throw new RuntimeException("invalid graph type: " + string);
    }

    private static boolean isTransient(List list) {
        if (list.size() != 1) {
            return false;
        }
        Node node = (Node)list.get(0);
        Iterator iterator = node.getOutgoingEdges().iterator();
        while (iterator.hasNext()) {
            if (((Edge)iterator.next()).getNext() != node) continue;
            return false;
        }
        return true;
    }

    private static boolean isTerminal(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getOutgoingEdges().iterator();
            while (iterator2.hasNext()) {
                if (list.contains(((Edge)iterator2.next()).getNext())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void clearAccepting(List list, Graph graph) {
        String string = graph.getStringAttribute("type");
        String string2 = graph.getStringAttribute("ac");
        if (string.equals("ba")) {
            if (string2.equals("nodes")) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    node.setBooleanAttribute("accepting", false);
                }
                return;
            } else {
                if (!string2.equals("edges")) throw new RuntimeException("invalid accepting type: " + string2);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    Iterator iterator2 = node.getOutgoingEdges().iterator();
                    while (iterator2.hasNext()) {
                        Edge edge = (Edge)iterator2.next();
                        edge.setBooleanAttribute("accepting", false);
                    }
                }
            }
            return;
        } else {
            if (!string.equals("gba")) throw new RuntimeException("invalid graph type: " + string);
            int n = graph.getIntAttribute("nsets");
            if (string2.equals("nodes")) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    int n2 = 0;
                    while (n2 < n) {
                        node.setBooleanAttribute("acc" + n2, false);
                        ++n2;
                    }
                }
                return;
            } else {
                if (!string2.equals("edges")) throw new RuntimeException("invalid accepting type: " + string2);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    Iterator iterator3 = node.getOutgoingEdges().iterator();
                    while (iterator3.hasNext()) {
                        Edge edge = (Edge)iterator3.next();
                        int n3 = 0;
                        while (n3 < n) {
                            edge.setBooleanAttribute("acc" + n3, false);
                            ++n3;
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void clearExternalEdges(List list, Graph graph) {
        String string = graph.getStringAttribute("type");
        String string2 = graph.getStringAttribute("ac");
        if (string.equals("ba")) {
            if (string2.equals("nodes")) return;
            if (!string2.equals("edges")) throw new RuntimeException("invalid accepting type: " + string2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                Iterator iterator2 = node.getOutgoingEdges().iterator();
                while (iterator2.hasNext()) {
                    Edge edge = (Edge)iterator2.next();
                    if (list.contains(edge.getNext())) continue;
                    edge.setBooleanAttribute("accepting", false);
                }
            }
            return;
        } else {
            if (!string.equals("gba")) throw new RuntimeException("invalid graph type: " + string);
            int n = graph.getIntAttribute("nsets");
            if (string2.equals("nodes")) return;
            if (!string2.equals("edges")) throw new RuntimeException("invalid accepting type: " + string2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                Iterator iterator3 = node.getOutgoingEdges().iterator();
                while (iterator3.hasNext()) {
                    Edge edge = (Edge)iterator3.next();
                    if (list.contains(edge.getNext())) continue;
                    int n2 = 0;
                    while (n2 < n) {
                        edge.setBooleanAttribute("acc" + n2, false);
                        ++n2;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean anyAcceptingState(List list, Graph graph) {
        String string = graph.getStringAttribute("type");
        String string2 = graph.getStringAttribute("ac");
        if (string.equals("ba")) {
            if (string2.equals("nodes")) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    if (!node.getBooleanAttribute("accepting")) continue;
                    return true;
                }
                return false;
            } else {
                if (!string2.equals("edges")) throw new RuntimeException("invalid accepting type: " + string2);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    Iterator iterator2 = node.getOutgoingEdges().iterator();
                    while (iterator2.hasNext()) {
                        Edge edge = (Edge)iterator2.next();
                        if (!edge.getBooleanAttribute("accepting")) continue;
                        return true;
                    }
                }
            }
            return false;
        } else {
            if (!string.equals("gba")) throw new RuntimeException("invalid graph type: " + string);
            int n = graph.getIntAttribute("nsets");
            if (string2.equals("nodes")) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    int n2 = 0;
                    while (n2 < n) {
                        if (node.getBooleanAttribute("acc" + n2)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            } else {
                if (!string2.equals("edges")) throw new RuntimeException("invalid accepting type: " + string2);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    Iterator iterator3 = node.getOutgoingEdges().iterator();
                    while (iterator3.hasNext()) {
                        Edge edge = (Edge)iterator3.next();
                        int n3 = 0;
                        while (n3 < n) {
                            if (edge.getBooleanAttribute("acc" + iterator3)) {
                                return true;
                            }
                            ++n3;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static Graph reduce(Graph graph) {
        boolean bl;
        String string = graph.getStringAttribute("type");
        String string2 = graph.getStringAttribute("ac");
        boolean bl2 = string2.equals("nodes");
        Iterator iterator = SCC.scc(graph).iterator();
        while (iterator.hasNext()) {
            SCCReduction.clearExternalEdges((List)iterator.next(), graph);
        }
        do {
            bl = false;
            List list = SCC.scc(graph);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                List list2 = (List)iterator2.next();
                boolean bl3 = SCCReduction.isAccepting(list2, graph);
                if (!bl3 && SCCReduction.isTerminal(list2)) {
                    bl = true;
                    Iterator iterator3 = list2.iterator();
                    while (iterator3.hasNext()) {
                        ((Node)iterator3.next()).remove();
                    }
                    continue;
                }
                if (!SCCReduction.isTransient(list2) && bl3) continue;
                bl |= SCCReduction.anyAcceptingState(list2, graph);
                SCCReduction.clearAccepting(list2, graph);
            }
        } while (bl);
        return graph;
    }
}

