/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.Node;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class SynchronousProduct {
    public static Graph product(Graph graph, Graph graph2) {
        int n = graph.getIntAttribute("nsets");
        if (n != graph2.getIntAttribute("nsets")) {
            System.err.println("Different number of accepting sets");
            System.exit(1);
        }
        Graph graph3 = new Graph();
        graph3.setStringAttribute("type", "ba");
        graph3.setStringAttribute("ac", "nodes");
        Node[][] nodeArray = new Node[graph.getNodeCount()][graph2.getNodeCount()];
        SynchronousProduct.dfs(graph3, nodeArray, n, graph.getInit(), graph2.getInit());
        return graph3;
    }

    public static void main(String[] stringArray) {
        Graph graph;
        Graph graph2;
        try {
            graph2 = Graph.load(stringArray[0]);
            graph = Graph.load(stringArray[1]);
        }
        catch (IOException iOException) {
            System.err.println("Can't load automata");
            System.exit(1);
            return;
        }
        Graph graph3 = SynchronousProduct.product(graph2, graph);
        graph3.save();
    }

    public static void dfs(Graph graph, Node[][] nodeArray, int n, Node node, Node node2) {
        Node node3 = SynchronousProduct.get(graph, nodeArray, node, node2);
        List list = node.getOutgoingEdges();
        List list2 = node2.getOutgoingEdges();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2;
            Object object;
            Edge edge = (Edge)iterator.next();
            Node node4 = edge.getNext();
            Object object2 = null;
            boolean bl = false;
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext() && !bl) {
                object = (Edge)iterator2.next();
                if (((Edge)object).getBooleanAttribute("else")) {
                    if (object2 == null) {
                        object2 = object;
                    }
                } else {
                    bl = true;
                    n2 = 0;
                    while (n2 < n) {
                        boolean bl2 = edge.getBooleanAttribute("acc" + n2);
                        boolean bl3 = ((Edge)object).getBooleanAttribute("acc" + n2);
                        if (bl3 && !bl2) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!bl) continue;
                object2 = object;
            }
            if (object2 == null) continue;
            object = ((Edge)object2).getNext();
            n2 = SynchronousProduct.isNew(nodeArray, node4, (Node)object);
            Node node5 = SynchronousProduct.get(graph, nodeArray, node4, (Node)object);
            Edge edge2 = new Edge(node3, node5, edge.getGuard(), ((Edge)object2).getAction(), null);
            if (n2 == 0) continue;
            SynchronousProduct.dfs(graph, nodeArray, n, node4, (Node)object);
        }
    }

    private static boolean isNew(Node[][] nodeArray, Node node, Node node2) {
        return nodeArray[node.getId()][node2.getId()] == null;
    }

    private static Node get(Graph graph, Node[][] nodeArray, Node node, Node node2) {
        if (nodeArray[node.getId()][node2.getId()] == null) {
            Node node3 = new Node(graph);
            String string = node.getStringAttribute("label");
            String string2 = node2.getStringAttribute("label");
            if (string == null) {
                string = Integer.toString(node.getId());
            }
            if (string2 == null) {
                string2 = Integer.toString(node2.getId());
            }
            node3.setStringAttribute("label", string + "+" + string2);
            if (node2.getBooleanAttribute("accepting")) {
                node3.setBooleanAttribute("accepting", true);
            }
            Node node4 = node3;
            nodeArray[node.getId()][node2.getId()] = node4;
            return node4;
        }
        return nodeArray[node.getId()][node2.getId()];
    }
}

