/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.EventClient;
import ic.doc.ltsa.lts.EventManager;
import ic.doc.ltsa.lts.LTSEvent;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.PrintTransitions;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PrintWindow
extends JSplitPane
implements LTSOutput,
EventClient {
    public static boolean fontFlag = false;
    JTextArea output;
    JList list;
    JScrollPane left;
    JScrollPane right;
    EventManager eman;
    int Nmach;
    int selectedMachine = 0;
    CompactState[] sm;
    Font f1 = new Font("Monospaced", 0, 12);
    Font f2 = new Font("Monospaced", 1, 18);
    Font f3 = new Font("SansSerif", 0, 12);
    Font f4 = new Font("SansSerif", 1, 18);
    PrintWindow thisWindow;
    private static final int MAXPRINT = 400;

    public PrintWindow(CompositeState cs, EventManager eman) {
        this.eman = eman;
        this.thisWindow = this;
        this.output = new JTextArea(23, 50);
        this.output.setEditable(false);
        this.right = new JScrollPane(this.output, 20, 30);
        this.output.setBackground(Color.white);
        this.output.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new PrintAction());
        this.left = new JScrollPane(this.list, 20, 30);
        if (eman != null) {
            eman.addClient(this);
        }
        this.new_machines(cs);
        this.setLeftComponent(this.left);
        this.setRightComponent(this.right);
        this.setDividerLocation(200);
        this.setBigFont(fontFlag);
        this.validate();
    }

    public void ltsAction(LTSEvent e) {
        switch (e.kind) {
            case 0: {
                break;
            }
            case 1: {
                this.new_machines((CompositeState)e.info);
                break;
            }
        }
    }

    public void out(String str) {
        this.output.append(str);
    }

    public void outln(String str) {
        this.output.append(String.valueOf(str) + "\n");
    }

    public void clearOutput() {
        this.output.setText("");
    }

    private void new_machines(CompositeState cs) {
        int i;
        int hasC;
        int n = hasC = cs != null && cs.composition != null ? 1 : 0;
        if (cs != null && cs.machines != null && cs.machines.size() > 0) {
            this.sm = new CompactState[cs.machines.size() + hasC];
            Enumeration e = cs.machines.elements();
            i = 0;
            while (e.hasMoreElements()) {
                this.sm[i] = (CompactState)e.nextElement();
                ++i;
            }
            this.Nmach = this.sm.length;
            if (hasC == 1) {
                this.sm[this.Nmach - 1] = cs.composition;
            }
        } else {
            this.Nmach = 0;
        }
        DefaultListModel<String> lm = new DefaultListModel<String>();
        i = 0;
        while (i < this.Nmach) {
            if (hasC == 1 && i == this.Nmach - 1) {
                lm.addElement("||" + this.sm[i].name);
            } else {
                lm.addElement(this.sm[i].name);
            }
            ++i;
        }
        this.list.setModel(lm);
        if (this.selectedMachine >= this.Nmach) {
            this.selectedMachine = 0;
        }
        this.clearOutput();
    }

    public void setBigFont(boolean b) {
        fontFlag = b;
        if (fontFlag) {
            this.output.setFont(this.f2);
            this.list.setFont(this.f4);
        } else {
            this.output.setFont(this.f1);
            this.list.setFont(this.f3);
        }
    }

    public void removeClient() {
        if (this.eman != null) {
            this.eman.removeClient(this);
        }
    }

    public void copy() {
        this.output.copy();
    }

    public void saveFile(String currentDirectory, String extension) {
        String message = extension.equals(".txt") ? "Save text in:" : "Save as Aldebaran format (.aut) in:";
        FileDialog fd = new FileDialog((Frame)this.getTopLevelAncestor(), message, 1);
        if (this.Nmach > 0) {
            String fname = this.sm[this.selectedMachine].name;
            int colon = fname.indexOf(58, 0);
            if (colon > 0) {
                fname = fname.substring(0, colon);
            }
            fd.setFile(String.valueOf(fname) + extension);
            fd.setDirectory(currentDirectory);
        }
        fd.show();
        String sn = fd.getFile();
        if (sn != null) {
            try {
                int i = sn.indexOf(46, 0);
                sn = String.valueOf(sn.substring(0, i)) + extension;
                File file = new File(fd.getDirectory(), sn);
                FileOutputStream fout = new FileOutputStream(file);
                PrintStream myOutput = new PrintStream(fout);
                if (extension.equals(".txt")) {
                    String text = this.output.getText();
                    myOutput.print(text);
                } else if (this.Nmach > 0) {
                    this.sm[this.selectedMachine].printAUT(myOutput);
                }
                myOutput.close();
                fout.close();
            }
            catch (IOException e) {
                this.outln("Error saving file: " + e);
            }
        }
    }

    public void saveAsPrism(String currentDirectory, String extension) {
    }

    class PrintAction
    implements ListSelectionListener {
        PrintAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int machine = PrintWindow.this.list.getSelectedIndex();
            if (machine < 0 || machine >= PrintWindow.this.Nmach) {
                return;
            }
            PrintWindow.this.selectedMachine = machine;
            PrintWindow.this.clearOutput();
            PrintTransitions p = new PrintTransitions(PrintWindow.this.sm[PrintWindow.this.selectedMachine]);
            p.print(PrintWindow.this.thisWindow, 400);
        }
    }
}

