/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.custom;

import ic.doc.extension.Animator;
import ic.doc.ltsa.custom.AnimationAction;
import ic.doc.ltsa.custom.AnimationMessage;
import ic.doc.ltsa.custom.ControlActionRegistry;
import ic.doc.ltsa.custom.OutputActionRegistry;
import ic.doc.ltsa.custom.Relation;
import java.util.BitSet;
import uk.ac.ic.doc.scenebeans.event.AnimationEvent;
import uk.ac.ic.doc.scenebeans.event.AnimationListener;

public class SceneAnimationController
implements Runnable,
AnimationMessage,
AnimationListener {
    Animator animator;
    OutputActionRegistry actions;
    ControlActionRegistry controls;
    String[] controlNames;
    volatile BitSet eligible;
    volatile boolean[] signalled;
    Thread ticker;
    boolean debug = false;
    boolean trace = false;
    boolean replayMode = false;
    Object canvas;
    public static int LIMIT = 300;

    public SceneAnimationController(Animator a, Relation actionMap, Relation controlMap, boolean replay, Object lock) {
        this.animator = a;
        this.replayMode = replay;
        this.canvas = lock;
        this.actions = new OutputActionRegistry(actionMap, this);
        this.controls = new ControlActionRegistry(controlMap, this);
    }

    public void setTrace(boolean b) {
        this.trace = b;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public void registerAction(String name, AnimationAction action) {
        this.actions.register(name, action);
    }

    public void start() {
        this.eligible = this.animator.initialise(this.controls.getControls());
        this.trace = this.replayMode;
        this.controlNames = this.animator.getMenuNames();
        this.signalled = new boolean[this.controlNames.length];
        int i = 0;
        while (i < this.signalled.length) {
            this.signalled[i] = true;
            ++i;
        }
        this.controls.initMap(this.controlNames);
    }

    public void stop() {
        if (this.ticker != null) {
            this.ticker.interrupt();
        }
    }

    public void restart() {
        if (this.ticker == null) {
            this.ticker = new Thread(this);
            this.ticker.start();
        }
    }

    void doReplay() throws InterruptedException {
        while (this.animator.traceChoice()) {
            this.eligible = this.animator.traceStep();
            String todo = this.animator.actionNameChosen();
            int c = this.controls.controlled(todo);
            if (c > 0) {
                while (!this.signalled[c]) {
                    this.canvas.wait();
                }
            }
            this.actions.doAction(this.animator.actionNameChosen());
            if (!this.animator.isError()) continue;
            this.animator.message("Animation - ERROR state reached");
            return;
        }
        this.animator.message("Animation - end of Replay");
    }

    void doActions() throws InterruptedException {
        try {
            while (true) {
                this.doNonControlActions();
                if (this.empty(this.eligible)) {
                    this.animator.message("Animation - STOP state reached");
                    return;
                }
                int choice = -1;
                while ((choice = this.getValidControl()) < 0) {
                    this.canvas.wait();
                }
                this.doMenuStep(choice);
            }
        }
        catch (AnimationException a) {
            this.animator.message("Animation - ERROR state reached " + a);
            return;
        }
    }

    int getValidControl() {
        int i = 0;
        while (i < this.signalled.length) {
            if (this.signalled[i] && this.eligible.get(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void doMenuStep(int choice) throws AnimationException {
        this.eligible = this.animator.menuStep(choice);
        this.actions.doAction(this.animator.actionNameChosen());
        if (this.animator.isError()) {
            throw new AnimationException();
        }
    }

    void doNonControlActions() throws AnimationException {
        int count = 0;
        while (this.animator.nonMenuChoice()) {
            this.eligible = this.animator.singleStep();
            this.actions.doAction(this.animator.actionNameChosen());
            if (this.animator.isError()) {
                throw new AnimationException();
            }
            if (++count <= LIMIT) continue;
            throw new AnimationException("immediate action LIMIT exceeded");
        }
    }

    private boolean empty(BitSet b) {
        int i = 0;
        while (i < b.size()) {
            if (b.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void traceMsg(String msg) {
        if (this.trace) {
            this.animator.message(msg);
        }
    }

    public void debugMsg(String msg) {
        if (this.debug) {
            this.animator.message(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalControl(String name) {
        Object object = this.canvas;
        synchronized (object) {
            if (name.charAt(0) != '~') {
                this.controls.mapControl(name, this.signalled, true);
                this.canvas.notifyAll();
            } else {
                this.controls.mapControl(name.substring(1), this.signalled, false);
            }
        }
    }

    public void clearControl(String name) {
        this.controls.mapControl(name, this.signalled, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object = this.canvas;
            synchronized (object) {
                if (!this.replayMode) {
                    this.doActions();
                } else {
                    this.doReplay();
                }
            }
        }
        catch (InterruptedException interruptedException) {}
        this.ticker = null;
    }

    public void animationEvent(AnimationEvent ev) {
        this.signalControl(ev.getName());
    }

    public class AnimationException
    extends Exception {
        public AnimationException() {
        }

        public AnimationException(String msg) {
            super(msg);
        }
    }
}

