/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.dclap;

import ic.doc.ltsa.dclap.QD;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;

public class Gr2PICT
extends Graphics {
    public static final int CLONE = 49;
    protected static final int PAGEHEIGHT = 792;
    protected static final int PAGEWIDTH = 612;
    protected DataOutputStream os;
    protected Color clr = Color.black;
    protected Font font = new Font("Serif", 0, 12);
    protected Rectangle clipr = new Rectangle(-30000, -30000, 60000, 60000);
    protected Point origin = new Point(0, 0);
    protected boolean trouble = false;
    protected Graphics g;
    private int fAlign = 0;

    public Gr2PICT(OutputStream o, Graphics g, Rectangle r) {
        this.os = new DataOutputStream(o);
        this.trouble = false;
        this.g = g;
        this.emitHeader(r.width, r.height);
    }

    public Gr2PICT(OutputStream o, Graphics g, int what) {
        this.os = new DataOutputStream(o);
        this.trouble = false;
        this.g = g;
        Rectangle r = g.getClipBounds();
        if (r == null) {
            r = new Rectangle(0, 0, 612, 792);
        }
        if (what != 49) {
            this.emitHeader(r.width, r.height);
        }
    }

    protected void emitbyte(int v) {
        try {
            this.os.writeByte(v);
            ++this.fAlign;
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    protected void emitword(int v) {
        try {
            this.os.writeShort(v);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    protected void emitint(int v) {
        try {
            this.os.writeInt(v);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    protected void emitstring(String s) {
        try {
            this.os.writeBytes(s);
            this.fAlign += s.length();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    protected final void emitop(int op) {
        if ((this.fAlign & 1) == 1) {
            this.emitbyte(0);
        }
        this.emitword(op);
    }

    protected final void emitcolor(Color c) {
        this.emitword(c.getRed() << 8);
        this.emitword(c.getGreen() << 8);
        this.emitword(c.getBlue() << 8);
    }

    protected final void emitrect(int x, int y, int width, int height) {
        this.emitword(y);
        this.emitword(x);
        this.emitword(y + height);
        this.emitword(x + width);
    }

    protected final void emitroundrect(int opcode, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.emitop(11);
        this.emitword(arcHeight);
        this.emitword(arcWidth);
        this.emitop(opcode);
        this.emitrect(x, y, width, height);
    }

    protected void emitpolygon(Polygon p) {
        int polysize = 10 + p.npoints * 4;
        this.emitword(polysize);
        Rectangle r = p.getBounds();
        this.emitrect(r.x, r.y, r.width, r.height);
        int i = 0;
        while (i < p.npoints) {
            this.emitword(p.ypoints[i]);
            this.emitword(p.xpoints[i]);
            ++i;
        }
    }

    protected void emitcomment(int kind, int datasize, String data) {
        if (datasize == 0) {
            this.emitop(160);
            this.emitword(kind);
        } else {
            this.emitop(161);
            this.emitword(kind);
            this.emitword(data.length());
            this.emitstring(data);
        }
    }

    public final void beginPicGroup() {
        this.emitcomment(140, 0, null);
    }

    public final void endPicGroup() {
        this.emitcomment(141, 0, null);
    }

    public void laserLine(int num, int denom) {
        this.emitop(161);
        this.emitword(182);
        this.emitword(4);
        this.emitword(num);
        this.emitword(denom);
    }

    protected void emitHeader(int picwidth, int picheight) {
        try {
            int buflen = 512;
            byte[] buf = new byte[buflen];
            this.os.write(buf, 0, buflen);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        int picbytes = 0;
        this.emitword(picbytes);
        this.emitrect(0, 0, picwidth, picheight);
        this.emitop(17);
        this.emitword(767);
        this.emitop(3072);
        this.emitint(-1);
        int i = 0;
        while (i < 4) {
            this.emitword(-1);
            this.emitword(0);
            ++i;
        }
        this.emitint(-1);
        this.emitop(30);
        this.clipRect(this.clipr.x, this.clipr.y, this.clipr.width, this.clipr.height);
        this.beginPicGroup();
    }

    public Graphics create() {
        Gr2PICT grpict = new Gr2PICT((OutputStream)this.os, this.g, 49);
        grpict.font = this.font;
        grpict.clipr = this.clipr;
        grpict.clr = this.clr;
        return grpict;
    }

    public Graphics create(int x, int y, int width, int height) {
        Graphics g = this.create();
        g.translate(x, y);
        g.clipRect(0, 0, width, height);
        return g;
    }

    public void translate(int x, int y) {
        this.origin.x = x;
        this.origin.y = y;
        this.emitop(12);
        this.emitword(-x);
        this.emitword(-y);
    }

    public Color getColor() {
        return this.clr;
    }

    public void setColor(Color c) {
        if (c != null) {
            this.clr = c;
        }
        this.emitop(26);
        this.emitcolor(this.clr);
    }

    public void setPaintMode() {
        this.emitop(8);
        this.emitword(8);
    }

    public void setXORMode(Color c1) {
        this.emitop(8);
        this.emitword(10);
        if (c1 != null) {
            this.emitop(28);
            this.emitop(29);
            this.emitcolor(c1);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        if (f != null) {
            this.font = f;
            String fname = this.font.getName();
            int qdnum = QD.getQuickDrawFontNum(fname);
            if (qdnum >= 0) {
                this.emitop(3);
                this.emitword(qdnum);
            } else {
                this.emitop(44);
                int len = fname.length() + 1 + 2 + 2;
                this.emitword(len);
                this.emitword(QD.fontnum++);
                this.emitstring(fname);
            }
            int face = 0;
            int style = this.font.getStyle();
            if ((style & 1) != 0) {
                face |= 1;
            }
            if ((style & 2) != 0) {
                face |= 2;
            }
            this.emitop(4);
            this.emitbyte(face);
            this.emitop(13);
            this.emitword(this.font.getSize());
        }
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.g.getFontMetrics(f);
    }

    public Rectangle getClipRect() {
        return this.clipr;
    }

    public void clipRect(int x, int y, int width, int height) {
        this.clipr = new Rectangle(x, y, width, height);
        this.emitop(1);
        int rgnsize = 10;
        this.emitword(rgnsize);
        this.emitrect(x, y, width, height);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.emitop(32);
        this.emitword(y1);
        this.emitword(x1);
        this.emitword(y2);
        this.emitword(x2);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.emitop(49);
        this.emitrect(x, y, width, height);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.emitop(48);
        this.emitrect(x, y, width, height);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.emitop(50);
        this.emitrect(x, y, width, height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.emitroundrect(64, x, y, width, height, arcWidth, arcHeight);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.emitroundrect(65, x, y, width, height, arcWidth, arcHeight);
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        Color c = this.getColor();
        Color brighter = c.brighter();
        Color darker = c.darker();
        this.setColor(raised ? brighter : darker);
        this.drawLine(x, y, x, y + height);
        this.drawLine(x + 1, y, x + width - 1, y);
        this.setColor(raised ? darker : brighter);
        this.drawLine(x + 1, y + height, x + width, y + height);
        this.drawLine(x + width, y, x + width, y + height);
        this.setColor(c);
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        Color c = this.getColor();
        Color brighter = c.brighter();
        Color darker = c.darker();
        if (!raised) {
            this.setColor(darker);
        }
        this.fillRect(x + 1, y + 1, width - 2, height - 2);
        this.setColor(raised ? brighter : darker);
        this.drawLine(x, y, x, y + height - 1);
        this.drawLine(x + 1, y, x + width - 2, y);
        this.setColor(raised ? darker : brighter);
        this.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        this.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        this.setColor(c);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.emitop(80);
        this.emitrect(x, y, width, height);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.emitop(81);
        this.emitrect(x, y, width, height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.emitop(96);
        this.emitrect(x, y, width, height);
        this.emitword(startAngle - 90);
        this.emitword(arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.emitop(97);
        this.emitrect(x, y, width, height);
        this.emitword(startAngle + 90);
        this.emitword(arcAngle);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(new Polygon(xPoints, yPoints, nPoints));
    }

    public void drawPolygon(Polygon p) {
        this.emitop(112);
        this.emitpolygon(p);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fillPolygon(new Polygon(xPoints, yPoints, nPoints));
    }

    public void fillPolygon(Polygon p) {
        this.emitop(113);
        this.emitpolygon(p);
    }

    public void drawString(String str, int x, int y) {
        this.emitop(40);
        this.emitword(y);
        this.emitword(x);
        this.emitbyte(str.length());
        this.emitstring(str);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, 0, offset, length), x, y);
    }

    public boolean doImage(Image img, int x, int y, int width, int height, ImageObserver observer, Color bgcolor) {
        return true;
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.doImage(img, x, y, 0, 0, observer, null);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.doImage(img, x, y, width, height, observer, null);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.doImage(img, x, y, 0, 0, observer, bgcolor);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.doImage(img, x, y, width, height, observer, bgcolor);
    }

    public void dispose() {
        this.endPicGroup();
        this.emitop(255);
        try {
            this.os.flush();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void finalize() {
        super.finalize();
        this.dispose();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    public boolean checkError() {
        return this.trouble;
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public void setClip(int x, int y, int width, int height) {
    }

    public Shape getClip() {
        return null;
    }

    public void setClip(Shape clip) {
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return false;
    }

    public void drawString(AttributedCharacterIterator a, int i, int j) {
    }
}

