/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import ltsaeclipse.views.ExampleTask;
import ltsaeclipse.views.ITaskListViewer;

public class ExampleTaskList {
    private final int COUNT = 0;
    private Vector tasks = new Vector(0);
    private Set changeListeners = new HashSet();
    private LinkedList Owners_List;
    static final String[] OWNERS_ARRAY = new String[]{"?", "Nancy", "Larry", "Joe"};

    public ExampleTaskList() {
        this.initData();
    }

    private void initData() {
        this.Owners_List = new LinkedList();
        this.Owners_List.add("");
        int i = 0;
        while (i < 0) {
            ExampleTask task = new ExampleTask("Task " + i, "");
            task.setOwner("");
            this.tasks.add(task);
            ++i;
        }
    }

    public void SetOwnerList(LinkedList newownerlist) {
        this.Owners_List = newownerlist;
    }

    public String[] getOwners() {
        String[] OwnerArray = new String[this.Owners_List.size() - 1];
        int Owner = 0;
        while (Owner < this.Owners_List.size() - 1) {
            OwnerArray[Owner] = (String)this.Owners_List.get(Owner);
            ++Owner;
        }
        return OwnerArray;
    }

    public Vector getTasks() {
        return this.tasks;
    }

    public void addTask(String col1, String col2) {
        ExampleTask task = new ExampleTask(col1, col2);
        task.setCompleted(true);
        this.tasks.add(this.tasks.size(), task);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ITaskListViewer)iterator.next()).addTask(task);
        }
    }

    public void removeTask(ExampleTask task) {
        this.tasks.remove(task);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ITaskListViewer)iterator.next()).removeTask(task);
        }
    }

    public void taskChanged(ExampleTask task) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ITaskListViewer)iterator.next()).updateTask(task);
        }
    }

    public void removeChangeListener(ITaskListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(ITaskListViewer viewer) {
        this.changeListeners.add(viewer);
    }
}

