/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import ic.doc.ltsa.lts.CompositeState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import ltsaeclipse.LTSAFunctions;
import ltsaeclipse.editors.MultiPageEditor;
import ltsaeclipse.views.LTSADrawView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class LTSACompilerView
extends ViewPart
implements ISelectionListener {
    public TextViewer viewer;
    private Action action1;
    private Action doubleClickAction;
    private Document doc;
    private LTSAFunctions LTSAfunctions;
    private ISelection lastselection;
    private MultiPageEditor mpe;

    public void setMPE(MultiPageEditor aMPE) {
        this.mpe = aMPE;
    }

    public void createPartControl(Composite parent) {
        this.doc = new Document("nothing");
        this.viewer = new TextViewer(parent, 770);
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().toString());
        this.LTSAfunctions = new LTSAFunctions();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.selectionChanged(null, this.getSite().getPage().getSelection());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        this.lastselection = sel;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LTSACompilerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
    }

    public Hashtable getParsetable() {
        return this.LTSAfunctions.getParsetable();
    }

    public boolean doParse(MultiPageEditor mpe) {
        boolean parsed = false;
        this.SetStatusLine("Parsing... ");
        parsed = this.LTSAfunctions.doParse(this.doc.get());
        if (!parsed) {
            mpe.createMarkerProblem(this.LTSAfunctions.errorline, this.LTSAfunctions.errorpos, this.LTSAfunctions.error);
        }
        this.SetStatusLine("Parsed.");
        Hashtable cs = this.LTSAfunctions.getParsetable();
        if (cs == null) {
            return parsed;
        }
        Enumeration e = cs.keys();
        ArrayList forSort = new ArrayList();
        while (e.hasMoreElements()) {
            forSort.add(e.nextElement());
        }
        Collections.sort(forSort);
        Iterator i = forSort.iterator();
        while (i.hasNext()) {
            this.LTSAfunctions.result = String.valueOf(this.LTSAfunctions.result) + i.next().toString() + ",";
        }
        return parsed;
    }

    public void doCompose(CompositeState cs) {
        this.SetStatusLine("Composing... ");
        this.LTSAfunctions.doCompose(cs);
        this.SetStatusLine("Composed ");
        Document docresult = new Document(this.LTSAfunctions.result);
        this.viewer.setDocument((IDocument)docresult);
        this.viewer.setSelectedRange(this.LTSAfunctions.result.length(), this.LTSAfunctions.result.length());
    }

    public void doAnalyse(CompositeState cs) {
        this.SetStatusLine("Analysing... ");
        this.LTSAfunctions.doAnalyse(cs);
        this.SetStatusLine("Analysed.");
        Document docresult = new Document(this.LTSAfunctions.result);
        this.viewer.setDocument((IDocument)docresult);
        this.viewer.setSelectedRange(this.LTSAfunctions.result.length(), this.LTSAfunctions.result.length());
    }

    public void doProgress(CompositeState cs) {
        this.SetStatusLine("Performing Progress Check... ");
        this.LTSAfunctions.doProgress(cs);
        this.SetStatusLine("Progress Checked.");
        Document docresult = new Document(this.LTSAfunctions.result);
        this.viewer.setDocument((IDocument)docresult);
        this.viewer.setSelectedRange(this.LTSAfunctions.result.length(), this.LTSAfunctions.result.length());
    }

    public void doMinimise(CompositeState cs) {
        this.SetStatusLine("Minimising... ");
        this.LTSAfunctions.doMinimise(cs);
        this.SetStatusLine("Minimised.");
        Document docresult = new Document(this.LTSAfunctions.result);
        this.viewer.setDocument((IDocument)docresult);
        this.viewer.setSelectedRange(this.LTSAfunctions.result.length(), this.LTSAfunctions.result.length());
    }

    public CompositeState doCompile(MultiPageEditor parent, String name) {
        final String asname = name;
        final MultiPageEditor asMPE = parent;
        this.SetStatusLine("Compiling... " + name);
        Document docresult = new Document("Compiling: " + asname);
        this.viewer.setDocument((IDocument)docresult);
        Display display = this.viewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (!LTSACompilerView.this.LTSAfunctions.doCompile(LTSACompilerView.this.doc.get(), asname)) {
                    asMPE.createMarkerProblem(((LTSACompilerView)LTSACompilerView.this).LTSAfunctions.errorline, ((LTSACompilerView)LTSACompilerView.this).LTSAfunctions.errorpos, ((LTSACompilerView)LTSACompilerView.this).LTSAfunctions.error);
                }
                LTSACompilerView.this.viewer.setDocument((IDocument)new Document(((LTSACompilerView)LTSACompilerView.this).LTSAfunctions.result));
                LTSACompilerView.this.SetStatusLine("Compiled " + asname);
                if (asMPE != null) {
                    asMPE.setCurrentState(LTSACompilerView.this.LTSAfunctions.getCurrentState());
                    LTSACompilerView.this.updateDraw();
                }
            }
        });
        return this.LTSAfunctions.getCurrentState();
    }

    public void updateDraw() {
        LTSADrawView drawv = (LTSADrawView)this.getSite().getPage().findView("ltsaeclipse.views.LTSADrawView");
        if (drawv != null) {
            try {
                drawv.CState = this.LTSAfunctions.getCurrentState();
                drawv.updateView("");
            }
            catch (Exception exception) {}
        }
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                LTSACompilerView.this.getFile(LTSACompilerView.this.lastselection);
                LTSACompilerView.this.doCompile(null, "Default");
            }
        };
        this.action1.setText("&Compile");
        this.action1.setToolTipText("Compile FSP");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = LTSACompilerView.this.viewer.getSelection();
                ((IStructuredSelection)selection).getFirstElement();
            }
        };
    }

    private void hookDoubleClickAction() {
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Sample View", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void getFile(ISelection sel) {
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structured = (IStructuredSelection)sel;
        Object object = structured.getFirstElement();
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            this.doc.set(this.getText(file));
        }
    }

    public void setSource(String source) {
        this.doc.set(source);
    }

    protected String getText(IFile file) {
        try {
            InputStream in = file.getContents();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int read = in.read(buf);
            while (read > 0) {
                out.write(buf, 0, read);
                read = in.read(buf);
            }
            return out.toString();
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        return "";
    }

    private void SetStatusLine(String msg) {
        IStatusLineManager slm;
        IActionBars actionbars = this.getViewSite().getActionBars();
        if (actionbars != null && (slm = actionbars.getStatusLineManager()) != null) {
            slm.setErrorMessage(msg);
        }
    }
}

