/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.BasicMSC;
import synthesis.Event;
import synthesis.FSPLabel;
import synthesis.Instance;
import synthesis.MyOutput;
import synthesis.Specification;

public class ImplementationSynthesiser {
    static final String SYSNAME = "Implementation Synthesiser";
    static final String SYSVERSION = "v1.4";
    static final String TAU = "internalAction";

    public void synthesise(Specification S, MyOutput Output2, String ComponentSuffix, String SystemName, LTSOutput o) throws Exception {
        String parallelComposition = "||" + SystemName + " = (";
        boolean first = true;
        Iterator Components = S.components().iterator();
        FSPLabel l = new FSPLabel();
        try {
            while (Components.hasNext()) {
                String name = (String)Components.next();
                if (!first) {
                    parallelComposition = String.valueOf(parallelComposition) + " || ";
                } else {
                    first = false;
                }
                l.setComponentLabel(name);
                parallelComposition = String.valueOf(parallelComposition) + l.getLabel() + ComponentSuffix;
                this.printComponentInstance(S, name, ComponentSuffix, Output2, o);
            }
            parallelComposition = String.valueOf(parallelComposition) + ").";
            Output2.println(parallelComposition);
            Output2.println("");
        }
        catch (Exception e) {
            o.outln(e.toString());
            throw new Exception("Inconsistent Spec");
        }
    }

    public void printComponentClass(Specification S, String className, String ComponentSuffix, MyOutput Output2, LTSOutput o, Map PortNames) throws Exception {
        String Composition = "";
        FSPLabel Fl = new FSPLabel();
        Fl.setComponentLabel(className);
        StringBuffer LocalBuffer = new StringBuffer();
        MyOutput LocalOutput = new MyOutput(LocalBuffer);
        StringBuffer HMSCBuffer = new StringBuffer();
        MyOutput HMSCOutput = new MyOutput(HMSCBuffer);
        boolean found = false;
        Iterator Components = S.components().iterator();
        if (Components.hasNext()) {
            HMSCOutput.println(String.valueOf(Fl.getLabel()) + "_ND = InitialNode,");
            while (Components.hasNext()) {
                String currName = (String)Components.next();
                String currClassName = new String("");
                String currInstanceName = new String("");
                int ColonPosition = currName.indexOf(":");
                if (ColonPosition > 0) {
                    currInstanceName = currName.substring(0, ColonPosition);
                    currClassName = currName.substring(ColonPosition + 1);
                } else {
                    currInstanceName = new String(currName);
                    currClassName = new String(currName);
                }
                if (!currClassName.equals(className)) continue;
                if (Composition.length() != 0) {
                    Composition = String.valueOf(Composition) + " | ";
                }
                Composition = String.valueOf(Composition) + "internalAction -> " + this.printComponent(S, currName, ComponentSuffix, false, LocalOutput, HMSCOutput, o, PortNames, currInstanceName);
                found = true;
            }
            HMSCOutput.println("InitialNode = (" + Composition + ").");
            HMSCOutput.append(LocalBuffer);
            HMSCOutput.println("deterministic ||" + Fl.getLabel() + ComponentSuffix + " = " + Fl.getLabel() + "_ND" + "\\{internalAction}.");
            if (found) {
                Output2.append(HMSCBuffer);
            }
        }
    }

    public void printComponentInstance(Specification S, String name, String ComponentSuffix, MyOutput Output2, LTSOutput o) throws Exception {
        String Init = this.printComponent(S, name, ComponentSuffix, true, Output2, Output2, o, null, null);
        FSPLabel Fl = new FSPLabel();
        Fl.setComponentLabel(name);
        Output2.println("deterministic ||" + Fl.getLabel() + ComponentSuffix + " = " + Init + "\\{internalAction}.");
    }

    private String printComponent(Specification S, String name, String ComponentSuffix, boolean Instance2, MyOutput LocalOutput, MyOutput Output2, LTSOutput o, Map PortNames, String instanceName) throws Exception {
        boolean dbg = false;
        String ClassInitialNode = null;
        if (!Instance2) {
            ClassInitialNode = "InitialNode";
        }
        if (dbg) {
            o.outln("// String -> Instances: bMSC name and corresponding component instance in bMSC.");
        }
        Map Instances = S.getComponentInstances(name);
        FSPLabel l = new FSPLabel();
        if (dbg) {
            o.outln("//Process header");
        }
        l.setComponentLabel(name);
        LocalOutput.println("////Component " + l.getLabel());
        if (dbg) {
            o.outln("//Start local processes.");
        }
        Iterator I = Instances.keySet().iterator();
        while (I.hasNext()) {
            String bMSC = (String)I.next();
            Instance Inst = (Instance)Instances.get(bMSC);
            l.setComponentLabel(name);
            LocalOutput.print(String.valueOf(l.getLabel()) + "_" + bMSC + " = ");
            if (Inst.size() != 0) {
                LocalOutput.print("(");
                int p = 0;
                while (p < Inst.size()) {
                    Event e = Inst.get(p);
                    l.setMessageLabel(e.getLabel(), PortNames, instanceName);
                    LocalOutput.print(l.getLabel());
                    LocalOutput.print(" -> ");
                    ++p;
                }
                LocalOutput.println("END).");
                continue;
            }
            LocalOutput.println("END.");
        }
        if (dbg) {
            o.outln("//End local processes.");
        }
        if (dbg) {
            o.outln("//Start HMSC.");
        }
        HashMap<BasicMSC, Integer> bMSC_To_Ids = new HashMap<BasicMSC, Integer>();
        Vector<BasicMSC> Ids_To_bMSCs = new Vector<BasicMSC>();
        Ids_To_bMSCs.setSize(S.getbMSCs().size() + 1);
        HashSet<Integer> Inits = new HashSet<Integer>();
        Iterator J = S.getbMSCs().iterator();
        int Id = 0;
        while (J.hasNext()) {
            BasicMSC b = (BasicMSC)J.next();
            bMSC_To_Ids.put(b, new Integer(Id));
            Ids_To_bMSCs.set(Id, b);
            if (S.getContinuationsInit().contains(b)) {
                Inits.add(new Integer(Id));
            }
            ++Id;
        }
        boolean firstInit = true;
        l.setComponentLabel(name);
        Output2.print("HMSC_" + l.getLabel() + " = (");
        J = Inits.iterator();
        while (J.hasNext()) {
            if (!firstInit) {
                Output2.print(" | ");
            } else {
                firstInit = false;
            }
            Output2.print("internalAction -> " + l.getLabel() + "_N" + J.next().toString());
        }
        Output2.print(")");
        int i = 0;
        while (i < Id) {
            String bName = ((BasicMSC)Ids_To_bMSCs.get((int)i)).name;
            Output2.println(",");
            l.setComponentLabel(name);
            Output2.print(String.valueOf(l.getLabel()) + "_N" + i + " = " + l.getLabel() + "_" + bName + ";" + l.getLabel() + "_N" + i + "_Adj");
            ++i;
        }
        i = 0;
        while (i < Id) {
            Output2.println(",");
            Output2.print(String.valueOf(l.getLabel()) + "_N" + i + "_Adj = (");
            Set Conts = S.getContinuations((BasicMSC)Ids_To_bMSCs.get(i));
            if (Conts.size() == 0) {
                Output2.print("endAction -> END)");
            } else {
                Iterator K = Conts.iterator();
                boolean first = true;
                while (K.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        Output2.print(" | ");
                    }
                    Integer num = (Integer)bMSC_To_Ids.get((BasicMSC)K.next());
                    if (num != 0 || Instance2) {
                        Output2.print("internalAction -> " + l.getLabel() + "_N" + num);
                        continue;
                    }
                    Output2.print("internalAction -> " + ClassInitialNode);
                }
                Output2.print(")");
            }
            ++i;
        }
        if (Instance2) {
            Output2.println(".");
        } else {
            Output2.println(",");
        }
        l.setComponentLabel(name);
        return "HMSC_" + l.getLabel();
    }
}

