/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.custom;

import ic.doc.extension.Animator;
import ic.doc.ltsa.custom.AnimationAction;
import ic.doc.ltsa.custom.AnimationControl;
import ic.doc.ltsa.custom.CustomAnimator;
import ic.doc.ltsa.custom.Relation;
import ic.doc.ltsa.custom.SceneAnimationController;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import uk.ac.ic.doc.scenebeans.animation.Animation;
import uk.ac.ic.doc.scenebeans.animation.AnimationCanvas;
import uk.ac.ic.doc.scenebeans.animation.CommandException;
import uk.ac.ic.doc.scenebeans.animation.parse.XMLAnimationParser;
import uk.ac.ic.doc.scenebeans.event.AnimationListener;
import uk.ac.ic.doc.scenebeans.input.MouseDispatcher;

public class SceneAnimator
extends CustomAnimator
implements AnimationControl {
    SceneAnimationController tac;
    MenuBar mb;
    Menu run;
    MenuItem pause;
    MenuItem resume;
    Menu trace;
    CheckboxMenuItem setTrace;
    CheckboxMenuItem setDebug;
    Scrollbar bar;
    Animator animator;
    Relation buttonControls;
    AnimationCanvas _canvas;
    MouseDispatcher _dispatcher;

    public SceneAnimator() {
        this.setTitle("SceneBean Animator");
        this.addWindowListener(new MyWindow());
        this.getContentPane().setLayout(new BorderLayout());
        this._canvas = new AnimationCanvas();
        this._canvas.setBackground(Color.white);
        this._canvas.setAnimationStretched(true);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this._canvas.setRenderingHints(hints);
        this._canvas.setFont(new Font("SansSerif", 1, 14));
        this.getContentPane().add("Center", (Component)this._canvas);
        this.bar = new Scrollbar(1, 25, 1, 1, 32);
        this._canvas.setFrameDelay(40L);
        this.getContentPane().add("East", this.bar);
        this.bar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                SceneAnimator.this._canvas.setTimeWarp((double)(33 - e.getValue()) * 0.125);
            }
        });
        MenuBar mb = new MenuBar();
        this.setMenuBar(mb);
        this.run = new Menu("Run");
        mb.add(this.run);
        this.pause = new MenuItem("Pause");
        this.run.add(this.pause);
        this.resume = new MenuItem("Resume");
        this.run.add(this.resume);
        this.pause.setEnabled(true);
        this.resume.setEnabled(false);
        RunMenu m = new RunMenu();
        this.pause.addActionListener(m);
        this.resume.addActionListener(m);
        this.trace = new Menu("Trace");
        mb.add(this.trace);
        this.setTrace = new CheckboxMenuItem("Trace");
        this.trace.add(this.setTrace);
        this.setTrace.setState(false);
        this.setDebug = new CheckboxMenuItem("Debug");
        this.trace.add(this.setDebug);
        this.setDebug.setState(false);
        CheckItem ca = new CheckItem();
        this.setDebug.addItemListener(ca);
        this.setTrace.addItemListener(ca);
        this._dispatcher = new MouseDispatcher(this._canvas.getSceneGraph(), (Object)this._canvas);
        this._dispatcher.attachTo((Component)this._canvas);
    }

    public void init(Animator a, File xml, Relation actions, Relation controls, boolean replay) {
        if (replay) {
            this.setTitle("Custom Animator - Replay Mode");
        }
        this.setTrace.setState(replay);
        this.animator = a;
        if (actions == null || controls == null) {
            this.animator.message("Animator - must have 'controls' and 'actions'");
            this.dispose();
            return;
        }
        try {
            XMLAnimationParser parser = new XMLAnimationParser(xml, (Component)this._canvas);
            Animation sprite = parser.parseAnimation();
            this._canvas.setAnimation(sprite);
            this.buttonControls = controls.inverse();
            Iterator i = sprite.getEventNames().iterator();
            while (i.hasNext()) {
                String control = (String)i.next();
                this.buttonControls.remove(control);
            }
            Relation all = new Relation();
            all.union(actions);
            all.union(this.buttonControls.inverse());
            this.tac = new SceneAnimationController(a, all, controls, replay, this._canvas);
            i = sprite.getCommandNames().iterator();
            while (i.hasNext()) {
                this.registerAction((String)i.next());
            }
            if (this.buttonControls.size() > 0) {
                this.createButtons(this.buttonControls);
            }
            sprite.addAnimationListener((AnimationListener)this.tac);
            this.invalidate();
            this.pack();
            this.tac.start();
            this.clearButtons(this.buttonControls);
            this.tac.restart();
        }
        catch (Exception ex) {
            this.animator.message("XML-" + ex);
            ex.printStackTrace();
            this.dispose();
        }
    }

    protected void createButtons(Relation r) {
        Panel p = new Panel();
        this.getContentPane().add("South", p);
        Enumeration k = r.keys();
        while (k.hasMoreElements()) {
            String name = (String)k.nextElement();
            Button b = new Button(name);
            b.setBackground(Color.green);
            b.addActionListener(new ButtonAction(name));
            this.registerButtonClearAction(name, b);
            p.add(b);
        }
    }

    protected void clearButtons(Relation r) {
        Enumeration k = r.keys();
        while (k.hasMoreElements()) {
            String name = (String)k.nextElement();
            this.clearControl(name);
        }
    }

    public void stop() {
        if (this.tac != null) {
            this.tac.stop();
        }
        if (this._canvas != null) {
            this._canvas.stop();
        }
    }

    public void registerAction(String name) {
        this.tac.registerAction(name, new CommandAction(name));
    }

    public void registerButtonClearAction(String name, Button b) {
        this.tac.registerAction(name, new ButtonClearAction(name, b));
    }

    public void signalControl(String name) {
        this.tac.signalControl(name);
    }

    public void clearControl(String name) {
        this.tac.clearControl(name);
    }

    class CommandAction
    implements AnimationAction {
        String name;

        CommandAction(String s) {
            this.name = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void action() {
            try {
                AnimationCanvas animationCanvas = SceneAnimator.this._canvas;
                synchronized (animationCanvas) {
                    SceneAnimator.this._canvas.getAnimation().invokeCommand(this.name);
                }
            }
            catch (CommandException e) {
                System.out.println("Animation" + (Object)((Object)e));
            }
        }
    }

    class ButtonClearAction
    implements AnimationAction {
        String name;
        Button button;

        ButtonClearAction(String s, Button b) {
            this.name = s;
            this.button = b;
        }

        public void action() {
            this.button.setBackground(Color.green);
            SceneAnimator.this.clearControl(this.name);
        }
    }

    class MyWindow
    extends WindowAdapter {
        MyWindow() {
        }

        public void windowClosing(WindowEvent e) {
            SceneAnimator.this.dispose();
        }
    }

    class CheckItem
    implements ItemListener {
        CheckItem() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == SceneAnimator.this.setTrace) {
                SceneAnimator.this.tac.setTrace(SceneAnimator.this.setTrace.getState());
            } else if (e.getSource() == SceneAnimator.this.setDebug) {
                SceneAnimator.this.tac.setDebug(SceneAnimator.this.setDebug.getState());
            }
        }
    }

    class RunMenu
    implements ActionListener {
        RunMenu() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SceneAnimator.this.pause) {
                if (SceneAnimator.this.tac != null) {
                    SceneAnimator.this.tac.stop();
                }
                SceneAnimator.this.pause.setEnabled(false);
                SceneAnimator.this.resume.setEnabled(true);
            } else if (e.getSource() == SceneAnimator.this.resume) {
                if (SceneAnimator.this.tac != null) {
                    SceneAnimator.this.tac.restart();
                }
                SceneAnimator.this.pause.setEnabled(true);
                SceneAnimator.this.resume.setEnabled(false);
            }
        }
    }

    class ButtonAction
    implements ActionListener {
        String name;

        public ButtonAction(String s) {
            this.name = s;
        }

        public void actionPerformed(ActionEvent e) {
            Button b = (Button)e.getSource();
            b.setBackground(Color.red);
            SceneAnimator.this.signalControl(this.name);
        }
    }
}

