/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Relation;
import ic.doc.ltsa.lts.Automata;
import ic.doc.ltsa.lts.Counter;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.MyHashStack;
import ic.doc.ltsa.lts.MyIntHash;
import ic.doc.ltsa.lts.MyList;
import ic.doc.ltsa.lts.StackCheck;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CompactState
implements Automata {
    public String name;
    public int maxStates;
    public String[] alphabet;
    public EventState[] states;
    public int endseq = -9999;
    private boolean hasduplicates = false;
    private boolean prop = false;

    public CompactState() {
    }

    public CompactState(int size, String name, MyHashStack statemap, MyList transitions, String[] alphabet, int endSequence) {
        this.alphabet = alphabet;
        this.name = name;
        this.maxStates = size;
        this.states = new EventState[this.maxStates];
        while (!transitions.empty()) {
            int fromState = transitions.getFrom();
            int toState = transitions.getTo() == null ? -1 : statemap.get(transitions.getTo());
            this.states[fromState] = EventState.add(this.states[fromState], new EventState(transitions.getAction(), toState));
            transitions.next();
        }
        this.endseq = endSequence;
    }

    public void reachable() {
        MyIntHash otn = EventState.reachable(this.states);
        EventState[] oldStates = this.states;
        this.maxStates = otn.size();
        this.states = new EventState[this.maxStates];
        int oldi = 0;
        while (oldi < oldStates.length) {
            int newi = otn.get(oldi);
            if (newi > -2) {
                this.states[newi] = EventState.renumberStates(oldStates[oldi], otn);
            }
            ++oldi;
        }
        if (this.endseq > 0) {
            this.endseq = otn.get(this.endseq);
        }
    }

    public void removeNonDetTau() {
        int oldSize;
        if (!this.hasTau()) {
            return;
        }
        do {
            boolean canRemove = false;
            int i = 0;
            while (i < this.maxStates) {
                this.states[i] = EventState.remove(this.states[i], new EventState(0, i));
                ++i;
            }
            BitSet tauOnly = new BitSet(this.maxStates);
            int i2 = 1;
            while (i2 < this.maxStates) {
                if (EventState.hasOnlyTauAndAccept(this.states[i2], this.alphabet)) {
                    tauOnly.set(i2);
                    canRemove = true;
                }
                ++i2;
            }
            if (!canRemove) {
                return;
            }
            i2 = 0;
            while (i2 < this.maxStates) {
                if (!tauOnly.get(i2)) {
                    this.states[i2] = EventState.addNonDetTau(this.states[i2], this.states, tauOnly);
                }
                ++i2;
            }
            oldSize = this.maxStates;
            this.reachable();
        } while (oldSize != this.maxStates);
    }

    public void removeDetCycles(String action) {
        int act = this.eventNo(action);
        if (act >= this.alphabet.length) {
            return;
        }
        int i = 0;
        while (i < this.states.length) {
            if (!EventState.hasNonDetEvent(this.states[i], act)) {
                this.states[i] = EventState.remove(this.states[i], new EventState(act, i));
            }
            ++i;
        }
    }

    public boolean isSafetyOnly() {
        int terminalAcceptStates = 0;
        int acceptStates = 0;
        int i = 0;
        while (i < this.maxStates) {
            if (EventState.isAccepting(this.states[i], this.alphabet)) {
                ++acceptStates;
                if (EventState.isTerminal(i, this.states[i])) {
                    ++terminalAcceptStates;
                }
            }
            ++i;
        }
        return terminalAcceptStates == 1 && acceptStates == true || acceptStates == 0;
    }

    public void makeSafety() {
        int acceptState = -1;
        int i = 0;
        while (i < this.maxStates) {
            if (EventState.isAccepting(this.states[i], this.alphabet)) {
                acceptState = i;
                break;
            }
            ++i;
        }
        if (acceptState >= 0) {
            this.states[acceptState] = EventState.removeAccept(this.states[acceptState]);
        }
        i = 0;
        while (i < this.maxStates) {
            EventState.replaceWithError(this.states[i], acceptState);
            ++i;
        }
        this.reachable();
    }

    public void removeAcceptTau() {
        int i = 1;
        while (i < this.maxStates) {
            if (EventState.hasOnlyTauAndAccept(this.states[i], this.alphabet)) {
                this.states[i] = EventState.removeAccept(this.states[i]);
            }
            ++i;
        }
    }

    public boolean hasERROR() {
        int i = 0;
        while (i < this.maxStates) {
            if (EventState.hasState(this.states[i], -1)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void prefixLabels(String prefix) {
        this.name = String.valueOf(prefix) + ":" + this.name;
        int i = 1;
        while (i < this.alphabet.length) {
            String old = this.alphabet[i];
            this.alphabet[i] = String.valueOf(prefix) + "." + old;
            ++i;
        }
    }

    public boolean relabelDuplicates() {
        return this.hasduplicates;
    }

    public void relabel(Relation oldtonew) {
        this.hasduplicates = false;
        if (oldtonew.isRelation()) {
            this.relational_relabel(oldtonew);
        } else {
            this.functional_relabel(oldtonew);
        }
    }

    private void relational_relabel(Relation oldtonew) {
        Vector<String> na = new Vector<String>();
        Relation otoni = new Relation();
        na.setSize(this.alphabet.length);
        int new_index = this.alphabet.length;
        na.setElementAt(this.alphabet[0], 0);
        int i = 1;
        while (i < this.alphabet.length) {
            int prefix_end = -1;
            Object o = oldtonew.get(this.alphabet[i]);
            if (o != null) {
                if (o instanceof String) {
                    na.setElementAt((String)o, i);
                } else {
                    Vector v = (Vector)o;
                    na.setElementAt((String)v.firstElement(), i);
                    int j = 1;
                    while (j < v.size()) {
                        na.addElement((String)v.elementAt(j));
                        otoni.put(new Integer(i), new Integer(new_index));
                        ++new_index;
                        ++j;
                    }
                }
            } else {
                prefix_end = this.maximalPrefix(this.alphabet[i], oldtonew);
                if (prefix_end >= 0) {
                    String old_prefix = this.alphabet[i].substring(0, prefix_end);
                    o = oldtonew.get(old_prefix);
                    if (o != null) {
                        if (o instanceof String) {
                            na.setElementAt(String.valueOf((String)o) + this.alphabet[i].substring(prefix_end), i);
                        } else {
                            Vector v = (Vector)o;
                            na.setElementAt(String.valueOf((String)v.firstElement()) + this.alphabet[i].substring(prefix_end), i);
                            int j = 1;
                            while (j < v.size()) {
                                na.addElement(String.valueOf((String)v.elementAt(j)) + this.alphabet[i].substring(prefix_end));
                                otoni.put(new Integer(i), new Integer(new_index));
                                ++new_index;
                                ++j;
                            }
                        }
                    } else {
                        na.setElementAt(this.alphabet[i], i);
                    }
                } else {
                    na.setElementAt(this.alphabet[i], i);
                }
            }
            ++i;
        }
        Object[] aa = new String[na.size()];
        na.copyInto(aa);
        this.alphabet = aa;
        this.addtransitions(otoni);
        this.checkDuplicates();
    }

    private void functional_relabel(Hashtable oldtonew) {
        int i = 1;
        while (i < this.alphabet.length) {
            String newlabel = (String)oldtonew.get(this.alphabet[i]);
            this.alphabet[i] = newlabel != null ? newlabel : this.prefixLabelReplace(i, oldtonew);
            ++i;
        }
        this.checkDuplicates();
    }

    private void checkDuplicates() {
        Hashtable<String, String> duplicates = new Hashtable<String, String>();
        int i = 1;
        while (i < this.alphabet.length) {
            if (duplicates.put(this.alphabet[i], this.alphabet[i]) != null) {
                this.hasduplicates = true;
                this.crunchDuplicates();
            }
            ++i;
        }
    }

    private void crunchDuplicates() {
        Hashtable<String, Integer> newAlpha = new Hashtable<String, Integer>();
        Hashtable oldtonew = new Hashtable();
        int index = 0;
        int i = 0;
        while (i < this.alphabet.length) {
            if (newAlpha.containsKey(this.alphabet[i])) {
                oldtonew.put(new Integer(i), newAlpha.get(this.alphabet[i]));
            } else {
                newAlpha.put(this.alphabet[i], new Integer(index));
                oldtonew.put(new Integer(i), new Integer(index));
                ++index;
            }
            ++i;
        }
        this.alphabet = new String[newAlpha.size()];
        Enumeration e = newAlpha.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            int i2 = (Integer)newAlpha.get(s);
            this.alphabet[i2] = s;
        }
        int i3 = 0;
        while (i3 < this.states.length) {
            this.states[i3] = EventState.renumberEvents(this.states[i3], oldtonew);
            ++i3;
        }
    }

    public Vector hide(Vector toShow) {
        Vector<String> toHide = new Vector<String>();
        int i = 1;
        while (i < this.alphabet.length) {
            if (!CompactState.contains(this.alphabet[i], toShow)) {
                toHide.addElement(this.alphabet[i]);
            }
            ++i;
        }
        return toHide;
    }

    public void expose(Vector toShow) {
        BitSet visible = new BitSet(this.alphabet.length);
        int i = 1;
        while (i < this.alphabet.length) {
            if (CompactState.contains(this.alphabet[i], toShow)) {
                visible.set(i);
            }
            ++i;
        }
        visible.set(0);
        this.dohiding(visible);
    }

    public void conceal(Vector toHide) {
        BitSet visible = new BitSet(this.alphabet.length);
        int i = 1;
        while (i < this.alphabet.length) {
            if (!CompactState.contains(this.alphabet[i], toHide)) {
                visible.set(i);
            }
            ++i;
        }
        visible.set(0);
        this.dohiding(visible);
    }

    private void dohiding(BitSet visible) {
        Integer tau = new Integer(0);
        Hashtable<Integer, Integer> oldtonew = new Hashtable<Integer, Integer>();
        Vector<String> newAlphabetVec = new Vector<String>();
        int index = 0;
        int i = 0;
        while (i < this.alphabet.length) {
            if (!visible.get(i)) {
                oldtonew.put(new Integer(i), tau);
            } else {
                newAlphabetVec.addElement(this.alphabet[i]);
                oldtonew.put(new Integer(i), new Integer(index));
                ++index;
            }
            ++i;
        }
        this.alphabet = new String[newAlphabetVec.size()];
        newAlphabetVec.copyInto(this.alphabet);
        i = 0;
        while (i < this.states.length) {
            this.states[i] = EventState.renumberEvents(this.states[i], oldtonew);
            ++i;
        }
    }

    static boolean contains(String action, Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.equals(action) && !CompactState.isPrefix(s, action)) continue;
            return true;
        }
        return false;
    }

    public boolean isProperty() {
        return this.prop;
    }

    public void makeProperty() {
        this.endseq = -9999;
        this.prop = true;
        int i = 0;
        while (i < this.maxStates) {
            this.states[i] = EventState.addTransToError(this.states[i], this.alphabet.length);
            ++i;
        }
    }

    public void unMakeProperty() {
        this.endseq = -9999;
        this.prop = false;
        int i = 0;
        while (i < this.maxStates) {
            this.states[i] = EventState.removeTransToError(this.states[i]);
            ++i;
        }
    }

    public boolean isNonDeterministic() {
        int i = 0;
        while (i < this.maxStates) {
            if (EventState.hasNonDet(this.states[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void printAUT(PrintStream out) {
        out.print("des(0," + this.ntransitions() + "," + this.maxStates + ")\n");
        int i = 0;
        while (i < this.states.length) {
            EventState.printAUT(this.states[i], i, this.alphabet, out);
            ++i;
        }
    }

    public CompactState myclone() {
        CompactState m = new CompactState();
        m.name = this.name;
        m.endseq = this.endseq;
        m.prop = this.prop;
        m.alphabet = new String[this.alphabet.length];
        int i = 0;
        while (i < this.alphabet.length) {
            m.alphabet[i] = this.alphabet[i];
            ++i;
        }
        m.maxStates = this.maxStates;
        m.states = new EventState[this.maxStates];
        i = 0;
        while (i < this.maxStates) {
            m.states[i] = EventState.union(m.states[i], this.states[i]);
            ++i;
        }
        return m;
    }

    public int ntransitions() {
        int count = 0;
        int i = 0;
        while (i < this.states.length) {
            count += EventState.count(this.states[i]);
            ++i;
        }
        return count;
    }

    public boolean hasTau() {
        int i = 0;
        while (i < this.states.length) {
            if (EventState.hasTau(this.states[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String prefixLabelReplace(int i, Hashtable oldtonew) {
        int prefix_end = this.maximalPrefix(this.alphabet[i], oldtonew);
        if (prefix_end < 0) {
            return this.alphabet[i];
        }
        String old_prefix = this.alphabet[i].substring(0, prefix_end);
        String new_prefix = (String)oldtonew.get(old_prefix);
        if (new_prefix == null) {
            return this.alphabet[i];
        }
        return String.valueOf(new_prefix) + this.alphabet[i].substring(prefix_end);
    }

    private int maximalPrefix(String s, Hashtable oldtonew) {
        int prefix_end = s.lastIndexOf(46);
        if (prefix_end < 0) {
            return prefix_end;
        }
        if (oldtonew.containsKey(s.substring(0, prefix_end))) {
            return prefix_end;
        }
        return this.maximalPrefix(s.substring(0, prefix_end), oldtonew);
    }

    private static boolean isPrefix(String prefix, String s) {
        int prefix_end = s.lastIndexOf(46);
        if (prefix_end < 0) {
            return false;
        }
        if (prefix.equals(s.substring(0, prefix_end))) {
            return true;
        }
        return CompactState.isPrefix(prefix, s.substring(0, prefix_end));
    }

    public boolean isErrorTrace(Vector trace) {
        boolean hasError = false;
        int i = 0;
        while (i < this.maxStates && !hasError) {
            if (EventState.hasState(this.states[i], -1)) {
                hasError = true;
            }
            ++i;
        }
        if (!hasError) {
            return false;
        }
        return this.isTrace(trace, 0, 0);
    }

    private boolean isTrace(Vector v, int index, int start) {
        if (index < v.size()) {
            String ename = (String)v.elementAt(index);
            int eno = this.eventNo(ename);
            if (eno < this.alphabet.length) {
                if (EventState.hasEvent(this.states[start], eno)) {
                    int[] n = EventState.nextState(this.states[start], eno);
                    int i = 0;
                    while (i < n.length) {
                        if (this.isTrace(v, index + 1, n[i])) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                if (eno != 0) {
                    return false;
                }
            }
            return this.isTrace(v, index + 1, start);
        }
        return start == -1;
    }

    private int eventNo(String ename) {
        int i = 0;
        while (i < this.alphabet.length && !ename.equals(this.alphabet[i])) {
            ++i;
        }
        return i;
    }

    public void addAccess(Vector pset) {
        int k;
        int n = pset.size();
        if (n == 0) {
            return;
        }
        String s = "{";
        CompactState[] machs = new CompactState[n];
        Enumeration e = pset.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            s = String.valueOf(s) + prefix;
            machs[i] = this.myclone();
            machs[i].prefixLabels(prefix);
            if (++i >= n) continue;
            s = String.valueOf(s) + ",";
        }
        this.name = String.valueOf(s) + "}::" + this.name;
        int alphaN = this.alphabet.length - 1;
        this.alphabet = new String[alphaN * n + 1];
        this.alphabet[0] = "tau";
        int j = 0;
        while (j < n) {
            k = 1;
            while (k < machs[j].alphabet.length) {
                this.alphabet[alphaN * j + k] = machs[j].alphabet[k];
                ++k;
            }
            ++j;
        }
        j = 1;
        while (j < n) {
            k = 0;
            while (k < this.maxStates) {
                EventState.offsetEvents(machs[j].states[k], alphaN * j);
                this.states[k] = EventState.union(this.states[k], machs[j].states[k]);
                ++k;
            }
            ++j;
        }
    }

    private void addtransitions(Relation oni) {
        int i = 0;
        while (i < this.states.length) {
            EventState ns = EventState.newTransitions(this.states[i], oni);
            if (ns != null) {
                this.states[i] = EventState.union(this.states[i], ns);
            }
            ++i;
        }
    }

    public boolean hasLabel(String label) {
        int i = 0;
        while (i < this.alphabet.length) {
            if (label.equals(this.alphabet[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean usesLabel(String label) {
        if (!this.hasLabel(label)) {
            return false;
        }
        int en = this.eventNo(label);
        int i = 0;
        while (i < this.states.length) {
            if (EventState.hasEvent(this.states[i], en)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSequential() {
        return this.endseq >= 0;
    }

    public boolean isEnd() {
        return this.maxStates == 1 && this.endseq == 0;
    }

    public static CompactState sequentialCompose(Vector seqs) {
        if (seqs == null) {
            return null;
        }
        if (seqs.size() == 0) {
            return null;
        }
        if (seqs.size() == 1) {
            return (CompactState)seqs.elementAt(0);
        }
        CompactState[] machines = new CompactState[seqs.size()];
        machines = seqs.toArray(machines);
        CompactState newMachine = new CompactState();
        newMachine.alphabet = CompactState.sharedAlphabet(machines);
        newMachine.maxStates = CompactState.seqSize(machines);
        newMachine.states = new EventState[newMachine.maxStates];
        int offset = 0;
        int i = 0;
        while (i < machines.length) {
            boolean last = i == machines.length - 1;
            CompactState.copyOffset(offset, newMachine.states, machines[i], last);
            if (last) {
                newMachine.endseq = machines[i].endseq + offset;
            }
            offset += machines[i].states.length;
            ++i;
        }
        return newMachine;
    }

    public void expandSequential(Hashtable inserts) {
        int ninserts = inserts.size();
        CompactState[] machines = new CompactState[ninserts + 1];
        int[] insertAt = new int[ninserts + 1];
        machines[0] = this;
        int index = 1;
        Enumeration e = inserts.keys();
        while (e.hasMoreElements()) {
            CompactState m;
            Integer ii = (Integer)e.nextElement();
            machines[index] = m = (CompactState)inserts.get(ii);
            insertAt[index] = ii;
            ++index;
        }
        this.alphabet = CompactState.sharedAlphabet(machines);
        int i = 1;
        while (i < machines.length) {
            int offset = insertAt[i];
            int j = 0;
            while (j < machines[i].states.length) {
                this.states[offset + j] = machines[i].states[j];
                ++j;
            }
            ++i;
        }
    }

    private static int seqSize(CompactState[] sm) {
        int length = 0;
        int i = 0;
        while (i < sm.length) {
            length += sm[i].states.length;
            ++i;
        }
        return length;
    }

    private static void copyOffset(int offset, EventState[] dest, CompactState m, boolean last) {
        int i = 0;
        while (i < m.states.length) {
            dest[i + offset] = !last ? EventState.offsetSeq(offset, m.endseq, m.maxStates + offset, m.states[i]) : EventState.offsetSeq(offset, m.endseq, m.endseq + offset, m.states[i]);
            ++i;
        }
    }

    public void offsetSeq(int offset, int finish) {
        int i = 0;
        while (i < this.states.length) {
            EventState.offsetSeq(offset, this.endseq, finish, this.states[i]);
            ++i;
        }
    }

    private static String[] sharedAlphabet(CompactState[] sm) {
        Counter newLabel = new Counter(0);
        Hashtable<String, Integer> actionMap = new Hashtable<String, Integer>();
        int i = 0;
        while (i < sm.length) {
            int j = 0;
            while (j < sm[i].alphabet.length) {
                if (!actionMap.containsKey(sm[i].alphabet[j])) {
                    actionMap.put(sm[i].alphabet[j], newLabel.label());
                }
                ++j;
            }
            ++i;
        }
        String[] actionName = new String[actionMap.size()];
        Enumeration e = actionMap.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            int index = (Integer)actionMap.get(s);
            actionName[index] = s;
        }
        int i2 = 0;
        while (i2 < sm.length) {
            int j = 0;
            while (j < sm[i2].maxStates) {
                EventState p = sm[i2].states[j];
                while (p != null) {
                    EventState tr = p;
                    tr.event = (Integer)actionMap.get(sm[i2].alphabet[tr.event]);
                    while (tr.nondet != null) {
                        tr.nondet.event = tr.event;
                        tr = tr.nondet;
                    }
                    p = p.list;
                }
                ++j;
            }
            ++i2;
        }
        return actionName;
    }

    private byte[] encode(int state) {
        byte[] code = new byte[4];
        int i = 0;
        while (i < 4) {
            int n = i++;
            code[n] = (byte)(code[n] | (byte)state);
            state >>>= 8;
        }
        return code;
    }

    private int decode(byte[] code) {
        int x = 0;
        int i = 3;
        while (i >= 0) {
            x |= code[i] & 0xFF;
            if (i > 0) {
                x <<= 8;
            }
            --i;
        }
        return x;
    }

    public String[] getAlphabet() {
        return this.alphabet;
    }

    public Vector getAlphabetV() {
        Vector<String> v = new Vector<String>(this.alphabet.length - 1);
        int i = 1;
        while (i < this.alphabet.length) {
            v.add(this.alphabet[i]);
            ++i;
        }
        return v;
    }

    public MyList getTransitions(byte[] fromState) {
        MyList tr = new MyList();
        int state = fromState == null ? -1 : this.decode(fromState);
        if (state < 0 || state >= this.maxStates) {
            return tr;
        }
        if (this.states[state] != null) {
            Enumeration e = this.states[state].elements();
            while (e.hasMoreElements()) {
                EventState t = (EventState)e.nextElement();
                tr.add(state, this.encode(t.next), t.event);
            }
        }
        return tr;
    }

    public String getViolatedProperty() {
        return null;
    }

    public Vector getTraceToState(byte[] from, byte[] to) {
        EventState trace = new EventState(0, 0);
        EventState.search(trace, this.states, this.decode(from), this.decode(to), -123456);
        return EventState.getPath(trace.path, this.alphabet);
    }

    public boolean END(byte[] state) {
        return this.decode(state) == this.endseq;
    }

    public boolean isAccepting(byte[] state) {
        return this.isAccepting(this.decode(state));
    }

    public byte[] START() {
        return this.encode(0);
    }

    public void setStackChecker(StackCheck s) {
    }

    public boolean isPartialOrder() {
        return false;
    }

    public void disablePartialOrder() {
    }

    public void enablePartialOrder() {
    }

    public boolean isAccepting(int n) {
        if (n < 0 || n >= this.maxStates) {
            return false;
        }
        return EventState.isAccepting(this.states[n], this.alphabet);
    }

    public BitSet accepting() {
        BitSet b = new BitSet();
        int i = 0;
        while (i < this.maxStates) {
            if (this.isAccepting(i)) {
                b.set(i);
            }
            ++i;
        }
        return b;
    }
}

