/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Relation;
import ic.doc.ltsa.lts.Analyser;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CounterExample;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.Minimiser;
import ic.doc.ltsa.lts.ProgressCheck;
import ic.doc.ltsa.lts.ltl.FluentTrace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class CompositeState {
    public static boolean reduceFlag = true;
    public String name;
    public Vector machines;
    public CompactState composition;
    public Vector hidden;
    public boolean exposeNotHide = false;
    public boolean priorityIsLow = true;
    public boolean makeDeterministic = false;
    public boolean makeMinimal = false;
    public boolean makeCompose = false;
    public boolean isProperty = false;
    public Vector priorityLabels;
    public CompactState alphaStop;
    protected Vector errorTrace = null;
    private CompactState saved = null;
    private FluentTrace tracer;

    public CompositeState(Vector v) {
        this.name = "DEFAULT";
        this.machines = v;
    }

    public CompositeState(String s, Vector v) {
        this.name = s;
        this.machines = v;
        this.initAlphaStop();
    }

    public Vector getErrorTrace() {
        return this.errorTrace;
    }

    public void setErrorTrace(List ll) {
        if (ll != null) {
            this.errorTrace = new Vector();
            this.errorTrace.addAll(ll);
        }
    }

    public void compose(LTSOutput output) {
        this.compose(output, false);
    }

    public void compose(LTSOutput output, boolean ignoreAsterisk) {
        if (this.machines != null && this.machines.size() > 0) {
            Analyser a = new Analyser(this, output, null, ignoreAsterisk);
            this.composition = a.composeNoHide();
            if (this.makeDeterministic) {
                this.applyHiding();
                this.determinise(output);
            } else if (this.makeMinimal) {
                this.applyHiding();
                this.minimise(output);
            } else {
                this.applyHiding();
            }
        }
    }

    private void applyHiding() {
        if (this.composition == null) {
            return;
        }
        if (this.hidden != null) {
            if (!this.exposeNotHide) {
                this.composition.conceal(this.hidden);
            } else {
                this.composition.expose(this.hidden);
            }
        }
    }

    public void analyse(LTSOutput output) {
        this.analyse(output, true);
    }

    public void analyse(LTSOutput output, boolean checkDeadlocks) {
        if (this.saved != null) {
            this.machines.remove(this.saved);
            this.saved = null;
        }
        if (this.composition != null) {
            CounterExample ce = new CounterExample(this);
            ce.print(output, checkDeadlocks);
            this.errorTrace = ce.getErrorTrace();
        } else {
            Analyser a = new Analyser(this, output, null);
            a.analyse();
            this.setErrorTrace(a.getErrorTrace());
        }
    }

    public void checkProgress(LTSOutput output) {
        ProgressCheck cc;
        if (this.saved != null) {
            this.machines.remove(this.saved);
            this.saved = null;
        }
        if (this.composition != null) {
            cc = new ProgressCheck(this.composition, output);
            cc.doProgressCheck();
        } else {
            Analyser a = new Analyser(this, output, null);
            cc = new ProgressCheck(a, output);
            cc.doProgressCheck();
        }
        this.errorTrace = cc.getErrorTrace();
    }

    public void checkLTL(LTSOutput output, CompositeState cs) {
        CompactState ltl_property = cs.composition;
        if (this.name.equals("DEFAULT") && this.machines.size() == 0) {
            this.machines = cs.machines;
            this.composition = cs.composition;
        } else {
            if (this.saved != null) {
                this.machines.remove(this.saved);
            }
            Vector saveHidden = this.hidden;
            boolean saveExposeNotHide = this.exposeNotHide;
            this.hidden = ltl_property.getAlphabetV();
            this.exposeNotHide = true;
            this.saved = ltl_property;
            this.machines.add(this.saved);
            Analyser a = new Analyser(this, output, null);
            if (!cs.composition.hasERROR()) {
                ProgressCheck cc = new ProgressCheck(a, output, cs.tracer);
                cc.doLTLCheck();
                this.errorTrace = cc.getErrorTrace();
            } else {
                a.analyse(cs.tracer);
                this.setErrorTrace(a.getErrorTrace());
            }
            this.hidden = saveHidden;
            this.exposeNotHide = saveExposeNotHide;
        }
    }

    public void minimise(LTSOutput output) {
        if (this.composition != null) {
            if (reduceFlag) {
                this.composition.removeNonDetTau();
            }
            Minimiser e = new Minimiser(this.composition, output);
            this.composition = e.minimise();
        }
    }

    public void determinise(LTSOutput output) {
        if (this.composition != null) {
            Minimiser d = new Minimiser(this.composition, output);
            this.composition = d.trace_minimise();
            if (this.isProperty) {
                this.composition.makeProperty();
            }
        }
    }

    public CompactState create(LTSOutput output) {
        this.compose(output);
        return this.composition;
    }

    public boolean needNotCreate() {
        return this.hidden == null && this.priorityLabels == null && !this.makeDeterministic && !this.makeMinimal && !this.makeCompose;
    }

    public void prefixLabels(String prefix) {
        this.name = String.valueOf(prefix) + ":" + this.name;
        this.alphaStop.prefixLabels(prefix);
        Enumeration ee = this.machines.elements();
        while (ee.hasMoreElements()) {
            CompactState mm = (CompactState)ee.nextElement();
            mm.prefixLabels(prefix);
        }
    }

    public void addAccess(Vector pset) {
        int n = pset.size();
        if (n == 0) {
            return;
        }
        String s = "{";
        Enumeration e = pset.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            s = String.valueOf(s) + prefix;
            if (++i >= n) continue;
            s = String.valueOf(s) + ",";
        }
        this.name = String.valueOf(s) + "}::" + this.name;
        this.alphaStop.addAccess(pset);
        Enumeration ee = this.machines.elements();
        while (ee.hasMoreElements()) {
            CompactState mm = (CompactState)ee.nextElement();
            mm.addAccess(pset);
        }
    }

    public CompactState relabel(Relation oldtonew, LTSOutput output) {
        this.alphaStop.relabel(oldtonew);
        if (this.alphaStop.relabelDuplicates() && this.machines.size() > 1) {
            this.compose(output);
            this.composition.relabel(oldtonew);
            return this.composition;
        }
        Enumeration ee = this.machines.elements();
        while (ee.hasMoreElements()) {
            CompactState mm = (CompactState)ee.nextElement();
            mm.relabel(oldtonew);
        }
        return null;
    }

    protected void initAlphaStop() {
        this.alphaStop = new CompactState();
        this.alphaStop.name = this.name;
        this.alphaStop.maxStates = 1;
        this.alphaStop.states = new EventState[this.alphaStop.maxStates];
        this.alphaStop.states[0] = null;
        Hashtable<String, String> alpha = new Hashtable<String, String>();
        Enumeration e = this.machines.elements();
        while (e.hasMoreElements()) {
            CompactState m = (CompactState)e.nextElement();
            int i = 1;
            while (i < m.alphabet.length) {
                alpha.put(m.alphabet[i], m.alphabet[i]);
                ++i;
            }
        }
        this.alphaStop.alphabet = new String[alpha.size() + 1];
        this.alphaStop.alphabet[0] = "tau";
        int j = 1;
        Enumeration e2 = alpha.keys();
        while (e2.hasMoreElements()) {
            String s;
            this.alphaStop.alphabet[j] = s = (String)e2.nextElement();
            ++j;
        }
    }

    public void setFluentTracer(FluentTrace ft) {
        this.tracer = ft;
    }

    public FluentTrace getFluentTracer() {
        return this.tracer;
    }
}

