/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.MyHashProgEntry;
import ic.doc.ltsa.lts.StackCheck;
import ic.doc.ltsa.lts.StateCodec;

public class MyHashProg
implements StackCheck {
    private MyHashProgEntry[] table;
    private int count = 0;

    public MyHashProg() {
        this.table = new MyHashProgEntry[100001];
    }

    public MyHashProg(int size) {
        this.table = new MyHashProgEntry[size];
    }

    public void add(byte[] key, MyHashProgEntry parent) {
        MyHashProgEntry entry = new MyHashProgEntry(key, parent);
        int hash = StateCodec.hash(key) % this.table.length;
        entry.next = this.table[hash];
        this.table[hash] = entry;
        ++this.count;
    }

    public MyHashProgEntry get(byte[] key) {
        int hash = StateCodec.hash(key) % this.table.length;
        MyHashProgEntry entry = this.table[hash];
        while (entry != null) {
            if (StateCodec.equals(entry.key, key)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean onStack(byte[] key) {
        MyHashProgEntry entry = this.get(key);
        if (entry == null) {
            return false;
        }
        return entry.isReturn && !entry.isProcessed;
    }

    public int size() {
        return this.count;
    }
}

