/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.MyHashQueueEntry;
import ic.doc.ltsa.lts.StackCheck;
import ic.doc.ltsa.lts.StateCodec;
import java.util.LinkedList;

public class MyHashQueue
implements StackCheck {
    private MyHashQueueEntry[] table;
    private int count = 0;
    private MyHashQueueEntry head = null;
    private MyHashQueueEntry tail = null;

    public MyHashQueue(int size) {
        this.table = new MyHashQueueEntry[size];
    }

    public void addPut(byte[] key, int action, MyHashQueueEntry parent) {
        MyHashQueueEntry entry = new MyHashQueueEntry(key, action, parent);
        if (parent != null) {
            entry.level = parent.level + 1;
        }
        int hash = StateCodec.hash(key) % this.table.length;
        entry.next = this.table[hash];
        this.table[hash] = entry;
        ++this.count;
        if (this.head == null) {
            this.head = this.tail = entry;
        } else {
            this.tail.link = entry;
            this.tail = entry;
        }
    }

    public MyHashQueueEntry peek() {
        return this.head;
    }

    public void pop() {
        this.head = this.head.link;
        if (this.head == null) {
            this.tail = this.head;
        }
    }

    public boolean empty() {
        return this.head == null;
    }

    public boolean containsKey(byte[] key) {
        int hash = StateCodec.hash(key) % this.table.length;
        MyHashQueueEntry entry = this.table[hash];
        while (entry != null) {
            if (StateCodec.equals(entry.key, key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean onStack(byte[] key) {
        int hash = StateCodec.hash(key) % this.table.length;
        MyHashQueueEntry entry = this.table[hash];
        while (entry != null) {
            if (StateCodec.equals(entry.key, key)) {
                return entry.level <= this.head.level;
            }
            entry = entry.next;
        }
        return false;
    }

    public int size() {
        return this.count;
    }

    public LinkedList getPath(MyHashQueueEntry end, String[] actionNames) {
        LinkedList<String> trace = new LinkedList<String>();
        while (end != null) {
            if (end.parent != null) {
                trace.addFirst(actionNames[end.action]);
            }
            end = end.parent;
        }
        return trace;
    }

    public int depth(MyHashQueueEntry e) {
        int d = 0;
        while (e != null) {
            ++d;
            e = e.parent;
        }
        return d;
    }
}

