/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.MyIntHashEntry;

public class MyIntHash {
    private MyIntHashEntry[] table;
    private int count = 0;

    public MyIntHash(int size) {
        this.table = new MyIntHashEntry[size];
    }

    public void put(int key) {
        MyIntHashEntry entry = new MyIntHashEntry(key);
        int hash = key % this.table.length;
        entry.next = this.table[hash];
        this.table[hash] = entry;
        ++this.count;
    }

    public void put(int key, int value) {
        int hash = key % this.table.length;
        MyIntHashEntry entry = this.table[hash];
        while (entry != null) {
            if (entry.key == key) {
                entry.value = value;
                return;
            }
            entry = entry.next;
        }
        entry = new MyIntHashEntry(key, value);
        entry.next = this.table[hash];
        this.table[hash] = entry;
        ++this.count;
    }

    public boolean containsKey(int key) {
        int hash = key % this.table.length;
        MyIntHashEntry entry = this.table[hash];
        while (entry != null) {
            if (entry.key == key) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int get(int key) {
        int hash = key % this.table.length;
        MyIntHashEntry entry = this.table[hash];
        while (entry != null) {
            if (entry.key == key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -99999;
    }

    public int size() {
        return this.count;
    }
}

