/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Relation;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Counter;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.Minimiser;
import ic.doc.ltsa.lts.ProcessSpec;
import ic.doc.ltsa.lts.Transition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class StateMachine {
    String name;
    String kludgeName;
    Hashtable alphabet = new Hashtable();
    Vector hidden;
    Relation relabels;
    Hashtable explicit_states = new Hashtable();
    Hashtable constants;
    Counter eventLabel = new Counter(0);
    Counter stateLabel = new Counter(0);
    Vector transitions = new Vector();
    boolean isProperty = false;
    boolean isMinimal = false;
    boolean isDeterministic = false;
    boolean exposeNotHide = false;
    Hashtable sequentialInserts;
    Hashtable preInsertsLast;
    Hashtable preInsertsMach;
    Hashtable aliases = new Hashtable();
    public static LTSOutput output;

    public StateMachine(ProcessSpec spec, Vector params) {
        this.name = spec.getname();
        if (params != null) {
            spec.doParams(params);
            this.kludgeName = String.valueOf(this.name) + StateMachine.paramString(params);
        } else {
            this.kludgeName = this.name;
        }
        this.make(spec);
    }

    public StateMachine(ProcessSpec spec) {
        this.kludgeName = this.name = spec.getname();
        this.make(spec);
    }

    private void make(ProcessSpec spec) {
        this.constants = spec.constants;
        this.alphabet.put("tau", this.eventLabel.label());
        spec.explicitStates(this);
        spec.crunch(this);
        this.renumber();
        spec.transition(this);
        spec.addAlphabet(this);
        spec.relabelAlphabet(this);
        spec.hideAlphabet(this);
        this.isProperty = spec.isProperty;
        this.isMinimal = spec.isMinimal;
        this.isDeterministic = spec.isDeterministic;
        this.exposeNotHide = spec.exposeNotHide;
    }

    public CompactState makeCompactState() {
        CompactState c = new CompactState();
        c.name = this.kludgeName;
        c.maxStates = this.stateLabel.lastLabel();
        Integer ii = (Integer)this.explicit_states.get("END");
        if (ii != null) {
            c.endseq = ii;
        }
        c.alphabet = new String[this.alphabet.size()];
        Enumeration<Object> e = this.alphabet.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            int j = (Integer)this.alphabet.get(s);
            if (s.equals("@")) {
                s = "@" + c.name;
            }
            c.alphabet[j] = s;
        }
        c.states = new EventState[c.maxStates];
        e = this.transitions.elements();
        while (e.hasMoreElements()) {
            Transition t = (Transition)e.nextElement();
            int ev = (Integer)this.alphabet.get("" + t.event);
            c.states[t.from] = EventState.add(c.states[t.from], new EventState(ev, t.to));
        }
        if (this.sequentialInserts != null) {
            c.expandSequential(this.sequentialInserts);
        }
        if (this.relabels != null) {
            c.relabel(this.relabels);
        }
        if (this.hidden != null) {
            if (!this.exposeNotHide) {
                c.conceal(this.hidden);
            } else {
                c.expose(this.hidden);
            }
        }
        if (this.isProperty) {
            if (c.isNonDeterministic() || c.hasTau()) {
                Diagnostics.fatal("primitive property processes must be deterministic: " + this.name);
            }
            c.makeProperty();
        }
        this.check_for_ERROR(c);
        c.reachable();
        if (this.isMinimal) {
            Minimiser me = new Minimiser(c, output);
            c = me.minimise();
        }
        if (this.isDeterministic) {
            Minimiser md = new Minimiser(c, output);
            c = md.trace_minimise();
        }
        return c;
    }

    void check_for_ERROR(CompactState c) {
        Integer I = (Integer)this.explicit_states.get(this.name);
        if (I == -1) {
            c.states = new EventState[1];
            c.maxStates = 1;
            c.states[0] = EventState.add(c.states[0], new EventState(0, -1));
        }
    }

    void addSequential(Integer state, CompactState mach) {
        if (this.sequentialInserts == null) {
            this.sequentialInserts = new Hashtable();
        }
        this.sequentialInserts.put(state, mach);
    }

    void preAddSequential(Integer start, Integer end, CompactState mach) {
        if (this.preInsertsLast == null) {
            this.preInsertsLast = new Hashtable();
        }
        if (this.preInsertsMach == null) {
            this.preInsertsMach = new Hashtable();
        }
        this.preInsertsLast.put(start, end);
        this.preInsertsMach.put(start, mach);
    }

    private void insertSequential(int[] map) {
        if (this.preInsertsMach == null) {
            return;
        }
        Enumeration e = this.preInsertsMach.keys();
        while (e.hasMoreElements()) {
            Integer start = (Integer)e.nextElement();
            CompactState mach = (CompactState)this.preInsertsMach.get(start);
            Integer end = (Integer)this.preInsertsLast.get(start);
            Integer newStart = new Integer(map[start]);
            mach.offsetSeq(newStart, end >= 0 ? map[end] : end);
            this.addSequential(newStart, mach);
        }
    }

    private Integer number(Integer alias, Counter newLabel) {
        if (this.preInsertsMach == null) {
            return newLabel.label();
        }
        CompactState mach = (CompactState)this.preInsertsMach.get(alias);
        if (mach == null) {
            return newLabel.label();
        }
        return newLabel.interval(mach.maxStates);
    }

    private void crunch(int index, int[] map) {
        int newi = map[index];
        while (newi >= 0 && newi != map[newi]) {
            newi = map[newi];
        }
        map[index] = newi;
    }

    private void renumber() {
        int[] map = new int[this.stateLabel.lastLabel().intValue()];
        int i = 0;
        while (i < map.length) {
            map[i] = i;
            ++i;
        }
        Enumeration e = this.aliases.keys();
        while (e.hasMoreElements()) {
            Integer targ = (Integer)e.nextElement();
            Integer alias = (Integer)this.aliases.get(targ);
            map[targ.intValue()] = alias;
        }
        int i2 = 0;
        while (i2 < map.length) {
            this.crunch(i2, map);
            ++i2;
        }
        Counter newLabel = new Counter(0);
        Hashtable<Integer, Integer> oldnew = new Hashtable<Integer, Integer>();
        int i3 = 0;
        while (i3 < map.length) {
            Integer newi;
            Integer alias = new Integer(map[i3]);
            if (!oldnew.containsKey(alias)) {
                newi = map[i3] >= 0 ? this.number(alias, newLabel) : new Integer(-1);
                oldnew.put(alias, newi);
                map[i3] = newi;
            } else {
                newi = (Integer)oldnew.get(alias);
                map[i3] = newi;
            }
            ++i3;
        }
        this.insertSequential(map);
        e = this.explicit_states.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            Integer ii = (Integer)this.explicit_states.get(s);
            if (ii < 0) continue;
            this.explicit_states.put(s, new Integer(map[ii]));
        }
        this.stateLabel = newLabel;
    }

    public void print(LTSOutput output) {
        String s;
        output.outln("PROCESS: " + this.name);
        output.outln("ALPHABET:");
        Enumeration<Object> e = this.alphabet.keys();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            output.outln("\t" + this.alphabet.get(s) + "\t" + s);
        }
        output.outln("EXPLICIT STATES:");
        e = this.explicit_states.keys();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            output.outln("\t" + this.explicit_states.get(s) + "\t" + s);
        }
        output.outln("TRANSITIONS:");
        e = this.transitions.elements();
        while (e.hasMoreElements()) {
            Transition t = (Transition)e.nextElement();
            output.outln("\t" + t);
        }
    }

    static String paramString(Vector v) {
        int max = v.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration e = v.elements();
        buf.append("(");
        int i = 0;
        while (i <= max) {
            String s = e.nextElement().toString();
            buf.append(s);
            if (i < max) {
                buf.append(",");
            }
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }
}

