/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.Automata;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.MyHash;
import ic.doc.ltsa.lts.MyList;
import ic.doc.ltsa.lts.MyStack;
import ic.doc.ltsa.lts.StateCodec;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;

public class SuperTrace {
    BitSet table;
    MyStack stack;
    int nbits;
    Automata mach;
    LTSOutput output;
    LinkedList errorTrace;
    private static int DEPTHBOUND = 100000;
    private static int HASHSIZE = 8000;
    private static final int SUCCESS = 0;
    private static final int DEADLOCK = 1;
    private static final int ERROR = 2;
    int nstate = 0;
    int nTrans = 0;

    public static void setDepthBound(int depth) {
        DEPTHBOUND = depth;
    }

    public static int getDepthBound() {
        return DEPTHBOUND;
    }

    public static void setHashSize(int size) {
        HASHSIZE = size;
    }

    public static int getHashSize() {
        return HASHSIZE;
    }

    public SuperTrace(Automata mach, LTSOutput output) {
        this.mach = mach;
        this.output = output;
        this.nbits = HASHSIZE * 1024 * 8;
        this.table = new BitSet(this.nbits);
        this.stack = new MyStack();
        this.analyse();
    }

    public void analyse() {
        this.output.outln("Analysing using Supertrace (Depth bound " + DEPTHBOUND + " Hashtable size " + HASHSIZE + "K )...");
        System.gc();
        long start = System.currentTimeMillis();
        int ret = this.search();
        long finish = System.currentTimeMillis();
        this.outStatistics(this.stack.depth, this.nstate, this.nTrans);
        if (ret == 1) {
            this.output.outln("Trace to DEADLOCK:");
            this.errorTrace = this.computeTrace(false);
            if (this.errorTrace.size() <= 100) {
                this.printPath(this.errorTrace);
            } else {
                this.output.outln("Trace length " + this.errorTrace.size() + ", replay using Check/Run");
            }
        } else if (ret == 2) {
            this.output.outln("Trace to property violation in " + this.mach.getViolatedProperty() + ":");
            this.errorTrace = this.computeTrace(true);
            if (this.errorTrace.size() <= 100) {
                this.printPath(this.errorTrace);
            } else {
                this.output.outln("Trace length " + this.errorTrace.size() + ", replay using Check/Run");
            }
        } else {
            this.output.outln("No deadlocks/errors");
        }
        this.output.outln("Analysed using Supertrace in: " + (finish - start) + "ms");
    }

    private int hashOne(byte[] value) {
        return StateCodec.hash(value);
    }

    private int hashTwo(byte[] val) {
        long value = StateCodec.hashLong(val);
        int h = (int)((value += 1325656567898L) ^ value >>> 32);
        return h & Integer.MAX_VALUE;
    }

    private void put(byte[] key) {
        this.table.set(this.hashOne(key) % this.nbits);
        this.table.set(this.hashTwo(key) % this.nbits);
    }

    private boolean contains(byte[] key) {
        return this.table.get(this.hashOne(key) % this.nbits) && this.table.get(this.hashTwo(key) % this.nbits);
    }

    /*
     * Unable to fully structure code
     */
    private int search() {
        start = this.mach.START();
        onStack = null;
        if (this.mach.isPartialOrder()) {
            onStack = new MyHash(SuperTrace.DEPTHBOUND + 1);
            this.mach.setStackChecker(onStack);
        }
        this.stack.push(start);
        this.put(start);
        while (!this.stack.empty()) {
            if (this.stack.marked()) {
                if (onStack != null) {
                    onStack.remove(this.stack.peek());
                }
                this.stack.pop();
                continue;
            }
            ++this.nstate;
            if (this.nstate % 10000 == 0) {
                this.outStatistics(this.stack.getDepth(), this.nstate, this.nTrans);
            }
            currentState = this.stack.peek();
            this.stack.mark();
            if (onStack != null) {
                onStack.put(currentState);
            }
            if (!(transitions = this.mach.getTransitions(currentState)).empty() || this.mach.END(currentState)) ** GOTO lbl31
            return 1;
lbl-1000:
            // 1 sources

            {
                ++this.nTrans;
                if (transitions.getTo() == null) {
                    return 2;
                }
                if (this.stack.getDepth() < SuperTrace.DEPTHBOUND && !this.contains(transitions.getTo())) {
                    this.stack.push(transitions.getTo());
                    this.put(transitions.getTo());
                }
                transitions.next();
lbl31:
                // 2 sources

                ** while (!transitions.empty())
            }
lbl32:
            // 1 sources

        }
        return 0;
    }

    public LinkedList getErrorTrace() {
        return this.errorTrace;
    }

    private void outStatistics(int depth, int states, int transitions) {
        this.output.out("-- Depth: " + depth + " States: " + states + " Transitions: " + transitions);
        Runtime r = Runtime.getRuntime();
        this.output.outln(" Memory used: " + (r.totalMemory() - r.freeMemory()) / 1000L + "K");
    }

    private void printPath(LinkedList v) {
        Iterator t = v.iterator();
        while (t.hasNext()) {
            this.output.outln("\t" + (String)t.next());
        }
    }

    private LinkedList computeTrace(boolean error) {
        this.mach.disablePartialOrder();
        LinkedList<String> trace = new LinkedList<String>();
        if (error) {
            while (!this.stack.marked()) {
                this.stack.pop();
            }
            trace.addFirst(this.findAction(this.stack.peek(), null));
        }
        byte[] to = this.stack.pop();
        while (!this.stack.empty()) {
            if (!this.stack.marked()) {
                this.stack.pop();
                continue;
            }
            trace.addFirst(this.findAction(this.stack.peek(), to));
            to = this.stack.pop();
        }
        return trace;
    }

    private String findAction(byte[] from, byte[] to) {
        MyList t = this.mach.getTransitions(from);
        while (!t.empty()) {
            if (StateCodec.equals(t.getTo(), to)) {
                return this.mach.getAlphabet()[t.getAction()];
            }
            t.next();
        }
        return "ACTION NOT FOUND";
    }
}

