/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;
import java.util.Iterator;
import java.util.List;

public class FluentTrace {
    PredicateDefinition[] fluents;
    int[] state;

    public FluentTrace(PredicateDefinition[] f) {
        if (f != null) {
            this.fluents = f;
            this.state = new int[this.fluents.length];
        }
    }

    private void initialise() {
        if (this.state == null) {
            return;
        }
        int i = 0;
        while (i < this.state.length) {
            this.state[i] = this.fluents[i].initial();
            ++i;
        }
    }

    private void update(String a) {
        if (this.state == null) {
            return;
        }
        int i = 0;
        while (i < this.state.length) {
            int res = this.fluents[i].query(a);
            if (res != 0) {
                this.state[i] = res;
            }
            ++i;
        }
    }

    private String fluentString() {
        if (this.state == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("\t\t");
        boolean first = true;
        int i = 0;
        while (i < this.state.length) {
            if (this.state[i] > 0) {
                if (!first) {
                    buf.append(" && ");
                }
                buf.append(this.fluents[i].toString());
                first = false;
            }
            ++i;
        }
        return buf.toString();
    }

    public void print(LTSOutput out, List trace, boolean init) {
        if (trace == null) {
            return;
        }
        if (init) {
            this.initialise();
        }
        Iterator I = trace.iterator();
        while (I.hasNext()) {
            String act = (String)I.next();
            this.update(act);
            out.outln("\t" + act + this.fluentString());
        }
    }
}

