/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import gov.nasa.arc.ase.util.graph.Graph;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.LabelFactory;
import ic.doc.ltsa.lts.ltl.Node;
import ic.doc.ltsa.lts.ltl.State;
import ic.doc.ltsa.lts.ltl.Transition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class GeneralizedBuchiAutomata {
    List nodes;
    Formula formula;
    FormulaFactory fac;
    List untils;
    int maxId = -1;
    Node[] equivClasses;
    State[] states;
    int naccept;
    String name;
    LabelFactory labelFac;

    public GeneralizedBuchiAutomata(String n, FormulaFactory f, Vector alphaExt) {
        this.fac = f;
        this.name = n;
        this.formula = f.getFormula();
        this.nodes = new ArrayList();
        this.labelFac = new LabelFactory(this.name, this.fac, alphaExt);
    }

    public void translate() {
        Node.setAut(this);
        Node.setFactory(this.fac);
        Transition.setLabelFactory(this.labelFac);
        this.untils = new ArrayList();
        this.naccept = this.fac.processUntils(this.formula, this.untils);
        Node first = new Node(this.formula);
        this.nodes = first.expand(this.nodes);
        this.states = this.makeStates();
    }

    public LabelFactory getLabelFactory() {
        return this.labelFac;
    }

    public void printNodes(LTSOutput out) {
        int ii = 0;
        while (ii < this.states.length) {
            if (this.states[ii] != null && ii == this.states[ii].getId()) {
                this.states[ii].print(out, this.naccept);
            }
            ++ii;
        }
    }

    public int indexEquivalence(Node n) {
        int i = 0;
        while (i < this.maxId) {
            if (this.equivClasses[i] == null) break;
            if (this.equivClasses[i].next.equals(n.next)) {
                return this.equivClasses[i].id;
            }
            ++i;
        }
        if (i == this.maxId) {
            Diagnostics.fatal("size of equivalence classes array was incorrect");
        }
        this.equivClasses[i] = n;
        return this.equivClasses[i].id;
    }

    public State[] makeStates() {
        State[] astate = new State[this.maxId];
        this.equivClasses = new Node[this.maxId];
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            node.equivId = this.indexEquivalence(node);
            node.makeTransitions(astate);
        }
        return astate;
    }

    int newId() {
        return ++this.maxId;
    }

    Graph Gmake() {
        Graph graph = new Graph();
        graph.setStringAttribute("type", "gba");
        graph.setStringAttribute("ac", "edges");
        if (this.states == null) {
            return graph;
        }
        int i = this.maxId;
        gov.nasa.arc.ase.util.graph.Node[] anode = new gov.nasa.arc.ase.util.graph.Node[i];
        int j = 0;
        while (j < i) {
            if (this.states[j] != null && j == this.states[j].getId()) {
                anode[j] = new gov.nasa.arc.ase.util.graph.Node(graph);
                anode[j].setStringAttribute("label", "S" + this.states[j].getId());
            }
            ++j;
        }
        int k = 0;
        while (k < i) {
            if (this.states[k] != null && k == this.states[k].getId()) {
                this.states[k].Gmake(anode, anode[k], this.naccept);
            }
            ++k;
        }
        if (this.naccept == 0) {
            graph.setIntAttribute("nsets", 1);
        } else {
            graph.setIntAttribute("nsets", this.naccept);
        }
        return graph;
    }
}

