/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.ComponentInstanceNotFound;
import synthesis.ConditionEvent;
import synthesis.Event;
import synthesis.FSPLabel;
import synthesis.InconsistentEvents;
import synthesis.InconsistentLabelUse;
import synthesis.InputEvent;
import synthesis.Instance;
import synthesis.MessageEvent;
import synthesis.MyOutput;
import synthesis.OutputEvent;
import synthesis.StringMap;
import synthesis.StringSet;
import synthesis.Trace;
import synthesis.loopBackMessage;

public class BasicMSC {
    static int counter = 0;
    static int limit = 0;
    static int counterlimit = 0;
    static boolean last = false;
    private HashMap instances = new HashMap();
    public String name;
    private Map SavedDependencies = null;
    private Map SavedLastDependencies = null;
    private Map SavedCanFinishBefore = null;

    public void addInstance(String componentName, Instance I) {
        this.instances.put(componentName, I);
    }

    public Set components() {
        return this.instances.keySet();
    }

    public Instance componentInstance(String name) throws ComponentInstanceNotFound {
        if (this.containsComponent(name)) {
            return (Instance)this.instances.get(name);
        }
        throw new ComponentInstanceNotFound();
    }

    public String getSource(String lbl) {
        Iterator I = this.components().iterator();
        boolean found = false;
        String Comp = null;
        while (I.hasNext() && !found) {
            Instance Inst = null;
            Comp = (String)I.next();
            try {
                Inst = this.componentInstance(Comp);
            }
            catch (Exception exception) {
                throw new Error("Internal Consistency Error");
            }
            found = Inst.outputs(lbl);
        }
        if (!found) {
            return null;
        }
        return Comp;
    }

    public String getTarget(String lbl) {
        Iterator I = this.components().iterator();
        boolean found = false;
        String Comp = null;
        while (I.hasNext() && !found) {
            Instance Inst = null;
            Comp = (String)I.next();
            try {
                Inst = this.componentInstance(Comp);
            }
            catch (Exception exception) {
                throw new Error("Internal Consistency Error");
            }
            found = Inst.inputs(lbl);
        }
        if (!found) {
            return null;
        }
        return Comp;
    }

    public boolean containsConditions() throws Exception {
        Iterator I = this.components().iterator();
        boolean Contains = false;
        Instance Inst = null;
        while (I.hasNext() && !Contains) {
            String lbl = (String)I.next();
            try {
                Inst = this.componentInstance(lbl);
            }
            catch (Exception exception) {
                throw new Exception("Internal Consistency Error");
            }
            Contains = Inst.containsConditions();
        }
        return Contains;
    }

    public StringSet getAlphabet() {
        Iterator I = this.components().iterator();
        Instance Inst = null;
        StringSet A = new StringSet();
        while (I.hasNext()) {
            String lbl = (String)I.next();
            try {
                Inst = this.componentInstance(lbl);
            }
            catch (Exception exception) {
                throw new Error("Internal Consistency Error");
            }
            A.addAll(Inst.getAlphabet());
        }
        return A;
    }

    public boolean empty() throws Exception {
        Iterator I = this.components().iterator();
        Instance Inst = null;
        boolean empty = true;
        while (I.hasNext() && empty) {
            String lbl = (String)I.next();
            try {
                Inst = this.componentInstance(lbl);
            }
            catch (Exception exception) {
                throw new Exception("Internal Consistency Error");
            }
            boolean bl = empty = Inst.size() == 0;
        }
        return empty;
    }

    public StringSet getParticipatingComponents() {
        Iterator I = this.components().iterator();
        Instance Inst = null;
        StringSet S = new StringSet();
        while (I.hasNext()) {
            String lbl = (String)I.next();
            try {
                Inst = this.componentInstance(lbl);
            }
            catch (Exception exception) {
                throw new Error("Internal Consistency Error");
            }
            if (Inst.isEmpty()) continue;
            S.add(lbl);
        }
        return S;
    }

    public void removeConditions() throws Exception {
        Iterator I = this.components().iterator();
        Instance Inst = null;
        while (I.hasNext()) {
            String lbl = (String)I.next();
            try {
                Inst = this.componentInstance(lbl);
            }
            catch (Exception exception) {
                throw new Exception("Internal Consistency Error");
            }
            Inst.removeConditions();
        }
    }

    public void append(BasicMSC B) {
        Iterator I = B.components().iterator();
        this.name = String.valueOf(this.name) + "_" + B.name;
        try {
            while (I.hasNext()) {
                String lbl = (String)I.next();
                Instance BInst = B.componentInstance(lbl);
                Instance Inst = this.componentInstance(lbl);
                Inst.append(BInst);
            }
        }
        catch (Exception exception) {}
    }

    public void appendAndMap(BasicMSC B, Map Sigma) {
        Iterator I = B.components().iterator();
        this.name = String.valueOf(this.name) + "_" + B.name;
        try {
            while (I.hasNext()) {
                String lbl = (String)I.next();
                Instance BInst = B.componentInstance(lbl);
                Instance Inst = this.componentInstance(lbl);
                Inst.appendAndMap(BInst, Sigma);
            }
        }
        catch (Exception exception) {}
    }

    public void appendMessage(String From, String lbl, String To) {
        Instance IFrom = this.getInstance(From);
        Instance ITo = this.getInstance(To);
        OutputEvent eFrom = new OutputEvent(lbl);
        eFrom.setTo(To);
        IFrom.appendEvent(eFrom);
        InputEvent eTo = new InputEvent(lbl);
        eTo.setFrom(From);
        ITo.appendEvent(eTo);
    }

    public void addMessage(String From, String lbl, String To, int Id1, int Id2) {
        Instance IFrom = this.getInstance(From);
        Instance ITo = this.getInstance(To);
        OutputEvent eFrom = new OutputEvent(lbl);
        eFrom.setTo(To);
        eFrom.Id = Id1;
        IFrom.addEvent(eFrom);
        InputEvent eTo = new InputEvent(lbl);
        eTo.setFrom(From);
        eTo.Id = Id2;
        ITo.addEvent(eTo);
    }

    public void addMessage(String From, String lbl, String To) {
        Instance IFrom = this.getInstance(From);
        Instance ITo = this.getInstance(To);
        OutputEvent eFrom = new OutputEvent(lbl);
        eFrom.setTo(To);
        IFrom.addEvent(eFrom);
        InputEvent eTo = new InputEvent(lbl);
        eTo.setFrom(From);
        ITo.addEvent(eTo);
    }

    public void addToAlphabet(StringSet L) {
        Iterator J = this.instances.keySet().iterator();
        while (J.hasNext()) {
            String component = (String)J.next();
            Instance I = null;
            try {
                I = (Instance)this.instances.get(component);
            }
            catch (Exception exception) {}
            I.addToAlphabet(L);
        }
    }

    public void hasAllComponentsIn(BasicMSC B) throws ComponentInstanceNotFound {
        Iterator I = this.components().iterator();
        while (I.hasNext()) {
            String Aux = (String)I.next();
            if (B.containsComponent(Aux)) continue;
            throw new ComponentInstanceNotFound(Aux);
        }
    }

    public boolean containsComponent(String name) {
        return this.instances.containsKey(name);
    }

    public void copyComponents(BasicMSC B) {
        Iterator I = B.components().iterator();
        while (I.hasNext()) {
            String lbl = (String)I.next();
            this.addInstance(lbl, new Instance());
        }
    }

    public Object clone() {
        BasicMSC B = new BasicMSC();
        B.name = this.name;
        Iterator I = this.components().iterator();
        while (I.hasNext()) {
            String lbl = (String)I.next();
            try {
                B.addInstance(lbl, (Instance)this.componentInstance(lbl).clone());
            }
            catch (Exception exception) {
                System.out.println("Error");
            }
        }
        return B;
    }

    public Object cloneAndMap(Map Sigma) {
        BasicMSC B = new BasicMSC();
        B.name = this.name;
        Iterator I = this.components().iterator();
        while (I.hasNext()) {
            String lbl = (String)I.next();
            try {
                Instance OldInstance = this.componentInstance(lbl);
                Instance NewInstance = (Instance)OldInstance.clone();
                B.addInstance(lbl, NewInstance);
                int i = 0;
                while (i < OldInstance.size()) {
                    Sigma.put(NewInstance.get(i), OldInstance.get(i));
                    ++i;
                }
            }
            catch (Exception exception) {
                System.out.println("Error");
            }
        }
        return B;
    }

    public void consistentLabels(HashMap M) throws Exception {
        Iterator I = this.components().iterator();
        String key = null;
        while (I.hasNext()) {
            Instance i;
            String iname = (String)I.next();
            try {
                i = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Exception("Internal Consistency Error:" + ex.getMessage());
            }
            ListIterator E = i.iterator();
            while (E.hasNext()) {
                Vector truple;
                Event e = (Event)E.next();
                if (e instanceof ConditionEvent) continue;
                Iterator K = M.keySet().iterator();
                boolean found = false;
                while (K.hasNext() && !found) {
                    key = (String)K.next();
                    found = e.getLabel().equals(key);
                }
                if (!found) {
                    truple = new Vector(3);
                    truple.add(0, this.name);
                    if (e instanceof InputEvent) {
                        truple.add(1, iname);
                        truple.add(2, ((InputEvent)e).getFrom());
                    } else {
                        truple.add(1, ((OutputEvent)e).getTo());
                        truple.add(2, iname);
                    }
                    M.put(e.getLabel(), truple);
                    if (!truple.get(1).equals(truple.get(2))) continue;
                    throw new loopBackMessage("Label " + e.getLabel() + " used as input and output in instance of component " + truple.get(2) + " in bMSC " + this.name);
                }
                truple = (Vector)M.get(key);
                if (e instanceof InputEvent) {
                    if (!truple.get(1).equals(iname)) {
                        if (this.name.equals(truple.get(0))) {
                            throw new InconsistentLabelUse("Label " + key + " used inconsistently in bMSC " + this.name);
                        }
                        throw new InconsistentLabelUse("Label " + key + " used inconsistently in bMSCs " + this.name + " and " + truple.get(0));
                    }
                    if (((InputEvent)e).getFrom().equals(truple.get(2))) continue;
                    throw new InconsistentLabelUse("Label " + key + " is declared to be received from component " + ((InputEvent)e).getFrom() + " but is being received from component " + truple.get(2) + " in bMSC " + this.name);
                }
                if (!truple.get(2).equals(iname)) {
                    if (this.name.equals(truple.get(0))) {
                        throw new InconsistentLabelUse("Label " + key + " used inconsistently in bMSC " + this.name);
                    }
                    throw new InconsistentLabelUse("Label " + key + " used inconsistently in bMSCs " + this.name + " and " + truple.get(0));
                }
                if (((OutputEvent)e).getTo().equals(truple.get(1))) continue;
                throw new InconsistentLabelUse("Label " + key + " is declared to be sent to component " + ((OutputEvent)e).getTo() + " but is being sent to component " + truple.get(1) + " in bMSC " + this.name);
            }
        }
    }

    public void consistentEvents() throws Exception {
        ListIterator i;
        int size = this.components().size();
        Vector<ListIterator> Instances = new Vector<ListIterator>(size);
        Vector<Event> enabledEvents = new Vector<Event>(size);
        int index2 = 0;
        int InstancesFinished = 0;
        Event e1 = null;
        Event e2 = null;
        Iterator I = this.components().iterator();
        int index = 0;
        while (I.hasNext()) {
            Instance Aux;
            String iname = (String)I.next();
            try {
                Aux = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Exception("Internal Consistency Error:" + ex.getMessage());
            }
            Instances.add(index++, Aux.iterator());
        }
        index = 0;
        while (index < size) {
            i = (ListIterator)Instances.get(index);
            e1 = null;
            while (i.hasNext() && e1 == null) {
                e1 = (Event)i.next();
                if (!(e1 instanceof ConditionEvent)) continue;
                e1 = null;
            }
            enabledEvents.add(index, e1);
            if (e1 == null) {
                ++InstancesFinished;
            }
            ++index;
        }
        while (InstancesFinished < size) {
            boolean foundMatch = false;
            index = 0;
            while (index < size && !foundMatch) {
                e1 = (Event)enabledEvents.get(index);
                if (e1 != null) {
                    index2 = index + 1;
                    while (index2 < size && !foundMatch) {
                        e2 = (Event)enabledEvents.get(index2);
                        if (e2 != null) {
                            foundMatch = e1.getLabel().equals(e2.getLabel());
                        }
                        ++index2;
                    }
                }
                ++index;
            }
            if (foundMatch) {
                e1 = null;
                i = (ListIterator)Instances.get(index - 1);
                while (i.hasNext() && e1 == null) {
                    e1 = (Event)i.next();
                    if (!(e1 instanceof ConditionEvent)) continue;
                    e1 = null;
                }
                enabledEvents.set(index - 1, e1);
                if (e1 == null) {
                    ++InstancesFinished;
                }
                e1 = null;
                i = (ListIterator)Instances.get(index2 - 1);
                while (i.hasNext() && e1 == null) {
                    e1 = (Event)i.next();
                    if (!(e1 instanceof ConditionEvent)) continue;
                    e1 = null;
                }
                enabledEvents.set(index2 - 1, e1);
                if (e1 != null) continue;
                ++InstancesFinished;
                continue;
            }
            String Message = "";
            index = 0;
            while (index < size) {
                Message = (Event)enabledEvents.get(index) != null ? String.valueOf(Message) + ((Event)enabledEvents.get(index)).getLabel() : String.valueOf(Message) + "-";
                if (index + 1 < size) {
                    Message = String.valueOf(Message) + ", ";
                }
                ++index;
            }
            throw new InconsistentEvents("Inconsistent events in bMSC " + this.name + ". Impossible to pair one of the following event labels " + Message);
        }
    }

    public void print(MyOutput Out) {
        Out.println("msc " + this.name + ";");
        Iterator J = this.instances.keySet().iterator();
        while (J.hasNext()) {
            String component = (String)J.next();
            Out.println("inst " + component + ";");
            try {
                ((Instance)this.instances.get(component)).print(Out);
            }
            catch (Exception exception) {
                Out.println("Error in instance.print");
            }
            Out.println("endinst");
        }
        Out.println("endmsc ");
    }

    public void print(LTSOutput Out) {
        Out.outln("msc " + this.name + ";");
        Iterator J = this.instances.keySet().iterator();
        while (J.hasNext()) {
            String component = (String)J.next();
            Out.outln("inst " + component + ";");
            try {
                ((Instance)this.instances.get(component)).print(Out);
            }
            catch (Exception exception) {
                Out.outln("Error in instance.print");
            }
            Out.outln("endinst");
        }
        Out.outln("endmsc ");
    }

    public boolean isPrefixOf(Set bMSCs) {
        boolean retVal = false;
        Iterator K = bMSCs.iterator();
        while (K.hasNext() && !retVal) {
            BasicMSC B = (BasicMSC)K.next();
            if (B == this) continue;
            Iterator J = this.instances.keySet().iterator();
            boolean isPrefix = false;
            while (J.hasNext() && !isPrefix) {
                Instance I2;
                String component = (String)J.next();
                Instance I = (Instance)this.instances.get(component);
                isPrefix = I.isPrefixOf(I2 = B.getInstance(component));
                if (!isPrefix) continue;
                System.out.println(String.valueOf(component) + ":" + this.name + " is a prefix of " + component + ":" + B.name);
            }
            if (!isPrefix) continue;
            retVal = true;
        }
        return retVal;
    }

    public StringMap BuildPrefixRelation(Set bMSCs) {
        StringMap H = new StringMap();
        Iterator J = this.instances.keySet().iterator();
        while (J.hasNext()) {
            String component = (String)J.next();
            Instance I = (Instance)this.instances.get(component);
            if (I.isEmpty()) {
                H.put(component, "E");
                continue;
            }
            Iterator K = bMSCs.iterator();
            boolean isPrefix = false;
            while (K.hasNext() && !isPrefix) {
                Instance I2;
                BasicMSC B = (BasicMSC)K.next();
                if (B == this || !I.isPrefixOf(I2 = B.getInstance(component))) continue;
                isPrefix = true;
                H.put(component, "P");
            }
            if (isPrefix) continue;
            H.put(component, "N");
        }
        return H;
    }

    public Instance getInstance(String Component2) {
        Iterator I = this.instances.keySet().iterator();
        while (I.hasNext()) {
            String lbl = (String)I.next();
            if (!lbl.equals(Component2)) continue;
            return (Instance)this.instances.get(lbl);
        }
        return null;
    }

    public void printLatex(MyOutput Out) {
        Out.println("\\begin{msc}{" + this.name.replace('_', '.') + "}");
        Iterator J = this.instances.keySet().iterator();
        while (J.hasNext()) {
            String component = (String)J.next();
            Out.println("\\declinst{" + component.replace('_', '.') + "}{}{" + component.replace('_', '.') + "}");
        }
        this.printLatexInstances(Out);
        Out.println("\\end{msc}");
        Out.println("");
        Out.println("");
        Out.println("");
        Out.println("");
    }

    public void printLatexInstances(MyOutput Out) {
        ListIterator i;
        int size = this.components().size();
        Vector<ListIterator> Instances = new Vector<ListIterator>(size);
        Vector<String> InstancesNames = new Vector<String>(size);
        Vector<Event> enabledEvents = new Vector<Event>(size);
        int index2 = 0;
        Instance Aux = new Instance();
        int InstancesFinished = 0;
        Event e1 = null;
        Event e2 = null;
        Iterator I = this.components().iterator();
        int index = 0;
        while (I.hasNext()) {
            String iname = (String)I.next();
            try {
                Aux = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {}
            InstancesNames.add(index, iname);
            Instances.add(index++, Aux.iterator());
        }
        index = 0;
        while (index < size) {
            i = (ListIterator)Instances.get(index);
            e1 = null;
            while (i.hasNext() && e1 == null) {
                e1 = (Event)i.next();
                if (!(e1 instanceof ConditionEvent)) continue;
                e1 = null;
            }
            enabledEvents.add(index, e1);
            if (e1 == null) {
                ++InstancesFinished;
            }
            ++index;
        }
        new HashSet();
        while (InstancesFinished < size) {
            boolean foundMatch = false;
            index = 0;
            while (index < size && !foundMatch) {
                e1 = (Event)enabledEvents.get(index);
                if (e1 != null) {
                    index2 = index + 1;
                    while (index2 < size && !foundMatch) {
                        e2 = (Event)enabledEvents.get(index2);
                        if (e2 != null && (foundMatch = e1.getLabel().equals(e2.getLabel()))) {
                            String from;
                            String to;
                            if (e2 instanceof OutputEvent) {
                                to = ((OutputEvent)e2).getTo();
                                from = ((InputEvent)e1).getFrom();
                            } else {
                                to = ((OutputEvent)e1).getTo();
                                from = ((InputEvent)e2).getFrom();
                            }
                            Out.println("\\mess{" + e2.getLabel().replace('_', '.') + "}{" + from.replace('_', '.') + "}{" + to.replace('_', '.') + "}");
                            Out.println("\\nextlevel");
                        }
                        ++index2;
                    }
                }
                ++index;
            }
            e1 = null;
            i = (ListIterator)Instances.get(index - 1);
            while (i.hasNext() && e1 == null) {
                e1 = (Event)i.next();
                if (!(e1 instanceof ConditionEvent)) continue;
                Out.println("\\condition{" + e1.getLabel().replace('_', '.') + "}{" + ((String)InstancesNames.get(index - 1)).replace('_', '.') + "}");
                Out.println("\\nextlevel[2]");
                e1 = null;
            }
            enabledEvents.set(index - 1, e1);
            if (e1 == null) {
                ++InstancesFinished;
            }
            e1 = null;
            i = (ListIterator)Instances.get(index2 - 1);
            while (i.hasNext() && e1 == null) {
                e1 = (Event)i.next();
                if (!(e1 instanceof ConditionEvent)) continue;
                Out.println("\\condition{" + e1.getLabel().replace('_', '.') + "}{" + ((String)InstancesNames.get(index2 - 1)).replace('_', '.') + "}");
                Out.println("\\nextlevel[2]");
                e1 = null;
            }
            enabledEvents.set(index2 - 1, e1);
            if (e1 != null) continue;
            ++InstancesFinished;
        }
    }

    public BasicMSC FindCutAndSplit(LTSOutput o, boolean l) throws Exception {
        last = l;
        int size = this.components().size();
        Vector<Instance> Instances = new Vector<Instance>(size);
        Vector<Event> enabledEvents = new Vector<Event>(size);
        Vector<String> Names = new Vector<String>(size);
        Vector<Integer> Pos = new Vector<Integer>(size);
        int index = 0;
        int InstancesFinished = 0;
        BasicMSC B = null;
        Iterator I = this.components().iterator();
        index = 0;
        while (I.hasNext()) {
            Instance Aux;
            String iname = (String)I.next();
            try {
                Aux = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Exception("Internal Consistency Error:" + ex.getMessage());
            }
            Names.add(index, iname);
            Pos.add(index, new Integer(0));
            Instances.add(index++, Aux);
        }
        index = 0;
        while (index < size) {
            Event e;
            Instance i = (Instance)Instances.get(index);
            int p = (Integer)Pos.get(index);
            if (p < i.size()) {
                e = i.get(p);
                Pos.set(index, new Integer(p + 1));
            } else {
                e = null;
            }
            enabledEvents.add(index, e);
            if (e == null) {
                ++InstancesFinished;
            }
            ++index;
        }
        if (this.FindNextCut(Instances, enabledEvents, Names, Pos, o)) {
            B = new BasicMSC();
            B.name = String.valueOf(this.name) + "_P";
            this.Split(B, Instances, Names, Pos, enabledEvents, o);
        }
        return B;
    }

    private boolean FindNextCut(Vector Instances, Vector enabledEvents, Vector Names, Vector Pos, LTSOutput o) throws Exception {
        int index = 0;
        int size = this.components().size();
        boolean Finished = false;
        boolean retVal = false;
        boolean FirstTime = true;
        boolean dbg = false;
        while (!Finished) {
            if (dbg) {
                o.outln("About to move forward");
            }
            if (this.MoveForwardUntilBlock(Instances, enabledEvents, Pos, o) || !FirstTime) {
                FirstTime = false;
                if (dbg) {
                    o.outln("Cut, end state, locked");
                }
                index = 0;
                while (index < size && enabledEvents.get(index) != null) {
                    ++index;
                }
                if (index < size) {
                    if (dbg) {
                        o.outln("Some instance is at its end.");
                    }
                    Finished = true;
                    retVal = false;
                    continue;
                }
                if (dbg) {
                    o.outln("Cut, locked");
                }
                boolean foundCut = true;
                Event e = null;
                index = 0;
                while (index < size && foundCut) {
                    e = (Event)enabledEvents.get(index);
                    foundCut = e != null ? e instanceof ConditionEvent : false;
                    ++index;
                }
                if (!foundCut) {
                    if (dbg) {
                        o.outln("locked");
                    }
                    if (e == null) {
                        if (dbg) {
                            o.outln(Names.get(index) + " is at the end. No cut is possible");
                        }
                        Finished = true;
                        retVal = false;
                        continue;
                    }
                    --index;
                    boolean readyToUnblock = false;
                    Event e2 = null;
                    int index2 = 0;
                    while (!readyToUnblock) {
                        if (e2 != null) {
                            index = index2;
                            e = e2;
                        }
                        if (dbg) {
                            o.outln(Names.get(index) + " has event " + e.getLabel() + " enabled");
                        }
                        String name = e instanceof OutputEvent ? ((OutputEvent)e).getTo() : ((InputEvent)e).getFrom();
                        index2 = 0;
                        while (!Names.get(index2).equals(name) && index2 < size) {
                            ++index2;
                        }
                        if (index2 == size) {
                            throw new InconsistentEvents("Inconsistency!");
                        }
                        if (dbg) {
                            o.outln("Event needs instance " + Names.get(index2) + " unblocked");
                        }
                        if ((e2 = (Event)enabledEvents.get(index2)) != null) {
                            readyToUnblock = e2 instanceof ConditionEvent;
                            continue;
                        }
                        throw new InconsistentEvents("Inconsistency1!");
                    }
                    if (dbg) {
                        o.outln("Unblocking instance " + index2);
                    }
                    if (this.MoveForward(Instances, Pos, enabledEvents, index2, o)) continue;
                    throw new InconsistentEvents("Inconsistency4!");
                }
                if (dbg) {
                    o.outln("Cut!");
                }
                Finished = true;
                retVal = true;
                continue;
            }
            if (dbg) {
                o.outln("Initial State is a cut");
            }
            FirstTime = false;
            boolean foundOneCut = false;
            Vector pairs = this.GetAllPairsThatCanBeUnblocked(Instances, Pos, enabledEvents, o);
            index = 0;
            while (index * 2 < pairs.size()) {
                Vector c_enabledEvents = (Vector)enabledEvents.clone();
                Vector c_Pos = (Vector)Pos.clone();
                if (!this.MoveForward(Instances, c_Pos, c_enabledEvents, (Integer)pairs.get(2 * index), o) || !this.MoveForward(Instances, c_Pos, c_enabledEvents, (Integer)pairs.get(2 * index + 1), o)) {
                    throw new InconsistentEvents("Inconsistency4!");
                }
                if (this.FindNextCut(Instances, c_enabledEvents, Names, c_Pos, o)) {
                    foundOneCut = true;
                    this.MoveForward(Instances, Pos, enabledEvents, (Integer)pairs.get(2 * index), o);
                    this.MoveForward(Instances, Pos, enabledEvents, (Integer)pairs.get(2 * index + 1), o);
                }
                ++index;
            }
            if (foundOneCut) continue;
            Finished = true;
            retVal = false;
        }
        return retVal;
    }

    private Vector GetAllPairsThatCanBeUnblocked(Vector Instances, Vector Pos, Vector enabledEvents, LTSOutput o) {
        Vector<Integer> pairs = new Vector<Integer>();
        int pos = 0;
        int index = 0;
        while (index < this.components().size()) {
            Event e1;
            Instance i;
            int p = (Integer)Pos.get(index);
            if (p < (i = (Instance)Instances.get(index)).size() && !((e1 = i.get(p)) instanceof ConditionEvent)) {
                int index2 = index + 1;
                while (index2 < this.components().size()) {
                    Event e2;
                    p = (Integer)Pos.get(index2);
                    if (p < (i = (Instance)Instances.get(index2)).size() && !((e2 = i.get(p)) instanceof ConditionEvent) && e1.getLabel().equals(e2.getLabel())) {
                        pairs.add(pos++, new Integer(index));
                        pairs.add(pos++, new Integer(index2));
                    }
                    ++index2;
                }
            }
            ++index;
        }
        return pairs;
    }

    public boolean MoveForwardUntilBlock(Vector Instances, Vector enabledEvents, Vector Pos, LTSOutput o) throws Exception {
        boolean foundMatch = true;
        boolean moved = false;
        while (foundMatch) {
            Vector TripleResult = this.FindMatch(this.components().size(), enabledEvents, o);
            int index = (Integer)TripleResult.get(0);
            int index2 = (Integer)TripleResult.get(1);
            boolean bl = foundMatch = (Integer)TripleResult.get(2) == 1;
            if (!foundMatch) continue;
            moved = true;
            this.MoveForward(Instances, Pos, enabledEvents, index, o);
            this.MoveForward(Instances, Pos, enabledEvents, index2, o);
        }
        return moved;
    }

    private Vector FindMatch(int size, Vector enabledEvents, LTSOutput o) {
        int index = 0;
        int index2 = 0;
        boolean dbg = false;
        boolean foundMatch = false;
        index = 0;
        while (index < size && !foundMatch) {
            Event e1 = (Event)enabledEvents.get(index);
            if (e1 != null && !(e1 instanceof ConditionEvent)) {
                index2 = index + 1;
                while (index2 < size && !foundMatch) {
                    Event e2 = (Event)enabledEvents.get(index2);
                    if (e2 != null && !(e2 instanceof ConditionEvent)) {
                        foundMatch = e1.getLabel().equals(e2.getLabel());
                        if (dbg && foundMatch) {
                            o.outln("Found match: " + index + " and " + index2 + " on label " + e1.getLabel());
                        }
                    }
                    ++index2;
                }
            }
            ++index;
        }
        Vector<Integer> retVal = new Vector<Integer>();
        retVal.add(0, new Integer(index - 1));
        retVal.add(1, new Integer(index2 - 1));
        if (foundMatch) {
            retVal.add(2, new Integer(1));
        } else {
            retVal.add(2, new Integer(0));
        }
        return retVal;
    }

    private boolean MoveForward(Vector Instances, Vector Pos, Vector enabledEvents, int index, LTSOutput o) {
        boolean dbg = false;
        if (dbg) {
            o.outln("Moving Forward. Index = " + index + ". Instaces.size = " + Instances.size());
        }
        Event e1 = null;
        Instance i = (Instance)Instances.get(index);
        int p = (Integer)Pos.get(index);
        if (p < i.size()) {
            e1 = i.get(p);
            Pos.set(index, new Integer(p + 1));
        } else {
            e1 = null;
        }
        enabledEvents.set(index, e1);
        return e1 != null;
    }

    private void Split(BasicMSC B, Vector Instances, Vector Names, Vector Pos, Vector enabledEvents, LTSOutput o) throws Exception {
        int inst = 0;
        while (inst < this.components().size()) {
            Instance Aux2;
            Instance NI = new Instance();
            B.addInstance((String)Names.get(inst), NI);
            Instance i = (Instance)Instances.get(inst);
            int p = (Integer)Pos.get(inst);
            if (enabledEvents.get(inst) != null) {
                NI.appendEvent((Event)enabledEvents.get(inst));
            }
            int tobedeleted = 0;
            while (p < i.size()) {
                ++tobedeleted;
                NI.appendEvent(i.get(p));
                ++p;
            }
            try {
                Aux2 = this.componentInstance((String)Names.get(inst));
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Exception("Internal Consistency Error:" + ex.getMessage());
            }
            Aux2.deleteLast(tobedeleted);
            ++inst;
        }
    }

    public boolean TrivialCut() throws Exception {
        boolean trivial = true;
        Iterator I = this.components().iterator();
        while (I.hasNext() && trivial) {
            Instance Aux;
            String iname = (String)I.next();
            try {
                Aux = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Exception("Internal Consistency Error:" + ex.getMessage());
            }
            trivial = false;
            if (Aux.size() != 1 || !(Aux.get(0) instanceof ConditionEvent)) continue;
            trivial = true;
        }
        return trivial;
    }

    public boolean isTheSameAs(BasicMSC B, LTSOutput o) throws Exception {
        Instance I1 = null;
        Instance I2 = null;
        boolean equal = true;
        boolean dbg = false;
        Iterator I = this.components().iterator();
        while (I.hasNext() && equal) {
            String n = (String)I.next();
            if (dbg) {
                o.outln("Checking component " + n);
            }
            try {
                I1 = this.componentInstance(n);
                I2 = B.componentInstance(n);
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Exception("Internal Consistency Error:" + ex.getMessage());
            }
            if (dbg && I1 == null) {
                o.outln(String.valueOf(this.name) + " does not have an Instance for that componment!");
            }
            if (dbg && I2 == null) {
                o.outln(String.valueOf(B.name) + "does not have an Instance for that componment!");
            }
            equal = I1.isTheSameAs(I2, o);
        }
        return equal;
    }

    public void AddScenarioEvents() {
        Iterator I = this.components().iterator();
        while (I.hasNext()) {
            String compname = (String)I.next();
            Instance Inst = (Instance)this.instances.get(compname);
            FSPLabel l = new FSPLabel();
            try {
                l.setComponentLabel(compname);
            }
            catch (Exception exception) {}
            OutputEvent c = new OutputEvent("s_" + l.getLabel() + "_" + this.name);
            c.setTo("Environment");
            Inst.insertEvent(c, 0);
        }
    }

    public void RemoveScenarioEvents(Set S) {
        Iterator I = this.components().iterator();
        while (I.hasNext()) {
            Instance Inst = (Instance)this.instances.get((String)I.next());
            int i = 0;
            while (i < Inst.size()) {
                Event e = Inst.get(i);
                if (e instanceof OutputEvent && ((OutputEvent)e).getTo().equals("Environment") && e.getLabel().substring(0, 2).equals("s_")) {
                    S.add(e.getLabel());
                    Inst.removeEvent(i);
                    --i;
                }
                ++i;
            }
        }
    }

    public void getScenarioEvents(Set S) {
        Iterator I = this.components().iterator();
        while (I.hasNext()) {
            Instance Inst = (Instance)this.instances.get((String)I.next());
            int i = 0;
            while (i < Inst.size()) {
                Event e = Inst.get(i);
                if (e instanceof OutputEvent && ((OutputEvent)e).getTo().equals("Environment") && e.getLabel().substring(0, 2).equals("s_")) {
                    S.add(e.getLabel());
                }
                ++i;
            }
        }
    }

    public void RemoveLabelsNotIn(StringSet s) {
        Iterator I = this.components().iterator();
        while (I.hasNext()) {
            Instance Inst = (Instance)this.instances.get((String)I.next());
            int i = 0;
            while (i < Inst.size()) {
                Event e = Inst.get(i);
                if (e instanceof ConditionEvent && !s.contains(e.getLabel())) {
                    Inst.removeEvent(i);
                    --i;
                }
                ++i;
            }
        }
    }

    public String showSequence() {
        ListIterator i;
        String Out = "";
        int size = this.components().size();
        Vector<ListIterator> Instances = new Vector<ListIterator>(size);
        Vector<String> InstancesNames = new Vector<String>(size);
        Vector<Event> enabledEvents = new Vector<Event>(size);
        int index2 = 0;
        Instance Aux = new Instance();
        int InstancesFinished = 0;
        Event e1 = null;
        Event e2 = null;
        Iterator I = this.components().iterator();
        int index = 0;
        while (I.hasNext()) {
            String iname = (String)I.next();
            try {
                Aux = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {}
            InstancesNames.add(index, iname);
            Instances.add(index++, Aux.iterator());
        }
        index = 0;
        while (index < size) {
            i = (ListIterator)Instances.get(index);
            e1 = null;
            while (i.hasNext() && e1 == null) {
                e1 = (Event)i.next();
                if (!(e1 instanceof ConditionEvent)) continue;
                e1 = null;
            }
            enabledEvents.add(index, e1);
            if (e1 == null) {
                ++InstancesFinished;
            }
            ++index;
        }
        new HashSet();
        while (InstancesFinished < size) {
            boolean foundMatch = false;
            index = 0;
            while (index < size && !foundMatch) {
                e1 = (Event)enabledEvents.get(index);
                if (e1 != null) {
                    index2 = index + 1;
                    while (index2 < size && !foundMatch) {
                        e2 = (Event)enabledEvents.get(index2);
                        if (e2 != null && (foundMatch = e1.getLabel().equals(e2.getLabel()))) {
                            if (e2 instanceof OutputEvent) {
                                ((OutputEvent)e2).getTo();
                                ((InputEvent)e1).getFrom();
                            } else {
                                ((OutputEvent)e1).getTo();
                                ((InputEvent)e2).getFrom();
                            }
                            Out = String.valueOf(Out) + e2.getLabel() + ", ";
                        }
                        ++index2;
                    }
                }
                ++index;
            }
            e1 = null;
            i = (ListIterator)Instances.get(index - 1);
            while (i.hasNext() && e1 == null) {
                e1 = (Event)i.next();
                if (!(e1 instanceof ConditionEvent)) continue;
                e1 = null;
            }
            enabledEvents.set(index - 1, e1);
            if (e1 == null) {
                ++InstancesFinished;
            }
            e1 = null;
            i = (ListIterator)Instances.get(index2 - 1);
            while (i.hasNext() && e1 == null) {
                e1 = (Event)i.next();
                if (!(e1 instanceof ConditionEvent)) continue;
                e1 = null;
            }
            enabledEvents.set(index2 - 1, e1);
            if (e1 != null) continue;
            ++InstancesFinished;
        }
        return Out;
    }

    public Set getAllTraces(LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("Getting traces");
        }
        HashSet Traces = new HashSet();
        int size = this.components().size();
        Vector<Instance> Instances = new Vector<Instance>(size);
        Vector<Event> enabledEvents = new Vector<Event>(size);
        Vector<String> Names = new Vector<String>(size);
        Vector<Integer> Pos = new Vector<Integer>(size);
        int index = 0;
        int InstancesFinished = 0;
        Iterator I = this.components().iterator();
        index = 0;
        while (I.hasNext()) {
            Instance Aux;
            String iname = (String)I.next();
            try {
                Aux = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Exception("Internal Consistency Error:" + ex.getMessage());
            }
            Names.add(index, iname);
            Pos.add(index, new Integer(0));
            Instances.add(index++, Aux);
        }
        index = 0;
        while (index < size) {
            Event e;
            Instance i = (Instance)Instances.get(index);
            int p = (Integer)Pos.get(index);
            if (p < i.size()) {
                e = i.get(p);
                Pos.set(index, new Integer(p + 1));
            } else {
                e = null;
            }
            enabledEvents.add(index, e);
            if (e == null) {
                ++InstancesFinished;
            }
            ++index;
        }
        Trace t = new Trace();
        new HashMap();
        this.getTrace(Traces, t, Instances, enabledEvents, Names, Pos, o);
        return Traces;
    }

    private boolean getTrace(Set Traces, Trace t, Vector Instances, Vector enabledEvents, Vector Names, Vector Pos, LTSOutput o) throws Exception {
        Vector pairs;
        int index = 0;
        int size = this.components().size();
        boolean retVal = false;
        boolean dbg = false;
        if (dbg) {
            o.outln("Printing Trace");
        }
        if ((pairs = this.GetAllPairsThatCanBeMoved(size, enabledEvents, o)).size() == 0) {
            Traces.add(t);
        } else {
            index = 0;
            while (index * 2 < pairs.size()) {
                Vector c_enabledEvents = (Vector)enabledEvents.clone();
                Vector c_Pos = (Vector)Pos.clone();
                Event e1 = (Event)c_enabledEvents.get((Integer)pairs.get(2 * index));
                Event e2 = (Event)c_enabledEvents.get((Integer)pairs.get(2 * index + 1));
                if (dbg) {
                    o.outln("About to move forward Indexes " + (Integer)pairs.get(2 * index) + ", " + (Integer)pairs.get(2 * index + 1) + ". Label " + e1.getLabel() + e2.getLabel());
                }
                this.MoveForward(Instances, c_Pos, c_enabledEvents, (Integer)pairs.get(2 * index), o);
                this.MoveForward(Instances, c_Pos, c_enabledEvents, (Integer)pairs.get(2 * index + 1), o);
                if (dbg) {
                    o.outln("Moved forward...");
                }
                Trace TraceCopy = t.myClone();
                if (dbg) {
                    o.outln("cloned...");
                }
                if (e1 instanceof OutputEvent) {
                    TraceCopy.add(e1.getLabel());
                } else {
                    TraceCopy.add(e2.getLabel());
                }
                if (dbg) {
                    o.outln("recursive call...");
                }
                this.getTrace(Traces, TraceCopy, Instances, c_enabledEvents, Names, c_Pos, o);
                ++index;
            }
        }
        return retVal;
    }

    private Vector GetAllPairsThatCanBeMoved(int size, Vector enabledEvents, LTSOutput o) {
        int index = 0;
        int index2 = 0;
        int pos = 0;
        Vector<Integer> pairs = new Vector<Integer>();
        boolean dbg = false;
        index = 0;
        while (index < size) {
            Event e1 = (Event)enabledEvents.get(index);
            if (e1 != null && !(e1 instanceof ConditionEvent)) {
                index2 = index + 1;
                while (index2 < size) {
                    Event e2 = (Event)enabledEvents.get(index2);
                    if (e2 != null && !(e2 instanceof ConditionEvent) && e1.getLabel().equals(e2.getLabel())) {
                        if (dbg) {
                            o.outln("Indexes " + index + ", " + index2 + ". Label " + e1.getLabel());
                        }
                        pairs.add(pos++, new Integer(index));
                        pairs.add(pos++, new Integer(index2));
                    }
                    ++index2;
                }
            }
            ++index;
        }
        return pairs;
    }

    public Set getFirstMoves(LTSOutput o) throws Exception {
        boolean dbg = false;
        StringSet Labels = new StringSet();
        HashSet Moves = new HashSet();
        int size = this.components().size();
        Vector<Instance> Instances = new Vector<Instance>(size);
        Vector<Event> enabledEvents = new Vector<Event>(size);
        Vector<String> Names = new Vector<String>(size);
        Vector<Integer> Pos = new Vector<Integer>(size);
        int index = 0;
        int InstancesFinished = 0;
        Iterator I = this.components().iterator();
        index = 0;
        while (I.hasNext()) {
            Instance Aux;
            String iname = (String)I.next();
            try {
                Aux = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Exception("Internal Consistency Error:" + ex.getMessage());
            }
            Names.add(index, iname);
            Pos.add(index, new Integer(0));
            Instances.add(index++, Aux);
        }
        index = 0;
        while (index < size) {
            Event e;
            Instance i = (Instance)Instances.get(index);
            int p = (Integer)Pos.get(index);
            if (p < i.size()) {
                e = i.get(p);
                Pos.set(index, new Integer(p + 1));
            } else {
                e = null;
            }
            enabledEvents.add(index, e);
            if (e == null) {
                ++InstancesFinished;
            }
            ++index;
        }
        Vector pairs = this.GetAllPairsThatCanBeMoved(size, enabledEvents, o);
        index = 0;
        while (index * 2 < pairs.size()) {
            Integer FirstInt = (Integer)pairs.get(2 * index);
            Integer SecondInt = (Integer)pairs.get(2 * index + 1);
            Event e = (Event)enabledEvents.get(FirstInt);
            String label = e.getLabel();
            if (dbg) {
                o.outln("Adding vector " + FirstInt + ", " + label + ", " + SecondInt);
            }
            if (!Labels.contains(label)) {
                Labels.add(label);
                Vector<String> v = new Vector<String>(3);
                if (e instanceof OutputEvent) {
                    v.add(0, (String)Names.get(FirstInt));
                    v.add(1, label);
                    v.add(2, (String)Names.get(SecondInt));
                } else {
                    v.add(0, (String)Names.get(SecondInt));
                    v.add(1, label);
                    v.add(2, (String)Names.get(FirstInt));
                }
                Moves.add(v);
            }
            ++index;
        }
        return Moves;
    }

    public boolean hasCommonFirstMoves(BasicMSC b, LTSOutput o) throws Exception {
        Set S1 = this.getFirstMoves(o);
        Set S2 = b.getFirstMoves(o);
        Iterator I1 = S1.iterator();
        while (I1.hasNext()) {
            Vector v1 = (Vector)I1.next();
            String s1 = (String)v1.get(1);
            Iterator I2 = S2.iterator();
            while (I2.hasNext()) {
                Vector v2 = (Vector)I2.next();
                String s2 = (String)v2.get(1);
                if (!s1.equals(s2)) continue;
                o.outln("Common intial message found: " + s1);
                return true;
            }
        }
        return false;
    }

    public Set getLastMoves(LTSOutput o) throws Exception {
        boolean dbg = false;
        StringSet Labels = new StringSet();
        HashSet Moves = new HashSet();
        int size = this.components().size();
        Vector<Instance> Instances = new Vector<Instance>(size);
        Vector<Event> enabledEvents = new Vector<Event>(size);
        Vector<String> Names = new Vector<String>(size);
        Vector<Integer> Pos = new Vector<Integer>(size);
        int index = 0;
        int InstancesFinished = 0;
        if (dbg) {
            o.outln("Fill vectors: Names, Pos, Instances");
        }
        Iterator I = this.components().iterator();
        index = 0;
        while (I.hasNext()) {
            Instance Aux;
            String iname = (String)I.next();
            try {
                Aux = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Exception("Internal Consistency Error:" + ex.getMessage());
            }
            Names.add(index, iname);
            Pos.add(index, new Integer(Aux.size() - 1));
            Instances.add(index++, Aux);
        }
        if (dbg) {
            o.outln("Create enabledEvents and update InstancesFinished");
        }
        index = 0;
        while (index < size) {
            Event e;
            Instance i = (Instance)Instances.get(index);
            int p = (Integer)Pos.get(index);
            if (p >= 0) {
                e = i.get(p);
                Pos.set(index, new Integer(p - 1));
            } else {
                e = null;
            }
            enabledEvents.add(index, e);
            if (e == null) {
                ++InstancesFinished;
            }
            ++index;
        }
        if (dbg) {
            o.outln("GetAllPairsThatCanBeMoved");
        }
        Vector pairs = this.GetAllPairsThatCanBeMoved(size, enabledEvents, o);
        index = 0;
        while (index * 2 < pairs.size()) {
            Integer FirstInt = (Integer)pairs.get(2 * index);
            Integer SecondInt = (Integer)pairs.get(2 * index + 1);
            Event e = (Event)enabledEvents.get(FirstInt);
            String label = e.getLabel();
            if (dbg) {
                o.outln("Adding vector " + FirstInt + ", " + label + ", " + SecondInt);
            }
            if (!Labels.contains(label)) {
                Labels.add(label);
                Vector<String> v = new Vector<String>(3);
                if (e instanceof OutputEvent) {
                    v.add(0, (String)Names.get(FirstInt));
                    v.add(1, label);
                    v.add(2, (String)Names.get(SecondInt));
                } else {
                    v.add(0, (String)Names.get(SecondInt));
                    v.add(1, label);
                    v.add(2, (String)Names.get(FirstInt));
                }
                Moves.add(v);
            }
            ++index;
        }
        return Moves;
    }

    public boolean hasPostponableMessage(BasicMSC B, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("hasPostponableMessages?");
        }
        Set LastMoves = this.getLastMoves(o);
        if (dbg) {
            o.outln("Got Last moves:" + LastMoves.size());
        }
        Set FirstMoves = B.getFirstMoves(o);
        if (dbg) {
            o.outln("Got First moves:" + FirstMoves.size());
        }
        Iterator LM = LastMoves.iterator();
        boolean found = false;
        while (LM.hasNext() && !found) {
            Vector move = (Vector)LM.next();
            String C1 = (String)move.get(0);
            String label = (String)move.get(1);
            String C2 = (String)move.get(2);
            Iterator FM = FirstMoves.iterator();
            if (dbg) {
                o.outln("Got " + label + ", comparing");
            }
            while (FM.hasNext() && !found) {
                Vector m = (Vector)FM.next();
                if (dbg) {
                    o.outln("Got " + (String)m.get(1));
                }
                if (C1.equals((String)m.get(0)) || C1.equals((String)m.get(2)) || C2.equals((String)m.get(0)) || C2.equals((String)m.get(2))) continue;
                found = true;
            }
        }
        return found;
    }

    public Vector getIdOfLastMessage(String C1, String label, String C2) {
        Instance I1 = this.getInstance(C1);
        Instance I2 = this.getInstance(C2);
        Vector<Integer> v = new Vector<Integer>(2);
        v.add(0, new Integer(I1.getIdOfLast()));
        v.add(1, new Integer(I2.getIdOfLast()));
        return v;
    }

    public void removeLastMessage(String C1, String label, String C2) {
        Instance I1 = this.getInstance(C1);
        Instance I2 = this.getInstance(C2);
        I1.deleteLast(1);
        I2.deleteLast(1);
    }

    public boolean PartitionVerticaly(Set Partitions, LTSOutput o) {
        boolean dbg = false;
        HashSet<String> NotProcessed = new HashSet<String>();
        Iterator Aux = this.instances.keySet().iterator();
        while (Aux.hasNext()) {
            NotProcessed.add((String)Aux.next());
        }
        while (NotProcessed.size() != 0) {
            Iterator J = NotProcessed.iterator();
            String Comp = (String)J.next();
            StringSet Partition = new StringSet();
            Partitions.add(Partition);
            Partition.add(Comp);
            NotProcessed.remove(Comp);
            if (dbg) {
                o.outln("New Partition, added " + Comp);
            }
            boolean added = true;
            while (added) {
                added = false;
                Iterator I = Partition.iterator();
                while (I.hasNext() && !added) {
                    Instance Inst = this.getInstance((String)I.next());
                    int i = 0;
                    while (i < Inst.size()) {
                        String SAux = ((MessageEvent)Inst.get(i)).getToFrom();
                        if (!Partition.contains(SAux)) {
                            added = true;
                            Partition.add(SAux);
                            NotProcessed.remove(SAux);
                            if (dbg) {
                                o.outln("added " + SAux);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        int NonTrivialPartitions = 0;
        Iterator J = Partitions.iterator();
        while (J.hasNext()) {
            if (((Set)J.next()).size() <= 1) continue;
            ++NonTrivialPartitions;
        }
        return NonTrivialPartitions > 1;
    }

    boolean OverlapsPartition(Set Partition) {
        Iterator I = Partition.iterator();
        while (I.hasNext()) {
            String instName = (String)I.next();
            Instance Inst = this.getInstance(instName);
            if (Inst.size() <= 0) continue;
            return true;
        }
        return false;
    }

    boolean IndependentMessage(Set Partition) {
        Iterator I = this.instances.keySet().iterator();
        while (I.hasNext()) {
            String instName = (String)I.next();
            if (Partition.contains(instName)) continue;
            Instance Inst = this.getInstance(instName);
            int i = 0;
            while (i < Inst.size()) {
                String SAux = ((MessageEvent)Inst.get(i)).getToFrom();
                if (!Partition.contains(SAux)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean IsIndependent(BasicMSC B, LTSOutput o) {
        o.outln("C1");
        StringSet C1 = this.getActiveComponents(o);
        o.outln("C2");
        StringSet C2 = B.getActiveComponents(o);
        return C1.intersection(C2).size() == 0;
    }

    public StringSet getActiveComponents(LTSOutput o) {
        StringSet RetVal = new StringSet();
        Iterator I = this.instances.keySet().iterator();
        while (I.hasNext()) {
            String instName = (String)I.next();
            if (this.getInstance(instName).size() <= 0) continue;
            o.outln(instName);
            RetVal.add(instName);
        }
        return RetVal;
    }

    BasicMSC getPostponables(BasicMSC B, LTSOutput o) throws Exception {
        boolean dbg = false;
        BasicMSC P_B = (BasicMSC)B.clone();
        BasicMSC A_P = (BasicMSC)this.clone();
        BasicMSC P = new BasicMSC();
        P.copyComponents(B);
        boolean found = true;
        while (found) {
            found = false;
            Set LastMoves = A_P.getLastMoves(o);
            Set FirstMoves = P_B.getFirstMoves(o);
            Iterator LM = LastMoves.iterator();
            while (LM.hasNext() && !found) {
                Vector move = (Vector)LM.next();
                String C1 = (String)move.get(0);
                String label = (String)move.get(1);
                String C2 = (String)move.get(2);
                Iterator FM = FirstMoves.iterator();
                while (FM.hasNext() && !found) {
                    Vector m = (Vector)FM.next();
                    if (C1.equals((String)m.get(0)) || C1.equals((String)m.get(2)) || C2.equals((String)m.get(0)) || C2.equals((String)m.get(2))) continue;
                    if (dbg) {
                        o.outln("Found postponable action " + label);
                    }
                    A_P.removeLastMessage(C1, label, C2);
                    P_B.addMessage(C1, label, C2);
                    P.addMessage(C1, label, C2);
                    found = true;
                }
            }
        }
        return P;
    }

    public boolean hasEventId(int Id) {
        Iterator I = this.components().iterator();
        while (I.hasNext()) {
            Instance Inst = (Instance)this.instances.get((String)I.next());
            int i = 0;
            while (i < Inst.size()) {
                Event e = Inst.get(i);
                if (e.Id == Id) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Map getDependencies(LTSOutput o) {
        ListIterator i;
        if (this.SavedDependencies != null) {
            return this.SavedDependencies;
        }
        boolean dbg = false;
        int size = this.components().size();
        Vector<ListIterator> Instances = new Vector<ListIterator>(size);
        Vector<StringSet> Dependencies = new Vector<StringSet>(size);
        Vector<String> InstanceNames = new Vector<String>(size);
        Vector<Event> enabledEvents = new Vector<Event>(size);
        int index2 = 0;
        int InstancesFinished = 0;
        Event e1 = null;
        Event e2 = null;
        if (dbg) {
            o.outln("//Create Listiterators for instances");
        }
        Iterator I = this.components().iterator();
        int index = 0;
        while (I.hasNext()) {
            Instance Aux;
            String iname = (String)I.next();
            try {
                Aux = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Error("Internal Consistency Error:" + ex.getMessage());
            }
            InstanceNames.add(index, iname);
            StringSet StSetAux = new StringSet();
            StSetAux.add(iname);
            Dependencies.add(index, StSetAux);
            Instances.add(index++, Aux.iterator());
        }
        if (dbg) {
            o.outln("//Create enabledEvents");
        }
        index = 0;
        while (index < size) {
            i = (ListIterator)Instances.get(index);
            e1 = null;
            while (i.hasNext() && e1 == null) {
                e1 = (Event)i.next();
                if (!(e1 instanceof ConditionEvent)) continue;
                e1 = null;
            }
            enabledEvents.add(index, e1);
            if (e1 == null) {
                ++InstancesFinished;
            }
            ++index;
        }
        while (InstancesFinished < size) {
            boolean foundMatch = false;
            index = 0;
            while (index < size && !foundMatch) {
                e1 = (Event)enabledEvents.get(index);
                if (e1 != null) {
                    index2 = index + 1;
                    while (index2 < size && !foundMatch) {
                        e2 = (Event)enabledEvents.get(index2);
                        if (e2 != null) {
                            foundMatch = e1.getLabel().equals(e2.getLabel());
                        }
                        ++index2;
                    }
                }
                ++index;
            }
            if (foundMatch) {
                if (dbg) {
                    o.outln("1");
                }
                ((Set)Dependencies.get(index - 1)).add(InstanceNames.get(index2 - 1));
                ((Set)Dependencies.get(index2 - 1)).add(InstanceNames.get(index - 1));
                if (dbg) {
                    o.outln("2");
                }
                ((Set)Dependencies.get(index - 1)).addAll((Set)Dependencies.get(index2 - 1));
                ((Set)Dependencies.get(index2 - 1)).addAll((Set)Dependencies.get(index - 1));
                if (dbg) {
                    o.outln("3");
                }
                e1 = null;
                i = (ListIterator)Instances.get(index - 1);
                while (i.hasNext() && e1 == null) {
                    e1 = (Event)i.next();
                    if (!(e1 instanceof ConditionEvent)) continue;
                    e1 = null;
                }
                enabledEvents.set(index - 1, e1);
                if (e1 == null) {
                    ++InstancesFinished;
                }
                e1 = null;
                i = (ListIterator)Instances.get(index2 - 1);
                while (i.hasNext() && e1 == null) {
                    e1 = (Event)i.next();
                    if (!(e1 instanceof ConditionEvent)) continue;
                    e1 = null;
                }
                enabledEvents.set(index2 - 1, e1);
                if (e1 != null) continue;
                ++InstancesFinished;
                continue;
            }
            String Message = "";
            index = 0;
            while (index < size) {
                Message = (Event)enabledEvents.get(index) != null ? String.valueOf(Message) + ((Event)enabledEvents.get(index)).getLabel() : String.valueOf(Message) + "-";
                if (index + 1 < size) {
                    Message = String.valueOf(Message) + ", ";
                }
                ++index;
            }
            throw new Error("Inconsistent events in bMSC " + this.name + ". Impossible to pair one of the following event labels " + Message);
        }
        if (dbg) {
            o.outln("5");
        }
        HashMap ret = new HashMap();
        int c = 0;
        while (c < size) {
            ret.put(InstanceNames.get(c), Dependencies.get(c));
            ++c;
        }
        this.SavedDependencies = ret;
        return this.SavedDependencies;
    }

    public Map getCanFinishBefore(LTSOutput o) {
        boolean dbg = false;
        boolean dbg2 = false;
        if (dbg) {
            o.outln("//getCanfinishBefore");
        }
        if (this.SavedCanFinishBefore != null) {
            return this.SavedCanFinishBefore;
        }
        int size = this.components().size();
        Vector<StringSet> Dependencies = new Vector<StringSet>(size);
        Vector<String> InstanceNames = new Vector<String>(size);
        if (dbg) {
            o.outln("//Create Listiterators for instances");
        }
        Iterator I = this.components().iterator();
        int index = 0;
        while (I.hasNext()) {
            String iname = (String)I.next();
            InstanceNames.add(index, iname);
            StringSet StSetAux = new StringSet();
            Dependencies.add(index++, StSetAux);
        }
        int c = 0;
        while (c < size) {
            String DependsOn = (String)InstanceNames.get(c);
            StringSet Visited = (StringSet)Dependencies.get(c);
            boolean Cont = true;
            while (Cont) {
                Visited.add(DependsOn);
                DependsOn = this.getLastDependency(DependsOn, o);
                if (DependsOn == null) {
                    Cont = false;
                    continue;
                }
                if (!Visited.contains(DependsOn)) continue;
                Cont = false;
            }
            if (Visited.size() == 1) {
                Visited.addAll((Collection)this.components());
            }
            ++c;
        }
        HashMap ret = new HashMap();
        int c2 = 0;
        while (c2 < size) {
            ret.put(InstanceNames.get(c2), Dependencies.get(c2));
            if (dbg2) {
                o.outln("Canfinishbefore for " + InstanceNames.get(c2) + " in " + this.name);
            }
            if (dbg2) {
                ((StringSet)Dependencies.get(c2)).print(o);
            }
            ++c2;
        }
        this.SavedCanFinishBefore = ret;
        return this.SavedCanFinishBefore;
    }

    public String getLastDependency(String Component2, LTSOutput o) {
        ListIterator i;
        boolean dbg = false;
        boolean dbg2 = false;
        if (dbg2) {
            o.outln("Get Last Dependency for " + Component2 + " in " + this.name);
        }
        if (this.SavedLastDependencies != null) {
            return (String)this.SavedLastDependencies.get(Component2);
        }
        int size = this.components().size();
        Vector<ListIterator> Instances = new Vector<ListIterator>(size);
        Vector<String> Dependencies = new Vector<String>(size);
        Vector<String> InstanceNames = new Vector<String>(size);
        Vector<Event> enabledEvents = new Vector<Event>(size);
        int index2 = 0;
        int InstancesFinished = 0;
        Event e1 = null;
        Event e2 = null;
        if (dbg) {
            o.outln("//Create Listiterators for instances");
        }
        Iterator I = this.components().iterator();
        int index = 0;
        while (I.hasNext()) {
            Instance Aux;
            String iname = (String)I.next();
            try {
                Aux = this.componentInstance(iname);
            }
            catch (ComponentInstanceNotFound ex) {
                throw new Error("Internal Consistency Error:" + ex.getMessage());
            }
            InstanceNames.add(index, iname);
            Dependencies.add(index, null);
            if (Component2.equals(iname)) {
            }
            Instances.add(index++, Aux.iterator());
        }
        if (dbg) {
            o.outln("//Create enabledEvents");
        }
        index = 0;
        while (index < size) {
            i = (ListIterator)Instances.get(index);
            e1 = null;
            while (i.hasNext() && e1 == null) {
                e1 = (Event)i.next();
                if (!(e1 instanceof ConditionEvent)) continue;
                e1 = null;
            }
            enabledEvents.add(index, e1);
            if (e1 == null) {
                ++InstancesFinished;
            }
            ++index;
        }
        while (InstancesFinished < size) {
            boolean foundMatch = false;
            index = 0;
            while (index < size && !foundMatch) {
                e1 = (Event)enabledEvents.get(index);
                if (e1 != null) {
                    index2 = index + 1;
                    while (index2 < size && !foundMatch) {
                        e2 = (Event)enabledEvents.get(index2);
                        if (e2 != null) {
                            foundMatch = e1.getLabel().equals(e2.getLabel());
                        }
                        ++index2;
                    }
                }
                ++index;
            }
            if (foundMatch) {
                Dependencies.set(index - 1, (String)InstanceNames.get(index2 - 1));
                Dependencies.set(index2 - 1, (String)InstanceNames.get(index - 1));
                e1 = null;
                i = (ListIterator)Instances.get(index - 1);
                while (i.hasNext() && e1 == null) {
                    e1 = (Event)i.next();
                    if (!(e1 instanceof ConditionEvent)) continue;
                    e1 = null;
                }
                enabledEvents.set(index - 1, e1);
                if (e1 == null) {
                    ++InstancesFinished;
                }
                e1 = null;
                i = (ListIterator)Instances.get(index2 - 1);
                while (i.hasNext() && e1 == null) {
                    e1 = (Event)i.next();
                    if (!(e1 instanceof ConditionEvent)) continue;
                    e1 = null;
                }
                enabledEvents.set(index2 - 1, e1);
                if (e1 != null) continue;
                ++InstancesFinished;
                continue;
            }
            String Message = "";
            index = 0;
            while (index < size) {
                Message = (Event)enabledEvents.get(index) != null ? String.valueOf(Message) + ((Event)enabledEvents.get(index)).getLabel() : String.valueOf(Message) + "-";
                if (index + 1 < size) {
                    Message = String.valueOf(Message) + ", ";
                }
                ++index;
            }
            throw new Error("Inconsistent events in bMSC " + this.name + ". Impossible to pair one of the following event labels " + Message);
        }
        if (dbg) {
            o.outln("5");
        }
        HashMap ret = new HashMap();
        int c = 0;
        while (c < size) {
            ret.put(InstanceNames.get(c), Dependencies.get(c));
            if (dbg2) {
                o.outln(InstanceNames.get(c) + " depends on " + Dependencies.get(c));
            }
            ++c;
        }
        this.SavedLastDependencies = ret;
        return (String)this.SavedLastDependencies.get(Component2);
    }
}

