/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import synthesis.BasicMSC;
import synthesis.StringSet;

public class Node {
    public int Id;
    private ArrayList History;
    private Vector Positions;
    private int first;
    private int size;
    private Vector bMSCPositions;

    private Node() {
    }

    private void setLocation(int c, BasicMSC b) {
        this.bMSCPositions.set(c, b);
    }

    private void setPosition(int c, int p) {
        this.Positions.set(c, new Integer(p));
    }

    public BasicMSC getLocation(int c) {
        return (BasicMSC)this.bMSCPositions.get(c);
    }

    private int getPosition(int c) {
        return (Integer)this.Positions.get(c);
    }

    public int SizeOfDestiny() {
        return 1 + this.first;
    }

    public Node(int s, BasicMSC Init) {
        this.size = s;
        this.History = new ArrayList();
        this.Positions = new Vector(this.size);
        this.bMSCPositions = new Vector(this.size);
        this.first = 0;
        this.History.add(this.first, Init);
        int i = 0;
        while (i < this.size) {
            this.Positions.add(i, new Integer(0));
            this.bMSCPositions.add(i, Init);
            ++i;
        }
    }

    public void print(LTSOutput o) {
        String line = "Node : " + this.Id + " History : ";
        int i = 0;
        while (i < this.History.size()) {
            line = String.valueOf(line) + ((BasicMSC)this.History.get((int)i)).name + ", ";
            ++i;
        }
        o.outln(line);
        line = "";
        i = 0;
        while (i < this.size) {
            line = String.valueOf(line) + this.getPosition(i) + ", ";
            ++i;
        }
        o.outln(line);
        line = "";
        i = 0;
        while (i < this.size) {
            line = String.valueOf(line) + this.getLocation((int)i).name + ", ";
            ++i;
        }
        o.outln(line);
    }

    public boolean Move(int c, Map Components, PrintStream BenchmarkOutput, LTSOutput o) {
        int i;
        boolean dbg = false;
        boolean retVal = false;
        int myPos = this.getPosition(c);
        BasicMSC NewLocation = (BasicMSC)this.History.get(myPos + 1);
        if (this.isFirst(c)) {
            throw new Error();
        }
        if (dbg) {
            o.outln("Checking if valid");
        }
        retVal = this.validMove(c, NewLocation, Components, BenchmarkOutput, o);
        if (dbg) {
            o.outln("Valid");
        }
        boolean found0 = false;
        if (myPos == 0) {
            i = 0;
            while (i < this.size && !found0) {
                if (i != c) {
                    found0 = this.getPosition(i) == 0;
                }
                ++i;
            }
        }
        if (myPos == 0 && !found0) {
            i = 0;
            while (i < this.size) {
                if (i != c) {
                    this.setPosition(i, this.getPosition(i) - 1);
                }
                ++i;
            }
            this.History.remove(0);
            this.setLocation(c, (BasicMSC)this.History.get(0));
            --this.first;
        } else {
            this.setPosition(c, ++myPos);
            this.setLocation(c, NewLocation);
        }
        return retVal;
    }

    public boolean Move(int c, BasicMSC b, Map Components, PrintStream BenchmarkOutput, LTSOutput o) {
        boolean dbg = false;
        boolean retVal = false;
        if (!this.isFirst(c)) {
            throw new Error();
        }
        if (dbg) {
            o.outln("Checking if valid " + c + " - " + b.name);
        }
        retVal = this.validMove(c, b, Components, BenchmarkOutput, o);
        if (dbg) {
            o.outln("Valid");
        }
        ++this.first;
        this.History.add(this.first, b);
        this.setPosition(c, this.first);
        this.setLocation(c, b);
        return retVal;
    }

    public boolean isFirst(int c) {
        return this.getPosition(c) == this.first;
    }

    public Node Clone() {
        Node N = new Node();
        N.first = this.first;
        N.size = this.size;
        N.Positions = (Vector)this.Positions.clone();
        N.bMSCPositions = (Vector)this.bMSCPositions.clone();
        N.History = (ArrayList)this.History.clone();
        return N;
    }

    private boolean equalLocations(Node N) {
        boolean equals = true;
        int i = 0;
        while (i < this.size && equals) {
            equals = this.getLocation(i) == N.getLocation(i);
            ++i;
        }
        return equals;
    }

    private boolean equalPositions(Node N) {
        boolean equals = true;
        int i = 0;
        while (i < this.size && equals) {
            equals = this.getPosition(i) == N.getPosition(i);
            ++i;
        }
        return equals;
    }

    private boolean equalHistory(Node N) {
        boolean equals = true;
        if (this.History.size() != N.History.size()) {
            return false;
        }
        int i = 0;
        while (i < this.History.size() && equals) {
            equals = this.History.get(i) == N.History.get(i);
            ++i;
        }
        return equals;
    }

    public boolean Equals(Node N) {
        if (!this.equalLocations(N)) {
            return false;
        }
        if (!this.equalPositions(N)) {
            return false;
        }
        if (!this.equalHistory(N)) {
            return false;
        }
        return this.first == N.first && this.size == N.size;
    }

    public Node eliminateLoop(LTSOutput o) {
        boolean dbg = false;
        int p1 = 0;
        while (p1 <= this.first) {
            BasicMSC b = (BasicMSC)this.History.get(p1);
            int p2 = p1 + 1;
            while (p2 <= this.first) {
                if ((BasicMSC)this.History.get(p2) == b) {
                    boolean EmptyLoop = true;
                    int check = 0;
                    while (check < this.size && EmptyLoop) {
                        EmptyLoop = this.getPosition(check) < p1 || this.getPosition(check) >= p2;
                        ++check;
                    }
                    if (EmptyLoop) {
                        Node NewShort;
                        Node Short = this.Clone();
                        int dif = p2 - p1;
                        int i = 0;
                        while (i < this.size) {
                            if (this.getPosition(i) >= p2) {
                                int newPos = this.getPosition(i) - dif;
                                Short.setPosition(i, newPos);
                            }
                            ++i;
                        }
                        Short.first = this.first - dif;
                        i = 0;
                        while (i < dif) {
                            Short.History.remove(p1);
                            ++i;
                        }
                        if (dbg) {
                            o.outln("Eliminated loop!!");
                        }
                        if (dbg) {
                            this.print(o);
                        }
                        if (dbg) {
                            Short.print(o);
                        }
                        if ((NewShort = Short.eliminateLoop(o)) == null) {
                            return Short;
                        }
                        return NewShort;
                    }
                }
                ++p2;
            }
            ++p1;
        }
        return null;
    }

    private boolean validMove(int c, BasicMSC b, Map Components, PrintStream BenchmarkOutput, LTSOutput o) {
        boolean dbg = false;
        boolean benchmark = BenchmarkOutput != null;
        boolean do1 = true;
        boolean do2 = true;
        boolean do3 = false;
        boolean do4 = true;
        boolean do5 = true;
        boolean do6 = true;
        if (benchmark) {
            boolean b1 = this.validMove1(c, Components, o);
            boolean b2 = this.validMove2(c, Components, o);
            boolean b3 = true;
            boolean b4 = this.validMove4(c, Components, o);
            boolean b5 = this.validMove5(c, Components, o);
            boolean b6 = this.validMove6(c, Components, o);
            BenchmarkOutput.println(String.valueOf(b1) + "," + b2 + "," + b3 + "," + b4 + "," + b5 + "," + b5);
            return b1 && b2 && b3 && b4 && b5 && b6;
        }
        if (!do1 || this.validMove1(c, Components, o)) {
            if (!do2 || this.validMove2(c, Components, o)) {
                if (!do3 || this.validMove3(c, Components, o)) {
                    if (!do4 || this.validMove4(c, Components, o)) {
                        if (!do5 || this.validMove5(c, Components, o)) {
                            if (!do6 || this.validMove6(c, Components, o)) {
                                return true;
                            }
                            if (dbg) {
                                o.outln("Node " + this.Id + ": " + c + " - " + b.name + " violates Rule 6");
                            }
                        } else if (dbg) {
                            o.outln("Node " + this.Id + ": " + c + " - " + b.name + " violates Rule 5");
                        }
                    } else if (dbg) {
                        o.outln("Node " + this.Id + ": " + c + " - " + b.name + " violates Rule 4");
                    }
                } else if (dbg) {
                    o.outln("Node " + this.Id + ": " + c + " - " + b.name + " violates Rule 3");
                }
            } else if (dbg) {
                o.outln("Node " + this.Id + ": " + c + " - " + b.name + " violates Rule 2");
            }
        } else if (dbg) {
            o.outln("Node " + this.Id + ": " + c + " - " + b.name + " violates Rule 1");
        }
        return false;
    }

    private boolean validMove5(int c, Map Components, LTSOutput o) {
        boolean found = false;
        if (this.isFirst(c)) {
            int myPos = this.getPosition(c);
            int i = 0;
            while (i < this.size && !found) {
                found = i != c && myPos == this.getPosition(i);
                ++i;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    private boolean validMove6(int c, Map Components, LTSOutput o) {
        int TotalIn_0 = 0;
        int TotalIn_1 = 0;
        int myPos = this.getPosition(c);
        if (myPos == 1) {
            int i = 0;
            while (i < this.size && TotalIn_0 + TotalIn_1 <= 2) {
                if (this.getPosition(i) == 1) {
                    ++TotalIn_1;
                }
                if (this.getPosition(i) == 0) {
                    ++TotalIn_0;
                }
                ++i;
            }
            if (TotalIn_0 + TotalIn_1 <= 2) {
                return false;
            }
        }
        return true;
    }

    private boolean validMove3(int c, Map Components, LTSOutput o) {
        boolean dbg = false;
        BasicMSC current = this.getLocation(c);
        if (dbg) {
            this.print(o);
        }
        int myPos = this.getPosition(c);
        int i = 0;
        while (i < this.size) {
            if (myPos > this.getPosition(i) && this.getLocation(i) == current) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean validMove1(int c, Map Components, LTSOutput o) {
        boolean dbg = false;
        BasicMSC current = this.getLocation(c);
        if (dbg) {
            this.print(o);
        }
        if (dbg) {
            o.outln("Get components needed in " + current.name + " so " + Components.get(new Integer(c)) + "can move to next.");
        }
        StringSet S = (StringSet)current.getDependencies(o).get((String)Components.get(new Integer(c)));
        if (dbg) {
            o.outln("Check if they are any components that haven't reached current and which c depends on.");
        }
        int myPos = this.getPosition(c);
        int i = 0;
        while (i < this.size) {
            if (myPos > this.getPosition(i)) {
                if (dbg) {
                    o.outln(Components.get(new Integer(i)) + "is needed");
                }
                if (S.contains(Components.get(new Integer(i)))) {
                    if (dbg) {
                        o.outln("AND IS NOT AVAILABLE");
                    }
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean validMove2(int c, Map Components, LTSOutput o) {
        boolean dbg = false;
        BasicMSC current = this.getLocation(c);
        Map M = current.getCanFinishBefore(o);
        String myCompName = (String)Components.get(new Integer(c));
        StringSet myDependencies = (StringSet)M.get(myCompName);
        int i = 0;
        while (i < Components.keySet().size()) {
            if (i != c && this.getPosition(i) == this.getPosition(c)) {
                String CompName = (String)Components.get(new Integer(i));
                StringSet Dependencies = (StringSet)M.get(CompName);
                if (!myDependencies.contains(CompName) && Dependencies.contains(myCompName)) {
                    if (dbg) {
                        o.outln("ValidMove2: C = " + c);
                    }
                    if (dbg) {
                        this.print(o);
                    }
                    if (dbg) {
                        o.outln("Component " + myCompName + ". Dependencies");
                    }
                    if (dbg) {
                        myDependencies.print(o);
                    }
                    if (dbg) {
                        o.outln("Against Component " + CompName + ". Dependencies");
                    }
                    if (dbg) {
                        Dependencies.print(o);
                    }
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean validMove4(int c, Map Components, LTSOutput o) {
        boolean dbg = false;
        BasicMSC current = this.getLocation(c);
        String myCompName = (String)Components.get(new Integer(c));
        int i = 0;
        while (i < Components.keySet().size()) {
            String CompName;
            String Partner;
            if (i != c && this.getPosition(i) > this.getPosition(c) && (Partner = current.getLastDependency(CompName = (String)Components.get(new Integer(i)), o)) != null && CompName.equals(current.getLastDependency(Partner, o)) && !Partner.equals(myCompName)) {
                int j = 0;
                while (j < Components.keySet().size()) {
                    if (((String)Components.get(new Integer(j))).equals(Partner) && this.getPosition(j) <= this.getPosition(c)) {
                        if (dbg) {
                            o.outln("Moving " + myCompName);
                        }
                        if (dbg) {
                            this.print(o);
                        }
                        if (dbg) {
                            o.outln("Found someone (" + CompName + ") who is more advanced and whose last partner (" + Partner + ") has not moved on");
                        }
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }
}

