#!/bin/sh

function environerror
{
  echo ""
  echo "BPWS4J Echo Complex Sample"
  echo "  An error occurred when invoking the sample.  Please set your BPWS4J_HOME and JAVA_HOME environment variables before continuing." | fmt
  echo ""
  exit 1
}

function help
{
  echo ""
  echo "BPWS4J Echo Complex Sample"
  echo "  Usage: EchoComplexSample <runtime-URL> <area-code> <exchange> <number>" | fmt
  echo "  e.g. EchoComplexSample http://localhost:8080/bpws4j/soaprpcrouter 123 456 7890" | fmt
  echo ""
  exit 1
}

if [ "$BPWS4J_HOME" = "" ] ; then
  environerror
elif [ "$JAVA_HOME" = "" ] ; then
  environerror
else
  ENDPOINT=$1
  AREACODE=$2
  EXCHANGE=$3
  NUMBER=$4
  if [ "$ENDPOINT" = "" ] ; then
    help
  elif [ "$AREACODE" = "" ] ; then
    help
  elif [ "$EXCHANGE" = "" ] ; then
    help
  elif [ "$NUMBER" = "" ] ; then
    help
  else
    CP=$BPWS4J_HOME/lib/bpws4j-samples.jar
    CP=$CP:$BPWS4J_HOME/lib/soap.jar
    CP=$CP:$BPWS4J_HOME/lib/xml-apis.jar
    CP=$CP:$BPWS4J_HOME/lib/xercesImpl.jar
    CP=$CP:$CLASSPATH
    export CP
    $JAVA_HOME/jre/bin/java -classpath $CP samples.echocomplex.EchoComplexClient $ENDPOINT $AREACODE $EXCHANGE $NUMBER
    exit 0
  fi 
fi
