package samples.loanapproval;

import java.io.*;
import java.net.*;
import java.util.*;
import org.apache.soap.*;
import org.apache.soap.rpc.*;

/**
 * See README for info.
 *
 * @author Rania Khalaf <rkhalaf@us.ibm.com>
 * @author William A Nagy <wnagy@us.ibm.com>
 */
public class Customer
{
  
  private static void printUsageAndTerminate()
  {
    System.err.println("Usage: java " + Customer.class.getName() +
			" SOAP-router-URL firstname lastname amount");
    System.exit(1);
  }

  public static void main(String[] args)
    throws Exception
  {
    if (args.length != 4)
    {
      printUsageAndTerminate();
    }
    
    // Process the arguments.
    URL url = new URL(args[0]);
      
    String firstName = args[1];
    String lastName = args[2];
    int amount = Integer.parseInt(args[3]);

    // Build the call.
    Call call = new Call();
    Vector params = new Vector();
 
    call.setTargetObjectURI("http://loans.org/wsdl/loan-approval#loanapprovalServiceBP#customer#http://tempuri.org/services/loanapprover#loanApprovalPT");
    params.addElement(new Parameter("firstName",String.class,firstName,null));
    params.addElement(new Parameter("name", String.class, lastName, null));
    params.addElement(new Parameter("amount",Integer.class,
                                    new Integer(amount), null));
    
    call.setMethodName("approve");
    call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);
    call.setParams(params);
    
    // make the call: note that the action URI is empty because the 
    // XML-SOAP rpc router does not need this. This may change in the
    // future.
    Response resp = call.invoke(/* router URL */ url, /* actionURI */ "" );
    
    // Check the response.
    if (resp.generatedFault())
    {
      Fault fault = resp.getFault();
      System.out.println("Ouch, the call failed: ");
      System.out.println("  Fault Code   = " + fault.getFaultCode());  
      System.out.println("  Fault String = " + fault.getFaultString());
      System.out.println("  Fault        = " + fault);
    }
    else
    {
      Parameter result = resp.getReturnValue();
      if (result != null)
	System.out.println(result.getValue());
      else
	System.out.println("No response was returned.  Perhaps there was an error with the flow.");
    }
  }
}
