#!/bin/sh

function environerror
{
  echo ""
  echo "BPWS4J Marketplace Sample"
  echo "  An error occurred when invoking the sample.  Please set your BPWS4J_HOME and JAVA_HOME environment variables before continuing." | fmt
  echo ""
  exit 1
}

function help
{
  echo ""
  echo "BPWS4J Marketplace Sample"
  echo "  Usage: MarketplaceSample <runtime-URL> buyer|seller <item> <price>" | fmt
  echo "  e.g. MarketplaceSample http://localhost:8080/bpws4j/soaprpcrouter buyer apples 10" | fmt
  echo ""
  exit 1
}

if [ "$BPWS4J_HOME" = "" ] ; then
  environerror
elif [ "$JAVA_HOME" = "" ] ; then
  environerror
else
  ENDPOINT=$1
  ROLE=$2
  ITEM=$3
  PRICE=$4
  if [ "$ENDPOINT" = "" ] ; then
    help
  elif [ "$ROLE" = "" ] ; then
    help
  elif [ "$ITEM" = "" ] ; then
    help
  elif [ "$PRICE" = "" ] ; then
    help
  else
    CP=$BPWS4J_HOME/lib/bpws4j-samples.jar
    CP=$CP:$BPWS4J_HOME/lib/soap.jar
    CP=$CP:$BPWS4J_HOME/lib/xml-apis.jar
    CP=$CP:$BPWS4J_HOME/lib/xercesImpl.jar
    CP=$CP:$CLASSPATH
    export CP
    $JAVA_HOME/jre/bin/java -classpath $CP samples.marketplace.BuyerSeller $ENDPOINT $ROLE $ITEM $PRICE
    exit 0
  fi 
fi
