package samples.atm;

import java.io.*;
import java.net.*;
import java.util.*;
import org.apache.soap.*;
import org.apache.soap.rpc.*;

/**
 * See README for info.
 *
 * @author William A. Nagy <nagy@watson.ibm.com>
 */
public class ATM
{
  
  private static void printUsageAndTerminate()
  {
    System.err.println("Usage: java " + ATM.class.getName() +
			" SOAP-router-URL (connect|disconnect <id>|status <id>|logon <id> <name>|logoff <name>|deposit <name> <amount>|withdraw <name> <amount>)");
    System.exit(1);
  }

  public static void main(String[] args)
    throws Exception
  {
    if ((args.length < 2) || (args.length > 4))
    {
      printUsageAndTerminate();
    }
    
    // Process the arguments.
    URL url = new URL(args[0]);
    String operation = args[1];
    
    // Build the call.
    Call call = new Call();
    Vector params = new Vector();
    call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);
    call.setMethodName(operation);
    
    if (operation.equals("connect"))
    {
      if (args.length != 2)
      {
	printUsageAndTerminate();
      }
      call.setTargetObjectURI("urn:samples:ATMService#ATMServiceBP#atmFrontEnd#urn:samples:ATMService#atmServicePT");
      call.setParams(params);
    }
    else if (operation.equals("disconnect"))
    {
      if (args.length != 3)
      {
	printUsageAndTerminate();
      }
      call.setTargetObjectURI("urn:samples:ATMService#ATMServiceBP#atmFrontEnd#urn:samples:ATMService#atmServicePT");
      params.addElement(new Parameter("sessionID", Integer.class, new Integer(args[2]), null));
      call.setParams(params);
    }
    else if (operation.equals("status"))
    {
      if (args.length != 3)
      {
	printUsageAndTerminate();
      }
      call.setTargetObjectURI("urn:samples:ATMService#ATMServiceBP#atmFrontEnd#urn:samples:ATMService#atmServicePT");
      params.addElement(new Parameter("sessionID", Integer.class, new Integer(args[2]), null));
      call.setParams(params);
    }
    else if (operation.equals("logon"))
    {
      if (args.length != 4)
      {
	printUsageAndTerminate();
      }
      call.setTargetObjectURI("urn:samples:ATMService#ATMServiceBP#atmFrontEnd#urn:samples:ATMService#atmServicePT");
      params.addElement(new Parameter("sessionID", Integer.class, new Integer(args[2]), null));
      params.addElement(new Parameter("customerName", String.class, args[3], null));
      call.setParams(params);
    }
    else if (operation.equals("logoff"))
    {
      if (args.length != 3)
      {
	printUsageAndTerminate();
      }
      call.setTargetObjectURI("urn:samples:ATMService#ATMServiceBP#atmFrontEnd#urn:samples:ATMService#atmServicePT");
      params.addElement(new Parameter("customerName", String.class, args[2], null));
      call.setParams(params);
    }
    else if (operation.equals("deposit"))
    {
      if (args.length != 4)
      {
	printUsageAndTerminate();
      }
      call.setTargetObjectURI("urn:samples:ATMService#ATMServiceBP#atmFrontEnd#urn:samples:ATMService#atmServicePT");
      params.addElement(new Parameter("customerName", String.class, args[2], null));
      params.addElement(new Parameter("amount", Integer.class, new Integer(args[3]), null));
      call.setParams(params);
    }
    else if (operation.equals("withdraw"))
    {
      if (args.length != 4)
      {
	printUsageAndTerminate();
      }
      call.setTargetObjectURI("urn:samples:ATMService#ATMServiceBP#atmFrontEnd#urn:samples:ATMService#atmServicePT");
      params.addElement(new Parameter("customerName", String.class, args[2], null));
      params.addElement(new Parameter("amount", Integer.class, new Integer(args[3]), null));
      call.setParams(params);
    }
    else
    {
      printUsageAndTerminate();
    }

    // make the call: note that the action URI is empty because the 
    // XML-SOAP rpc router does not need this. This may change in the
    // future.
    Response resp = call.invoke(/* router URL */ url, /* actionURI */ "" );
    
    // Check the response.
    if (resp.generatedFault())
    {
      Fault fault = resp.getFault();
      System.out.println("Ouch, the call failed: ");
      System.out.println("  Fault Code   = " + fault.getFaultCode());  
      System.out.println("  Fault String = " + fault.getFaultString());
      System.out.println("  Fault        = " + fault);
    }
    else
    {
      Parameter result = resp.getReturnValue();
      if (result != null)
	System.out.println(result.getValue());
    }
  }
}
