#!/bin/sh

function environerror
{
  echo ""
  echo "BPWS4J ATM Sample"
  echo "  An error occurred when invoking the sample.  Please set your BPWS4J_HOME and JAVA_HOME environment variables before continuing." | fmt
  echo ""
  exit 1
}

function help
{
  echo ""
  echo "BPWS4J ATM Sample"
  echo "  Usage: ATMSample <runtime-URL> (connect|disconnect <id>|status <id>|logon <id> <name>|logoff <name>|deposit <name> <amount>|withdraw <name> <amount>)" | fmt
  echo "  e.g. ATMSample http://localhost:8080/bpws4j/soaprpcrouter connect" | fmt
  echo ""
  exit 1
}

if [ "$BPWS4J_HOME" = "" ] ; then
  environerror
elif [ "$JAVA_HOME" = "" ] ; then
  environerror
else
  ENDPOINT=$1
  OPERATION=$2
  OPERATOR1=$3
  OPERATOR2=$4
  if [ "$ENDPOINT" = "" ] ; then
    help
  elif [ "$OPERATION" = "" ] ; then
    help
  else
    CP=$BPWS4J_HOME/lib/bpws4j-samples.jar
    CP=$CP:$BPWS4J_HOME/lib/soap.jar
    CP=$CP:$BPWS4J_HOME/lib/xml-apis.jar
    CP=$CP:$BPWS4J_HOME/lib/xercesImpl.jar
    CP=$CP:$CLASSPATH
    export CP
    $JAVA_HOME/jre/bin/java -classpath $CP samples.atm.ATM $ENDPOINT $OPERATION $OPERATOR1 $OPERATOR2
    exit 0
  fi 
fi
