package samples.echo;

import java.io.*;
import java.net.*;
import java.util.*;
import org.apache.soap.*;
import org.apache.soap.rpc.*;

public class EchoClient {
  public static void main (String[] args) throws Exception {
    if (args.length != 2) {
      System.err.println ("Usage: java " + EchoClient.class.getName () +
                          " SOAP-router-URL string-to-echo");
      System.exit (1);
    }

    URL url = new URL (args[0]);
    String echoStr = args[1];

    // Build the call.
    Call call = new Call ();
    call.setTargetObjectURI ("urn:echo:echoService#echoServiceBP#caller#urn:echo:echoService#echoPT");
    call.setMethodName ("echo");
    call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);
    Vector params = new Vector ();
    params.addElement (new Parameter("string-to-echo", String.class, 
                                     echoStr, null));
    call.setParams (params);

    // make the call: note that the action URI is empty because the 
    // XML-SOAP rpc router does not need this. This may change in the
    // future.
    Response resp = call.invoke (/* router URL */ url, /* actionURI */ "" );

    // Check the response.
    if (resp.generatedFault ()) {
      Fault fault = resp.getFault ();
      System.out.println ("Ouch, the call failed: ");
      System.out.println ("  Fault Code   = " + fault.getFaultCode ());  
      System.out.println ("  Fault String = " + fault.getFaultString ());
      System.out.println ("  Fault        = " + fault);
    } else {
      Parameter result = resp.getReturnValue ();
      System.out.println (result.getValue ());
    }
  }
}
