package samples.echocomplex;

import java.io.*;
import java.net.*;
import java.util.*;
import org.apache.soap.*;
import org.apache.soap.rpc.*;
import org.apache.soap.encoding.*;
import org.apache.soap.encoding.soapenc.*;
import org.apache.soap.util.xml.*;

public class EchoComplexClient
{
  public static void main(String[] args)
    throws Exception
  {
    if (args.length != 4)
    {
      System.err.println("Usage: java " + EchoComplexClient.class.getName() +
			 " SOAP-router-URL area-code exchange number");
      System.exit(1);
    }

    URL url = new URL(args[0]);

    Phone echoData = new Phone((new Integer(args[1])).intValue(),
			       args[2], args[3]);

    SOAPMappingRegistry smr = new SOAPMappingRegistry();
    BeanSerializer beanSer = new BeanSerializer();

    // Map the types.
    smr.mapTypes(Constants.NS_URI_SOAP_ENC,
                 new QName("http://www.ibm.com/bpws4j/samples/echocomplex/types", "phone"),
                 Phone.class, beanSer, beanSer);

    // Build the call.
    Call call = new Call();
    call.setSOAPMappingRegistry(smr);
    call.setTargetObjectURI("urn:echo:echoComplexService#echoComplexServiceBP#caller#urn:echo:echoComplexService#echoComplexPT");
    call.setMethodName("echo");
    call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);
    Vector params = new Vector();
    params.addElement(new Parameter("echoData", Phone.class, 
				    echoData, null));
    call.setParams(params);
    
    // make the call: note that the action URI is empty because the 
    // XML-SOAP rpc router does not need this. This may change in the
    // future.
    Response resp = call.invoke(url, "");

    // Check the response.
    if (resp.generatedFault())
    {
      Fault fault = resp.getFault();
      System.out.println("Ouch, the call failed: ");
      System.out.println("  Fault Code   = " + fault.getFaultCode ());  
      System.out.println("  Fault String = " + fault.getFaultString ());
      System.out.println("  Fault        = " + fault);
    }
    else
    {
      Parameter result = resp.getReturnValue();
      System.out.println(result.getValue());
    }
  }
}
