/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import ic.doc.simulation.sim.HistogramResult;
import ic.doc.simulation.sim.MeasureResult;
import ic.doc.simulation.sim.Result;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import simulationplugin.ui.ComponentFactory;
import simulationplugin.ui.MeasureDisplayComponent;

public class HistogramDisplayComponent
extends MeasureDisplayComponent {
    private double transientResetTime;
    private int movAvgPeriod;

    public HistogramDisplayComponent(Result[] resultArray, double d, double d2) {
        this(resultArray, d, d2, 0);
    }

    public HistogramDisplayComponent(Result[] resultArray, double d, double d2, int n) {
        super(resultArray, d, d2, n);
        this.transientResetTime = d2;
        this.movAvgPeriod = n;
    }

    protected JComponent makeOneResultDisplay(MeasureResult measureResult, int n) {
        HistogramResult histogramResult = (HistogramResult)measureResult;
        String string = histogramResult.getSource().getName() + " (run " + (n + 1) + ")";
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        JComponent jComponent = ComponentFactory.makeTimeSeriesChart((MeasureResult)histogramResult, string, this.transientResetTime, this.movAvgPeriod);
        jPanel.add(jComponent);
        jComponent = ComponentFactory.makeHistogram(histogramResult, string);
        jPanel.add(jComponent);
        jComponent = ComponentFactory.makeStatisticalSummary((MeasureResult)histogramResult);
        jPanel.add(jComponent);
        return jPanel;
    }
}

