/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.IntervalXYDataset;
import java.util.ArrayList;

public class IntervalDataSet
extends AbstractSeriesDataset
implements IntervalXYDataset {
    private String name;
    private ArrayList yvals;
    private ArrayList xmins;
    private ArrayList xmaxs;

    public IntervalDataSet(String string) {
        this.name = string;
        this.yvals = new ArrayList();
        this.xmins = new ArrayList();
        this.xmaxs = new ArrayList();
    }

    public void add(Number number, Number number2, Number number3) {
        if (number2.doubleValue() < number.doubleValue()) {
            throw new IllegalArgumentException("bad interval");
        }
        this.xmins.add(number);
        this.xmaxs.add(number2);
        this.yvals.add(number3);
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return 1;
    }

    public String getSeriesName(int n) {
        if (n == 0) {
            return this.name;
        }
        throw new IllegalArgumentException("bad series value " + n);
    }

    public int getItemCount(int n) {
        if (n == 0) {
            return this.yvals.size();
        }
        throw new IllegalArgumentException("bad series value " + n);
    }

    public Number getXValue(int n, int n2) {
        if (n == 0) {
            return new Double((((Number)this.xmins.get(n2)).doubleValue() + ((Number)this.xmaxs.get(n2)).doubleValue()) / 2.0);
        }
        throw new IllegalArgumentException("bad series value " + n);
    }

    public Number getYValue(int n, int n2) {
        if (n == 0) {
            return (Number)this.yvals.get(n2);
        }
        throw new IllegalArgumentException("bad series value " + n);
    }

    public Number getEndXValue(int n, int n2) {
        if (n == 0) {
            return (Number)this.xmaxs.get(n2);
        }
        throw new IllegalArgumentException("bad series value " + n);
    }

    public Number getStartXValue(int n, int n2) {
        if (n == 0) {
            return (Number)this.xmins.get(n2);
        }
        throw new IllegalArgumentException("bad series value " + n);
    }

    public Number getEndYValue(int n, int n2) {
        if (n == 0) {
            return (Number)this.yvals.get(n2);
        }
        throw new IllegalArgumentException("bad series value " + n);
    }

    public Number getStartYValue(int n, int n2) {
        if (n == 0) {
            return (Number)this.yvals.get(n2);
        }
        throw new IllegalArgumentException("bad series value " + n);
    }
}

