/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import javax.swing.JTextField;
import simulationplugin.ui.ValidatingDocument;

public class LongField
extends JTextField {
    public LongField() {
        this.setDocument(new ValidatingDocument(){

            public boolean validate(String string) {
                if (string.length() == 0) {
                    return true;
                }
                try {
                    Long.parseLong(string);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        });
    }

    public void setValue(long l) {
        this.setText(Long.toString(l));
    }

    public long getValue() {
        try {
            return this.getText().length() == 0 ? 0L : Long.parseLong(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("bad number format");
        }
    }
}

