/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartPanel;
import com.jrefinery.chart.StandardLegend;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.SeriesException;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XYSeries;
import com.jrefinery.data.XYSeriesCollection;
import ic.doc.simulation.sim.BatchListener;
import ic.doc.simulation.sim.BatchManager;
import ic.doc.simulation.sim.ChartablePerformanceMeasure;
import ic.doc.simulation.sim.PerformanceMeasure;
import ic.doc.simulation.sim.ProgressListener;
import ic.doc.simulation.sim.Simulation;
import ic.doc.simulation.sim.SimulationAbortionException;
import ic.doc.simulation.sim.SimulationException;
import ic.doc.simulation.sim.TimeSeries;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import simulationplugin.ui.ComponentFactory;
import simulationplugin.ui.OptionsStep;
import simulationplugin.ui.SimulationWindow;
import simulationplugin.ui.WizardStep;

public class SimulationStep
extends WizardStep
implements ProgressListener,
BatchListener {
    private int nRuns = 1;
    private final Simulation sim;
    private boolean simComplete;
    private JLabel status;
    private JProgressBar progressBar;
    private JComponent display;
    private ValueAxis plotDomainAxis;
    private ValueAxis plotRangeAxis;
    private double maximumRangeValue = 0.0;
    private double minimumRangeValue = Double.MAX_VALUE;
    private Thread workerThread;
    private XYSeriesCollection series;
    private Map measuresToSeries;
    private BatchManager bm;
    private int currentRun = 1;
    private long startTime;
    private JFreeChart progressChart;
    private SimulationWindow parent;
    private long lastEstimateTime = -500L;

    public SimulationStep(SimulationWindow simulationWindow) {
        this.parent = simulationWindow;
        this.sim = simulationWindow.getSimulation();
        this.sim.addProgressListener((ProgressListener)this);
        this.simComplete = false;
        this.measuresToSeries = new Hashtable();
        this.display = this.makeDisplay(simulationWindow.isBigFont());
    }

    public boolean nextEnabled() {
        return this.simComplete;
    }

    public boolean returnEnabled() {
        return true;
    }

    public void percentComplete(int n) {
        boolean bl;
        long l;
        double d = (double)this.currentRun * 100.0 / (double)this.nRuns;
        final double d2 = d + (double)n / (double)this.nRuns;
        long l2 = System.currentTimeMillis() - this.startTime;
        if (l2 - this.lastEstimateTime > 500L) {
            l = d2 == 0.0 ? 0L : ((long)((double)(l2 * 100L) / d2) - l2) / 1000L;
            this.lastEstimateTime = l2;
            bl = true;
        } else {
            l = 0L;
            bl = false;
        }
        this.plotPoints();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimulationStep.this.progressBar.setValue((int)d2);
                if (bl) {
                    SimulationStep.this.status.setText("Executing run " + (SimulationStep.this.currentRun + 1) + " of " + SimulationStep.this.nRuns + ". " + l + " second" + (l != 1L ? "s" : "") + " remaining.");
                }
            }
        });
    }

    private void plotPoints() {
        int n = this.sim.getOptions().getMovingAveragePeriod();
        Iterator iterator = this.measuresToSeries.keySet().iterator();
        while (iterator.hasNext()) {
            ChartablePerformanceMeasure chartablePerformanceMeasure = (ChartablePerformanceMeasure)iterator.next();
            XYSeries xYSeries = (XYSeries)this.measuresToSeries.get(chartablePerformanceMeasure);
            TimeSeries timeSeries = chartablePerformanceMeasure.getTimeSeries();
            try {
                if (this.sim.getOptions().isMovingAverage()) {
                    if (timeSeries.size() < n) continue;
                    timeSeries.setPosition(timeSeries.size() - n);
                    double d = 0.0;
                    int n2 = 0;
                    while (n2 < n) {
                        d += timeSeries.getValue();
                        if (n2 + 1 < n) {
                            timeSeries.next();
                        }
                        ++n2;
                    }
                    xYSeries.add(timeSeries.getTime(), d / (double)n);
                    continue;
                }
                timeSeries.setPosition(timeSeries.size() - 1);
                double d = timeSeries.getValue();
                if (d > this.maximumRangeValue) {
                    this.maximumRangeValue = d;
                }
                if (d < this.minimumRangeValue) {
                    this.minimumRangeValue = d;
                }
                xYSeries.add(timeSeries.getTime(), d);
            }
            catch (SeriesException seriesException) {
                // empty catch block
            }
        }
        this.plotRangeAxis.setAxisRange(this.minimumRangeValue * 0.96, this.maximumRangeValue * 1.04);
    }

    public void runStarting(int n) {
        Collection collection = this.parent.getOptionsStep().getProgressMeasureNames();
        this.currentRun = n;
        Iterator iterator = this.sim.getPerformanceMeasures().iterator();
        while (iterator.hasNext()) {
            PerformanceMeasure performanceMeasure = (PerformanceMeasure)iterator.next();
            if (!(performanceMeasure instanceof ChartablePerformanceMeasure) || !collection.contains(performanceMeasure.getName())) continue;
            XYSeries xYSeries = new XYSeries(performanceMeasure.getName() + "(run " + (n + 1) + ")");
            this.measuresToSeries.put(performanceMeasure, xYSeries);
            this.series.addSeries(xYSeries);
        }
    }

    public void runFinished(int n) {
        if (n == this.nRuns - 1) {
            this.parent.getResultStep().setResults(this.bm.getResults());
        }
    }

    public void prepare() {
        Object object;
        Object object2;
        double d = this.parent.getSimulationOptions().getTransientResetTime();
        if (d > 0.0) {
            try {
                object2 = this.getDisplayComponent();
                object = ((Container)object2).getComponent(2);
                JFreeChartPanel jFreeChartPanel = (JFreeChartPanel)object;
                XYPlot xYPlot = (XYPlot)jFreeChartPanel.getChart().getPlot();
                xYPlot.addVerticalLine((Number)new Double(d), (Paint)Color.black);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = this.parent.getOptionsStep();
        this.plotDomainAxis.setAxisRange(0.0, this.parent.getSimulationOptions().getRunLength() * 1.04);
        this.nRuns = ((OptionsStep)object2).getNumberOfRuns();
        if (!this.simComplete) {
            this.progressBar.setValue(0);
            this.status.setText("Executing run 1 of " + this.nRuns + ".");
            this.updateWizard();
            object = new Runnable(){
                private long elapsed;

                public void run() {
                    SimulationStep.this.bm = new BatchManager(SimulationStep.this.sim, SimulationStep.this.nRuns);
                    SimulationStep.this.startTime = System.currentTimeMillis();
                    SimulationStep.this.sim.setOptions(SimulationStep.this.parent.getSimulationOptions());
                    SimulationStep.this.bm.addBatchListener((BatchListener)SimulationStep.this);
                    try {
                        SimulationStep.this.bm.run();
                    }
                    catch (SimulationException simulationException) {
                        JOptionPane.showMessageDialog(SimulationStep.this.parent, simulationException.getMessage(), "Simulation Error", 0);
                        SimulationStep.this.parent.reset();
                    }
                    catch (SimulationAbortionException simulationAbortionException) {
                        return;
                    }
                    this.elapsed = System.currentTimeMillis() - SimulationStep.this.startTime;
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            SimulationStep.access$000(2.access$800(this.this$1)).setValue(100);
                            SimulationStep.access$300(2.access$800(this.this$1)).setText("Complete. Elapsed " + 2.access$900(this.this$1) + "ms");
                            SimulationStep.access$1002(2.access$800(this.this$1), true);
                            2.access$800(this.this$1).updateWizard();
                        }
                    });
                }

                static /* synthetic */ SimulationStep access$800(2 var0) {
                    return var0.SimulationStep.this;
                }

                static /* synthetic */ long access$900(2 var0) {
                    return var0.elapsed;
                }
            };
            this.workerThread = new Thread((Runnable)object);
            this.workerThread.start();
        }
    }

    public void reset() {
        this.abort();
        this.sim.reset();
        this.simComplete = false;
        this.series = new XYSeriesCollection();
        this.progressChart.setDataset((Dataset)this.series);
        this.measuresToSeries = new Hashtable();
        this.lastEstimateTime = -500L;
    }

    public void abort() {
        this.sim.abort();
    }

    public JComponent getDisplayComponent() {
        return this.display;
    }

    private JComponent makeDisplay(boolean bl) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.ipady = 5;
        this.status = new JLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.status, gridBagConstraints);
        jPanel.add(this.status);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setMinimumSize(new Dimension(150, 25));
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.progressBar, gridBagConstraints);
        jPanel.add(this.progressBar);
        JComponent jComponent = this.makeChart(bl);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        return jPanel;
    }

    private JComponent makeChart(boolean bl) {
        this.series = new XYSeriesCollection();
        this.progressChart = ChartFactory.createXYChart((String)"Measures", (String)"Time", (String)"Average", (XYDataset)this.series, (boolean)true);
        XYPlot xYPlot = (XYPlot)this.progressChart.getPlot();
        this.plotDomainAxis = xYPlot.getDomainAxis();
        this.plotDomainAxis.setAutoRange(false);
        this.plotRangeAxis = xYPlot.getRangeAxis();
        this.plotRangeAxis.setAutoRange(false);
        if (bl) {
            StandardLegend standardLegend = (StandardLegend)this.progressChart.getLegend();
            standardLegend.setItemFont(SimulationWindow.BIG_FONT);
            this.plotDomainAxis.setLabelFont(SimulationWindow.BIG_FONT);
            this.plotDomainAxis.setTickLabelFont(SimulationWindow.BIG_FONT);
            this.plotRangeAxis.setLabelFont(SimulationWindow.BIG_FONT);
            this.plotRangeAxis.setTickLabelFont(SimulationWindow.BIG_FONT);
        }
        ComponentFactory.addBackground(this.progressChart);
        return new JFreeChartPanel(this.progressChart);
    }

    static /* synthetic */ boolean access$1002(SimulationStep simulationStep, boolean bl) {
        simulationStep.simComplete = bl;
        return simulationStep.simComplete;
    }
}

